/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.nio.ByteOrder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.jevio.ByteParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;

public class cMsgHandler {
    private cMsg cmsg;
    private String udl;
    private String subject;
    private String type;
    private cMsgSubscriptionHandle handle;
    private myCallback callback = new myCallback();
    private BlockingQueue<cMsgMessage> queue = new LinkedBlockingQueue<cMsgMessage>(1000);
    private ByteParser byteParser = new ByteParser();
    private cMsgMessage lastRetrievedMessage;
    private String lastDictionaryLoaded;
    private static cMsgHandler handler = new cMsgHandler();

    public static cMsgHandler getInstance() {
        return handler;
    }

    private cMsgHandler() {
    }

    public String getSubject() {
        return this.subject;
    }

    public String getType() {
        return this.type;
    }

    public void disconnect() {
        if (this.cmsg == null || !this.cmsg.isConnected()) {
            return;
        }
        try {
            this.cmsg.disconnect();
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.handle = null;
        this.subject = null;
        this.type = null;
    }

    public void connect(String string) throws cMsgException {
        String string2;
        String string3;
        if (this.cmsg == null) {
            string3 = "evioViewer_" + System.currentTimeMillis();
            string2 = "evio event viewer";
            this.cmsg = new cMsg(string, string3, string2);
            this.udl = string;
        }
        if (this.cmsg.isConnected()) {
            if (string.equals(this.udl)) {
                return;
            }
            this.cmsg.disconnect();
        }
        if (!string.equals(this.udl)) {
            string3 = "evioViewer_" + System.currentTimeMillis();
            string2 = "evio event viewer";
            this.cmsg = new cMsg(string, string3, string2);
            this.udl = string;
        }
        this.cmsg.connect();
        this.cmsg.start();
        this.subject = null;
        this.type = null;
    }

    public boolean subscribe(String string, String string2) throws cMsgException {
        if (this.cmsg == null || !this.cmsg.isConnected() || string == null || string2 == null || string.length() < 1 || string2.length() < 1) {
            this.handle = null;
            return false;
        }
        if (string.equals(this.subject) && string2.equals(this.type)) {
            return true;
        }
        if (this.handle != null) {
            try {
                this.cmsg.unsubscribe(this.handle);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.handle = this.cmsg.subscribe(string, string2, (cMsgCallbackInterface)this.callback, null);
        this.subject = string;
        this.type = string2;
        return true;
    }

    public cMsgMessage getNextMessage() {
        try {
            cMsgMessage cMsgMessage2 = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (cMsgMessage2 != null) {
                this.lastRetrievedMessage = cMsgMessage2;
            }
            return cMsgMessage2;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public EvioEvent getNextEvent() {
        while (true) {
            try {
                cMsgMessage cMsgMessage2 = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (cMsgMessage2 == null) {
                    return null;
                }
                this.lastRetrievedMessage = cMsgMessage2;
                return this.byteParser.parseEvent(cMsgMessage2.getByteArray(), this.getByteOrder(cMsgMessage2));
            }
            catch (EvioException evioException) {
                continue;
            }
            break;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void clearQueue() {
        this.queue.clear();
    }

    public void clearQueue(int n) {
        if (n >= this.queue.size()) {
            this.queue.clear();
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (this.queue.poll() != null) continue;
            return;
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public String getDictionaryString() {
        return this.lastDictionaryLoaded;
    }

    public boolean setDictionary() {
        return this.setDictionary(this.lastRetrievedMessage);
    }

    public boolean setDictionary(cMsgMessage cMsgMessage2) {
        if (cMsgMessage2 == null) {
            return false;
        }
        cMsgPayloadItem cMsgPayloadItem2 = cMsgMessage2.getPayloadItem("dictionary");
        if (cMsgPayloadItem2 == null) {
            return false;
        }
        try {
            String string = cMsgPayloadItem2.getString();
            NameProvider.setProvider(NameProviderFactory.createNameProvider(string));
            this.lastDictionaryLoaded = string;
            return true;
        }
        catch (cMsgException cMsgException2) {
            return false;
        }
    }

    public ByteOrder getByteOrder() {
        return this.getByteOrder(this.lastRetrievedMessage);
    }

    public ByteOrder getByteOrder(cMsgMessage cMsgMessage2) {
        int n = cMsgMessage2.getByteArrayEndian();
        if (n == 1) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    private class myCallback
    extends cMsgCallbackAdapter {
        private myCallback() {
        }

        public void callback(cMsgMessage cMsgMessage2, Object object) {
            byte[] byArray = cMsgMessage2.getByteArray();
            if (byArray == null) {
                return;
            }
            cMsgHandler.this.queue.offer(cMsgMessage2);
        }
    }
}

