/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.graphics.NamedLabel;

public class HeaderPanel
extends JPanel {
    private NamedLabel lengthLabel;
    private NamedLabel structureLabel;
    private NamedLabel dataTypeLabel;
    private NamedLabel tagLabel;
    private NamedLabel numberLabel;
    private NamedLabel descriptionLabel;

    public HeaderPanel() {
        this.setLayout(new GridLayout(2, 1, 0, 3));
        this.setBorder(new EmptyBorder(5, 5, 2, 0));
        this.structureLabel = new NamedLabel("structure", "description", 150);
        this.dataTypeLabel = new NamedLabel("data type", "description", 150);
        this.tagLabel = new NamedLabel("tag", "number", 150);
        this.numberLabel = new NamedLabel("number", "number", 150);
        this.lengthLabel = new NamedLabel("length", "description", 200);
        this.descriptionLabel = new NamedLabel("description", "description", 200);
        Dimension dimension = this.structureLabel.getPreferredSize();
        Dimension dimension2 = this.descriptionLabel.getPreferredSize();
        this.structureLabel.setMaximumSize(dimension);
        this.dataTypeLabel.setMaximumSize(dimension);
        this.tagLabel.setMaximumSize(dimension);
        this.numberLabel.setMaximumSize(dimension);
        this.lengthLabel.setMaximumSize(dimension2);
        this.descriptionLabel.setMaximumSize(dimension2);
        JPanel jPanel = this.createLayoutPanel();
        JPanel jPanel2 = this.createLayoutPanel();
        jPanel.add(this.structureLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.tagLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.lengthLabel);
        jPanel2.add(this.dataTypeLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.numberLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.descriptionLabel);
        this.add(jPanel);
        this.add(jPanel2);
    }

    private JPanel createLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        return jPanel;
    }

    public void setHeader(BaseStructure baseStructure) {
        if (baseStructure == null || baseStructure.getHeader() == null) {
            this.structureLabel.setText("   ");
            this.lengthLabel.setText("   ");
            this.tagLabel.setText("   ");
            this.dataTypeLabel.setText("   ");
            this.numberLabel.setText("   ");
            this.descriptionLabel.setText("   ");
        } else {
            BaseStructureHeader baseStructureHeader = baseStructure.getHeader();
            this.structureLabel.setText("" + (Object)((Object)baseStructure.getStructureType()));
            this.lengthLabel.setText(4 * baseStructureHeader.getLength() + " bytes");
            this.tagLabel.setText("" + baseStructureHeader.getTag());
            this.dataTypeLabel.setText("" + (Object)((Object)baseStructureHeader.getDataTypeEnum()));
            this.numberLabel.setText("" + baseStructureHeader.getNumber());
            this.descriptionLabel.setText(baseStructure.getDescription());
        }
    }
}

