/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Environment {
    private static Environment environment;
    private String homeDirectory = this.getProperty("user.home");
    private String currentWorkingDirectory = this.getProperty("user.dir");
    private String userName = this.getProperty("user.name");
    private String osName = this.getProperty("os.name");
    private String tempDirectory = this.getProperty("java.io.tmpdir");
    private String classPath = this.getProperty("java.class.path");
    private String hostName;

    private Environment() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.hostName = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = "???";
        }
    }

    public static Environment getInstance() {
        if (environment == null) {
            environment = new Environment();
        }
        return environment;
    }

    private String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Environment: \n");
        stringBuffer.append("Host Name: " + this.getHostName() + "\n");
        stringBuffer.append("User Name: " + this.getUserName() + "\n");
        stringBuffer.append("Temp Directory: " + this.getTempDirectory() + "\n");
        stringBuffer.append("OS Name: " + this.getOsName() + "\n");
        stringBuffer.append("Home Directory: " + this.getHomeDirectory() + "\n");
        stringBuffer.append("Current Working Directory: " + this.getCurrentWorkingDirectory() + "\n");
        stringBuffer.append("Class Path: " + this.getClassPath() + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Environment environment = Environment.getInstance();
        System.out.println(environment.toString());
    }
}

