/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

public enum DataType {
    UNKNOWN32(0),
    UINT32(1),
    FLOAT32(2),
    CHARSTAR8(3),
    SHORT16(4),
    USHORT16(5),
    CHAR8(6),
    UCHAR8(7),
    DOUBLE64(8),
    LONG64(9),
    ULONG64(10),
    INT32(11),
    TAGSEGMENT(12),
    SEGMENT(13),
    BANK(14),
    ALSOBANK(16),
    ALSOSEGMENT(32),
    ALSOTAGSEGMENT(64);

    private int value;

    private DataType(int n2) {
        this.value = n2;
    }

    public int getValue() {
        return this.value;
    }

    public static String getName(int n) {
        DataType[] dataTypeArray;
        for (DataType dataType : dataTypeArray = DataType.values()) {
            if (dataType.value != n) continue;
            return dataType.name();
        }
        return "UNKNOWN";
    }

    public static DataType getDataType(int n) {
        DataType[] dataTypeArray;
        for (DataType dataType : dataTypeArray = DataType.values()) {
            if (dataType.value != n) continue;
            return dataType;
        }
        return null;
    }

    public boolean isStructure() {
        switch (this) {
            case BANK: 
            case SEGMENT: 
            case TAGSEGMENT: {
                return true;
            }
            case ALSOBANK: 
            case ALSOSEGMENT: 
            case ALSOTAGSEGMENT: {
                return true;
            }
        }
        return false;
    }
}

