/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IEvioWriter;

public class BlockHeader
implements IEvioWriter {
    public static final int MAX_BLOCK_SIZE = 32768;
    public static final int MAGIC_NUMBER = -1059454720;
    private int size;
    private int number;
    private int headerLength;
    private int start;
    private int end;
    private int version;
    private int reserved1;
    private int magicNumber;
    private int bufferStartingPosition = -1;

    public int getSize() {
        return this.size;
    }

    public BlockHeader() {
        this.size = 0;
        this.number = 0;
        this.headerLength = 0;
        this.start = 0;
        this.end = 0;
        this.version = 0;
        this.reserved1 = 0;
        this.magicNumber = 0;
    }

    public BlockHeader(int n, int n2) {
        this.size = n;
        this.number = n2;
        this.headerLength = 8;
        this.start = 8;
        this.end = n;
        this.version = 2;
        this.reserved1 = 0;
        this.magicNumber = -1059454720;
    }

    public void setSize(int n) throws EvioException {
        if (n < 8 || n > 32768) {
            throw new EvioException(String.format("Bad value for size in block (physical record) header: %d", n));
        }
        if (n % 256 != 0) {
            throw new EvioException(String.format("Bad value for size in block (physical record) header: %d (must be multiple of 256 ints)", n));
        }
        this.size = n;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) throws EvioException {
        if (n < 0 || n > 32768) {
            throw new EvioException(String.format("Bad value for start in block (physical record) header: %d", n));
        }
        this.start = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) throws EvioException {
        if (n < 8 || n > 32768) {
            throw new EvioException(String.format("Bad value for end in block (physical record) header: %d", n));
        }
        this.end = n;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int n) throws EvioException {
        if (n != 8) {
            String string = "Bad Block (Physical Record) Header Length: " + n;
            throw new EvioException(string);
        }
        this.headerLength = n;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int n) {
        this.reserved1 = n;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(int n) throws EvioException {
        if (n != -1059454720) {
            throw new EvioException(String.format("Value for magicNumber %8x does not match MAGIC_NUMBER 0xc0da0100.", n));
        }
        this.magicNumber = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(String.format("block size:    %d\n", this.size));
        stringBuffer.append(String.format("number:        %d\n", this.number));
        stringBuffer.append(String.format("headerLen:     %d\n", this.headerLength));
        stringBuffer.append(String.format("start:         %d\n", this.start));
        stringBuffer.append(String.format("end:           %d\n", this.end));
        stringBuffer.append(String.format("version:       %d\n", this.version));
        stringBuffer.append(String.format("reserved1:     %d\n", this.reserved1));
        stringBuffer.append(String.format("magicNumber:   %8x\n", this.magicNumber));
        stringBuffer.append(String.format(" *buffer start:  %d\n", this.getBufferStartingPosition()));
        stringBuffer.append(String.format(" *next   start:  %d\n", this.nextBufferStartingPosition()));
        return stringBuffer.toString();
    }

    public int getBufferEndingPosition() {
        return this.bufferStartingPosition + 4 * this.end;
    }

    public int getBufferStartingPosition() {
        return this.bufferStartingPosition;
    }

    public void setBufferStartingPosition(int n) {
        this.bufferStartingPosition = n;
    }

    public int nextBufferStartingPosition() {
        return this.bufferStartingPosition + 4 * this.size;
    }

    public int firstEventStartingPosition() {
        if (this.start == 0) {
            return 0;
        }
        return this.bufferStartingPosition + 4 * this.start;
    }

    public int bytesRemaining(int n) throws EvioException {
        if (n < this.bufferStartingPosition) {
            throw new EvioException("Provided position is less than buffer starting position.");
        }
        int n2 = this.nextBufferStartingPosition();
        if (n > n2) {
            throw new EvioException("Provided position beyond buffer end position.");
        }
        return n2 - n;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.size);
        byteBuffer.putInt(this.number);
        byteBuffer.putInt(this.headerLength);
        byteBuffer.putInt(this.start);
        byteBuffer.putInt(this.end);
        byteBuffer.putInt(this.version);
        byteBuffer.putInt(this.reserved1);
        byteBuffer.putInt(this.magicNumber);
        return 32;
    }
}

