/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioFile;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;
import org.jlab.coda.jevio.graphics.EventSource;
import org.jlab.coda.jevio.graphics.EventTreePanel;
import org.jlab.coda.jevio.graphics.cMsgHandler;

public class EventTreeMenu {
    private JMenuItem nextEventItem;
    private JMenu gotoEventItem;
    private JMenuItem xmlExportItem;
    private JMenuItem openEventFile;
    private EventTreePanel eventTreePanel;
    private JMenu sourceConfig;
    private JTextField eventNumberInput;
    private EventSource eventSource = EventSource.FILE;
    boolean dictionarySetByCmsg;
    private cMsgHandler cmsgHandler;
    private JPanel cmsgPanel;
    private JButton connectButton;
    private boolean buttonWillConnect = true;
    private UpdateThread cmsgUpdateThread;

    public EventTreeMenu(EventTreePanel eventTreePanel) {
        this.eventTreePanel = eventTreePanel;
    }

    public EventTreePanel getEventTreePanel() {
        return this.eventTreePanel;
    }

    private void setEventSource(EventSource eventSource) {
        if (eventSource == this.eventSource) {
            return;
        }
        this.eventSource = eventSource;
        this.eventTreePanel.setEvent(null);
        switch (eventSource) {
            case CMSG: {
                this.sourceConfig.setEnabled(true);
                this.sourceConfig.removeAll();
                this.sourceConfig.add(this.cmsgPanel);
                this.sourceConfig.setText("cMsg config");
                this.openEventFile.setEnabled(false);
                this.gotoEventItem.setEnabled(true);
                this.nextEventItem.setEnabled(true);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay("cMsg messages", 0, 0, null);
                this.cmsgUpdateThread = new UpdateThread();
                this.cmsgUpdateThread.start();
                break;
            }
            case FILE: {
                if (this.cmsgUpdateThread != null) {
                    this.cmsgUpdateThread.interrupt();
                }
                if (!this.buttonWillConnect) {
                    this.connectButton.doClick();
                }
                EvioFile evioFile = this.eventTreePanel.getEvioFile();
                this.sourceConfig.setText(" ");
                this.sourceConfig.setEnabled(false);
                this.openEventFile.setEnabled(true);
                if (evioFile == null) {
                    this.gotoEventItem.setEnabled(false);
                    this.nextEventItem.setEnabled(false);
                } else {
                    this.gotoEventItem.setEnabled(true);
                    this.nextEventItem.setEnabled(true);
                    this.xmlExportItem.setEnabled(true);
                }
                String string = "";
                String string2 = null;
                int n = 0;
                if (evioFile != null) {
                    string = this.eventTreePanel.getDataFilePath();
                    String string3 = this.eventTreePanel.getDictionaryFilePath();
                    if (string3 != null) {
                        NameProvider.setProvider(NameProviderFactory.createNameProvider(new File(string3)));
                        string2 = string3;
                    }
                    try {
                        n = evioFile.getEventCount();
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay(string, 0, n, string2);
                break;
            }
            case ET: {
                if (this.cmsgUpdateThread != null) {
                    this.cmsgUpdateThread.interrupt();
                }
                if (!this.buttonWillConnect) {
                    this.connectButton.doClick();
                }
                this.sourceConfig.setText(" ");
                this.sourceConfig.setEnabled(false);
                this.eventTreePanel.getEventInfoPanel().setDisplay("", 0, 0, null);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay("ET buffers", 0, 0, null);
                break;
            }
        }
    }

    public JMenu createEventMenu() {
        final JMenu jMenu = new JMenu(" Event ");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        if (EventTreeMenu.this.eventTreePanel.getEvioFile() == null) break;
                        try {
                            EvioEvent evioEvent = EventTreeMenu.this.eventTreePanel.getEvioFile().parseNextEvent();
                            if (evioEvent == null) break;
                            EventTreeMenu.this.eventTreePanel.setEvent(evioEvent);
                        }
                        catch (EvioException evioException) {
                            evioException.printStackTrace();
                        }
                        break;
                    }
                    case CMSG: {
                        EvioEvent evioEvent;
                        if (EventTreeMenu.this.cmsgHandler == null || (evioEvent = EventTreeMenu.this.cmsgHandler.getNextEvent()) == null) break;
                        EventTreeMenu.this.eventTreePanel.setEvent(evioEvent);
                        EventTreeMenu.this.dictionarySetByCmsg |= EventTreeMenu.this.cmsgHandler.setDictionary();
                        if (!EventTreeMenu.this.dictionarySetByCmsg) break;
                        EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                        break;
                    }
                }
            }
        };
        this.nextEventItem = new JMenuItem("Next Event");
        this.nextEventItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.nextEventItem.addActionListener(actionListener);
        this.nextEventItem.setEnabled(false);
        jMenu.add(this.nextEventItem);
        AbstractAction abstractAction = new AbstractAction("gotoEvent"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        try {
                            EvioEvent evioEvent;
                            int n;
                            String string = "Go to Event (1.." + EventTreeMenu.this.getEventTreePanel().getEvioFile().getEventCount() + ")";
                            String string2 = JOptionPane.showInputDialog(string);
                            if (string2 == null || (n = Integer.parseInt(string2)) <= 0 || n > EventTreeMenu.this.getEventTreePanel().getEvioFile().getEventCount() || (evioEvent = EventTreeMenu.this.getEventTreePanel().getEvioFile().gotoEventNumber(n)) == null) break;
                            EventTreeMenu.this.getEventTreePanel().setEvent(evioEvent);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case CMSG: {
                        int n;
                        if (EventTreeMenu.this.cmsgHandler == null) break;
                        int n2 = EventTreeMenu.this.cmsgHandler.getQueueSize();
                        String string = "Go to Event (1.." + n2 + ")";
                        String string3 = JOptionPane.showInputDialog(string);
                        if (string3 == null || (n = Integer.parseInt(string3)) <= 0 || n > n2) break;
                        EventTreeMenu.this.cmsgHandler.clearQueue(n - 1);
                        EvioEvent evioEvent = EventTreeMenu.this.cmsgHandler.getNextEvent();
                        if (evioEvent == null) break;
                        EventTreeMenu.this.eventTreePanel.setEvent(evioEvent);
                        EventTreeMenu.this.dictionarySetByCmsg |= EventTreeMenu.this.cmsgHandler.setDictionary();
                        if (!EventTreeMenu.this.dictionarySetByCmsg) break;
                        EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                        break;
                    }
                }
            }
        };
        jMenu.getActionMap().put(abstractAction.getValue("Name"), abstractAction);
        jMenu.getInputMap(2).put(KeyStroke.getKeyStroke(71, 2), "gotoEvent");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block12: {
                    try {
                        String string = EventTreeMenu.this.eventNumberInput.getText();
                        if (string == null) break block12;
                        int n = Integer.parseInt(string);
                        switch (EventTreeMenu.this.eventSource) {
                            case FILE: {
                                if (n > 0 && n <= EventTreeMenu.this.eventTreePanel.getEvioFile().getEventCount()) {
                                    EvioEvent evioEvent = EventTreeMenu.this.eventTreePanel.getEvioFile().gotoEventNumber(n);
                                    if (evioEvent != null) {
                                        EventTreeMenu.this.eventTreePanel.setEvent(evioEvent);
                                    }
                                    break;
                                }
                                EventTreeMenu.this.eventNumberInput.setText("");
                                break;
                            }
                            case CMSG: {
                                if (EventTreeMenu.this.cmsgHandler == null) break;
                                int n2 = EventTreeMenu.this.cmsgHandler.getQueueSize();
                                if (n > 0 && n <= n2) {
                                    EventTreeMenu.this.cmsgHandler.clearQueue(n - 1);
                                    EvioEvent evioEvent = EventTreeMenu.this.cmsgHandler.getNextEvent();
                                    if (evioEvent != null) {
                                        EventTreeMenu.this.eventTreePanel.setEvent(evioEvent);
                                        EventTreeMenu.this.dictionarySetByCmsg |= EventTreeMenu.this.cmsgHandler.setDictionary();
                                        if (EventTreeMenu.this.dictionarySetByCmsg) {
                                            EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        EventTreeMenu.this.eventNumberInput.setText("");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.gotoEventItem = new JMenu("Go to Event ...            ");
        this.eventNumberInput = new JTextField();
        this.eventNumberInput.setPreferredSize(new Dimension(100, 20));
        this.eventNumberInput.addActionListener(actionListener2);
        this.gotoEventItem.add(this.eventNumberInput);
        this.gotoEventItem.setEnabled(false);
        jMenu.add(this.gotoEventItem);
        jMenu.addSeparator();
        JLabel jLabel = new JLabel("Event Sources");
        jLabel.setBorder(new EmptyBorder(3, 20, 3, 0));
        jLabel.setHorizontalTextPosition(0);
        jMenu.add(jLabel);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("File");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("cMsg");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("ET (not available)");
        EmptyBorder emptyBorder = new EmptyBorder(3, 30, 3, 0);
        jRadioButtonMenuItem.setBorder(emptyBorder);
        jRadioButtonMenuItem2.setBorder(emptyBorder);
        jRadioButtonMenuItem3.setBorder(emptyBorder);
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EventTreeMenu.this.cmsgPanel == null) {
                    EventTreeMenu.this.cmsgPanel = EventTreeMenu.this.createCmsgPanel();
                }
                EventTreeMenu.this.setEventSource(EventSource.CMSG);
                jMenu.doClick();
            }
        };
        jRadioButtonMenuItem2.addActionListener(actionListener3);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.setEventSource(EventSource.FILE);
                jMenu.doClick();
            }
        };
        jRadioButtonMenuItem.addActionListener(actionListener4);
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.setEventSource(EventSource.ET);
                jMenu.doClick();
            }
        };
        jRadioButtonMenuItem3.addActionListener(actionListener5);
        jRadioButtonMenuItem3.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem3);
        jMenu.addSeparator();
        this.sourceConfig = new JMenu("");
        this.sourceConfig.setText(" ");
        this.sourceConfig.setEnabled(false);
        jMenu.add(this.sourceConfig);
        return jMenu;
    }

    public JMenu createViewMenu() {
        JMenu jMenu = new JMenu(" View ");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = jMenuItem.getText();
                if (string.equals("Hexidecimal")) {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(true);
                    jMenuItem.setText("Decimal");
                } else {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(false);
                    jMenuItem.setText("Hexidecimal");
                }
                EventTreeMenu.this.eventTreePanel.refreshDisplay();
            }
        };
        JMenuItem jMenuItem = new JMenuItem("Hexidecimal");
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenu createFileMenu() {
        JMenu jMenu = new JMenu(" File ");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.doOpenEventFile();
            }
        };
        this.openEventFile = new JMenuItem("Open Event File...");
        this.openEventFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openEventFile.addActionListener(actionListener);
        jMenu.add(this.openEventFile);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.doOpenDictionary();
            }
        };
        JMenuItem jMenuItem = new JMenuItem("Open Dictionary...");
        jMenuItem.addActionListener(actionListener2);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.doXMLFileExport();
            }
        };
        this.xmlExportItem = new JMenuItem("Export File to XML...");
        this.xmlExportItem.addActionListener(actionListener3);
        this.xmlExportItem.setEnabled(false);
        jMenu.add(this.xmlExportItem);
        jMenu.addSeparator();
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
        JMenuItem jMenuItem2 = new JMenuItem("Quit");
        jMenuItem2.addActionListener(actionListener4);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private void doXMLFileExport() {
        this.eventTreePanel.exportToXML();
    }

    private void doOpenEventFile() {
        EvioFile evioFile;
        EvioFile evioFile2 = this.eventTreePanel.getEvioFile();
        if (evioFile2 == (evioFile = this.eventTreePanel.openEventFile())) {
            return;
        }
        this.nextEventItem.setEnabled(evioFile != null);
        this.gotoEventItem.setEnabled(evioFile != null);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
        try {
            if (evioFile != null) {
                this.gotoEventItem.setText("Go to Event (1.." + this.eventTreePanel.getEvioFile().getEventCount() + ")");
            }
        }
        catch (EvioException evioException) {
            // empty catch block
        }
    }

    public void manualOpenEventFile(File file) {
        EvioFile evioFile;
        EvioFile evioFile2 = this.eventTreePanel.getEvioFile();
        if (evioFile2 == (evioFile = this.eventTreePanel.openEventFile(file))) {
            return;
        }
        this.nextEventItem.setEnabled(evioFile != null);
        this.gotoEventItem.setEnabled(evioFile != null);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
        try {
            if (evioFile != null) {
                this.gotoEventItem.setText("Go to Event (1.." + this.eventTreePanel.getEvioFile().getEventCount() + ")");
            }
        }
        catch (EvioException evioException) {
            // empty catch block
        }
    }

    private void doOpenDictionary() {
        if (this.eventTreePanel.openDictionary()) {
            this.dictionarySetByCmsg = false;
        }
    }

    public JPanel createCmsgPanel() {
        final Color color = new Color(0, 160, 0);
        final Color color2 = new Color(160, 0, 0);
        final JTextField jTextField = new JTextField("cMsg://localhost/cMsg/myNameSpace");
        final JTextField jTextField2 = new JTextField("evio");
        final JTextField jTextField3 = new JTextField("*");
        jTextField.setEditable(true);
        jTextField.setMargin(new Insets(2, 5, 2, 5));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EventTreeMenu.this.cmsgHandler.subscribe(jTextField2.getText(), jTextField3.getText());
                }
                catch (cMsgException cMsgException2) {
                    cMsgException2.printStackTrace();
                    jTextField2.setText("evio");
                }
            }
        };
        jTextField2.addActionListener(actionListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                try {
                    if (EventTreeMenu.this.cmsgHandler != null) {
                        EventTreeMenu.this.cmsgHandler.subscribe(jTextField2.getText(), jTextField3.getText());
                    }
                }
                catch (cMsgException cMsgException2) {
                    cMsgException2.printStackTrace();
                    jTextField2.setText("evio");
                }
            }
        };
        jTextField2.addMouseListener(mouseAdapter);
        jTextField2.setEditable(true);
        jTextField2.setMargin(new Insets(2, 5, 2, 5));
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EventTreeMenu.this.cmsgHandler.subscribe(jTextField2.getText(), jTextField3.getText());
                }
                catch (cMsgException cMsgException2) {
                    cMsgException2.printStackTrace();
                    jTextField2.setText("*");
                }
            }
        };
        jTextField3.addActionListener(actionListener2);
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                try {
                    if (EventTreeMenu.this.cmsgHandler != null) {
                        EventTreeMenu.this.cmsgHandler.subscribe(jTextField2.getText(), jTextField3.getText());
                    }
                }
                catch (cMsgException cMsgException2) {
                    cMsgException2.printStackTrace();
                    jTextField2.setText("*");
                }
            }
        };
        jTextField3.addMouseListener(mouseAdapter2);
        jTextField3.setEditable(true);
        jTextField3.setMargin(new Insets(2, 5, 2, 5));
        final JLabel jLabel = new JLabel("  Press button to connect to cMsg server  ");
        jLabel.setVerticalTextPosition(0);
        jLabel.setBorder(new LineBorder(Color.black));
        JPanel jPanel = new JPanel();
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText().equals("Connect")) {
                    if (EventTreeMenu.this.cmsgHandler == null) {
                        EventTreeMenu.this.cmsgHandler = cMsgHandler.getInstance();
                    }
                    try {
                        EventTreeMenu.this.cmsgHandler.connect(jTextField.getText());
                        EventTreeMenu.this.cmsgHandler.subscribe(jTextField2.getText(), jTextField3.getText());
                    }
                    catch (cMsgException cMsgException2) {
                        jLabel.setForeground(Color.red);
                        jLabel.setText(" Failed to connect to cmsg server");
                        return;
                    }
                    jTextField.setEnabled(false);
                    jLabel.setForeground(color);
                    jLabel.setText(" Connected to cmsg server");
                    EventTreeMenu.this.connectButton.setText("Disconnect");
                    EventTreeMenu.this.buttonWillConnect = false;
                } else {
                    EventTreeMenu.this.cmsgHandler.disconnect();
                    jTextField.setEnabled(true);
                    jLabel.setForeground(color2);
                    jLabel.setText(" Disconnected from cmsg server");
                    EventTreeMenu.this.connectButton.setText("Connect");
                    EventTreeMenu.this.buttonWillConnect = true;
                }
            }
        };
        this.connectButton = new JButton("Connect");
        this.connectButton.setAlignmentX(0.5f);
        this.connectButton.addActionListener(actionListener3);
        this.connectButton.setEnabled(true);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTreeMenu.this.cmsgHandler.clearQueue();
            }
        };
        JButton jButton = new JButton("Clear Message Queue");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(actionListener4);
        jPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        jPanel.setLayout(new GridLayout(0, 2));
        jPanel.add(this.connectButton);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 0));
        JLabel jLabel2 = new JLabel("UDL ");
        jLabel2.setHorizontalAlignment(4);
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel("Subject ");
        jLabel3.setHorizontalAlignment(4);
        jPanel2.add(jLabel3);
        JLabel jLabel4 = new JLabel("Type ");
        jLabel4.setHorizontalAlignment(4);
        jPanel2.add(jLabel4);
        JLabel jLabel5 = new JLabel("Status ");
        jLabel5.setHorizontalAlignment(4);
        jPanel2.add(jLabel5);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(4, 0));
        jPanel3.add(jTextField);
        jPanel3.add(jTextField2);
        jPanel3.add(jTextField3);
        jPanel3.add(jLabel);
        Dimension dimension = jPanel2.getPreferredSize();
        dimension.height = jPanel3.getPreferredSize().height;
        jPanel2.setMaximumSize(dimension);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel4.add(Box.createRigidArea(new Dimension(3, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel5.add(jPanel4);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel5.add(jPanel);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 5)));
        return jPanel5;
    }

    private class UpdateThread
    extends Thread {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (EventTreeMenu.this.cmsgHandler != null) {
                    EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDisplay("cMsg messages", 0, EventTreeMenu.this.cmsgHandler.getQueueSize(), null);
                }
            }
        };

        private UpdateThread() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                SwingUtilities.invokeLater(this.r);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

