/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.StructureType;

public class StructureFinder {
    public static List<BaseStructure> getMatchingStructures(EvioEvent evioEvent, IEvioFilter iEvioFilter) {
        if (evioEvent == null) {
            return null;
        }
        return evioEvent.getMatchingStructures(iEvioFilter);
    }

    public static List<BaseStructure> getMatchingBanks(EvioEvent evioEvent, final int n, final int n2) {
        IEvioFilter iEvioFilter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType structureType, BaseStructureHeader baseStructureHeader) {
                return structureType == StructureType.BANK && n == baseStructureHeader.tag && n2 == baseStructureHeader.number;
            }
        };
        return StructureFinder.getMatchingStructures(evioEvent, iEvioFilter);
    }

    public static List<BaseStructure> getMatchingStructures(EvioEvent evioEvent, final int n) {
        IEvioFilter iEvioFilter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType structureType, BaseStructureHeader baseStructureHeader) {
                return n == baseStructureHeader.tag;
            }
        };
        return StructureFinder.getMatchingStructures(evioEvent, iEvioFilter);
    }

    public static List<BaseStructure> getMatchingNonBanks(EvioEvent evioEvent, final int n) {
        IEvioFilter iEvioFilter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType structureType, BaseStructureHeader baseStructureHeader) {
                return structureType != StructureType.BANK && n == baseStructureHeader.tag;
            }
        };
        return StructureFinder.getMatchingStructures(evioEvent, iEvioFilter);
    }
}

