/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.TagSegmentHeader;

public class EventParser {
    private EventListenerList evioListenerList;
    protected boolean notificationActive = true;
    private static EventParser parser = new EventParser();
    private IEvioFilter evioFilter;

    public static EventParser getInstance() {
        return parser;
    }

    public synchronized void parseEvent(EvioEvent evioEvent) throws EvioException {
        if (evioEvent == null) {
            throw new EvioException("Null event in parseEvent.");
        }
        this.notifyStart(evioEvent);
        this.parseStructure(evioEvent, evioEvent);
        this.notifyStop(evioEvent);
    }

    private void parseStructure(EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        BaseStructure baseStructure2 = baseStructure;
        BaseStructure baseStructure3 = baseStructure2.getParent();
        if (baseStructure3 == null) {
            evioEvent.treeModel = new DefaultTreeModel(evioEvent);
        } else {
            evioEvent.insert(baseStructure2, baseStructure3);
        }
        DataType dataType = baseStructure.getHeader().getDataTypeEnum();
        if (!dataType.isStructure()) {
            this.notifyEvioListeners(evioEvent, baseStructure);
            return;
        }
        if (dataType.isStructure()) {
            byte[] byArray = baseStructure.getRawBytes();
            ByteOrder byteOrder = baseStructure.getByteOrder();
            if (byArray == null && evioEvent == null) {
                throw new EvioException("Null data in parseStructure (Bank).");
            }
            int n = byArray.length;
            switch (dataType) {
                case BANK: 
                case ALSOBANK: {
                    int n2;
                    BankHeader bankHeader;
                    for (n2 = 0; n2 < n; n2 += 4 * (bankHeader.getLength() + 1)) {
                        bankHeader = this.createBankHeader(byArray, n2, byteOrder);
                        int n3 = 4 * (bankHeader.getLength() - 1);
                        byte[] byArray2 = new byte[n3];
                        System.arraycopy(byArray, n2 + 8, byArray2, 0, n3);
                        EvioBank evioBank = new EvioBank(bankHeader);
                        evioBank.setParent(baseStructure);
                        evioBank.setRawBytes(byArray2);
                        evioBank.setByteOrder(byteOrder);
                        this.parseStructure(evioEvent, evioBank);
                    }
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: {
                    int n2;
                    while (n2 < n) {
                        SegmentHeader segmentHeader = this.createSegmentHeader(byArray, n2, byteOrder);
                        int n4 = 4 * segmentHeader.getLength();
                        byte[] byArray3 = new byte[n4];
                        System.arraycopy(byArray, n2 + 4, byArray3, 0, n4);
                        EvioSegment evioSegment = new EvioSegment(segmentHeader);
                        evioSegment.setParent(baseStructure);
                        evioSegment.setRawBytes(byArray3);
                        evioSegment.setByteOrder(byteOrder);
                        this.parseStructure(evioEvent, evioSegment);
                        n2 += 4 * (segmentHeader.getLength() + 1);
                    }
                    break;
                }
                case TAGSEGMENT: 
                case ALSOTAGSEGMENT: {
                    int n2;
                    while (n2 < n) {
                        TagSegmentHeader tagSegmentHeader = this.createTagSegmentHeader(byArray, n2, byteOrder);
                        int n5 = 4 * tagSegmentHeader.getLength();
                        byte[] byArray4 = new byte[n5];
                        System.arraycopy(byArray, n2 + 4, byArray4, 0, n5);
                        EvioTagSegment evioTagSegment = new EvioTagSegment(tagSegmentHeader);
                        evioTagSegment.setParent(baseStructure);
                        evioTagSegment.setRawBytes(byArray4);
                        evioTagSegment.setByteOrder(byteOrder);
                        this.parseStructure(evioEvent, evioTagSegment);
                        n2 += 4 * (tagSegmentHeader.getLength() + 1);
                    }
                    break;
                }
            }
        }
        this.notifyEvioListeners(evioEvent, baseStructure);
    }

    private BankHeader createBankHeader(byte[] byArray, int n, ByteOrder byteOrder) {
        BankHeader bankHeader = new BankHeader();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        byteBuffer.position(n);
        bankHeader.setLength(byteBuffer.getInt());
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            bankHeader.setTag(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            bankHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setNumber(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
        } else {
            bankHeader.setNumber(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setTag(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        }
        return bankHeader;
    }

    private SegmentHeader createSegmentHeader(byte[] byArray, int n, ByteOrder byteOrder) {
        SegmentHeader segmentHeader = new SegmentHeader();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        byteBuffer.position(n);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            segmentHeader.setTag(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        } else {
            segmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            segmentHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setTag(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
        }
        return segmentHeader;
    }

    private TagSegmentHeader createTagSegmentHeader(byte[] byArray, int n, ByteOrder byteOrder) {
        TagSegmentHeader tagSegmentHeader = new TagSegmentHeader();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        byteBuffer.position(n);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            int n2 = ByteDataTransformer.shortBitsToInt(byteBuffer.getShort());
            tagSegmentHeader.setTag(n2 >>> 4);
            tagSegmentHeader.setDataType(n2 & 0xF);
            tagSegmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        } else {
            tagSegmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            int n3 = ByteDataTransformer.shortBitsToInt(byteBuffer.getShort());
            tagSegmentHeader.setTag(n3 >>> 4);
            tagSegmentHeader.setDataType(n3 & 0xF);
        }
        return tagSegmentHeader;
    }

    protected void notifyEvioListeners(EvioEvent evioEvent, IEvioStructure iEvioStructure) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        if (this.evioFilter != null && !this.evioFilter.accept(iEvioStructure.getStructureType(), iEvioStructure.getHeader())) {
            return;
        }
        Object[] objectArray = this.evioListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IEvioListener.class) continue;
            ((IEvioListener)objectArray[i + 1]).gotStructure(evioEvent, iEvioStructure);
        }
    }

    protected void notifyStart(EvioEvent evioEvent) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        Object[] objectArray = this.evioListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IEvioListener.class) continue;
            ((IEvioListener)objectArray[i + 1]).startEventParse(evioEvent);
        }
    }

    protected void notifyStop(EvioEvent evioEvent) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        Object[] objectArray = this.evioListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IEvioListener.class) continue;
            ((IEvioListener)objectArray[i + 1]).endEventParse(evioEvent);
        }
    }

    public void removeEvioListener(IEvioListener iEvioListener) {
        if (iEvioListener == null || this.evioListenerList == null) {
            return;
        }
        this.evioListenerList.remove(IEvioListener.class, iEvioListener);
    }

    public void addEvioListener(IEvioListener iEvioListener) {
        if (iEvioListener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, iEvioListener);
    }

    public boolean isNotificationActive() {
        return this.notificationActive;
    }

    public void setNotificationActive(boolean bl) {
        this.notificationActive = bl;
    }

    public void setEvioFilter(IEvioFilter iEvioFilter) {
        this.evioFilter = iEvioFilter;
    }
}

