/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioFile;
import org.jlab.coda.jevio.IEvioProgressListener;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;
import org.jlab.coda.jevio.graphics.EventInfoPanel;
import org.jlab.coda.jevio.graphics.HeaderPanel;

public class EventTreePanel
extends JPanel
implements TreeSelectionListener {
    private String dataFilePath;
    private String dictionaryFilePath;
    private String xmlFilePath;
    private HeaderPanel headerPanel = new HeaderPanel();
    private EventInfoPanel eventInfoPanel = new EventInfoPanel();
    private JTree tree;
    private EvioFile evioFile;
    private FileNameExtensionFilter evioFileFilter;
    private EvioEvent event;
    private JTextArea textArea;
    private JProgressBar progressBar;
    private boolean intsInHex;

    public EventTreePanel() {
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    public void setIntsInHex(boolean bl) {
        this.intsInHex = bl;
    }

    public String getDataFilePath() {
        return this.dataFilePath;
    }

    public String getDictionaryFilePath() {
        return this.dictionaryFilePath;
    }

    public EventInfoPanel getEventInfoPanel() {
        return this.eventInfoPanel;
    }

    public void refreshDisplay() {
        this.valueChanged(null);
    }

    protected void addComponents() {
        this.add((Component)this.eventInfoPanel, "North");
        this.add((Component)this.createTree(), "Center");
        this.add((Component)this.createTextArea(), "West");
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createTitledBorder(null, "progress", 4, 2, null, Color.blue));
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.headerPanel, "Center");
        jPanel.add((Component)this.progressBar, "West");
        this.add((Component)jPanel, "South");
    }

    private JScrollPane createTree() {
        this.tree = new JTree();
        this.tree.setModel(null);
        this.tree.setBorder(BorderFactory.createTitledBorder(null, "Tree representation of the EVIO event", 4, 2, null, Color.blue));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.tree);
        return jScrollPane;
    }

    private JScrollPane createTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createTitledBorder(null, "Array Data", 4, 2, null, Color.blue));
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(200, 1000));
        return jScrollPane;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BaseStructure baseStructure = (BaseStructure)this.tree.getLastSelectedPathComponent();
        this.textArea.setText("");
        int n = 5;
        if (baseStructure == null) {
            return;
        }
        this.headerPanel.setHeader(baseStructure);
        if (baseStructure.isLeaf()) {
            int n2 = 1;
            int n3 = 1;
            BaseStructureHeader baseStructureHeader = baseStructure.getHeader();
            switch (baseStructureHeader.getDataTypeEnum()) {
                case DOUBLE64: {
                    double[] dArray = baseStructure.getDoubleData();
                    if (dArray != null) {
                        for (double d : dArray) {
                            String string = String.format("[%02d]  %15.11e", n3++, d);
                            this.textArea.append(string);
                            if (n2 >= dArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case FLOAT32: {
                    float[] fArray = baseStructure.getFloatData();
                    if (fArray != null) {
                        for (float f : fArray) {
                            String string = String.format("[%02d]  %10.6e", n3++, Float.valueOf(f));
                            this.textArea.append(string);
                            if (n2 >= fArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    long[] lArray = baseStructure.getLongData();
                    if (lArray != null) {
                        for (long l : lArray) {
                            String string = this.intsInHex ? String.format("[%02d]  %#018X", n3++, l) : String.format("[%02d]  %d", n3++, l);
                            this.textArea.append(string);
                            if (n2 >= lArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case INT32: 
                case UINT32: {
                    int[] nArray = baseStructure.getIntData();
                    if (nArray != null) {
                        for (int n4 : nArray) {
                            String string = this.intsInHex ? String.format("[%02d]  %#010X", n3++, n4) : String.format("[%02d]  %d", n3++, n4);
                            this.textArea.append(string);
                            if (n2 >= nArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    short[] sArray = baseStructure.getShortData();
                    if (sArray != null) {
                        for (short s : sArray) {
                            String string = this.intsInHex ? String.format("[%02d]  %#06X", n3++, s) : String.format("[%02d]  %d", n3++, s);
                            this.textArea.append(string);
                            if (n2 >= sArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    byte[] byArray = baseStructure.getByteData();
                    if (byArray != null) {
                        for (byte by : byArray) {
                            String string = String.format("[%02d]  %d", n3++, by);
                            this.textArea.append(string);
                            if (n2 >= byArray.length) continue;
                            if (n2 % n == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++n2;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case CHARSTAR8: {
                    String[] stringArray;
                    for (String string : stringArray = baseStructure.getStringData()) {
                        String string2;
                        this.textArea.append((string2 = String.format("[%02d]  %s\n", n3++, string)) != null ? string2 : "null data\n");
                    }
                    break;
                }
            }
        }
        this.tree.repaint();
    }

    public EvioFile getEvioFile() {
        return this.evioFile;
    }

    public void setEvioFile(EvioFile evioFile) {
        this.evioFile = evioFile;
    }

    public EvioEvent getEvent() {
        return this.event;
    }

    public void setEvent(EvioEvent evioEvent) {
        this.event = evioEvent;
        if (evioEvent != null) {
            this.tree.setModel(evioEvent.getTreeModel());
            this.headerPanel.setHeader(evioEvent);
            this.eventInfoPanel.setEventNumber(evioEvent.getEventNumber());
            this.expandAll();
        } else {
            this.tree.setModel(null);
            this.headerPanel.setHeader(null);
            this.eventInfoPanel.setEventNumber(0);
        }
    }

    public void expandAll() {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        }
    }

    public void exportToXML() {
        this.progressBar.setValue(0);
        JFileChooser jFileChooser = new JFileChooser(this.xmlFilePath);
        jFileChooser.setSelectedFile(null);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("XML Evio Files", "xml");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = jFileChooser.getSelectedFile();
            this.xmlFilePath = file.getAbsolutePath();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, file.getPath() + "  already exists. Do you want to overwrite it?", "Overwite Existing File?", 0)) != 0) {
                return;
            }
            final IEvioProgressListener iEvioProgressListener = new IEvioProgressListener(){

                @Override
                public void completed(int n, int n2) {
                    int n3 = (int)(100.0 * (double)n / (double)n2);
                    EventTreePanel.this.progressBar.setValue(n3);
                    EventTreePanel.this.progressBar.repaint();
                }
            };
            final EventTreePanel eventTreePanel = this;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EventTreePanel.this.evioFile.toXMLFile(EventTreePanel.this.xmlFilePath, iEvioProgressListener);
                    EventTreePanel.this.progressBar.setValue(0);
                    JOptionPane.showMessageDialog(eventTreePanel, "XML Writing has completed.", "Done", 1);
                }
            };
            new Thread(runnable).start();
        }
    }

    public void addEventFileExtension(String string) {
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio", string);
        } else {
            String[] stringArray = this.evioFileFilter.getExtensions();
            String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray2[stringArray.length] = string;
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", stringArray2);
        }
    }

    public void setEventFileExtensions(String[] stringArray) {
        this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", stringArray);
    }

    public EvioFile openEventFile() {
        this.eventInfoPanel.setEventNumber(0);
        JFileChooser jFileChooser = new JFileChooser(this.dataFilePath);
        jFileChooser.setSelectedFile(null);
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio");
        }
        jFileChooser.setFileFilter(this.evioFileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.headerPanel.setHeader(null);
            File file = jFileChooser.getSelectedFile();
            this.dataFilePath = file.getAbsolutePath();
            this.eventInfoPanel.setSource(this.dataFilePath);
            if (this.evioFile != null) {
                this.evioFile.close();
                this.eventInfoPanel.setNumberOfEvents(0);
            }
            try {
                this.evioFile = new EvioFile(file);
                this.eventInfoPanel.setNumberOfEvents(this.evioFile.getEventCount());
            }
            catch (EvioException evioException) {
                this.evioFile = null;
                evioException.printStackTrace();
            }
            catch (IOException iOException) {
                this.evioFile = null;
                iOException.printStackTrace();
            }
        }
        return this.evioFile;
    }

    public EvioFile openEventFile(File file) {
        this.eventInfoPanel.setEventNumber(0);
        this.headerPanel.setHeader(null);
        this.dataFilePath = file.getAbsolutePath();
        this.eventInfoPanel.setSource(this.dataFilePath);
        if (this.evioFile != null) {
            this.evioFile.close();
            this.eventInfoPanel.setNumberOfEvents(0);
        }
        try {
            this.evioFile = new EvioFile(file);
            this.eventInfoPanel.setNumberOfEvents(this.evioFile.getEventCount());
        }
        catch (EvioException evioException) {
            this.evioFile = null;
            evioException.printStackTrace();
        }
        catch (IOException iOException) {
            this.evioFile = null;
            iOException.printStackTrace();
        }
        return this.evioFile;
    }

    public void setDefaultDataDir(String string) {
        this.dataFilePath = string;
    }

    public boolean openDictionary() {
        JFileChooser jFileChooser = new JFileChooser(this.dictionaryFilePath);
        jFileChooser.setSelectedFile(null);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Dictionary Files", "xml", "dict", "txt");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            NameProvider.setProvider(NameProviderFactory.createNameProvider(file));
            this.dictionaryFilePath = file.getAbsolutePath();
            this.eventInfoPanel.setDictionary(this.dictionaryFilePath);
            return true;
        }
        return false;
    }

    public void openDictionaryFile(File file) {
        if (file != null) {
            NameProvider.setProvider(NameProviderFactory.createNameProvider(file));
            this.dictionaryFilePath = file.getAbsolutePath();
            this.eventInfoPanel.setDictionary(this.dictionaryFilePath);
        }
    }
}

