/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import org.jlab.coda.jevio.graphics.EventTreeMenu;
import org.jlab.coda.jevio.graphics.EventTreePanel;

public class EventTreeFrame
extends JFrame {
    public EventTreeFrame() {
        super("Jevio Event Tree");
        this.initializeLookAndFeel();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Exiting.");
                System.exit(0);
            }
        };
        this.addWindowListener(windowAdapter);
        this.addComponents();
        this.sizeToScreen(this, 0.85);
    }

    protected void addComponents() {
        EventTreePanel eventTreePanel = new EventTreePanel();
        this.addMenus(eventTreePanel);
        this.add((Component)eventTreePanel, "Center");
    }

    protected void addMenus(EventTreePanel eventTreePanel) {
        JMenuBar jMenuBar = new JMenuBar();
        EventTreeMenu eventTreeMenu = new EventTreeMenu(eventTreePanel);
        jMenuBar.add(eventTreeMenu.createFileMenu());
        jMenuBar.add(eventTreeMenu.createViewMenu());
        jMenuBar.add(eventTreeMenu.createEventMenu());
        this.setJMenuBar(jMenuBar);
    }

    private void sizeToScreen(JFrame jFrame, double d) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width = (int)(d * 0.65 * (double)dimension.width);
        dimension.height = (int)(d * (double)dimension.height);
        jFrame.setSize(dimension);
        this.centerComponent(jFrame);
    }

    private void centerComponent(Component component) {
        if (component == null) {
            return;
        }
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = component.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            component.setLocation(n, n2);
        }
        catch (Exception exception) {
            component.setLocation(200, 200);
            exception.printStackTrace();
        }
    }

    private void initializeLookAndFeel() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (lookAndFeelInfoArray == null || lookAndFeelInfoArray.length < 1) {
            return;
        }
        String string = "Windows";
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (!lookAndFeelInfoArray[i].getName().equals(string)) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeelInfoArray[i].getClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static void main(String[] stringArray) {
        final EventTreeFrame eventTreeFrame = new EventTreeFrame();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                eventTreeFrame.setVisible(true);
            }
        });
    }
}

