/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;

public final class TagSegmentHeader
extends BaseStructureHeader {
    public TagSegmentHeader() {
    }

    public TagSegmentHeader(int n, DataType dataType) {
        super(n, dataType);
    }

    public TagSegmentHeader(int n, int n2) {
        super(n, n2);
    }

    @Override
    public int getHeaderLength() {
        return 1;
    }

    @Override
    protected void toArray(byte[] byArray, int n, ByteOrder byteOrder) {
        short s = (short)(this.tag << 4 | this.dataType & 0xF);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ByteDataTransformer.shortToBytes(s, byArray, n);
            ByteDataTransformer.shortToBytes(this.shortValue(this.length), byArray, n + 2);
        } else {
            ByteDataTransformer.shortToBytes(Short.reverseBytes(this.shortValue(this.length)), byArray, n);
            ByteDataTransformer.shortToBytes(Short.reverseBytes(s), byArray, n + 2);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(String.format("tag-seg length: %d\n", this.length));
        stringBuffer.append(String.format("number:         %d\n", this.number));
        stringBuffer.append(String.format("data type:      %s\n", this.getDataTypeName()));
        stringBuffer.append(String.format("tag:            %d\n", this.tag));
        return stringBuffer.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        short s = (short)(this.tag << 4 | this.dataType & 0xF);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.putShort(s);
            byteBuffer.putShort(this.shortValue(this.length));
        } else {
            byteBuffer.putShort(this.shortValue(this.length));
            byteBuffer.putShort(s);
        }
        return 4;
    }
}

