/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.EvioDictionaryEntry;
import org.jlab.coda.jevio.INameProvider;
import org.jlab.coda.jevio.NameProvider;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EvioXMLDictionary
extends Vector<EvioDictionaryEntry>
implements INameProvider {
    private static String ENTRY = "xmldumpDictEntry";
    private static String NAME = "name";
    private static String TAG = "tag";
    private static String NUM = "num";

    public EvioXMLDictionary(File file) {
        this(EvioXMLDictionary.getDomObject(file));
    }

    public EvioXMLDictionary(String string) {
        this(EvioXMLDictionary.getDomObject(string));
    }

    public EvioXMLDictionary(Document document) {
        super(100);
        NodeList nodeList;
        if (document != null && (nodeList = document.getElementsByTagName(ENTRY)) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2;
                Node node3 = nodeList.item(i);
                if (node3 == null || !node3.hasAttributes()) continue;
                String string = null;
                String string2 = null;
                String string3 = null;
                NamedNodeMap namedNodeMap = node3.getAttributes();
                Node node4 = namedNodeMap.getNamedItem(NAME);
                if (node4 != null) {
                    string = node4.getNodeValue();
                }
                if ((node2 = namedNodeMap.getNamedItem(TAG)) != null) {
                    string2 = node2.getNodeValue();
                }
                if ((node = namedNodeMap.getNamedItem(NUM)) != null) {
                    string3 = node.getNodeValue();
                }
                this.add(new EvioDictionaryEntry(string2, string3, string));
            }
        }
        Collections.sort(this);
    }

    @Override
    public String getName(BaseStructure baseStructure) {
        for (EvioDictionaryEntry evioDictionaryEntry : this) {
            if (!evioDictionaryEntry.match(baseStructure)) continue;
            return evioDictionaryEntry.getDescription();
        }
        return NameProvider.NO_NAME_STRING;
    }

    private static Document getDomObject(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private static Document getDomObject(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("-- Dictionary --\n");
        for (EvioDictionaryEntry evioDictionaryEntry : this) {
            stringBuffer.append(evioDictionaryEntry + "\n");
        }
        return stringBuffer.toString();
    }
}

