/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioFile;

public class EvioFileTest {
    public static int totalBlockCount(EvioFile evioFile) {
        evioFile.rewind();
        EvioFile.ReadStatus readStatus = EvioFile.ReadStatus.SUCCESS;
        int n = 0;
        while (readStatus == EvioFile.ReadStatus.SUCCESS) {
            readStatus = evioFile.nextBlockHeader();
            if (readStatus != EvioFile.ReadStatus.SUCCESS) continue;
            evioFile.position(evioFile.getCurrentBlockHeader().nextBufferStartingPosition());
            ++n;
        }
        System.out.println("total block count: " + n);
        evioFile.rewind();
        return n;
    }

    public static TestResult readAllBlockHeadersTest(EvioFile evioFile) {
        TestResult testResult;
        evioFile.rewind();
        EvioFile.ReadStatus readStatus = EvioFile.ReadStatus.SUCCESS;
        int n = 0;
        while (readStatus == EvioFile.ReadStatus.SUCCESS) {
            readStatus = evioFile.nextBlockHeader();
            if (readStatus != EvioFile.ReadStatus.SUCCESS) continue;
            evioFile.position(evioFile.getCurrentBlockHeader().nextBufferStartingPosition());
            ++n;
        }
        if (readStatus == EvioFile.ReadStatus.END_OF_FILE) {
            System.out.println("Total blocks read: " + n);
            testResult = TestResult.PASS;
        } else {
            testResult = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)testResult));
        evioFile.rewind();
        return testResult;
    }

    public static TestResult readAllEventsTest(EvioFile evioFile) {
        int n = evioFile.position();
        evioFile.rewind();
        int n2 = 0;
        TestResult testResult = TestResult.PASS;
        try {
            EvioEvent evioEvent;
            while ((evioEvent = evioFile.nextEvent()) != null) {
                BaseStructureHeader baseStructureHeader = evioEvent.getHeader();
                System.out.println(++n2 + ")  size: " + baseStructureHeader.getLength() + " type: " + baseStructureHeader.getDataTypeName() + " \"" + evioEvent.getDescription() + "\"");
            }
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            testResult = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)testResult));
        evioFile.position(n);
        return testResult;
    }

    public static TestResult parseEventsTest(EvioFile evioFile, int n) {
        int n2;
        int n3 = evioFile.position();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        evioFile.rewind();
        TestResult testResult = TestResult.PASS;
        try {
            EvioEvent evioEvent;
            for (n2 = 0; n2 < n && (evioEvent = evioFile.nextEvent()) != null; ++n2) {
                evioFile.parseEvent(evioEvent);
            }
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            testResult = TestResult.FAIL;
        }
        System.out.println("parseEventsTest parsed: " + n2 + " events");
        System.out.println("parseEventsTest result: " + (Object)((Object)testResult));
        evioFile.position(n3);
        return testResult;
    }

    public static enum TestResult {
        PASS,
        FAIL;

    }
}

