/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.StringTokenizer;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;

public class EvioDictionaryEntry
implements Comparable<EvioDictionaryEntry> {
    private int tag;
    private int[] numbers;
    private String description;

    public EvioDictionaryEntry(String string, String string2, String string3) {
        this.description = string3;
        this.tag = Integer.parseInt(string);
        if (string2 != null) {
            String[] stringArray = this.tokens(string2, ".");
            this.numbers = new int[stringArray.length];
            int n = 0;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                this.numbers[n] = Integer.parseInt(stringArray[i]);
                ++n;
            }
        }
    }

    public boolean match(BaseStructure baseStructure) {
        if (baseStructure instanceof EvioEvent) {
            if (this.numbers == null || this.numbers.length != 1) {
                return false;
            }
            BaseStructureHeader baseStructureHeader = baseStructure.header;
            return this.tag == baseStructureHeader.tag && this.numbers[0] == baseStructureHeader.number;
        }
        if (baseStructure instanceof EvioBank) {
            if (baseStructure.header.tag != this.tag) {
                return false;
            }
            if (this.numbers == null) {
                return false;
            }
            for (int i = 0; i < this.numbers.length; ++i) {
                BaseStructureHeader baseStructureHeader = baseStructure.header;
                if (this.numbers[i] != baseStructureHeader.number) {
                    return false;
                }
                if ((baseStructure = baseStructure.getParent()) == null) {
                    return i >= this.numbers.length - 1;
                }
                if (baseStructure instanceof EvioSegment) {
                    return false;
                }
                if (!(baseStructure instanceof EvioTagSegment)) continue;
                return false;
            }
            return true;
        }
        BaseStructureHeader baseStructureHeader = baseStructure.header;
        return this.tag == baseStructureHeader.tag;
    }

    @Override
    public int compareTo(EvioDictionaryEntry evioDictionaryEntry) {
        if (evioDictionaryEntry.numbers == null) {
            return -1;
        }
        if (this.numbers == null) {
            return 1;
        }
        if (this.numbers.length > evioDictionaryEntry.numbers.length) {
            return -1;
        }
        if (this.numbers.length < evioDictionaryEntry.numbers.length) {
            return 1;
        }
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] < evioDictionaryEntry.numbers[i]) {
                return -1;
            }
            if (this.numbers[i] <= evioDictionaryEntry.numbers[i]) continue;
            return 1;
        }
        return 0;
    }

    private String[] tokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        String string = null;
        if (this.numbers != null) {
            for (int i = this.numbers.length - 1; i >= 0; --i) {
                if (string == null) {
                    string = "";
                }
                string = string + this.numbers[i];
                if (i == 0) continue;
                string = string + ".";
            }
        }
        if (string == null) {
            return String.format("tag: %-4d description: %s", this.tag, this.description);
        }
        return String.format("tag: %-4d num: %-10s description: %s", this.tag, string, this.description);
    }
}

