/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.StructureType;

public class EvioBank
extends BaseStructure {
    public static final String ELEMENT_NAME = "bank";
    protected transient Object attachment;

    public EvioBank() {
        super(new BankHeader());
    }

    public EvioBank(BankHeader bankHeader) {
        super(bankHeader);
    }

    public EvioBank(int n, DataType dataType, int n2) {
        this(new BankHeader(n, dataType, n2));
    }

    public EvioBank(int n, int n2, int n3) {
        this(new BankHeader(n, n2, n3));
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.BANK;
    }

    @Override
    public void toXML(XMLStreamWriter xMLStreamWriter) {
        try {
            this.commonXMLStart(xMLStreamWriter);
            if (DataType.getDataType(this.header.dataType).isStructure()) {
                xMLStreamWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xMLStreamWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType));
            xMLStreamWriter.writeAttribute("tag", "" + this.header.tag);
            xMLStreamWriter.writeAttribute("num", "" + this.header.number);
            xMLStreamWriter.writeAttribute("length", "" + this.header.length);
            xMLStreamWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xMLStreamWriter);
            this.decreaseXmlIndent();
            this.commonXMLClose(xMLStreamWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.rawBytes.length + this.header.getHeaderLength() * 4];
        this.header.toArray(byArray, 0, this.byteOrder);
        System.arraycopy(this.rawBytes, 0, byArray, this.header.getHeaderLength() * 4, this.rawBytes.length);
        return byArray;
    }
}

