/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.Environment;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioFile;
import org.jlab.coda.jevio.EvioFileTest;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;

public class Demo
implements IEvioListener {
    public static void main(String[] stringArray) {
        System.out.println("Test of EvioFile class.");
        String string = Environment.getInstance().getCurrentWorkingDirectory();
        String string2 = string + File.separator + "testdata" + File.separator + "out.ev";
        String string3 = string + File.separator + "testdata" + File.separator + "eviodict.xml";
        EvioFile evioFile = null;
        try {
            File file = new File(string2);
            System.out.println("ev file: " + string2 + " size: " + file.length());
            evioFile = new EvioFile(string2);
            EventParser.getInstance().addEvioListener(new Demo());
            NameProvider.setProvider(NameProviderFactory.createNameProvider(new File(string3)));
            EvioFileTest.readAllBlockHeadersTest(evioFile);
            EvioFileTest.readAllEventsTest(evioFile);
            EvioFileTest.totalBlockCount(evioFile);
            EvioFileTest.parseEventsTest(evioFile, 1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void startEventParse(EvioEvent evioEvent) {
    }

    @Override
    public void endEventParse(EvioEvent evioEvent) {
    }

    @Override
    public void gotStructure(EvioEvent evioEvent, IEvioStructure iEvioStructure) {
        BaseStructureHeader baseStructureHeader = iEvioStructure.getHeader();
        System.out.println("------------------");
        System.out.println("" + iEvioStructure);
        switch (baseStructureHeader.getDataTypeEnum()) {
            case DOUBLE64: {
                double[] dArray;
                System.out.println("        DOUBLE VALS");
                for (double d : dArray = iEvioStructure.getDoubleData()) {
                    System.out.println("         " + d);
                }
                break;
            }
            case INT32: 
            case UINT32: {
                int[] nArray;
                System.out.println("        INT VALS");
                for (int n : nArray = iEvioStructure.getIntData()) {
                    System.out.println("         " + n);
                }
                break;
            }
            case CHAR8: 
            case UCHAR8: {
                byte[] byArray;
                System.out.println("        BYTE VALS");
                for (byte by : byArray = iEvioStructure.getByteData()) {
                    System.out.println("         " + by);
                }
                break;
            }
        }
    }
}

