/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jlab.coda.et.system.ListeningThread;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

class SystemUdpServer
extends Thread {
    private int port;
    private SystemCreate sys;
    private SystemConfig config;
    private ThreadGroup tGroup;

    SystemUdpServer(SystemCreate sys, ThreadGroup tGroup) {
        super(tGroup, "udpServerThread");
        this.sys = sys;
        this.tGroup = tGroup;
        this.config = sys.getConfig();
        this.port = this.config.getServerPort();
    }

    @Override
    public void run() {
        if (this.config.getDebug() >= 4) {
            System.out.println("Running UDP Listening Threads");
        }
        if (this.port < 1) {
            this.port = 11111;
        }
        if (this.config.getMulticastAddrs().size() > 0) {
            try {
                System.out.println("setting up for multicast on port " + this.config.getUdpPort());
                MulticastSocket sock = new MulticastSocket(this.config.getUdpPort());
                sock.setReceiveBufferSize(1024);
                sock.setSendBufferSize(1024);
                ListeningThread lis = new ListeningThread(this.sys, sock, this.tGroup);
                lis.start();
            }
            catch (IOException e) {
                System.out.println("cannot listen on port " + this.config.getUdpPort() + " for multicasting");
                e.printStackTrace();
            }
            return;
        }
        try {
            System.out.println("setting up for broadcast on port " + this.config.getUdpPort());
            DatagramSocket sock = new DatagramSocket(this.config.getUdpPort());
            sock.setBroadcast(true);
            sock.setReceiveBufferSize(1024);
            sock.setSendBufferSize(1024);
            ListeningThread lis = new ListeningThread(this.sys, sock, this.tGroup);
            lis.start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

