/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;

public class Killer {
    private static void usage() {
        System.out.println("\nUsage: java Killer -f <et name>\n                      [-h] [-v] [-r] [-m] [-b] [-host <ET host>]\n                      [-p <ET port>] [-a <mcast addr>]\n\n       -f     ET system's (memory-mapped file) name\n       -host  ET system's host if direct connection (default to local)\n       -h     help\n       -v     verbose output\n\n       -a     multicast address(es) (dot-decimal), may use multiple times\n       -m     multicast to find ET (use default address if -a unused)\n       -b     broadcast to find ET\n\n       -r     act as remote (TCP) client even if ET system is local\n       -p     port (TCP for direct, UDP for broad/multicast)\n\n        This producer works by making a direct connection to the\n        ET system's server port and host unless at least one multicast address\n        is specified with -a, the -m option is used, or the -b option is used\n        in which case multi/broadcasting used to find the ET system.\n        If multi/broadcasting fails, look locally to find the ET system.\n        The system is then killed.\n\n");
    }

    public static void main(String[] args) {
        int port = 0;
        boolean verbose = false;
        boolean remote = false;
        boolean broadcast = false;
        boolean multicast = false;
        boolean broadAndMulticast = false;
        HashSet<Object> multicastAddrs = new HashSet<Object>();
        String etName = null;
        String host = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Killer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Killer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-m")) {
                multicast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b")) {
                broadcast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                try {
                    String addr = args[++i];
                    if (InetAddress.getByName(addr).isMulticastAddress()) {
                        multicastAddrs.add(addr);
                        multicast = true;
                        continue;
                    }
                    System.out.println("\nignoring improper multicast address\n");
                }
                catch (UnknownHostException addr) {}
                continue;
            }
            Killer.usage();
            return;
        }
        if (etName == null) {
            Killer.usage();
            return;
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig();
            if (broadcast && multicast) {
                broadAndMulticast = true;
            }
            if (multicast) {
                if (multicastAddrs.size() < 1) {
                    config.addMulticastAddr("239.200.0.0");
                } else {
                    for (String string : multicastAddrs) {
                        config.addMulticastAddr(string);
                    }
                }
            }
            if (broadAndMulticast) {
                System.out.println("Broad and Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(3);
                config.setHost(".anywhere");
            } else if (multicast) {
                System.out.println("Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(0);
                config.setHost(".anywhere");
            } else if (broadcast) {
                System.out.println("Broadcasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(1);
                config.setHost(".anywhere");
            } else {
                if (port == 0) {
                    port = 11111;
                }
                config.setTcpPort(port);
                config.setNetworkContactMethod(2);
                if (host == null) {
                    host = ".local";
                }
                config.setHost(host);
                System.out.println("Direct connection to " + host);
            }
            config.setWaitTime(0L);
            config.setEtName(etName);
            if (remote) {
                System.out.println("Set as remote");
                config.setConnectRemotely(remote);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            sys.kill();
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as killer");
            ex.printStackTrace();
        }
    }
}

