/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtContainer;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.enums.Modify;

public class Consumer {
    private static void usage() {
        System.out.println("\nUsage: java Consumer -f <et name> -s <station name>\n                      [-h] [-v] [-n] [-e] [-nb] [-r] [-m] [-b] [-nd] [-read] [-dump]\n                      [-host <ET host>] [-p <ET port>]\n                      [-c <chunk size>] [-q <Q size>]\n                      [-pos <station pos>] [-ppos <parallel station pos>]\n                      [-i <interface address>] [-a <mcast addr>]\n                      [-rb <buf size>] [-sb <buf size>]\n\n       -f     ET system's (memory-mapped file) name\n       -host  ET system's host if direct connection (default to local)\n       -s     create station of this name\n       -h     help\n\n       -v     verbose output (also prints data if reading with -read)\n       -n     use new, non-garbage-generating new,get,put,dump methods\n       -e     if specified read data as little endian, else big\n       -read  read data (1 int for each event)\n       -dump  dump events back into ET (go directly to GC) instead of put\n       -c     number of events in one get/put array\n       -r     act as remote (TCP) client even if ET system is local\n       -p     port, TCP if direct, else UDP\n\n       -nb    make station non-blocking\n       -q     queue size if creating non-blocking station\n       -pos   position of station (1,2,...)\n       -ppos  position of station within a group of parallel stations (-1=end, -2=head)\n\n       -i     outgoing network interface address (dot-decimal)\n       -a     multicast address(es) (dot-decimal), may use multiple times\n       -m     multicast to find ET (use default address if -a unused)\n       -b     broadcast to find ET\n\n       -rb    TCP receive buffer size (bytes)\n       -sb    TCP send    buffer size (bytes)\n       -nd    use TCP_NODELAY option\n\n        This consumer works by making a direct connection to the\n        ET system's server port and host unless at least one multicast address\n        is specified with -a, the -m option is used, or the -b option is used\n        in which case multi/broadcasting used to find the ET system.\n        If multi/broadcasting fails, look locally to find the ET system.\n        This program gets all events from the given station and puts them back.\n\n");
    }

    public static void main(String[] args) {
        int port = 0;
        int flowMode = 0;
        int position = 1;
        int pposition = 0;
        int qSize = 0;
        int chunk = 1;
        int recvBufSize = 0;
        int sendBufSize = 0;
        boolean dump = false;
        boolean readData = false;
        boolean noDelay = false;
        boolean blocking = true;
        boolean verbose = false;
        boolean newIF = false;
        boolean remote = false;
        boolean broadcast = false;
        boolean multicast = false;
        boolean broadAndMulticast = false;
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        HashSet<String> multicastAddrs = new HashSet<String>();
        String outgoingInterface = null;
        String etName = null;
        String host = null;
        String statName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                try {
                    String addr = args[++i];
                    if (InetAddress.getByName(addr).isMulticastAddress()) {
                        multicastAddrs.add(addr);
                        multicast = true;
                        continue;
                    }
                    System.out.println("\nignoring improper multicast address\n");
                }
                catch (UnknownHostException addr) {}
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                outgoingInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-nb")) {
                blocking = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nd")) {
                noDelay = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                System.out.println("Using NEW interface");
                newIF = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-read")) {
                readData = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dump")) {
                dump = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-m")) {
                multicast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b")) {
                broadcast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                statName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-e")) {
                order = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-c")) {
                try {
                    chunk = Integer.parseInt(args[++i]);
                    if (chunk >= 1 && chunk <= 1000) continue;
                    System.out.println("Chunk size may be 1 - 1000.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper chunk size.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-rb")) {
                try {
                    recvBufSize = Integer.parseInt(args[++i]);
                    if (recvBufSize >= 0) continue;
                    System.out.println("Receive buf size must be 0 or greater.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper receive buffer size.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-sb")) {
                try {
                    sendBufSize = Integer.parseInt(args[++i]);
                    if (sendBufSize >= 0) continue;
                    System.out.println("Send buf size must be 0 or greater.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper send buffer size.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-q")) {
                try {
                    qSize = Integer.parseInt(args[++i]);
                    if (qSize >= 1) continue;
                    System.out.println("Queue size must be > 0.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper queue size number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-pos")) {
                try {
                    position = Integer.parseInt(args[++i]);
                    if (position >= 1) continue;
                    System.out.println("Position must be > 0.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper position number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-ppos")) {
                try {
                    pposition = Integer.parseInt(args[++i]);
                    if (pposition < -2 || pposition == 0) {
                        System.out.println("Parallel position must be > -3 and != 0.");
                        Consumer.usage();
                        return;
                    }
                    System.out.println("Flow mode is parallel");
                    flowMode = 1;
                    if (pposition == -2) {
                        pposition = -2;
                        continue;
                    }
                    if (pposition != -1) continue;
                    pposition = -1;
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper parallel position number.");
                    Consumer.usage();
                    return;
                }
            }
            Consumer.usage();
            return;
        }
        if (etName == null || statName == null) {
            Consumer.usage();
            return;
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig();
            if (broadcast && multicast) {
                broadAndMulticast = true;
            }
            if (multicast) {
                if (multicastAddrs.size() < 1) {
                    config.addMulticastAddr("239.200.0.0");
                } else {
                    for (String mcastAddr : multicastAddrs) {
                        config.addMulticastAddr(mcastAddr);
                    }
                }
            }
            if (broadAndMulticast) {
                System.out.println("Broad and Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(3);
                config.setHost(".anywhere");
            } else if (multicast) {
                System.out.println("Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(0);
                config.setHost(".anywhere");
            } else if (broadcast) {
                System.out.println("Broadcasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(1);
                config.setHost(".anywhere");
            } else {
                if (port == 0) {
                    port = 11111;
                }
                config.setTcpPort(port);
                config.setNetworkContactMethod(2);
                if (host == null) {
                    host = ".local";
                }
                config.setHost(host);
                System.out.println("Direct connection to " + host);
            }
            config.setNoDelay(noDelay);
            config.setTcpRecvBufSize(recvBufSize);
            config.setTcpSendBufSize(sendBufSize);
            config.setNetworkInterface(outgoingInterface);
            config.setWaitTime(0L);
            config.setEtName(etName);
            if (remote) {
                System.out.println("Set as remote");
                config.setConnectRemotely(remote);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            System.out.println("Connect to ET using local IP addr = " + sys.getLocalAddress());
            EtStationConfig statConfig = new EtStationConfig();
            statConfig.setFlowMode(flowMode);
            if (!blocking) {
                statConfig.setBlockMode(0);
                if (qSize > 0) {
                    statConfig.setCue(qSize);
                }
            }
            EtStation stat = sys.createStation(statConfig, statName, position, pposition);
            EtAttachment att = sys.attach(stat);
            EtContainer container = null;
            if (newIF) {
                container = new EtContainer(chunk, (int)sys.getEventSize());
            }
            long t1 = 0L;
            long t2 = 0L;
            long totalT = 0L;
            long count = 0L;
            long totalCount = 0L;
            long bytes = 0L;
            long totalBytes = 0L;
            t1 = System.currentTimeMillis();
            while (true) {
                int len;
                int i;
                EtEvent[] mevs;
                int validEvents;
                if (newIF) {
                    container.getEvents(att, Mode.SLEEP, Modify.ANYTHING, 0, chunk);
                    sys.getEvents(container);
                    validEvents = container.getEventCount();
                    mevs = container.getEventArray();
                } else {
                    mevs = sys.getEvents(att, Mode.SLEEP, Modify.ANYTHING, 0, chunk);
                    validEvents = mevs.length;
                }
                if (readData) {
                    for (i = 0; i < validEvents; ++i) {
                        int[] con;
                        ByteBuffer buf = mevs[i].getDataBuffer();
                        buf.order(order);
                        int num = buf.getInt(0);
                        len = mevs[i].getLength();
                        bytes += (long)len;
                        totalBytes += (long)len;
                        if (!verbose) continue;
                        System.out.println("    data (len = " + mevs[i].getLength() + ") = " + num);
                        if (buf.hasArray()) {
                            byte[] data = mevs[i].getData();
                            int idata = EtUtils.bytesToInt(data, 0);
                            System.out.println("data byte order = " + mevs[i].getByteOrder());
                            if (mevs[i].needToSwap()) {
                                System.out.println("    data (len = " + len + ") needs swapping, swapped int = " + Integer.reverseBytes(idata));
                            } else {
                                System.out.println("    data (len = " + len + ")does NOT need swapping, int = " + idata);
                            }
                        }
                        System.out.print("control array = {");
                        for (int j : con = mevs[i].getControl()) {
                            System.out.print(j + " ");
                        }
                        System.out.println("}");
                    }
                } else {
                    for (i = 0; i < validEvents; ++i) {
                        len = mevs[i].getLength();
                        bytes += (long)len;
                        totalBytes += (long)len;
                    }
                }
                if (dump) {
                    if (newIF) {
                        container.dumpEvents(att, 0, validEvents);
                        sys.dumpEvents(container);
                    } else {
                        sys.dumpEvents(att, mevs);
                    }
                } else if (newIF) {
                    container.putEvents(att, 0, validEvents);
                    sys.putEvents(container);
                } else {
                    sys.putEvents(att, mevs);
                }
                count += (long)validEvents;
                t2 = System.currentTimeMillis();
                long time = t2 - t1;
                if (time <= 5000L) continue;
                if (totalCount >= Long.MAX_VALUE - count || totalT >= Long.MAX_VALUE - time) {
                    count = 0L;
                    totalCount = 0L;
                    totalT = 0L;
                    totalBytes = 0L;
                    bytes = 0L;
                    t1 = t2;
                    continue;
                }
                double rate = 1000.0 * (double)count / (double)time;
                double avgRate = 1000.0 * (double)(totalCount += count) / (double)(totalT += time);
                System.out.println("Events = " + String.format("%.3g", rate) + " Hz,    avg = " + String.format("%.3g", avgRate));
                rate = (double)bytes / (double)time;
                avgRate = (double)totalBytes / (double)totalT;
                System.out.println("  Data = " + String.format("%.3g", rate) + " kB/s,  avg = " + String.format("%.3g", avgRate) + "\n");
                count = 0L;
                bytes = 0L;
                t1 = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as consumer");
            ex.printStackTrace();
            return;
        }
    }
}

