/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jlab.coda.et.DatagramReceive;
import org.jlab.coda.et.EtConstants;
import org.jlab.coda.et.EtJniAccess;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;

public class EtSystemOpen {
    private EtSystemOpenConfig config;
    private Socket sock;
    private String hostAddress;
    private String localAddress;
    private ArrayList<String> hostAddresses;
    private ArrayList<String> broadcastAddresses;
    private int tcpPort;
    private LinkedHashMap<ArrayList<String>[], Integer> responders;
    private boolean connected;
    private boolean etOnLocalHost;
    private int debug;
    private boolean useJniLibrary;
    private EtJniAccess jni;
    private int endian;
    private int numEvents;
    private long eventSize;
    private int version;
    private int stationSelectInts;
    private int language;
    private boolean isJavaEtSystem;
    private boolean bit64;
    private Collection<String> localHostIpAddrs;
    private final boolean foundServer = true;
    private final boolean cannotFindServer = false;
    private final boolean gotMatch = true;
    private final boolean noMatch = false;

    public EtSystemOpen(EtSystemOpenConfig config) {
        this.config = new EtSystemOpenConfig(config);
        this.debug = 2;
        this.responders = new LinkedHashMap(20);
        this.hostAddresses = new ArrayList();
        this.broadcastAddresses = new ArrayList();
        this.localHostIpAddrs = EtUtils.getAllIpAddresses();
    }

    public void setDebug(int debug) throws EtException {
        if (debug != 0 && debug != 1 && debug != 2 && debug != 3 && debug != 4) {
            throw new EtException("bad debug argument");
        }
        this.debug = debug;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public long getEventSize() {
        return this.eventSize;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public ArrayList<String> getHostAddresses() {
        return this.hostAddresses;
    }

    public ArrayList<String> getBroadcastAddresses() {
        return this.broadcastAddresses;
    }

    public String getName() {
        return this.config.getEtName();
    }

    public int getEndian() {
        return this.endian;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLanguage() {
        return this.language;
    }

    public int getSelectInts() {
        return this.stationSelectInts;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public int getDebug() {
        return this.debug;
    }

    public EtSystemOpenConfig getConfig() {
        return new EtSystemOpenConfig(this.config);
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public boolean isBit64() {
        return this.bit64;
    }

    public LinkedHashMap<ArrayList<String>[], Integer> getResponders() {
        return this.responders;
    }

    public boolean usingJniLibrary() {
        return this.useJniLibrary;
    }

    public EtJniAccess getJni() {
        return this.jni;
    }

    public String[] getAllHosts() {
        if (this.responders.size() == 0) {
            if (this.hostAddress == null) {
                return null;
            }
            return new String[]{this.hostAddress};
        }
        Set<ArrayList<String>[]> setOfAddrListArrays = this.responders.keySet();
        ArrayList<String> addrs = new ArrayList<String>();
        for (ArrayList<String>[] addrListArray : setOfAddrListArrays) {
            for (ArrayList<String> addrList : addrListArray) {
                addrs.addAll(addrList);
            }
        }
        return (String[])addrs.toArray();
    }

    public int[] getAllPorts() {
        if (this.responders.size() == 0) {
            if (this.tcpPort == 0) {
                return null;
            }
            return new int[]{this.tcpPort};
        }
        Integer[] p = (Integer[])this.responders.values().toArray();
        int[] ports = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            ports[i] = p[i];
        }
        return ports;
    }

    private boolean findServerPort(int totalWait) throws IOException, UnknownHostException, EtTooManyException {
        MulticastSocket socket;
        int waitTime;
        boolean match = false;
        int totalPacketsSent = 0;
        int sendPacketLimit = 4;
        int[] timeOuts = new int[]{100, 1000, 2000, 4000};
        int socketTimeOut = 8000;
        Collection<String> knownHostIpAddrs = null;
        if (totalWait >= 80) {
            waitTime = (totalWait - 10) / 7;
            timeOuts[0] = 10;
            timeOuts[1] = waitTime;
            timeOuts[2] = 2 * waitTime;
            timeOuts[3] = 4 * waitTime;
            socketTimeOut = totalWait + 1000;
        }
        this.responders.clear();
        this.hostAddresses.clear();
        this.broadcastAddresses.clear();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(122);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(EtConstants.magicNumbers[0]);
        dos.writeInt(EtConstants.magicNumbers[1]);
        dos.writeInt(EtConstants.magicNumbers[2]);
        dos.writeInt(16);
        dos.writeInt(this.config.getEtName().length() + 1);
        try {
            dos.write(this.config.getEtName().getBytes("ASCII"));
            dos.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        dos.flush();
        final byte[] sbuffer = baos.toByteArray();
        dos.close();
        baos.close();
        class Send {
            int port;
            String address;
            InetAddress addr;
            MulticastSocket socket;
            DatagramPacket packet;

            Send(String address, MulticastSocket socket, int port) throws UnknownHostException {
                this.port = port;
                this.address = address;
                this.socket = socket;
                this.addr = InetAddress.getByName(address);
                this.packet = new DatagramPacket(sbuffer, sbuffer.length, this.addr, port);
            }
        }
        LinkedList<Send> sendList = new LinkedList<Send>();
        String localHost = null;
        InetAddress localAddr = null;
        try {
            localAddr = InetAddress.getLocalHost();
            localHost = localAddr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!this.config.getHost().equals(".remote") && !this.config.getHost().equals(".anywhere")) {
            String specifiedHost;
            MulticastSocket socket2 = new MulticastSocket();
            try {
                socket2.setSoTimeout(socketTimeOut);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (this.config.getHost().equals(".local") || this.config.getHost().equals("localhost")) {
                specifiedHost = localHost;
                knownHostIpAddrs = this.localHostIpAddrs;
            } else {
                specifiedHost = this.config.getHost();
                InetAddress[] inetAddressArray = InetAddress.getAllByName(specifiedHost);
                knownHostIpAddrs = new LinkedHashSet<String>();
                for (InetAddress ia : inetAddressArray) {
                    knownHostIpAddrs.add(ia.getHostAddress());
                }
            }
            sendList.add(new Send(specifiedHost, socket2, this.config.getUdpPort()));
            if (this.debug >= 4) {
                System.out.println("findServerPort: send to local or specified host " + specifiedHost + " on port " + this.config.getUdpPort());
            }
        }
        if (this.config.getNetworkContactMethod() == 1 || this.config.getNetworkContactMethod() == 3) {
            if (this.config.getBroadcastAddrs().size() < 1) {
                Iterator<String> socket2 = new MulticastSocket();
                try {
                    ((DatagramSocket)((Object)socket2)).setSoTimeout(socketTimeOut);
                    ((DatagramSocket)((Object)socket2)).setBroadcast(true);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                sendList.add(new Send("255.255.255.255", (MulticastSocket)((Object)socket2), this.config.getUdpPort()));
                if (this.debug >= 4) {
                    System.out.println("findServerPort: broadcasting to " + "255.255.255.255" + " on port " + this.config.getUdpPort());
                }
            } else {
                for (String string : this.config.getBroadcastAddrs()) {
                    socket = new MulticastSocket();
                    try {
                        socket.setSoTimeout(socketTimeOut);
                        socket.setBroadcast(true);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    sendList.add(new Send(string, socket, this.config.getUdpPort()));
                    if (this.debug < 4) continue;
                    System.out.println("findServerPort: broadcasting to " + string + " on port " + this.config.getUdpPort());
                }
            }
        }
        if (this.config.getNetworkContactMethod() == 0 || this.config.getNetworkContactMethod() == 3) {
            for (String string : this.config.getMulticastAddrs()) {
                socket = new MulticastSocket();
                try {
                    socket.setSoTimeout(socketTimeOut);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (this.config.getTTL() != 1) {
                    socket.setTimeToLive(this.config.getTTL());
                }
                sendList.add(new Send(string, socket, this.config.getUdpPort()));
                if (this.debug < 4) continue;
                System.out.println("findServerPort: multicasting to " + string + " on port " + this.config.getUdpPort());
            }
        }
        class Get {
            byte[] buffer = new byte[4096];
            DatagramReceive thread;
            DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
            MulticastSocket socket;

            Get(MulticastSocket sock) {
                this.socket = sock;
            }

            void start() {
                this.thread = new DatagramReceive(this.packet, this.socket);
                this.thread.start();
            }
        }
        LinkedList<Get> receiveList = new LinkedList<Get>();
        for (Send sender : sendList) {
            Get receiver = new Get(sender.socket);
            receiveList.add(receiver);
            if (this.debug >= 4) {
                System.out.println("findServerPort: starting thread to socket " + sender.socket);
            }
            receiver.start();
        }
        Thread.yield();
        while (totalPacketsSent < sendPacketLimit) {
            for (Send sender : sendList) {
                sender.socket.send(sender.packet);
            }
            waitTime = timeOuts[totalPacketsSent++];
            block20: while (true) {
                if (this.debug >= 4) {
                    System.out.println("findServerPort: wait for " + waitTime + " milliseconds");
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (Get receiver : receiveList) {
                    int status = receiver.thread.waitForReply(10);
                    if (this.debug >= 4) {
                        System.out.println("findServerPort: receive on socket " + receiver.socket + ", status = " + status);
                    }
                    if (status == -1 || status == 0 || status != 1) continue;
                    if (this.replyMatch(receiver.packet, knownHostIpAddrs)) {
                        if (this.debug >= 4) {
                            System.out.println("findServerPort: found match");
                        }
                        match = true;
                    } else if (this.debug >= 4) {
                        System.out.println("findServerPort: no match");
                    }
                    waitTime = 50;
                    receiver.start();
                    Thread.yield();
                    continue block20;
                }
                break;
            }
            if (match || totalPacketsSent >= sendPacketLimit) break;
            if (this.debug < 4) continue;
            System.out.println("findServerPort: timed out, try again with longer wait");
        }
        if (match) {
            if ((this.config.getHost().equals(".remote") || this.config.getHost().equals(".anywhere")) && this.responders.size() > 1) {
                if (this.config.getResponsePolicy() == 0) {
                    Iterator<Map.Entry<ArrayList<String>[], Integer>> iterator = this.responders.entrySet().iterator();
                    Map.Entry<ArrayList<String>[], Integer> entry2 = iterator.next();
                    ArrayList<String>[] addrLists = entry2.getKey();
                    this.hostAddresses = addrLists[0];
                    this.broadcastAddresses = addrLists[1];
                    this.hostAddress = this.hostAddresses.get(0);
                    this.tcpPort = entry2.getValue();
                    this.etOnLocalHost = EtUtils.isHostLocal(this.hostAddresses);
                } else if (this.config.getResponsePolicy() == 1) {
                    this.etOnLocalHost = false;
                    for (Map.Entry<ArrayList<String>[], Integer> entry : this.responders.entrySet()) {
                        ArrayList<String>[] addrLists = entry.getKey();
                        if (!EtUtils.isHostLocal(addrLists[0])) continue;
                        this.hostAddresses = addrLists[0];
                        this.broadcastAddresses = addrLists[1];
                        this.hostAddress = this.hostAddresses.get(0);
                        this.tcpPort = entry.getValue();
                        this.etOnLocalHost = true;
                        break;
                    }
                    if (!this.etOnLocalHost) {
                        Map.Entry<ArrayList<String>[], Integer> entry;
                        Iterator<Map.Entry<ArrayList<String>[], Integer>> iterator = this.responders.entrySet().iterator();
                        entry = iterator.next();
                        ArrayList<String>[] addrLists = entry.getKey();
                        this.hostAddresses = addrLists[0];
                        this.broadcastAddresses = addrLists[1];
                        this.hostAddress = this.hostAddresses.get(0);
                        this.tcpPort = entry.getValue();
                    }
                } else {
                    String firstUname = null;
                    for (Map.Entry<ArrayList<String>[], Integer> entry3 : this.responders.entrySet()) {
                        ArrayList<String>[] addrLists = entry3.getKey();
                        if (firstUname == null) {
                            firstUname = addrLists[2].get(0);
                            this.hostAddresses = addrLists[0];
                            this.broadcastAddresses = addrLists[1];
                            this.hostAddress = this.hostAddresses.get(0);
                            this.tcpPort = entry3.getValue();
                            this.etOnLocalHost = EtUtils.isHostLocal(this.hostAddresses);
                            continue;
                        }
                        String string = addrLists[2].get(0);
                        boolean same = false;
                        if (firstUname.equals(string)) {
                            same = true;
                        }
                        if (same) continue;
                        throw new EtTooManyException("too many different responding ET systems");
                    }
                }
            }
            return true;
        }
        if (this.debug >= 4) {
            System.out.println("findServerPort: cannot find server, quitting");
        }
        this.broadcastAddresses.clear();
        this.hostAddresses.clear();
        this.hostAddress = null;
        this.tcpPort = 0;
        return false;
    }

    private boolean replyMatch(DatagramPacket packet, Collection<String> knownHostIpAddrs) throws IOException, UnknownHostException {
        int numAddrs;
        int cast;
        int port;
        boolean localDebug = this.debug == 4;
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData());
        DataInputStream dis = new DataInputStream(bais);
        ArrayList<String> addresses = new ArrayList<String>(20);
        ArrayList<String> broadAddresses = new ArrayList<String>(20);
        ArrayList<String> unameList = new ArrayList<String>(1);
        ArrayList[] lists = new ArrayList[]{addresses, broadAddresses, unameList};
        int magic1 = dis.readInt();
        int magic2 = dis.readInt();
        int magic3 = dis.readInt();
        if (magic1 != EtConstants.magicNumbers[0] || magic2 != EtConstants.magicNumbers[1] || magic3 != EtConstants.magicNumbers[2]) {
            if (localDebug) {
                System.out.println("replyMatch:  Magic numbers did NOT match");
            }
            return false;
        }
        int version = dis.readInt();
        if (version != 16) {
            if (localDebug) {
                System.out.println("replyMatch:  version did NOT match");
            }
            return false;
        }
        if (localDebug) {
            System.out.println("replyMatch:  version = " + version);
        }
        if ((port = dis.readInt()) < 1 || port > 65536) {
            return false;
        }
        if (localDebug) {
            System.out.println("replyMatch:  server port = " + port);
        }
        if ((cast = dis.readInt()) != 1 && cast != 0 && cast != 3) {
            return false;
        }
        if (localDebug) {
            if (cast == 1) {
                System.out.println("replyMatch:  broadcasting");
            } else if (cast == 0) {
                System.out.println("replyMatch:  multicasting");
            } else {
                System.out.println("replyMatch:  broad & multicasting");
            }
        }
        dis.skipBytes(4);
        int length = dis.readInt();
        if (length < 1 || length > 256) {
            return false;
        }
        byte[] buf = new byte[length];
        dis.readFully(buf, 0, length);
        String repliedUname = null;
        try {
            repliedUname = new String(buf, 0, length - 1, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        unameList.add(repliedUname);
        if (localDebug) {
            System.out.println("replyMatch:  uname len = " + length + ", uname = " + repliedUname);
        }
        if ((length = dis.readInt()) < 1 || length > 256) {
            return false;
        }
        buf = new byte[length];
        dis.readFully(buf, 0, length);
        String canonicalName = null;
        try {
            canonicalName = new String(buf, 0, length - 1, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (localDebug) {
            System.out.println("replyMatch:  canonical name len = " + length + ", canonical name = " + canonicalName);
        }
        if ((numAddrs = dis.readInt()) < 0) {
            return false;
        }
        if (localDebug) {
            System.out.println("replyMatch:  # of addresses to come = " + numAddrs);
        }
        String repliedAddress = null;
        for (int i = 0; i < numAddrs; ++i) {
            int addr = dis.readInt();
            if (localDebug) {
                System.out.println("replyMatch:  addr #" + i + ": numeric addr = " + addr);
            }
            length = dis.readInt();
            if (localDebug) {
                System.out.println("replyMatch:  addr #" + i + ": string len = " + length);
            }
            buf = new byte[length];
            dis.readFully(buf, 0, length);
            try {
                repliedAddress = new String(buf, 0, length - 1, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (localDebug) {
                System.out.println("replyMatch:  addr #" + i + ": string addr = " + repliedAddress);
            }
            addresses.add(repliedAddress);
        }
        int numBrAddrs = dis.readInt();
        if (localDebug) {
            System.out.println("replyMatch:  # of broadcast addresses to come = " + numAddrs);
        }
        if (numBrAddrs == numAddrs) {
            for (int i = 0; i < numAddrs; ++i) {
                length = dis.readInt();
                if (localDebug) {
                    System.out.println("replyMatch:  addr #" + i + ": string len = " + length);
                }
                buf = new byte[length];
                dis.readFully(buf, 0, length);
                try {
                    repliedAddress = new String(buf, 0, length - 1, "ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (localDebug) {
                    System.out.println("replyMatch:  addr #" + i + ": string br addr = " + repliedAddress);
                }
                broadAddresses.add(repliedAddress);
            }
        }
        if (localDebug) {
            System.out.println("replyMatch: port = " + port + ", uname = " + repliedUname);
            for (int i = 0; i < numAddrs; ++i) {
                System.out.println("          :    addr " + (i + 1) + " = " + (String)addresses.get(i));
                System.out.println("          : br addr " + (i + 1) + " = " + (String)broadAddresses.get(i));
            }
            System.out.println();
        }
        dis.close();
        bais.close();
        if (this.config.getHost().equals(".anywhere")) {
            if (localDebug) {
                System.out.println("replyMatch: ET is anywhere, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            this.responders.put(lists, port);
            this.etOnLocalHost = EtUtils.isHostLocal((String)addresses.get(0));
            this.broadcastAddresses = broadAddresses;
            this.hostAddresses = addresses;
            this.hostAddress = (String)addresses.get(0);
            this.tcpPort = port;
            return true;
        }
        if (this.config.getHost().equals(".remote")) {
            for (String address : addresses) {
                for (String localIP : this.localHostIpAddrs) {
                    if (!localIP.equals(address)) continue;
                    if (localDebug) {
                        System.out.println("replyMatch: ET is local but looking for remote, " + address);
                    }
                    return false;
                }
            }
            if (localDebug) {
                System.out.println("replyMatch: ET is remote, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            this.responders.put(lists, port);
            this.etOnLocalHost = false;
            this.broadcastAddresses = broadAddresses;
            this.hostAddresses = addresses;
            this.hostAddress = (String)addresses.get(0);
            this.tcpPort = port;
            return true;
        }
        if (this.config.getHost().equals(".local") || this.config.getHost().equals("localhost")) {
            for (String address : addresses) {
                for (String localIP : this.localHostIpAddrs) {
                    if (!localIP.equals(address)) continue;
                    if (localDebug) {
                        System.out.println("replyMatch: ET is local, " + address);
                    }
                    this.etOnLocalHost = true;
                    this.broadcastAddresses = broadAddresses;
                    this.hostAddresses = addresses;
                    this.hostAddress = address;
                    this.tcpPort = port;
                    return true;
                }
            }
            if (localDebug) {
                System.out.println("replyMatch: no local match");
            }
        } else {
            if (localDebug) {
                System.out.println("replyMatch: <name>, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            for (String address : addresses) {
                for (String hostIP : knownHostIpAddrs) {
                    if (!hostIP.equals(address)) continue;
                    if (localDebug) {
                        System.out.println("replyMatch: <name> matched, " + address);
                    }
                    this.etOnLocalHost = EtUtils.isHostLocal(addresses);
                    this.broadcastAddresses = broadAddresses;
                    this.hostAddresses = addresses;
                    this.hostAddress = address;
                    this.tcpPort = port;
                    return true;
                }
            }
        }
        return false;
    }

    private void connectToEtServer() throws IOException, EtException {
        DataInputStream dis = new DataInputStream(this.sock.getInputStream());
        DataOutputStream dos = new DataOutputStream(this.sock.getOutputStream());
        dos.writeInt(EtConstants.magicNumbers[0]);
        dos.writeInt(EtConstants.magicNumbers[1]);
        dos.writeInt(EtConstants.magicNumbers[2]);
        dos.writeInt(0);
        dos.writeInt(this.config.getEtName().length() + 1);
        dos.writeInt(0);
        dos.writeLong(0L);
        try {
            dos.write(this.config.getEtName().getBytes("ASCII"));
            dos.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        dos.flush();
        if (dis.readInt() != 0) {
            throw new EtException("found the wrong ET system");
        }
        this.endian = dis.readInt();
        this.numEvents = dis.readInt();
        this.eventSize = dis.readLong();
        this.version = dis.readInt();
        this.stationSelectInts = dis.readInt();
        this.language = dis.readInt();
        this.bit64 = dis.readInt() > 0;
        dis.skipBytes(4);
        if (this.version != 16) {
            this.disconnect();
            throw new EtException("may not open wrong version ET system (" + this.version + "), since this is version " + 16);
        }
        if (this.stationSelectInts != 6) {
            this.disconnect();
            throw new EtException("may not open ET system with different # of select integers");
        }
        if (this.language == 2) {
            this.isJavaEtSystem = true;
        }
        this.connected = true;
        if (this.debug >= 4) {
            System.out.println("open: endian = " + (this.endian == 0 ? "big" : "little") + ", nevents = " + this.numEvents + ", event size = " + this.eventSize + ", version = " + this.version + ",\n      selectInts = " + this.stationSelectInts + ", language = " + (this.language == 2 ? "Java" : "C"));
        }
    }

    public synchronized void connect() throws IOException, EtException, EtTooManyException {
        long t2;
        this.useJniLibrary = false;
        Exception excep = null;
        boolean gotConnection = false;
        String outgoingIp = null;
        if (this.config.getNetworkInterface() != null) {
            outgoingIp = EtUtils.getMatchingLocalIpAddress(this.config.getNetworkInterface());
            if (this.debug >= 4) {
                System.out.println("connect(): outgoing IP = " + outgoingIp);
            }
        }
        long t1 = t2 = System.currentTimeMillis();
        while (t2 <= t1 + this.config.getWaitTime()) {
            LinkedHashMap<Object, Object> addrList;
            this.sock = null;
            if (this.config.getNetworkContactMethod() == 2) {
                if (this.debug >= 4) {
                    System.out.println("connect(): make a direct connection");
                }
                this.tcpPort = this.config.getTcpPort();
                this.etOnLocalHost = this.config.getHost().equals(".local") || this.config.getHost().equals("localhost") ? true : EtUtils.isHostLocal(this.config.getHost());
                if (this.etOnLocalHost) {
                    this.useJniLibrary = true;
                    this.hostAddresses = new ArrayList<String>(this.localHostIpAddrs);
                    this.hostAddress = this.hostAddresses.get(0);
                } else {
                    this.hostAddress = InetAddress.getByName(this.config.getHost()).getHostAddress();
                }
            } else {
                if (this.debug >= 4) {
                    System.out.println("connect(): try to find server port");
                }
                if (!this.findServerPort((int)this.config.getWaitTime())) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    t2 = System.currentTimeMillis();
                    continue;
                }
                if (this.etOnLocalHost) {
                    this.useJniLibrary = true;
                }
            }
            if (this.config.isConnectRemotely()) {
                this.useJniLibrary = false;
            }
            if (this.debug >= 4) {
                System.out.println("connect(): try to connect to ET system " + (this.useJniLibrary ? "locally" : "remotely"));
            }
            if (this.hostAddresses == null || this.hostAddresses.size() < 1) {
                addrList = new LinkedHashMap<String, Boolean>();
                if (this.etOnLocalHost) {
                    addrList.put("127.0.0.1", Boolean.FALSE);
                }
                addrList.put(this.hostAddress, Boolean.FALSE);
            } else {
                if (this.debug >= 4) {
                    System.out.println("connect(): order ET's IP addresses with preferred = " + this.config.getNetworkInterface());
                }
                addrList = EtUtils.orderIPAddresses(this.hostAddresses, this.broadcastAddresses, this.config.getNetworkInterface(), this.etOnLocalHost);
            }
            if (this.debug >= 4) {
                System.out.println("connect(): ET's ordered IP addresses = ");
                for (Map.Entry<Object, Object> entry : addrList.entrySet()) {
                    System.out.println("           ip = " + (String)entry.getKey());
                }
            }
            for (Map.Entry<Object, Object> entry : addrList.entrySet()) {
                String connectionHost = (String)entry.getKey();
                boolean onPreferredSubnet = (Boolean)entry.getValue();
                excep = null;
                try {
                    this.sock = new Socket();
                    if (this.config.isNoDelay()) {
                        this.sock.setTcpNoDelay(true);
                    }
                    this.sock.setKeepAlive(true);
                    if (this.config.getTcpRecvBufSize() > 0) {
                        this.sock.setReceiveBufferSize(this.config.getTcpRecvBufSize());
                    }
                    if (this.config.getTcpSendBufSize() > 0) {
                        this.sock.setSendBufferSize(this.config.getTcpSendBufSize());
                    }
                    if (this.config.getNetworkInterface() != null && outgoingIp != null) {
                        if (onPreferredSubnet) {
                            try {
                                this.sock.bind(new InetSocketAddress(outgoingIp, 0));
                                if (this.debug >= 4) {
                                    System.out.println("connect(): bound outgoing data to " + outgoingIp);
                                }
                            }
                            catch (IOException e) {
                                System.out.println("connect(): tried but FAILED to bind outgoing data to " + outgoingIp);
                            }
                        } else if (this.debug >= 4) {
                            System.out.println("connect(): cannot specify preferred subnet since destination IP address is NOT on it");
                        }
                    }
                    if (this.debug >= 4) {
                        System.out.println("connect(): try connect to host " + connectionHost + " on port " + this.tcpPort);
                    }
                    try {
                        this.sock.connect(new InetSocketAddress(connectionHost, this.tcpPort), 5000);
                        this.localAddress = this.sock.getLocalAddress().getHostAddress();
                    }
                    catch (SocketTimeoutException e) {
                        System.out.println("connect(): timed out, try again");
                        continue;
                    }
                    System.out.println("connect(): SUCCESS creating socket to host " + connectionHost + " on port " + this.tcpPort);
                    break;
                }
                catch (SocketException ex) {
                    System.out.println("connect(): FAILED setting socket options");
                    excep = ex;
                }
                catch (IOException ex) {
                    System.out.println("connect(): FAILED creating connection to " + connectionHost);
                    excep = ex;
                }
                catch (Exception ex) {
                    System.out.println("connect(): FAILED creating connection to " + connectionHost);
                    excep = ex;
                }
            }
            if (this.sock == null || !this.sock.isConnected()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                t2 = System.currentTimeMillis();
                continue;
            }
            try {
                this.connectToEtServer();
                if (this.isJavaEtSystem) {
                    this.useJniLibrary = false;
                    System.out.println("connect(): Not using local shared memory since connecting to java ET system");
                }
                gotConnection = true;
                break;
            }
            catch (IOException ex) {
                excep = ex;
            }
            catch (EtException ex) {
                excep = ex;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            t2 = System.currentTimeMillis();
        }
        if (!gotConnection) {
            throw new IOException("Cannot create network connection to ET system", excep);
        }
        if (!this.useJniLibrary) {
            System.out.println("connect(): NOT using local shared memory");
        } else {
            try {
                int byteOrder;
                RandomAccessFile file = new RandomAccessFile(this.config.getEtName(), "rw");
                FileChannel fileChannel = file.getChannel();
                MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 64L);
                if (this.debug >= 4) {
                    System.out.println("Use a JNI local connection:");
                }
                if ((byteOrder = buffer.getInt()) != 67305985) {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.debug >= 4) {
                    System.out.println("    byteOrder = " + Integer.toHexString(byteOrder));
                }
                int next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("    systemType = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("    major version = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("    minor version = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("    num select ints = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("    head byte size = " + next);
                }
                long nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("    event byte size = " + nextLong);
                }
                nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("    header position = " + nextLong);
                }
                long dataPosition = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("    data position = " + nextLong);
                }
                long totalFileSize = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("    total file size = " + nextLong + ", but is really " + fileChannel.size());
                }
                long usedFileSize = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("    used file size = " + nextLong);
                }
                fileChannel.close();
                this.jni = EtJniAccess.getInstance(this.config.getEtName());
                System.out.println("connect(): connect to local C-ET using memory map");
            }
            catch (EtTimeoutException e) {
                this.useJniLibrary = false;
            }
            catch (EtException e) {
                this.useJniLibrary = false;
                System.out.println("Error in opening ET with jni, Et exception, use sockets only to talk to ET system");
            }
            catch (IOException e) {
                this.useJniLibrary = false;
                System.out.println("Error in opening ET with jni, IO exception, use sockets only to talk to ET system");
            }
        }
    }

    public synchronized void disconnect() {
        this.connected = false;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

