/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.Serializable;
import java.util.Arrays;
import org.jlab.coda.et.exception.EtException;

public class EtStationConfig
implements Serializable {
    private int cue;
    private int prescale;
    private int flowMode;
    private int userMode;
    private int restoreMode;
    private int blockMode;
    private int selectMode;
    private int[] select;
    private String selectFunction;
    private String selectLibrary;
    private String selectClass;

    public EtStationConfig() {
        this.cue = 10;
        this.prescale = 1;
        this.flowMode = 0;
        this.userMode = 0;
        this.restoreMode = 0;
        this.blockMode = 1;
        this.selectMode = 1;
        this.select = new int[6];
        Arrays.fill(this.select, -1);
    }

    public EtStationConfig(EtStationConfig config) {
        this.cue = config.cue;
        this.prescale = config.prescale;
        this.flowMode = config.flowMode;
        this.userMode = config.userMode;
        this.restoreMode = config.restoreMode;
        this.blockMode = config.blockMode;
        this.selectMode = config.selectMode;
        this.select = (int[])config.select.clone();
        this.selectFunction = config.selectFunction;
        this.selectLibrary = config.selectLibrary;
        this.selectClass = config.selectClass;
    }

    public static boolean compatibleParallelConfigs(EtStationConfig group, EtStationConfig config) {
        if (group.flowMode != 1 || config.flowMode != 1) {
            return false;
        }
        if (group.selectMode == 4 && config.selectMode != 4 || group.selectMode == 5 && config.selectMode != 5) {
            return false;
        }
        if (!(group.selectMode != 4 && group.selectMode != 5 || group.blockMode == config.blockMode && group.prescale == config.prescale)) {
            return false;
        }
        return group.selectMode == 4 || group.selectMode == 5 || config.selectMode != 4 && config.selectMode != 5;
    }

    public int getCue() {
        return this.cue;
    }

    public int getPrescale() {
        return this.prescale;
    }

    public int getFlowMode() {
        return this.flowMode;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public int getRestoreMode() {
        return this.restoreMode;
    }

    public int getBlockMode() {
        return this.blockMode;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int[] getSelect() {
        return (int[])this.select.clone();
    }

    public String getSelectFunction() {
        return this.selectFunction;
    }

    public String getSelectLibrary() {
        return this.selectLibrary;
    }

    public String getSelectClass() {
        return this.selectClass;
    }

    public void setCue(int q) throws EtException {
        if (q < 1) {
            throw new EtException("bad cue value");
        }
        this.cue = q;
    }

    public void setPrescale(int pre) throws EtException {
        if (pre < 1) {
            throw new EtException("bad prescale value");
        }
        this.prescale = pre;
    }

    public void setFlowMode(int mode) throws EtException {
        if (mode != 0 && mode != 1) {
            throw new EtException("bad flow mode value");
        }
        this.flowMode = mode;
    }

    public void setUserMode(int mode) throws EtException {
        if (mode < 0) {
            throw new EtException("bad user mode value");
        }
        this.userMode = mode;
    }

    public void setRestoreMode(int mode) throws EtException {
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3) {
            throw new EtException("bad restore mode value");
        }
        this.restoreMode = mode;
    }

    public void setBlockMode(int mode) throws EtException {
        if (mode != 1 && mode != 0) {
            throw new EtException("bad block mode value");
        }
        this.blockMode = mode;
    }

    public void setSelectMode(int mode) throws EtException {
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4 && mode != 5) {
            throw new EtException("bad select mode value");
        }
        this.selectMode = mode;
    }

    public void setSelect(int[] sel) throws EtException {
        if (sel.length != 6) {
            throw new EtException("wrong number of elements in select array");
        }
        this.select = (int[])sel.clone();
    }

    public void setSelectFunction(String func) throws EtException {
        if (func.length() > 47) {
            throw new EtException("arg is too long (> 47 chars)");
        }
        this.selectFunction = func;
    }

    public void setSelectLibrary(String lib) throws EtException {
        if (lib.length() > 99) {
            throw new EtException("arg is too long (> 99 chars)");
        }
        this.selectLibrary = lib;
    }

    public void setSelectClass(String sClass) throws EtException {
        if (sClass.length() > 99) {
            throw new EtException("arg is too long (> 99 chars)");
        }
        this.selectClass = sClass;
    }
}

