/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.enums.DataStatus;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.enums.Priority;
import org.jlab.coda.et.exception.EtBusyException;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.et.exception.EtReadException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.exception.EtWakeUpException;
import org.jlab.coda.et.system.AttachmentLocal;
import org.jlab.coda.et.system.StationLocal;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

class ClientThread
extends Thread {
    private Socket sock;
    private SystemCreate sys;
    private SystemConfig config;
    private DataInputStream in;
    private DataOutputStream out;
    boolean bit64;
    private static int counter = 0;

    ClientThread(SystemCreate sys, Socket sock, ThreadGroup tGroup) {
        super(tGroup, "clientThread" + counter++);
        this.sys = sys;
        this.sock = sock;
        this.config = sys.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: {
            try {
                this.in = this.config.getTcpRecvBufSize() > 0 ? new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.config.getTcpRecvBufSize())) : new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.sock.getReceiveBufferSize()));
                this.out = this.config.getTcpRecvBufSize() > 0 ? new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.config.getTcpSendBufSize())) : new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.sock.getSendBufferSize()));
                int endian = this.in.readInt();
                int length = this.in.readInt();
                int b64 = this.in.readInt();
                this.bit64 = b64 == 1;
                this.in.readLong();
                byte[] buf = new byte[length];
                this.in.readFully(buf, 0, length);
                String etName = new String(buf, 0, length - 1, "ASCII");
                if (!etName.equals(this.sys.getName())) {
                    if (this.config.getDebug() >= 2) {
                        System.out.println("Tcp Server: client trying to connect to " + etName);
                    }
                    this.out.writeInt(-1);
                    this.out.flush();
                    return;
                }
                this.out.writeInt(0);
                this.out.writeInt(0);
                this.out.writeInt(this.config.getNumEvents());
                this.out.writeLong(this.config.getEventSize());
                this.out.writeInt(16);
                this.out.writeInt(6);
                this.out.writeInt(2);
                this.out.writeInt(0);
                this.out.writeInt(0);
                this.out.flush();
                this.commandLoop();
            }
            catch (IOException ex) {
                if (this.config.getDebug() >= 2) {
                    System.out.println("Tcp Server: IO error in client etOpen");
                }
                break block17;
            }
            finally {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commandLoop() {
        block298: {
            block291: {
                block292: {
                    block297: {
                        block289: {
                            block290: {
                                block296: {
                                    block287: {
                                        block288: {
                                            block295: {
                                                block285: {
                                                    block286: {
                                                        block294: {
                                                            block283: {
                                                                block284: {
                                                                    selectInts = 6;
                                                                    dataShift = 4;
                                                                    priorityMask = true;
                                                                    dataMask = 48;
                                                                    modify = 4;
                                                                    ok = false;
                                                                    evs = null;
                                                                    attachments = new HashMap<Integer, AttachmentLocal>(this.sys.getConfig().getAttachmentsMax() + 1);
                                                                    buffer = new byte[65535];
                                                                    params = new byte[56];
                                                                    try lbl-1000:
                                                                    // 11 sources

                                                                    {
                                                                        block129: while (true) {
                                                                            block293: {
                                                                                try {
                                                                                    command = this.in.readInt();
                                                                                }
                                                                                catch (InterruptedIOException ex) {
                                                                                    if (!this.sys.killAllThreads()) continue;
                                                                                    return;
                                                                                }
                                                                                if (command < 20) {
                                                                                    if (this.config.getDebug() >= 2) {
                                                                                        System.out.println("No Java support for local Linux");
                                                                                    }
                                                                                    throw new EtReadException("No Java support for local Linux");
                                                                                }
                                                                                if (command < 40) {
                                                                                    switch (command) {
                                                                                        case 20: {
                                                                                            this.in.readFully(params, 0, 20);
                                                                                            err = 0;
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            mode = EtUtils.bytesToInt(params, 4);
                                                                                            mod = EtUtils.bytesToInt(params, 8);
                                                                                            sec = EtUtils.bytesToInt(params, 12);
                                                                                            nsec = EtUtils.bytesToInt(params, 16);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            try {
                                                                                                if (mode == 1) {
                                                                                                    if (att.isWakeUp()) {
                                                                                                        att.setWakeUp(false);
                                                                                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                                                    }
                                                                                                    uSec = sec * 1000000 + nsec / 1000;
                                                                                                    evs = this.sys.getEvents(att, mode, uSec, 1);
                                                                                                    break block283;
                                                                                                }
                                                                                                if (mode == 0) {
                                                                                                    att.setSleepMode(true);
                                                                                                    break block284;
                                                                                                }
                                                                                                evs = this.sys.getEvents(att, mode, 0, 1);
                                                                                            }
                                                                                            catch (EtException ex) {
                                                                                                err = -1;
                                                                                            }
                                                                                            catch (EtBusyException ex) {
                                                                                                err = -7;
                                                                                            }
                                                                                            catch (EtEmptyException ex) {
                                                                                                err = -6;
                                                                                            }
                                                                                            catch (EtWakeUpException ex) {
                                                                                                err = -4;
                                                                                                att.setSleepMode(false);
                                                                                            }
                                                                                            catch (EtTimeoutException ex) {
                                                                                                err = -5;
                                                                                            }
                                                                                            break block283;
                                                                                        }
                                                                                        case 21: {
                                                                                            this.in.readFully(params, 0, 24);
                                                                                            err = 0;
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            mode = EtUtils.bytesToInt(params, 4);
                                                                                            mod = EtUtils.bytesToInt(params, 8);
                                                                                            count = EtUtils.bytesToInt(params, 12);
                                                                                            sec = EtUtils.bytesToInt(params, 16);
                                                                                            nsec = EtUtils.bytesToInt(params, 20);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            try {
                                                                                                if (mode == 1) {
                                                                                                    if (att.isWakeUp()) {
                                                                                                        att.setWakeUp(false);
                                                                                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                                                    }
                                                                                                    uSec = sec * 1000000 + nsec / 1000;
                                                                                                    evs = this.sys.getEvents(att, mode, uSec, count);
                                                                                                    break block285;
                                                                                                }
                                                                                                if (mode == 0) {
                                                                                                    att.setSleepMode(true);
                                                                                                    break block286;
                                                                                                }
                                                                                                evs = this.sys.getEvents(att, mode, 0, count);
                                                                                            }
                                                                                            catch (EtException ex) {
                                                                                                err = -1;
                                                                                            }
                                                                                            catch (EtBusyException ex) {
                                                                                                err = -7;
                                                                                            }
                                                                                            catch (EtEmptyException ex) {
                                                                                                err = -6;
                                                                                            }
                                                                                            catch (EtWakeUpException ex) {
                                                                                                err = -4;
                                                                                                att.setSleepMode(false);
                                                                                            }
                                                                                            catch (EtTimeoutException ex) {
                                                                                                err = -5;
                                                                                            }
                                                                                            break block285;
                                                                                        }
                                                                                        case 22: {
                                                                                            this.in.readFully(params, 0, 56);
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            id = EtUtils.bytesToInt(params, 4);
                                                                                            ev = this.sys.getEvents()[id];
                                                                                            len = EtUtils.bytesToLong(params, 12);
                                                                                            if (len > 0x7FFFFFFFL) {
                                                                                                throw new EtException("Event is too long for this (java) ET system");
                                                                                            }
                                                                                            ev.setLengthFromServer((int)len);
                                                                                            priAndStat = EtUtils.bytesToInt(params, 20);
                                                                                            ev.setPriority(Priority.getPriority(priAndStat & 1));
                                                                                            ev.setDataStatus(DataStatus.getStatus((priAndStat & 48) >> 4));
                                                                                            ev.setRawByteOrder(EtUtils.bytesToInt(params, 24));
                                                                                            index = 24;
                                                                                            control = new int[6];
                                                                                            for (i = 0; i < 6; ++i) {
                                                                                                control[i] = EtUtils.bytesToInt(params, index += 4);
                                                                                            }
                                                                                            ev.setControl(control);
                                                                                            if (ev.getModify() == Modify.ANYTHING) {
                                                                                                this.in.readFully(ev.getData(), 0, ev.getLength());
                                                                                            }
                                                                                            evArray = new EtEventImpl[]{ev};
                                                                                            this.sys.putEvents(att, evArray);
                                                                                            this.out.writeInt(0);
                                                                                            this.out.flush();
                                                                                            break;
                                                                                        }
                                                                                        case 23: {
                                                                                            this.in.readFully(params, 0, 16);
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            numEvents = EtUtils.bytesToInt(params, 4);
                                                                                            size = EtUtils.bytesToLong(params, 8);
                                                                                            byteChunk = 52;
                                                                                            evs = new EtEventImpl[numEvents];
                                                                                            for (j = 0; j < numEvents; ++j) {
                                                                                                this.in.readFully(params, 0, byteChunk);
                                                                                                id = EtUtils.bytesToInt(params, 0);
                                                                                                evs[j] = this.sys.getEvents()[id];
                                                                                                len = EtUtils.bytesToLong(params, 8);
                                                                                                if (len > 0x7FFFFFFFL) {
                                                                                                    throw new EtException("Event is too long for this (java) ET system");
                                                                                                }
                                                                                                evs[j].setLengthFromServer((int)len);
                                                                                                priAndStat = EtUtils.bytesToInt(params, 16);
                                                                                                evs[j].setPriority(Priority.getPriority(priAndStat & 1));
                                                                                                evs[j].setDataStatus(DataStatus.getStatus((priAndStat & 48) >> 4));
                                                                                                evs[j].setRawByteOrder(EtUtils.bytesToInt(params, 20));
                                                                                                index = 24;
                                                                                                control = new int[6];
                                                                                                for (i = 0; i < 6; ++i) {
                                                                                                    control[i] = EtUtils.bytesToInt(params, index += 4);
                                                                                                }
                                                                                                evs[j].setControl(control);
                                                                                                if (evs[j].getModify() != Modify.ANYTHING) continue;
                                                                                                if (evs[j].getLength() > evs[j].getMemSize()) {
                                                                                                    evs[j].setData(new byte[evs[j].getLength()]);
                                                                                                    evs[j].setMemSize(evs[j].getLength());
                                                                                                }
                                                                                                this.in.readFully(evs[j].getData(), 0, evs[j].getLength());
                                                                                            }
                                                                                            this.sys.putEvents(att, evs);
                                                                                            this.out.writeInt(0);
                                                                                            this.out.flush();
                                                                                            break;
                                                                                        }
                                                                                        case 24: {
                                                                                            this.in.readFully(params, 0, 24);
                                                                                            err = 0;
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            mode = EtUtils.bytesToInt(params, 4);
                                                                                            size = EtUtils.bytesToLong(params, 8);
                                                                                            sec = EtUtils.bytesToInt(params, 16);
                                                                                            nsec = EtUtils.bytesToInt(params, 20);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            if (this.bit64 && size > 0x19999999L) {
                                                                                                this.out.writeInt(-13);
                                                                                                this.out.writeLong(0L);
                                                                                                break;
                                                                                            }
                                                                                            try {
                                                                                                if (mode == 1) {
                                                                                                    if (att.isWakeUp()) {
                                                                                                        att.setWakeUp(false);
                                                                                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                                                    }
                                                                                                    uSec = sec * 1000000 + nsec / 1000;
                                                                                                    evs = this.sys.newEvents(att, mode, uSec, 1, (int)size);
                                                                                                    break block287;
                                                                                                }
                                                                                                if (mode == 0) {
                                                                                                    att.setSleepMode(true);
                                                                                                    break block288;
                                                                                                }
                                                                                                evs = this.sys.newEvents(att, mode, 0, 1, (int)size);
                                                                                            }
                                                                                            catch (EtException ex) {
                                                                                                err = -1;
                                                                                            }
                                                                                            catch (EtBusyException ex) {
                                                                                                err = -7;
                                                                                            }
                                                                                            catch (EtEmptyException ex) {
                                                                                                err = -6;
                                                                                            }
                                                                                            catch (EtWakeUpException ex) {
                                                                                                err = -4;
                                                                                                att.setSleepMode(false);
                                                                                            }
                                                                                            catch (EtTimeoutException ex) {
                                                                                                err = -5;
                                                                                            }
                                                                                            break block287;
                                                                                        }
                                                                                        case 25: {
                                                                                            this.in.readFully(params, 0, 28);
                                                                                            err = 0;
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            mode = EtUtils.bytesToInt(params, 4);
                                                                                            size = EtUtils.bytesToLong(params, 8);
                                                                                            count = EtUtils.bytesToInt(params, 16);
                                                                                            sec = EtUtils.bytesToInt(params, 20);
                                                                                            nsec = EtUtils.bytesToInt(params, 24);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            if (this.bit64 && (long)count * size > 0x19999999L) {
                                                                                                this.out.writeInt(-13);
                                                                                                break;
                                                                                            }
                                                                                            try {
                                                                                                if (mode == 1) {
                                                                                                    if (att.isWakeUp()) {
                                                                                                        att.setWakeUp(false);
                                                                                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                                                    }
                                                                                                    uSec = sec * 1000000 + nsec / 1000;
                                                                                                    evs = this.sys.newEvents(att, mode, uSec, count, (int)size);
                                                                                                    break block289;
                                                                                                }
                                                                                                if (mode == 0) {
                                                                                                    att.setSleepMode(true);
                                                                                                    break block290;
                                                                                                }
                                                                                                evs = this.sys.newEvents(att, mode, 0, count, (int)size);
                                                                                            }
                                                                                            catch (EtException ex) {
                                                                                                err = -1;
                                                                                            }
                                                                                            catch (EtBusyException ex) {
                                                                                                err = -7;
                                                                                            }
                                                                                            catch (EtEmptyException ex) {
                                                                                                err = -6;
                                                                                            }
                                                                                            catch (EtWakeUpException ex) {
                                                                                                err = -4;
                                                                                                att.setSleepMode(false);
                                                                                            }
                                                                                            catch (EtTimeoutException ex) {
                                                                                                err = -5;
                                                                                            }
                                                                                            break block289;
                                                                                        }
                                                                                        case 26: {
                                                                                            attId = this.in.readInt();
                                                                                            id = this.in.readInt();
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            ev = this.sys.getEvents()[id];
                                                                                            evArray = new EtEventImpl[]{ev};
                                                                                            this.sys.dumpEvents(att, evArray);
                                                                                            this.out.writeInt(0);
                                                                                            this.out.flush();
                                                                                            break;
                                                                                        }
                                                                                        case 27: {
                                                                                            attId = this.in.readInt();
                                                                                            numEvents = this.in.readInt();
                                                                                            evs = new EtEventImpl[numEvents];
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            buf = new byte[4 * numEvents];
                                                                                            this.in.readFully(buf, 0, 4 * numEvents);
                                                                                            index = -4;
                                                                                            for (j = 0; j < numEvents; ++j) {
                                                                                                id = EtUtils.bytesToInt(buf, index += 4);
                                                                                                evs[j] = this.sys.getEvents()[id];
                                                                                            }
                                                                                            this.sys.dumpEvents(att, evs);
                                                                                            this.out.writeInt(0);
                                                                                            this.out.flush();
                                                                                            break;
                                                                                        }
                                                                                        case 28: {
                                                                                            this.in.readFully(params, 0, 32);
                                                                                            err = 0;
                                                                                            attId = EtUtils.bytesToInt(params, 0);
                                                                                            mode = EtUtils.bytesToInt(params, 4);
                                                                                            size = EtUtils.bytesToLong(params, 8);
                                                                                            count = EtUtils.bytesToInt(params, 16);
                                                                                            group = EtUtils.bytesToInt(params, 20);
                                                                                            sec = EtUtils.bytesToInt(params, 24);
                                                                                            nsec = EtUtils.bytesToInt(params, 28);
                                                                                            att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                            evList = null;
                                                                                            if (this.bit64 && (long)count * size > 0x19999999L) {
                                                                                                this.out.writeInt(-13);
                                                                                                break;
                                                                                            }
                                                                                            try {
                                                                                                if (mode == 1) {
                                                                                                    if (att.isWakeUp()) {
                                                                                                        att.setWakeUp(false);
                                                                                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                                                    }
                                                                                                    uSec = sec * 1000000 + nsec / 1000;
                                                                                                    evList = this.sys.newEvents(att, mode, uSec, count, (int)size, group);
                                                                                                    break block291;
                                                                                                }
                                                                                                if (mode == 0) {
                                                                                                    att.setSleepMode(true);
                                                                                                    break block292;
                                                                                                }
                                                                                                evList = this.sys.newEvents(att, mode, 0, count, (int)size, group);
                                                                                            }
                                                                                            catch (EtException ex) {
                                                                                                err = -1;
                                                                                            }
                                                                                            catch (EtBusyException ex) {
                                                                                                err = -7;
                                                                                            }
                                                                                            catch (EtEmptyException ex) {
                                                                                                err = -6;
                                                                                            }
                                                                                            catch (EtWakeUpException ex) {
                                                                                                err = -4;
                                                                                                att.setSleepMode(false);
                                                                                            }
                                                                                            catch (EtTimeoutException ex) {
                                                                                                err = -5;
                                                                                            }
                                                                                            break block291;
                                                                                        }
                                                                                    }
                                                                                    continue;
                                                                                }
                                                                                if (command >= 100) break block293;
                                                                                switch (command) {
                                                                                    case 40: {
                                                                                        this.out.writeInt(1);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 41: {
                                                                                        this.out.writeInt(0);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 42: 
                                                                                    case 43: {
                                                                                        for (Map.Entry<K, V> ent : attachments.entrySet()) {
                                                                                            this.sys.detach((AttachmentLocal)ent.getValue());
                                                                                        }
                                                                                        if (this.config.getDebug() >= 4) {
                                                                                            System.out.println("commandLoop: remote client closing");
                                                                                        }
                                                                                        return;
                                                                                    }
                                                                                    case 46: {
                                                                                        if (this.config.getDebug() >= 4) {
                                                                                            System.out.println("commandLoop: got command to kill this ET");
                                                                                        }
                                                                                        System.exit(-1);
                                                                                    }
                                                                                    case 44: {
                                                                                        attId = this.in.readInt();
                                                                                        att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                        if (att == null) continue block129;
                                                                                        att.getStation().getInputList().wakeUp(att);
                                                                                        att.setWakeUp(true);
                                                                                        continue block129;
                                                                                    }
                                                                                    case 45: {
                                                                                        statId = this.in.readInt();
                                                                                        att = this.sys.getStationLock();
                                                                                        synchronized (att) {
                                                                                            for (StationLocal stat : this.sys.getStations()) {
                                                                                                if (stat.getStationId() != statId) continue;
                                                                                                for (AttachmentLocal att : stat.getAttachments()) {
                                                                                                    att.setWakeUp(true);
                                                                                                }
                                                                                                stat.getInputList().wakeUpAll();
                                                                                                break;
                                                                                            }
                                                                                            continue block129;
                                                                                        }
                                                                                    }
                                                                                    case 60: {
                                                                                        err = 0;
                                                                                        statId = this.in.readInt();
                                                                                        pid = this.in.readInt();
                                                                                        length = this.in.readInt();
                                                                                        ipLength = this.in.readInt();
                                                                                        host = null;
                                                                                        ipAddr = null;
                                                                                        att = null;
                                                                                        if (length > 0) {
                                                                                            buf = new byte[length];
                                                                                            this.in.readFully(buf, 0, length);
                                                                                            host = new String(buf, 0, length - 1, "ASCII");
                                                                                        }
                                                                                        if (ipLength > 0) {
                                                                                            buf = new byte[ipLength];
                                                                                            this.in.readFully(buf, 0, ipLength);
                                                                                            ipAddr = new String(buf, 0, ipLength - 1, "ASCII");
                                                                                        }
                                                                                        try {
                                                                                            att = this.sys.attach(statId);
                                                                                            att.setPid(pid);
                                                                                            if (length > 0) {
                                                                                                att.setHost(host);
                                                                                            }
                                                                                            if (ipLength > 0) {
                                                                                                att.setIpAddress(ipAddr);
                                                                                            }
                                                                                            attachments.put(att.getId(), att);
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            err = -1;
                                                                                        }
                                                                                        catch (EtTooManyException ex) {
                                                                                            err = -2;
                                                                                        }
                                                                                        this.out.writeInt(err);
                                                                                        if (err == 0) {
                                                                                            this.out.writeInt(att.getId());
                                                                                        } else {
                                                                                            this.out.writeInt(0);
                                                                                        }
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 61: {
                                                                                        attId = this.in.readInt();
                                                                                        att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                        this.sys.detach(att);
                                                                                        attachments.remove(att.getId());
                                                                                        this.out.writeInt(0);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 62: {
                                                                                        err = 0;
                                                                                        stat = null;
                                                                                        statConfig = new EtStationConfig();
                                                                                        init = this.in.readInt();
                                                                                        statConfig.setFlowMode(this.in.readInt());
                                                                                        statConfig.setUserMode(this.in.readInt());
                                                                                        statConfig.setRestoreMode(this.in.readInt());
                                                                                        statConfig.setBlockMode(this.in.readInt());
                                                                                        statConfig.setPrescale(this.in.readInt());
                                                                                        statConfig.setCue(this.in.readInt());
                                                                                        statConfig.setSelectMode(this.in.readInt());
                                                                                        select = new int[6];
                                                                                        for (i = 0; i < 6; ++i) {
                                                                                            select[i] = this.in.readInt();
                                                                                        }
                                                                                        statConfig.setSelect(select);
                                                                                        lengthFunc = this.in.readInt();
                                                                                        lengthLib = this.in.readInt();
                                                                                        lengthClass = this.in.readInt();
                                                                                        lengthName = this.in.readInt();
                                                                                        position = this.in.readInt();
                                                                                        parallelPosition = this.in.readInt();
                                                                                        length = lengthClass > lengthLib ? lengthClass : lengthLib;
                                                                                        length = length > lengthFunc ? length : lengthFunc;
                                                                                        length = length > lengthName ? length : lengthName;
                                                                                        buf = new byte[length];
                                                                                        if (lengthFunc > 0) {
                                                                                            this.in.readFully(buf, 0, lengthFunc);
                                                                                            statConfig.setSelectFunction(new String(buf, 0, lengthFunc - 1, "ASCII"));
                                                                                        }
                                                                                        if (lengthLib > 0) {
                                                                                            this.in.readFully(buf, 0, lengthLib);
                                                                                            statConfig.setSelectLibrary(new String(buf, 0, lengthLib - 1, "ASCII"));
                                                                                        }
                                                                                        if (lengthClass > 0) {
                                                                                            this.in.readFully(buf, 0, lengthClass);
                                                                                            statConfig.setSelectClass(new String(buf, 0, lengthClass - 1, "ASCII"));
                                                                                        }
                                                                                        this.in.readFully(buf, 0, lengthName);
                                                                                        name = new String(buf, 0, lengthName - 1, "ASCII");
                                                                                        try {
                                                                                            stat = this.sys.createStation(statConfig, name, position, parallelPosition);
                                                                                        }
                                                                                        catch (EtTooManyException ex) {
                                                                                            err = -2;
                                                                                        }
                                                                                        catch (EtExistsException ex) {
                                                                                            err = -3;
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            err = -1;
                                                                                        }
                                                                                        this.out.writeInt(err);
                                                                                        if (err != 0) {
                                                                                            this.out.writeInt(0);
                                                                                        } else {
                                                                                            this.out.writeInt(stat.getStationId());
                                                                                        }
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 63: {
                                                                                        err = 0;
                                                                                        statId = this.in.readInt();
                                                                                        try {
                                                                                            this.sys.removeStation(statId);
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            err = -1;
                                                                                        }
                                                                                        this.out.writeInt(err);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 64: {
                                                                                        err = 0;
                                                                                        statId = this.in.readInt();
                                                                                        position = this.in.readInt();
                                                                                        pposition = this.in.readInt();
                                                                                        try {
                                                                                            this.sys.setStationPosition(statId, position, pposition);
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            err = -1;
                                                                                        }
                                                                                        this.out.writeInt(err);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 65: {
                                                                                        position = -1;
                                                                                        pPosition = 0;
                                                                                        err = 0;
                                                                                        statId = this.in.readInt();
                                                                                        try {
                                                                                            position = this.sys.getStationPosition(statId);
                                                                                            pPosition = this.sys.getStationParallelPosition(statId);
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            err = -1;
                                                                                        }
                                                                                        this.out.writeInt(err);
                                                                                        this.out.writeInt(position);
                                                                                        this.out.writeInt(pPosition);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 80: {
                                                                                        statId = this.in.readInt();
                                                                                        attId = this.in.readInt();
                                                                                        try {
                                                                                            attached = this.sys.stationAttached(statId, attId) != false ? 1 : 0;
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            attached = -1;
                                                                                        }
                                                                                        this.out.writeInt(attached);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 81: {
                                                                                        exists = true;
                                                                                        statId = 0;
                                                                                        length = this.in.readInt();
                                                                                        buf = new byte[length];
                                                                                        this.in.readFully(buf, 0, length);
                                                                                        name = new String(buf, 0, length - 1, "ASCII");
                                                                                        try {
                                                                                            statId = this.sys.stationNameToObject(name).getStationId();
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            exists = false;
                                                                                        }
                                                                                        this.out.writeInt(exists != false ? 1 : 0);
                                                                                        this.out.writeInt(statId);
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 82: {
                                                                                        stat = null;
                                                                                        select = new int[6];
                                                                                        statId = this.in.readInt();
                                                                                        for (i = 0; i < 6; ++i) {
                                                                                            select[i] = this.in.readInt();
                                                                                        }
                                                                                        try {
                                                                                            stat = this.sys.stationIdToObject(statId);
                                                                                        }
                                                                                        catch (EtException i) {
                                                                                            // empty catch block
                                                                                        }
                                                                                        if (stat != null) {
                                                                                            stat.setSelectWords(select);
                                                                                            this.out.writeInt(0);
                                                                                        } else {
                                                                                            this.out.writeInt(-1);
                                                                                        }
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 83: {
                                                                                        statId = this.in.readInt();
                                                                                        stat = null;
                                                                                        try {
                                                                                            stat = this.sys.stationIdToObject(statId);
                                                                                        }
                                                                                        catch (EtException statId) {
                                                                                            // empty catch block
                                                                                        }
                                                                                        if (stat != null) {
                                                                                            this.out.writeInt(0);
                                                                                            select = stat.getConfig().getSelect();
                                                                                            for (i = 0; i < 6; ++i) {
                                                                                                this.out.writeInt(select[i]);
                                                                                            }
                                                                                        } else {
                                                                                            this.out.writeInt(-1);
                                                                                        }
                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                    case 84: 
                                                                                    case 85: 
                                                                                    case 86: {
                                                                                        statId = this.in.readInt();
                                                                                        try {
                                                                                            stat = this.sys.stationIdToObject(statId);
                                                                                            returnString = command == 85 ? stat.getConfig().getSelectFunction() : (command == 84 ? stat.getConfig().getSelectLibrary() : stat.getConfig().getSelectClass());
                                                                                            if (returnString != null) ** GOTO lbl577
                                                                                            this.out.writeInt(-1);
                                                                                            this.out.writeInt(0);
                                                                                            ** GOTO lbl589
lbl577:
                                                                                            // 1 sources

                                                                                            this.out.writeInt(0);
                                                                                            this.out.writeInt(returnString.length() + 1);
                                                                                            try {
                                                                                                this.out.write(returnString.getBytes("ASCII"));
                                                                                            }
                                                                                            catch (UnsupportedEncodingException var15_121) {
                                                                                                // empty catch block
                                                                                            }
                                                                                            this.out.writeByte(0);
                                                                                        }
                                                                                        catch (EtException ex) {
                                                                                            this.out.writeInt(-1);
                                                                                            this.out.writeInt(-1);
                                                                                        }
lbl589:
                                                                                        // 3 sources

                                                                                        this.out.flush();
                                                                                        continue block129;
                                                                                    }
                                                                                }
                                                                                continue;
                                                                            }
                                                                            if (command < 115) {
                                                                                val = 0;
                                                                                statId = this.in.readInt();
                                                                                stat = null;
                                                                                try {
                                                                                    stat = this.sys.stationIdToObject(statId);
                                                                                }
                                                                                catch (EtException var15_122) {
                                                                                    // empty catch block
                                                                                }
                                                                                if (stat == null) {
                                                                                    this.out.writeInt(-1);
                                                                                } else {
                                                                                    if (command == 100) {
                                                                                        var15_123 = this.sys.getStationLock();
                                                                                        synchronized (var15_123) {
                                                                                            val = stat.getAttachments().size();
                                                                                        }
                                                                                    } else if (command == 101) {
                                                                                        val = stat.getStatus();
                                                                                    } else if (command == 102) {
                                                                                        var15_124 = stat.getInputList();
                                                                                        synchronized (var15_124) {
                                                                                            val = stat.getInputList().getEvents().size();
                                                                                        }
                                                                                    } else if (command == 103) {
                                                                                        var15_125 = stat.getOutputList();
                                                                                        synchronized (var15_125) {
                                                                                            val = stat.getOutputList().getEvents().size();
                                                                                        }
                                                                                    } else if (command == 104) {
                                                                                        val = stat.getConfig().getBlockMode();
                                                                                    } else if (command == 105) {
                                                                                        val = stat.getConfig().getUserMode();
                                                                                    } else if (command == 106) {
                                                                                        val = stat.getConfig().getRestoreMode();
                                                                                    } else if (command == 107) {
                                                                                        val = stat.getConfig().getPrescale();
                                                                                    } else if (command == 108) {
                                                                                        val = stat.getConfig().getCue();
                                                                                    } else if (command == 109) {
                                                                                        val = stat.getConfig().getSelectMode();
                                                                                    } else {
                                                                                        if (this.config.getDebug() >= 2) {
                                                                                            System.out.println("commandLoop: bad command value");
                                                                                        }
                                                                                        throw new EtReadException("bad command value");
                                                                                    }
                                                                                    this.out.writeInt(0);
                                                                                }
                                                                                this.out.writeInt(val);
                                                                                this.out.flush();
                                                                                continue;
                                                                            }
                                                                            if (command < 130) {
                                                                                statId = this.in.readInt();
                                                                                val = this.in.readInt();
                                                                                stat = null;
                                                                                try {
                                                                                    stat = this.sys.stationIdToObject(statId);
                                                                                }
                                                                                catch (EtException var15_126) {
                                                                                    // empty catch block
                                                                                }
                                                                                if (stat == null) {
                                                                                    this.out.writeInt(-1);
                                                                                } else {
                                                                                    if (command == 115) {
                                                                                        stat.setBlockMode(val);
                                                                                    } else if (command == 116) {
                                                                                        stat.setUserMode(val);
                                                                                    } else if (command == 117) {
                                                                                        stat.setRestoreMode(val);
                                                                                    } else if (command == 118) {
                                                                                        stat.setPrescale(val);
                                                                                    } else if (command == 119) {
                                                                                        stat.setCue(val);
                                                                                    } else {
                                                                                        if (this.config.getDebug() >= 2) {
                                                                                            System.out.println("commandLoop: bad command value");
                                                                                        }
                                                                                        throw new EtReadException("bad command value");
                                                                                    }
                                                                                    this.out.writeInt(0);
                                                                                }
                                                                                this.out.flush();
                                                                                continue;
                                                                            }
                                                                            if (command < 150) {
                                                                                attId = this.in.readInt();
                                                                                att = (AttachmentLocal)attachments.get(new Integer(attId));
                                                                                if (att == null) {
                                                                                    this.out.writeInt(-1);
                                                                                    this.out.writeLong(0L);
                                                                                } else {
                                                                                    this.out.writeInt(0);
                                                                                    if (command == 130) {
                                                                                        this.out.writeLong(att.getEventsPut());
                                                                                    } else if (command == 131) {
                                                                                        this.out.writeLong(att.getEventsGet());
                                                                                    } else if (command == 132) {
                                                                                        this.out.writeLong(att.getEventsDump());
                                                                                    } else if (command == 133) {
                                                                                        this.out.writeLong(att.getEventsMake());
                                                                                    }
                                                                                }
                                                                                this.out.flush();
                                                                                continue;
                                                                            }
                                                                            if (command <= 160) {
                                                                                if (command == 150) {
                                                                                    val = 0;
                                                                                } else if (command == 151) {
                                                                                    val = 0;
                                                                                } else if (command == 152) {
                                                                                    att = this.sys.getStationLock();
                                                                                    synchronized (att) {
                                                                                        val = this.sys.getStations().size();
                                                                                    }
                                                                                } else if (command == 153) {
                                                                                    val = this.sys.getConfig().getStationsMax();
                                                                                } else if (command == 154) {
                                                                                    val = 0;
                                                                                } else if (command == 155) {
                                                                                    val = 0;
                                                                                } else if (command == 156) {
                                                                                    att = this.sys.getSystemLock();
                                                                                    synchronized (att) {
                                                                                        val = this.sys.getAttachments().size();
                                                                                    }
                                                                                } else if (command == 157) {
                                                                                    val = this.sys.getConfig().getAttachmentsMax();
                                                                                } else if (command == 158) {
                                                                                    val = 0;
                                                                                } else if (command == 159) {
                                                                                    val = -1;
                                                                                } else if (command == 160) {
                                                                                    val = this.sys.getConfig().getGroups().length;
                                                                                } else {
                                                                                    if (this.config.getDebug() >= 2) {
                                                                                        System.out.println("commandLoop: bad command value");
                                                                                    }
                                                                                    throw new EtReadException("bad command value");
                                                                                }
                                                                                this.out.writeInt(0);
                                                                                this.out.writeInt(val);
                                                                                this.out.flush();
                                                                                continue;
                                                                            }
                                                                            if (command <= 172) {
                                                                                if (command == 170) {
                                                                                    val = this.sys.getInfoArray();
                                                                                    synchronized (val) {
                                                                                        err = this.sys.gatherSystemData();
                                                                                        this.out.writeInt(err);
                                                                                        if (err == 0) {
                                                                                            this.out.write(this.sys.getInfoArray(), 0, this.sys.getDataLength() + 4);
                                                                                        }
                                                                                    }
                                                                                    this.out.flush();
                                                                                    continue;
                                                                                }
                                                                                if (command == 171) {
                                                                                    this.out.writeInt(-1);
                                                                                    this.out.flush();
                                                                                    continue;
                                                                                }
                                                                                if (command != 172) continue;
                                                                                groups = this.sys.getConfig().getGroups();
                                                                                this.out.writeInt(groups.length);
                                                                                for (int j : groups) {
                                                                                    this.out.writeInt(j);
                                                                                }
                                                                                this.out.flush();
                                                                                continue;
                                                                            }
                                                                            if (this.config.getDebug() >= 2) {
                                                                                System.out.println("commandLoop: bad command value");
                                                                            }
                                                                            throw new EtReadException("bad command value");
                                                                        }
                                                                    }
                                                                    catch (EtReadException var12_42) {
                                                                    }
                                                                    catch (EtException var12_43) {
                                                                    }
                                                                    catch (IOException var12_44) {
                                                                        // empty catch block
                                                                    }
                                                                    for (Map.Entry<K, V> entry : attachments.entrySet()) {
                                                                        this.sys.detach((AttachmentLocal)entry.getValue());
                                                                    }
                                                                    if (this.config.getDebug() >= 2) {
                                                                        System.out.println("commandLoop: remote client connection broken");
                                                                    }
                                                                    return;
                                                                }
                                                                while (true) {
                                                                    try {
                                                                        if (att.isWakeUp()) {
                                                                            att.setWakeUp(false);
                                                                            throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                                        }
                                                                        evs = this.sys.getEvents(att, 1, 4000000, 1);
                                                                        att.setSleepMode(false);
                                                                        att.setWakeUp(false);
                                                                    }
                                                                    catch (EtTimeoutException tx) {
                                                                        try {
                                                                            this.in.readInt();
                                                                            att.setSleepMode(false);
                                                                            throw new EtException("communication protocol error");
                                                                        }
                                                                        catch (InterruptedIOException var20_172) {
                                                                            continue;
                                                                        }
                                                                    }
                                                                    break;
                                                                }
                                                            }
                                                            if (err == 0) break block294;
                                                            this.out.writeInt(err);
                                                            this.out.flush();
                                                            ** GOTO lbl-1000
                                                        }
                                                        ev = evs[0];
                                                        buf = new byte[64 + ev.getLength()];
                                                        EtUtils.intToBytes(err, buf, 0);
                                                        EtUtils.longToBytes(ev.getLength(), buf, 4);
                                                        EtUtils.longToBytes(ev.getMemSize(), buf, 12);
                                                        EtUtils.intToBytes(ev.getPriority().getValue() | ev.getDataStatus().getValue() << 4, buf, 20);
                                                        EtUtils.intToBytes(ev.getId(), buf, 24);
                                                        EtUtils.intToBytes(ev.getRawByteOrder(), buf, 32);
                                                        index = 36;
                                                        control = ev.getControl();
                                                        for (i = 0; i < 6; ++i) {
                                                            EtUtils.intToBytes(control[i], buf, index += 4);
                                                        }
                                                        System.arraycopy(ev.getData(), 0, buf, index += 4, ev.getLength());
                                                        this.out.write(buf);
                                                        this.out.flush();
                                                        ev.setModify(Modify.getModify(mod));
                                                        if (mod == 0) {
                                                            this.sys.putEvents(att, evs);
                                                        }
                                                        evs = null;
                                                        ** GOTO lbl-1000
                                                    }
                                                    while (true) {
                                                        try {
                                                            if (att.isWakeUp()) {
                                                                att.setWakeUp(false);
                                                                throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                            }
                                                            evs = this.sys.getEvents(att, 1, 4000000, count);
                                                            att.setSleepMode(false);
                                                            att.setWakeUp(false);
                                                        }
                                                        catch (EtTimeoutException tx) {
                                                            try {
                                                                this.in.readInt();
                                                                att.setSleepMode(false);
                                                                throw new EtException("communication protocol error");
                                                            }
                                                            catch (InterruptedIOException index) {
                                                                continue;
                                                            }
                                                        }
                                                        break;
                                                    }
                                                }
                                                if (err == 0) break block295;
                                                this.out.writeInt(err);
                                                this.out.flush();
                                                ** GOTO lbl-1000
                                            }
                                            index = 12;
                                            headerSize = 48;
                                            size = evs.length * headerSize;
                                            var24_233 = evs;
                                            var25_239 = var24_233.length;
                                            for (var26_245 = 0; var26_245 < var25_239; size += ev1.getLength(), ++var26_245) {
                                                ev1 = var24_233[var26_245];
                                            }
                                            EtUtils.intToBytes(evs.length, buffer, 0);
                                            EtUtils.longToBytes(size, buffer, 4);
                                            mfy = Modify.getModify(mod);
                                            var25_240 = evs;
                                            var26_245 = var25_240.length;
                                            for (var27_251 = 0; var27_251 < var26_245; ++var27_251) {
                                                ev = var25_240[var27_251];
                                                ev.setModify(mfy);
                                                length = ev.getLength();
                                                EtUtils.longToBytes(length, buffer, index);
                                                EtUtils.longToBytes(ev.getMemSize(), buffer, index += 8);
                                                EtUtils.intToBytes(ev.getPriority().getValue() | ev.getDataStatus().getValue() << 4, buffer, index += 8);
                                                EtUtils.intToBytes(ev.getId(), buffer, index += 4);
                                                EtUtils.intToBytes(ev.getRawByteOrder(), buffer, index += 8);
                                                EtUtils.intToBytes(0, buffer, index += 4);
                                                control = ev.getControl();
                                                for (i = 0; i < 6; ++i) {
                                                    EtUtils.intToBytes(control[i], buffer, index += 4);
                                                }
                                                if ((index += 4) + headerSize + length > buffer.length) {
                                                    this.out.write(buffer, 0, index);
                                                    index = 0;
                                                    if (headerSize + length > buffer.length / 2) {
                                                        this.out.write(ev.getData(), 0, length);
                                                        this.out.flush();
                                                        continue;
                                                    }
                                                    this.out.flush();
                                                }
                                                System.arraycopy(ev.getData(), 0, buffer, index, length);
                                                index += length;
                                            }
                                            if (index > 0) {
                                                this.out.write(buffer, 0, index);
                                                this.out.flush();
                                            }
                                            if (mod == 0) {
                                                this.sys.putEvents(att, evs);
                                            }
                                            evs = null;
                                            ** GOTO lbl-1000
                                        }
                                        while (true) {
                                            try {
                                                if (att.isWakeUp()) {
                                                    att.setWakeUp(false);
                                                    throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                                }
                                                evs = this.sys.newEvents(att, 1, 4000000, 1, (int)size);
                                                att.setSleepMode(false);
                                                att.setWakeUp(false);
                                            }
                                            catch (EtTimeoutException tx) {
                                                try {
                                                    this.in.readInt();
                                                    att.setSleepMode(false);
                                                    throw new EtException("communication protocol error");
                                                }
                                                catch (InterruptedIOException index) {
                                                    continue;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    if (err == 0) break block296;
                                    this.out.writeInt(err);
                                    this.out.writeLong(0L);
                                    this.out.flush();
                                    ** GOTO lbl-1000
                                }
                                evs[0].setModify(Modify.ANYTHING);
                                this.out.writeInt(err);
                                this.out.writeInt(evs[0].getId());
                                this.out.writeInt(0);
                                this.out.flush();
                                evs = null;
                                ** GOTO lbl-1000
                            }
                            while (true) {
                                try {
                                    if (att.isWakeUp()) {
                                        att.setWakeUp(false);
                                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                                    }
                                    evs = this.sys.newEvents(att, 1, 4000000, count, (int)size);
                                    att.setSleepMode(false);
                                    att.setWakeUp(false);
                                }
                                catch (EtTimeoutException tx) {
                                    try {
                                        this.in.readInt();
                                        att.setSleepMode(false);
                                        throw new EtException("communication protocol error");
                                    }
                                    catch (InterruptedIOException byteChunk) {
                                        continue;
                                    }
                                }
                                break;
                            }
                        }
                        if (err == 0) break block297;
                        this.out.writeInt(err);
                        this.out.flush();
                        ** GOTO lbl-1000
                    }
                    index = 0;
                    buf = new byte[4 + 4 * evs.length];
                    EtUtils.intToBytes(evs.length, buf, 0);
                    for (EtEventImpl ev : evs) {
                        ev.setModify(Modify.ANYTHING);
                        EtUtils.intToBytes(ev.getId(), buf, index += 4);
                    }
                    this.out.write(buf);
                    this.out.flush();
                    evs = null;
                    ** GOTO lbl-1000
                }
                while (true) {
                    try {
                        if (att.isWakeUp()) {
                            att.setWakeUp(false);
                            throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                        }
                        evList = this.sys.newEvents(att, 1, 4000000, count, (int)size, group);
                        att.setSleepMode(false);
                        att.setWakeUp(false);
                    }
                    catch (EtTimeoutException tx) {
                        try {
                            this.in.readInt();
                            att.setSleepMode(false);
                            throw new EtException("communication protocol error");
                        }
                        catch (InterruptedIOException control) {
                            continue;
                        }
                    }
                    break;
                }
            }
            if (err == 0) break block298;
            this.out.writeInt(err);
            this.out.flush();
            ** GOTO lbl-1000
        }
        index = 0;
        buf = new byte[4 + 4 * evList.size()];
        EtUtils.intToBytes(evList.size(), buf, 0);
        for (EtEventImpl ev : evList) {
            ev.setModify(Modify.ANYTHING);
            EtUtils.intToBytes(ev.getId(), buf, index += 4);
        }
        this.out.write(buf);
        this.out.flush();
        ** while (true)
    }
}

