/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtContainer;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;

public class UserEventInjector {
    private static void usage() {
        System.out.println("\nUsage: java UserEventInjector -f <et name>\n                      [-h] [-v] [-n] [-r] [-m] [-b] [-nd]\n                      [-host <ET host>] [-w <big endian? 0/1>]\n                      [-g <group>]\n                      [-d <delay>] [-p <ET port>]\n                      [-i <interface address>] [-a <mcast addr>]\n                      [-rb <buf size>] [-sb <buf size>]\n\n       -f     ET system's (memory-mapped file) name\n       -host  ET system's host if direct connection (default to local)\n       -h     help\n       -v     verbose output\n       -n     use new, non-garbage-generating new,get,put,dump methods\n\n       -g     group from which to get new events (1,2,...)\n       -d     delay in millisec between each round of getting and putting events\n\n       -p     ET port (TCP for direct, UDP for broad/multicast)\n       -r     act as remote (TCP) client even if ET system is local\n       -w     write data (1 sequential int per event), 1 = Java (big) endian, 0 else\n\n       -i     outgoing network interface address (dot-decimal)\n       -a     multicast address(es) (dot-decimal), may use multiple times\n       -m     multicast to find ET (use default address if -a unused)\n       -b     broadcast to find ET\n\n       -rb    TCP receive buffer size (bytes)\n       -sb    TCP send    buffer size (bytes)\n       -nd    use TCP_NODELAY option\n\n        This producer works by making a direct connection to the\n        ET system's server port and host unless at least one multicast address\n        is specified with -a, the -m option is used, or the -b option is used\n        in which case multi/broadcasting used to find the ET system.\n        If multi/broadcasting fails, look locally to find the ET system.\n        This program gets new events from the system and puts them back.\n\n");
    }

    public static void main(String[] args) {
        int group = 1;
        int delay = 0;
        int size = 32;
        int port = 0;
        int chunk = 1;
        int recvBufSize = 0;
        int sendBufSize = 0;
        boolean noDelay = false;
        boolean verbose = false;
        boolean newIF = false;
        boolean remote = false;
        boolean bigEndian = true;
        boolean broadcast = false;
        boolean multicast = false;
        boolean broadAndMulticast = false;
        HashSet<String> multicastAddrs = new HashSet<String>();
        String outgoingInterface = null;
        String etName = null;
        String host = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                try {
                    String addr = args[++i];
                    if (InetAddress.getByName(addr).isMulticastAddress()) {
                        multicastAddrs.add(addr);
                        multicast = true;
                        continue;
                    }
                    System.out.println("\nignoring improper multicast address\n");
                }
                catch (UnknownHostException addr) {}
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                outgoingInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-nd")) {
                noDelay = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                System.out.println("Using NEW interface");
                newIF = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-m")) {
                multicast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b")) {
                broadcast = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-w")) {
                try {
                    int isBigEndian = Integer.parseInt(args[++i]);
                    bigEndian = isBigEndian != 0;
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper endian value (1=big, else 0).");
                    UserEventInjector.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    UserEventInjector.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    UserEventInjector.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-rb")) {
                try {
                    recvBufSize = Integer.parseInt(args[++i]);
                    if (recvBufSize >= 0) continue;
                    System.out.println("Receive buf size must be 0 or greater.");
                    UserEventInjector.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper receive buffer size.");
                    UserEventInjector.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-sb")) {
                try {
                    sendBufSize = Integer.parseInt(args[++i]);
                    if (sendBufSize >= 0) continue;
                    System.out.println("Send buf size must be 0 or greater.");
                    UserEventInjector.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper send buffer size.");
                    UserEventInjector.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-g")) {
                try {
                    group = Integer.parseInt(args[++i]);
                    if (group >= 1 && group <= 10) continue;
                    System.out.println("Group number must be between 0 and 10.");
                    UserEventInjector.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper group number.");
                    UserEventInjector.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-d")) {
                try {
                    delay = Integer.parseInt(args[++i]);
                    if (delay >= 1) continue;
                    System.out.println("delay must be > 0.");
                    UserEventInjector.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper delay.");
                    UserEventInjector.usage();
                    return;
                }
            }
            UserEventInjector.usage();
            return;
        }
        if (etName == null) {
            UserEventInjector.usage();
            return;
        }
        ByteBuffer firstBuffer = ByteBuffer.allocate(56);
        firstBuffer.putInt(14);
        firstBuffer.putInt(1);
        firstBuffer.putInt(8);
        firstBuffer.putInt(1);
        firstBuffer.putInt(0);
        firstBuffer.putInt(20996);
        firstBuffer.putInt(0);
        firstBuffer.putInt(-1059454720);
        firstBuffer.putInt(5);
        firstBuffer.putInt(131329);
        firstBuffer.putInt(1);
        firstBuffer.putInt(2);
        firstBuffer.putInt(3);
        firstBuffer.putInt(4);
        firstBuffer.flip();
        ByteBuffer userBuffer = ByteBuffer.allocate(56);
        userBuffer.putInt(14);
        userBuffer.putInt(1);
        userBuffer.putInt(8);
        userBuffer.putInt(1);
        userBuffer.putInt(0);
        userBuffer.putInt(4612);
        userBuffer.putInt(0);
        userBuffer.putInt(-1059454720);
        userBuffer.putInt(5);
        userBuffer.putInt(262403);
        userBuffer.putInt(5);
        userBuffer.putInt(6);
        userBuffer.putInt(7);
        userBuffer.putInt(8);
        userBuffer.flip();
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig();
            if (broadcast && multicast) {
                broadAndMulticast = true;
            }
            if (multicast) {
                if (multicastAddrs.size() < 1) {
                    config.addMulticastAddr("239.200.0.0");
                } else {
                    for (String mcastAddr : multicastAddrs) {
                        config.addMulticastAddr(mcastAddr);
                    }
                }
            }
            if (broadAndMulticast) {
                System.out.println("Broad and Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(3);
                config.setHost(".anywhere");
            } else if (multicast) {
                System.out.println("Multicasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(0);
                config.setHost(".anywhere");
            } else if (broadcast) {
                System.out.println("Broadcasting");
                if (port == 0) {
                    port = 11111;
                }
                config.setUdpPort(port);
                config.setNetworkContactMethod(1);
                config.setHost(".anywhere");
            } else {
                if (port == 0) {
                    port = 11111;
                }
                config.setTcpPort(port);
                config.setNetworkContactMethod(2);
                if (host == null) {
                    host = ".local";
                }
                config.setHost(host);
                System.out.println("Direct connection to " + host);
            }
            config.setNoDelay(noDelay);
            config.setTcpRecvBufSize(recvBufSize);
            config.setTcpSendBufSize(sendBufSize);
            config.setNetworkInterface(outgoingInterface);
            config.setWaitTime(0L);
            config.setEtName(etName);
            config.setResponsePolicy(2);
            if (remote) {
                System.out.println("Set as remote");
                config.setConnectRemotely(remote);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            if (sys.usingJniLibrary()) {
                System.out.println("ET is local\n");
            } else {
                System.out.println("ET is remote\n");
            }
            EtStation gc = sys.stationNameToObject("GRAND_CENTRAL");
            EtAttachment att = sys.attach(gc);
            EtContainer container = null;
            if (newIF) {
                container = new EtContainer(chunk, (int)sys.getEventSize());
            }
            long totalT = 0L;
            long totalCount = 0L;
            long count = 0L;
            boolean sendFirstEvent = true;
            long t1 = System.currentTimeMillis();
            while (true) {
                long t2;
                long time;
                EtEvent[] events;
                int validEvents;
                if (newIF) {
                    container.newEvents(att, Mode.SLEEP, 0, 1, size, group);
                    sys.newEvents(container);
                    validEvents = container.getEventCount();
                    count += (long)validEvents;
                    events = container.getEventArray();
                } else {
                    events = sys.newEvents(att, Mode.SLEEP, false, 0, 1, size, group);
                    validEvents = events.length;
                    count += (long)validEvents;
                }
                for (int j = 0; j < validEvents; ++j) {
                    ByteBuffer buf = events[j].getDataBuffer();
                    if (sendFirstEvent) {
                        buf.put(firstBuffer);
                        firstBuffer.flip();
                    } else {
                        buf.put(userBuffer);
                        userBuffer.flip();
                    }
                    events[j].setByteOrder(ByteOrder.BIG_ENDIAN);
                    events[j].setLength(56);
                }
                if (delay > 0) {
                    Thread.sleep(delay);
                }
                if (newIF) {
                    container.putEvents(att, 0, validEvents);
                    sys.putEvents(container);
                } else {
                    sys.putEvents(att, events);
                }
                if ((time = (t2 = System.currentTimeMillis()) - t1) <= 5000L) continue;
                if (totalCount >= Long.MAX_VALUE - count || totalT >= Long.MAX_VALUE - time) {
                    count = 0L;
                    totalCount = 0L;
                    totalT = 0L;
                    t1 = t2;
                    continue;
                }
                double rate = 1000.0 * (double)count / (double)time;
                double avgRate = 1000.0 * (double)(totalCount += count) / (double)(totalT += time);
                System.out.println("Events = " + String.format("%.3g", rate) + " Hz,    avg = " + String.format("%.3g", avgRate));
                rate = (double)count * (double)size / (double)time;
                avgRate = (double)totalCount * (double)size / (double)totalT;
                System.out.println("  Data = " + String.format("%.3g", rate) + " kB/s,  avg = " + String.format("%.3g", avgRate) + "\n");
                count = 0L;
                t1 = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as producer");
            ex.printStackTrace();
            return;
        }
    }
}

