/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

public class StartEt {
    private static void usage() {
        System.out.println("\nUsage: java StartEt [-h] [-v] [-d] [-f <file>] [-n <events>] [-s <eventSize>]\n                    [-g <groups>] [-a <multicast address>]\n                    [-p <TCP server port>] [-u <UDP port>]\n                    [-rb <buf size>] [-sb <buf size>] [-nd]\n\n          -h   help\n          -v   verbose output\n          -d   deletes an existing file first\n          -f   memory-mapped file name\n\n          -n   number of events\n          -s   event size in bytes\n          -g   number of groups to divide events into\n\n          -p   TCP server port #\n          -u   UDP broadcast port #\n          -a   multicast address\n\n          -rb  TCP receive buffer size (bytes)\n          -sb  TCP send    buffer size (bytes)\n          -nd  use TCP_NODELAY option\n\n          This program starts up an ET system.\n          Listens on 239.200.0.0 by default.\n");
    }

    public static void main(String[] args) {
        int numEvents = 3000;
        int size = 128;
        int serverPort = 11111;
        int udpPort = 11111;
        int recvBufSize = 0;
        int sendBufSize = 0;
        int numGroups = 1;
        boolean debug = false;
        boolean noDelay = false;
        boolean deleteFile = false;
        String file = null;
        HashSet<Object> multicastAddrs = new HashSet<Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                StartEt.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                numEvents = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                file = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                serverPort = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                udpPort = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                size = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rb")) {
                recvBufSize = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-sb")) {
                sendBufSize = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nd")) {
                noDelay = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-g")) {
                numGroups = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                deleteFile = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                try {
                    String addr = args[++i];
                    if (InetAddress.getByName(addr).isMulticastAddress()) {
                        multicastAddrs.add(addr);
                        continue;
                    }
                    System.out.println("\nignoring improper multicast address\n");
                }
                catch (UnknownHostException addr) {}
                continue;
            }
            StartEt.usage();
            System.exit(-1);
        }
        if (file == null) {
            String et_filename = System.getenv("SESSION");
            if (et_filename == null) {
                System.out.println("No ET file name given and SESSION env variable not defined");
                StartEt.usage();
                System.exit(-1);
            }
            file = "/tmp/et_sys_" + et_filename;
        }
        if (file.length() >= 101) {
            System.out.println("ET file name is too long");
            StartEt.usage();
            System.exit(-1);
        }
        if (deleteFile) {
            File f = new File(file);
            f.delete();
        }
        try {
            System.out.println("STARTING ET SYSTEM");
            SystemConfig config = new SystemConfig();
            if (multicastAddrs.size() < 1) {
                config.addMulticastAddr("239.200.0.0");
            } else {
                for (String string : multicastAddrs) {
                    config.addMulticastAddr(string);
                }
            }
            config.setServerPort(serverPort);
            config.setUdpPort(udpPort);
            config.setNumEvents(numEvents);
            config.setEventSize(size);
            if (recvBufSize > 0) {
                config.setTcpRecvBufSize(recvBufSize);
            }
            if (sendBufSize > 0) {
                config.setTcpSendBufSize(sendBufSize);
            }
            if (noDelay) {
                config.setNoDelay(noDelay);
            }
            if (debug) {
                config.setDebug(4);
            }
            if (numGroups > 1) {
                int addgroup = 0;
                int n = numEvents / numGroups;
                int r = numEvents % numGroups;
                if (r > 0) {
                    addgroup = 1;
                }
                int[] groups = new int[numGroups + addgroup];
                for (int i = 0; i < numGroups; ++i) {
                    groups[i] = n;
                }
                if (addgroup > 0) {
                    groups[numGroups] = r;
                }
                config.setGroups(groups);
            }
            SystemCreate systemCreate = new SystemCreate(file, config);
        }
        catch (Exception ex) {
            System.out.println("ERROR STARTING ET SYSTEM");
            ex.printStackTrace();
        }
    }
}

