/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtContainer;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystemOpen;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.data.AllData;
import org.jlab.coda.et.data.AttachmentData;
import org.jlab.coda.et.data.ProcessData;
import org.jlab.coda.et.data.StationData;
import org.jlab.coda.et.enums.DataStatus;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.enums.Priority;
import org.jlab.coda.et.exception.EtBusyException;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtDeadException;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.exception.EtWakeUpException;

public class EtSystem {
    private EtSystemOpenConfig openConfig;
    private EtSystemOpen sys;
    private boolean open;
    private int debug;
    private Socket sock;
    private boolean isJava;
    private DataInputStream in;
    private DataOutputStream out;

    public EtSystem(EtSystemOpenConfig config, int debug) throws EtException {
        if (config == null) {
            throw new EtException("Invalid arg");
        }
        this.openConfig = new EtSystemOpenConfig(config);
        if (!this.openConfig.selfConsistent()) {
            throw new EtException("system open configuration is not self-consistent");
        }
        this.sys = new EtSystemOpen(this.openConfig);
        this.debug = debug != 0 && debug != 1 && debug != 2 && debug != 3 && debug != 4 ? 2 : debug;
        try {
            this.sys.setDebug(debug);
        }
        catch (EtException etException) {
            // empty catch block
        }
    }

    public EtSystem(EtSystemOpenConfig config) throws EtException {
        this(config, 2);
    }

    public EtSystem(EtSystemOpen sys, int debug) throws IOException, EtException, EtTooManyException {
        if (sys == null) {
            throw new EtException("Invalid arg");
        }
        this.sys = sys;
        this.openConfig = sys.getConfig();
        this.debug = debug != 0 && debug != 1 && debug != 2 && debug != 3 && debug != 4 ? 2 : debug;
        if (sys.isConnected()) {
            if (sys.getLanguage() == 2) {
                this.isJava = true;
            }
            this.sock = sys.getSocket();
            this.in = this.openConfig.getTcpRecvBufSize() > 0 ? new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.openConfig.getTcpRecvBufSize())) : new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.sock.getReceiveBufferSize()));
            this.out = this.openConfig.getTcpSendBufSize() > 0 ? new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.openConfig.getTcpSendBufSize())) : new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.sock.getSendBufferSize()));
            this.open = true;
        } else {
            this.open();
        }
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    public boolean usingJniLibrary() {
        return this.sys.usingJniLibrary();
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int val) throws EtException {
        if (val != 0 && val != 1 && val != 2 && val != 3 && val != 4) {
            throw new EtException("bad debug argument");
        }
        this.debug = val;
        try {
            this.sys.setDebug(this.debug);
        }
        catch (EtException etException) {
            // empty catch block
        }
    }

    public EtSystemOpenConfig getConfig() {
        return new EtSystemOpenConfig(this.openConfig);
    }

    public synchronized void open() throws IOException, EtException, EtTooManyException {
        if (this.open) {
            return;
        }
        try {
            this.sys.connect();
        }
        catch (EtTooManyException ex) {
            if (this.debug >= 2) {
                int count = 1;
                System.out.println("The following hosts responded:");
                for (Map.Entry<ArrayList<String>[], Integer> entry : this.sys.getResponders().entrySet()) {
                    System.out.println("  host #" + count++ + " at port " + entry.getValue());
                    ArrayList<String> addrList = entry.getKey()[0];
                    for (String s : addrList) {
                        System.out.println("    " + s);
                    }
                    System.out.println();
                }
            }
            throw ex;
        }
        if (this.sys.getLanguage() == 2) {
            this.isJava = true;
        }
        this.sock = this.sys.getSocket();
        this.in = this.openConfig.getTcpRecvBufSize() > 0 ? new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.openConfig.getTcpRecvBufSize())) : new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), this.sock.getReceiveBufferSize()));
        this.out = this.openConfig.getTcpSendBufSize() > 0 ? new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.openConfig.getTcpSendBufSize())) : new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), this.sock.getSendBufferSize()));
        this.open = true;
    }

    public synchronized void close() {
        if (!this.open) {
            return;
        }
        try {
            if (this.sys.usingJniLibrary()) {
                this.sys.getJni().close();
            }
            this.out.writeInt(42);
            this.out.flush();
        }
        catch (IOException ex) {
            if (this.debug >= 2) {
                System.out.println("network communication error");
            }
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.sys.disconnect();
            }
            catch (IOException iOException) {}
        }
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void kill() throws IOException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("ET system is closed");
        }
        try {
            if (this.sys.usingJniLibrary()) {
                EtSystem etSystem = this;
                synchronized (etSystem) {
                    if (!this.open) {
                        throw new EtClosedException("Not connected to ET system");
                    }
                }
                this.sys.getJni().killEtSystem(this.sys.getJni().getLocalEtId());
                this.sys.getJni().close();
            }
            this.out.writeInt(46);
            this.out.flush();
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.sys.disconnect();
            }
            catch (IOException iOException) {}
        }
        this.open = false;
    }

    public synchronized boolean alive() {
        int alive;
        if (!this.open) {
            return false;
        }
        try {
            this.out.writeInt(40);
            this.out.flush();
            alive = this.in.readInt();
        }
        catch (IOException ex) {
            if (this.debug >= 2) {
                System.out.println("network communication error");
            }
            return false;
        }
        return alive == 1;
    }

    public synchronized void wakeUpAttachment(EtAttachment att) throws IOException, EtException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(44);
        this.out.writeInt(att.getId());
        this.out.flush();
    }

    public synchronized void wakeUpAll(EtStation station) throws IOException, EtException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null || !station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(45);
        this.out.writeInt(station.getId());
        this.out.flush();
    }

    private void configCheck(EtStationConfig config) throws EtException {
        if (config == null) {
            throw new EtException("Invalid arg");
        }
        if (config.getSelectMode() == 3 && config.getSelectClass() == null) {
            throw new EtException("station config needs a select class name");
        }
        if (!(config.getSelectMode() != 4 && config.getSelectMode() != 5 || config.getFlowMode() != 0 && config.getBlockMode() != 0 && config.getRestoreMode() != 1 && config.getPrescale() == 1)) {
            throw new EtException("if flowMode = rrobin/equalcue, station must be parallel, blocking, prescale=1, & not restoreIn");
        }
        if (config.getRestoreMode() == 3 && config.getFlowMode() != 1) {
            throw new EtException("if restoreMode = restoreRedist, station must be parallel");
        }
        if (config.getCue() > this.sys.getNumEvents()) {
            config.setCue(this.sys.getNumEvents());
        }
    }

    public EtStation createStation(EtStationConfig config, String name) throws IOException, EtDeadException, EtClosedException, EtException, EtExistsException, EtTooManyException {
        return this.createStation(config, name, -1, -1);
    }

    public EtStation createStation(EtStationConfig config, String name, int position) throws IOException, EtDeadException, EtClosedException, EtException, EtExistsException, EtTooManyException {
        return this.createStation(config, name, position, -1);
    }

    public synchronized EtStation createStation(EtStationConfig config, String name, int position, int parallelPosition) throws IOException, EtDeadException, EtClosedException, EtException, EtExistsException, EtTooManyException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (name == null || config == null) {
            throw new EtException("Invalid arg");
        }
        if (name.equals("GRAND_CENTRAL")) {
            throw new EtException("Cannot create GRAND_CENTRAL station");
        }
        if (name.length() > 47) {
            throw new EtException("Station name too long (> 47 chars)");
        }
        if (position != -1 && position < 1) {
            throw new EtException("Bad value for position");
        }
        if (parallelPosition != -1 && parallelPosition != -2 && parallelPosition < 0) {
            throw new EtException("Bad value for parallel position");
        }
        this.configCheck(config);
        this.out.writeInt(62);
        this.out.writeInt(1);
        this.out.writeInt(config.getFlowMode());
        this.out.writeInt(config.getUserMode());
        this.out.writeInt(config.getRestoreMode());
        this.out.writeInt(config.getBlockMode());
        this.out.writeInt(config.getPrescale());
        this.out.writeInt(config.getCue());
        this.out.writeInt(config.getSelectMode());
        int[] select = config.getSelect();
        for (int i = 0; i < 6; ++i) {
            this.out.writeInt(select[i]);
        }
        int functionLength = 0;
        if (config.getSelectFunction() != null) {
            functionLength = config.getSelectFunction().length() + 1;
        }
        this.out.writeInt(functionLength);
        int libraryLength = 0;
        if (config.getSelectLibrary() != null) {
            libraryLength = config.getSelectLibrary().length() + 1;
        }
        this.out.writeInt(libraryLength);
        int classLength = 0;
        if (config.getSelectClass() != null) {
            classLength = config.getSelectClass().length() + 1;
        }
        this.out.writeInt(classLength);
        int nameLength = name.length() + 1;
        this.out.writeInt(nameLength);
        this.out.writeInt(position);
        this.out.writeInt(parallelPosition);
        try {
            if (functionLength > 0) {
                this.out.write(config.getSelectFunction().getBytes("ASCII"));
                this.out.writeByte(0);
            }
            if (libraryLength > 0) {
                this.out.write(config.getSelectLibrary().getBytes("ASCII"));
                this.out.writeByte(0);
            }
            if (classLength > 0) {
                this.out.write(config.getSelectClass().getBytes("ASCII"));
                this.out.writeByte(0);
            }
            this.out.write(name.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int err = this.in.readInt();
        int statId = this.in.readInt();
        if (err == -8) {
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            throw new EtClosedException("ET is closed");
        }
        if (err == -2) {
            throw new EtTooManyException("Maximum number of stations already created");
        }
        if (err == -3) {
            throw new EtExistsException("Station already exists with different definition");
        }
        if (err < 0) {
            throw new EtException("Trying to add incompatible parallel station, or\ntrying to add parallel station to head of existing parallel group, or\ncannot load select class");
        }
        EtStation station = new EtStation(name, statId, this);
        station.setUsable(true);
        if (this.debug >= 4) {
            System.out.println("Creating station " + name + " is done");
        }
        return station;
    }

    public synchronized void removeStation(EtStation station) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null) {
            throw new EtException("Invalid station");
        }
        if (station.getId() == 0) {
            throw new EtException("Cannot remove GRAND_CENTRAL station");
        }
        if (!station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(63);
        this.out.writeInt(station.getId());
        this.out.flush();
        int err = this.in.readInt();
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            throw new EtException("Either no such station exists or remove all attachments before removing station");
        }
        station.setUsable(false);
    }

    public synchronized void setStationPosition(EtStation station, int position, int parallelPosition) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null) {
            throw new EtException("Invalid station");
        }
        if (station.getId() == 0) {
            throw new EtException("Cannot move GRAND_CENTRAL station");
        }
        if (position != -1 && position < 0) {
            throw new EtException("bad value for position");
        }
        if (position == 0) {
            throw new EtException("GRAND_CENTRAL station is always first");
        }
        if (parallelPosition != -1 && parallelPosition != -2 && parallelPosition < 0) {
            throw new EtException("bad value for parallelPosition");
        }
        if (!station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(64);
        this.out.writeInt(station.getId());
        this.out.writeInt(position);
        this.out.writeInt(parallelPosition);
        this.out.flush();
        int err = this.in.readInt();
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            station.setUsable(false);
            throw new EtException("station does not exist");
        }
    }

    public synchronized int getStationPosition(EtStation station) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null || !station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        if (station.getId() == 0) {
            return 0;
        }
        this.out.writeInt(65);
        this.out.writeInt(station.getId());
        this.out.flush();
        int err = this.in.readInt();
        int position = this.in.readInt();
        this.in.skipBytes(4);
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            station.setUsable(false);
            throw new EtException("station does not exist");
        }
        return position;
    }

    public synchronized int getStationParallelPosition(EtStation station) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null || !station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        if (station.getId() == 0) {
            return 0;
        }
        this.out.writeInt(65);
        this.out.writeInt(station.getId());
        this.out.flush();
        int err = this.in.readInt();
        this.in.skipBytes(4);
        int pPosition = this.in.readInt();
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            station.setUsable(false);
            throw new EtException("station does not exist");
        }
        return pPosition;
    }

    public synchronized EtAttachment attach(EtStation station) throws IOException, EtDeadException, EtClosedException, EtException, EtTooManyException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null || !station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        String host = "unknown";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String ipAddr = this.sock.getLocalAddress().getHostAddress();
        this.out.writeInt(60);
        this.out.writeInt(station.getId());
        this.out.writeInt(-1);
        this.out.writeInt(host.length() + 1);
        this.out.writeInt(ipAddr.length() + 1);
        try {
            this.out.write(host.getBytes("ASCII"));
            this.out.writeByte(0);
            this.out.write(ipAddr.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int err = this.in.readInt();
        int attId = this.in.readInt();
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err == -2) {
            throw new EtTooManyException("no more attachments allowed to station or system");
        }
        if (err < 0) {
            station.setUsable(false);
            throw new EtException("station does not exist or not idle/active");
        }
        EtAttachment att = new EtAttachment(station, attId, this);
        att.setUsable(true);
        return att;
    }

    public synchronized void detach(EtAttachment att) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(61);
        this.out.writeInt(att.getId());
        this.out.flush();
        int err = this.in.readInt();
        att.setUsable(false);
        if (err == -8) {
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            throw new EtException("not attached to station");
        }
    }

    public synchronized boolean stationAttached(EtStation station, EtAttachment att) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (station == null || !station.isUsable() || station.getSys() != this) {
            throw new EtException("Invalid station");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(80);
        this.out.writeInt(station.getId());
        this.out.writeInt(att.getId());
        this.out.flush();
        int err = this.in.readInt();
        if (err == -8) {
            station.setUsable(false);
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            station.setUsable(false);
            throw new EtClosedException("ET is closed");
        }
        if (err < 0) {
            station.setUsable(false);
            throw new EtException("station does not exist");
        }
        return err == 1;
    }

    public synchronized boolean stationExists(String name) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (name == null) {
            throw new EtException("Invalid station name");
        }
        this.out.writeInt(81);
        this.out.writeInt(name.length() + 1);
        try {
            this.out.write(name.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int err = this.in.readInt();
        this.in.skipBytes(4);
        if (err == -8) {
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            throw new EtClosedException("ET is closed");
        }
        return err == 1;
    }

    public synchronized EtStation stationNameToObject(String name) throws IOException, EtDeadException, EtClosedException, EtException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (name == null) {
            throw new EtException("Invalid station name");
        }
        this.out.writeInt(81);
        this.out.writeInt(name.length() + 1);
        try {
            this.out.write(name.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int err = this.in.readInt();
        int statId = this.in.readInt();
        if (err == 1) {
            EtStation stat = new EtStation(name, statId, this);
            stat.setUsable(true);
            return stat;
        }
        if (err == -8) {
            throw new EtDeadException("ET is dead");
        }
        if (err == -18) {
            throw new EtClosedException("ET is closed");
        }
        return null;
    }

    public EtEvent[] newEvents(EtAttachment att, Mode mode, int microSec, int count, int size) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        return this.newEvents(att, mode, false, microSec, count, size, 1);
    }

    private EtEvent[] newEventsJNI(int attId, int mode, int sec, int nsec, int count, int size, int group) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        EtEvent[] events = this.sys.getJni().newEvents(this.sys.getJni().getLocalEtId(), attId, mode, sec, nsec, count, size, group);
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EtEvent[] newEvents(EtAttachment att, Mode mode, boolean noBuffer, int microSec, int count, int size, int group) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        long sizeLimit;
        EtEvent[] evs;
        int numEvents;
        int err;
        if (mode == null) {
            throw new EtException("Invalid mode");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        if (count == 0) {
            return new EtEvent[0];
        }
        if (count < 0) {
            throw new EtException("bad count argument");
        }
        if (microSec < 0 && mode == Mode.TIMED) {
            throw new EtException("bad microSec argument");
        }
        if (size < 1) {
            throw new EtException("bad size argument");
        }
        if (group < 1) {
            throw new EtException("group number must be > 0");
        }
        int sec = 0;
        int nsec = 0;
        if (microSec > 0) {
            sec = microSec / 1000000;
            nsec = (microSec - sec * 1000000) * 1000;
        }
        if (this.sys.usingJniLibrary()) {
            EtSystem etSystem = this;
            synchronized (etSystem) {
                if (!this.open) {
                    throw new EtClosedException("Not connected to ET system");
                }
                return this.newEventsJNI(att.getId(), mode.getValue(), sec, nsec, count, size, group);
            }
        }
        int iterations = 1;
        int newTimeInterval = 200000;
        Mode netMode = mode;
        if (mode == Mode.SLEEP) {
            netMode = Mode.TIMED;
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
        } else if (mode == Mode.TIMED && microSec > 1000000) {
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
            iterations = microSec / newTimeInterval;
            if (microSec % newTimeInterval > 0) {
                ++iterations;
            }
        }
        byte[] buffer = new byte[36];
        EtUtils.intToBytes(28, buffer, 0);
        EtUtils.intToBytes(att.getId(), buffer, 4);
        EtUtils.intToBytes(netMode.getValue(), buffer, 8);
        EtUtils.longToBytes(size, buffer, 12);
        EtUtils.intToBytes(count, buffer, 20);
        EtUtils.intToBytes(group, buffer, 24);
        EtUtils.intToBytes(sec, buffer, 28);
        EtUtils.intToBytes(nsec, buffer, 32);
        boolean wait = false;
        while (true) {
            if (wait) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            EtSystem etSystem = this;
            synchronized (etSystem) {
                if (!this.open) {
                    throw new EtClosedException("Not connected to ET system");
                }
                this.out.write(buffer);
                this.out.flush();
                while (true) {
                    try {
                        err = this.in.readInt();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    break;
                }
                if (err >= 0) break;
                if (this.debug >= 2 && err != -5) {
                    System.out.println("error in ET system (newEvents), err = " + err);
                }
                if (err == -1) {
                    throw new EtException("bad mode value or group # too high");
                }
                if (err == -7) {
                    throw new EtBusyException("input list is busy");
                }
                if (err == -6) {
                    throw new EtEmptyException("no events in list");
                }
                if (err == -4) {
                    throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                }
                if (err != -5) break;
                if (mode != Mode.SLEEP && iterations-- <= 0) {
                    throw new EtTimeoutException("no events within timeout");
                }
                wait = true;
            }
        }
        {
            numEvents = err;
            evs = new EtEventImpl[numEvents];
            buffer = new byte[4 * numEvents];
            this.in.readFully(buffer, 0, 4 * numEvents);
        }
        int index = -4;
        long l = sizeLimit = (long)size > this.sys.getEventSize() ? (long)size : this.sys.getEventSize();
        if (!this.isJava && this.sys.isBit64() && (long)numEvents * this.sys.getEventSize() > 0x3FFFFFFFL) {
            sizeLimit = size;
        }
        int j = 0;
        while (j < numEvents) {
            evs[j] = new EtEventImpl(size, (int)sizeLimit, this.isJava, noBuffer);
            ((EtEventImpl)evs[j]).setId(EtUtils.bytesToInt(buffer, index += 4));
            ((EtEventImpl)evs[j]).setModify(Modify.ANYTHING);
            ((EtEventImpl)evs[j]).setOwner(att.getId());
            ++j;
        }
        return evs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void newEvents(EtContainer container) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        long sizeLimit;
        EtEventImpl[] evs;
        int numEvents;
        if (container == null || container.method != EtContainer.MethodType.NEW) {
            throw new EtException("arg null or not setup for newEvents");
        }
        EtAttachment att = container.att;
        Mode mode = container.mode;
        int microSec = container.microSec;
        int count = container.count;
        int size = container.size;
        int group = container.group;
        if (count == 0) {
            container.eventCount = 0;
            return;
        }
        int sec = 0;
        int nsec = 0;
        if (microSec > 0) {
            sec = microSec / 1000000;
            nsec = (microSec - sec * 1000000) * 1000;
        }
        if (this.sys.usingJniLibrary()) {
            container.holdNewEvents(this.sys.getJni().newEvents(this.sys.getJni().getLocalEtId(), att.getId(), mode.getValue(), sec, nsec, count, size, group));
            return;
        }
        int iterations = 1;
        int newTimeInterval = 200000;
        Mode netMode = mode;
        if (mode == Mode.SLEEP) {
            netMode = Mode.TIMED;
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
        } else if (mode == Mode.TIMED && microSec > 1000000) {
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
            iterations = microSec / newTimeInterval;
            if (microSec % newTimeInterval > 0) {
                ++iterations;
            }
        }
        byte[] buffer = container.byteArray;
        EtUtils.intToBytes(28, buffer, 0);
        EtUtils.intToBytes(att.getId(), buffer, 4);
        EtUtils.intToBytes(netMode.getValue(), buffer, 8);
        EtUtils.longToBytes(size, buffer, 12);
        EtUtils.intToBytes(count, buffer, 20);
        EtUtils.intToBytes(group, buffer, 24);
        EtUtils.intToBytes(sec, buffer, 28);
        EtUtils.intToBytes(nsec, buffer, 32);
        try {
            int err;
            while (true) {
                EtSystem etSystem = this;
                synchronized (etSystem) {
                    this.out.write(buffer, 0, 36);
                    this.out.flush();
                    err = this.in.readInt();
                    if (err >= 0) break;
                    if (this.debug >= 2 && err != -5) {
                        System.out.println("error in ET system (newEvents), err = " + err);
                    }
                    if (err == -1) {
                        throw new EtException("bad mode value or group # too high");
                    }
                    if (err == -7) {
                        throw new EtBusyException("input list is busy");
                    }
                    if (err == -6) {
                        throw new EtEmptyException("no events in list");
                    }
                    if (err == -4) {
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    if (err != -5) break;
                    if (mode != Mode.SLEEP && iterations-- <= 0) {
                        throw new EtTimeoutException("no events within timeout");
                    }
                }
            }
            {
                numEvents = err;
                int numBytes = 4 * numEvents;
                evs = container.realEvents;
                container.adjustByteArraySize(numBytes);
                buffer = container.byteArray;
                this.in.readFully(buffer, 0, numBytes);
            }
        }
        catch (InterruptedIOException ex) {
            throw new EtException("thread interrupted while reading socket", ex);
        }
        int index = -4;
        long l = sizeLimit = (long)size > this.sys.getEventSize() ? (long)size : this.sys.getEventSize();
        if (!this.isJava && this.sys.isBit64() && (long)numEvents * this.sys.getEventSize() > 0x3FFFFFFFL) {
            sizeLimit = size;
        }
        int j = 0;
        while (true) {
            if (j >= numEvents) {
                container.holdNewEvents(evs, numEvents);
                return;
            }
            evs[j].setSizeLimit((int)sizeLimit);
            evs[j].setJava(this.isJava);
            evs[j].setId(EtUtils.bytesToInt(buffer, index += 4));
            evs[j].setModify(Modify.ANYTHING);
            evs[j].setOwner(att.getId());
            ++j;
        }
    }

    private EtEvent[] getEventsJNI(int attId, int mode, int sec, int nsec, int count) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        EtEvent[] events = this.sys.getJni().getEvents(this.sys.getJni().getLocalEtId(), attId, mode, sec, nsec, count);
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EtEvent[] getEvents(EtAttachment att, Mode mode, Modify modify, int microSec, int count) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        int err;
        if (att == null) throw new EtException("Invalid attachment");
        if (!att.isUsable()) throw new EtException("Invalid attachment");
        if (att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        if (modify == null) {
            modify = Modify.NOTHING;
        }
        if (att.getStation().getId() == 0) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (count == 0) {
            return new EtEvent[0];
        }
        if (count < 0) {
            throw new EtException("bad count argument");
        }
        if (mode == null) {
            throw new EtException("Invalid mode");
        }
        if (mode == Mode.TIMED && microSec < 0) {
            throw new EtException("bad microSec argument");
        }
        int sec = 0;
        int nsec = 0;
        if (microSec > 0) {
            sec = microSec / 1000000;
            nsec = (microSec - sec * 1000000) * 1000;
        }
        if (this.sys.usingJniLibrary()) {
            EtSystem etSystem = this;
            synchronized (etSystem) {
                if (this.open) return this.getEventsJNI(att.getId(), mode.getValue(), sec, nsec, count);
                throw new EtClosedException("Not connected to ET system");
            }
        }
        int iterations = 1;
        int newTimeInterval = 200000;
        Mode netMode = mode;
        if (mode == Mode.SLEEP) {
            netMode = Mode.TIMED;
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
        } else if (mode == Mode.TIMED && microSec > 1000000) {
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
            iterations = microSec / newTimeInterval;
            if (microSec % newTimeInterval > 0) {
                ++iterations;
            }
        }
        byte[] buffer = new byte[28];
        EtUtils.intToBytes(21, buffer, 0);
        EtUtils.intToBytes(att.getId(), buffer, 4);
        EtUtils.intToBytes(netMode.getValue(), buffer, 8);
        EtUtils.intToBytes(modify.getValue(), buffer, 12);
        EtUtils.intToBytes(count, buffer, 16);
        EtUtils.intToBytes(sec, buffer, 20);
        EtUtils.intToBytes(nsec, buffer, 24);
        boolean wait = false;
        while (true) {
            if (wait) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            EtSystem etSystem = this;
            synchronized (etSystem) {
                if (!this.open) {
                    throw new EtClosedException("Not connected to ET system");
                }
                this.out.write(buffer);
                this.out.flush();
                while (true) {
                    try {
                        err = this.in.readInt();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    break;
                }
                if (err >= 0) break;
                if (this.debug >= 2 && err != -5) {
                    System.out.println("error in ET system (getEvents), err = " + err);
                }
                if (err == -1) {
                    throw new EtException("bad mode value");
                }
                if (err == -7) {
                    throw new EtBusyException("input list is busy");
                }
                if (err == -6) {
                    throw new EtEmptyException("no events in list");
                }
                if (err == -4) {
                    throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                }
                if (err != -5) break;
                if (mode != Mode.SLEEP && iterations-- <= 0) {
                    if (this.debug < 2) throw new EtTimeoutException("no events within timeout");
                    throw new EtTimeoutException("no events within timeout");
                }
                wait = true;
            }
        }
        {
            this.in.skipBytes(8);
            int selectInts = 6;
            int dataShift = 4;
            int dataMask = 48;
            boolean priorityMask = true;
            int numEvents = err;
            EtEvent[] evs = new EtEventImpl[numEvents];
            int byteChunk = 60;
            buffer = new byte[byteChunk];
            int j = 0;
            while (j < numEvents) {
                this.in.readFully(buffer, 0, byteChunk);
                long length = EtUtils.bytesToLong(buffer, 0);
                long memSize = EtUtils.bytesToLong(buffer, 8);
                if (!this.isJava && this.sys.isBit64() && memSize > 0x3FFFFFFFL) {
                    memSize = length;
                }
                evs[j] = new EtEventImpl((int)memSize, (int)memSize, this.isJava, false);
                ((EtEventImpl)evs[j]).setLength((int)length);
                ((EtEventImpl)evs[j]).getDataBuffer().limit((int)length);
                int priAndStat = EtUtils.bytesToInt(buffer, 16);
                ((EtEventImpl)evs[j]).setPriority(Priority.getPriority(priAndStat & 1));
                ((EtEventImpl)evs[j]).setDataStatus(DataStatus.getStatus((priAndStat & 0x30) >> 4));
                ((EtEventImpl)evs[j]).setId(EtUtils.bytesToInt(buffer, 20));
                ((EtEventImpl)evs[j]).setRawByteOrder(EtUtils.bytesToInt(buffer, 28));
                int index = 32;
                int[] control = new int[6];
                for (int i = 0; i < 6; ++i) {
                    control[i] = EtUtils.bytesToInt(buffer, index += 4);
                }
                ((EtEventImpl)evs[j]).setControl(control);
                ((EtEventImpl)evs[j]).setModify(modify);
                ((EtEventImpl)evs[j]).setOwner(att.getId());
                this.in.readFully(((EtEventImpl)evs[j]).getData(), 0, (int)length);
                ++j;
            }
            return evs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getEvents(EtContainer container) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        if (container == null) throw new EtException("arg null or not setup for getEvents");
        if (container.method != EtContainer.MethodType.GET) {
            throw new EtException("arg null or not setup for getEvents");
        }
        EtAttachment att = container.att;
        Mode mode = container.mode;
        Modify modify = container.modify;
        int microSec = container.microSec;
        int count = container.count;
        if (count == 0) {
            container.eventCount = 0;
            return;
        }
        int sec = 0;
        int nsec = 0;
        if (microSec > 0) {
            sec = microSec / 1000000;
            nsec = (microSec - sec * 1000000) * 1000;
        }
        if (this.sys.usingJniLibrary()) {
            container.holdNewEvents(this.sys.getJni().getEvents(this.sys.getJni().getLocalEtId(), att.getId(), mode.getValue(), sec, nsec, count));
            return;
        }
        int iterations = 1;
        int newTimeInterval = 200000;
        Mode netMode = mode;
        if (mode == Mode.SLEEP) {
            netMode = Mode.TIMED;
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
        } else if (mode == Mode.TIMED && microSec > 1000000) {
            sec = newTimeInterval / 1000000;
            nsec = (newTimeInterval - sec * 1000000) * 1000;
            iterations = microSec / newTimeInterval;
            if (microSec % newTimeInterval > 0) {
                ++iterations;
            }
        }
        byte[] buffer = container.byteArray;
        EtUtils.intToBytes(21, buffer, 0);
        EtUtils.intToBytes(att.getId(), buffer, 4);
        EtUtils.intToBytes(netMode.getValue(), buffer, 8);
        EtUtils.intToBytes(modify.getValue(), buffer, 12);
        EtUtils.intToBytes(count, buffer, 16);
        EtUtils.intToBytes(sec, buffer, 20);
        EtUtils.intToBytes(nsec, buffer, 24);
        try {
            int err;
            boolean wait = false;
            while (true) {
                if (wait) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                EtSystem etSystem = this;
                synchronized (etSystem) {
                    this.out.write(buffer, 0, 28);
                    this.out.flush();
                    err = this.in.readInt();
                    if (err >= 0) break;
                    if (this.debug >= 2 && err != -5) {
                        System.out.println("error in ET system (getEvents), err = " + err);
                    }
                    if (err == -1) {
                        throw new EtException("bad mode value");
                    }
                    if (err == -7) {
                        throw new EtBusyException("input list is busy");
                    }
                    if (err == -6) {
                        throw new EtEmptyException("no events in list");
                    }
                    if (err == -4) {
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    if (err != -5) break;
                    if (mode != Mode.SLEEP && iterations-- <= 0) {
                        if (this.debug < 2) throw new EtTimeoutException("no events within timeout");
                        throw new EtTimeoutException("no events within timeout");
                    }
                    wait = true;
                }
            }
            {
                this.in.readLong();
                int selectInts = 6;
                int dataShift = 4;
                int dataMask = 48;
                boolean priorityMask = true;
                int numEvents = err;
                EtEventImpl[] evs = container.realEvents;
                int byteChunk = 60;
                int j = 0;
                while (true) {
                    if (j >= numEvents) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 7, 11] lbl86 : MonitorExitStatement: MONITOREXIT : var17_16
                        container.holdNewEvents(evs, numEvents);
                        return;
                    }
                    this.in.readFully(buffer, 0, byteChunk);
                    long length = EtUtils.bytesToLong(buffer, 0);
                    long memSize = EtUtils.bytesToLong(buffer, 8);
                    if (!this.isJava && this.sys.isBit64() && memSize > 0x3FFFFFFFL) {
                        memSize = length;
                    }
                    if (memSize > (long)evs[j].getMemSize()) {
                        evs[j] = container.realEvents[j] = new EtEventImpl((int)memSize);
                    }
                    evs[j].setJava(this.isJava);
                    evs[j].setLength((int)length);
                    evs[j].getDataBuffer().limit((int)length);
                    int priAndStat = EtUtils.bytesToInt(buffer, 16);
                    evs[j].setPriority(Priority.getPriority(priAndStat & 1));
                    evs[j].setDataStatus(DataStatus.getStatus((priAndStat & 0x30) >> 4));
                    evs[j].setId(EtUtils.bytesToInt(buffer, 20));
                    evs[j].setRawByteOrder(EtUtils.bytesToInt(buffer, 28));
                    int index = 32;
                    int[] control = evs[j].getControlNoCopy();
                    for (int i = 0; i < 6; ++i) {
                        control[i] = EtUtils.bytesToInt(buffer, index += 4);
                    }
                    evs[j].setModify(modify);
                    evs[j].setOwner(att.getId());
                    this.in.readFully(evs[j].getData(), 0, (int)length);
                    ++j;
                }
            }
        }
        catch (InterruptedIOException ex) {
            throw new EtException("thread interrupted while reading socket", ex);
        }
    }

    public void putEvents(EtAttachment att, List<EtEvent> eventList) throws IOException, EtException, EtDeadException, EtClosedException {
        if (eventList == null) {
            throw new EtException("Invalid event list arg");
        }
        this.putEvents(att, eventList.toArray(new EtEvent[eventList.size()]));
    }

    public void putEvents(EtAttachment att, EtEvent[] evs) throws IOException, EtException, EtDeadException, EtClosedException {
        if (evs == null) {
            throw new EtException("Invalid event array arg");
        }
        this.putEvents(att, evs, 0, evs.length);
    }

    private void putEventsJNI(int attId, EtEvent[] evs, int offset, int length) throws EtException, EtDeadException, EtClosedException {
        EtEventImpl[] events = new EtEventImpl[length];
        for (int i = 0; i < length; ++i) {
            events[i] = (EtEventImpl)evs[offset + i];
        }
        this.sys.getJni().putEvents(this.sys.getJni().getLocalEtId(), attId, events, length);
    }

    public synchronized void putEvents(EtAttachment att, EtEvent[] evs, int offset, int length) throws IOException, EtException, EtDeadException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (evs == null) {
            throw new EtException("Invalid event array arg");
        }
        if (offset < 0 || length < 0 || offset + length > evs.length) {
            throw new EtException("Bad offset or length argument(s)");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        int selectInts = 6;
        int dataShift = 4;
        int bytes = 0;
        int numEvents = 0;
        int headerSize = 52;
        for (int i = offset; i < offset + length; ++i) {
            if (evs[i].getOwner() != att.getId()) {
                throw new EtException("may not put event(s), not owner");
            }
            if (evs[i].getModify() == Modify.NOTHING) continue;
            ++numEvents;
            bytes += headerSize;
            if (evs[i].getModify() != Modify.ANYTHING) continue;
            bytes += evs[i].getLength();
        }
        if (this.sys.usingJniLibrary()) {
            this.putEventsJNI(att.getId(), evs, offset, length);
            return;
        }
        if (numEvents == 0) {
            return;
        }
        byte[] header = new byte[headerSize];
        this.out.writeInt(23);
        this.out.writeInt(att.getId());
        this.out.writeInt(numEvents);
        this.out.writeLong(bytes);
        for (int i = offset; i < offset + length; ++i) {
            if (evs[i].getModify() == Modify.NOTHING) continue;
            EtUtils.intToBytes(evs[i].getId(), ByteOrder.BIG_ENDIAN, header, 0);
            EtUtils.longToBytes(evs[i].getLength(), ByteOrder.BIG_ENDIAN, header, 8);
            EtUtils.intToBytes(evs[i].getPriority().getValue() | evs[i].getDataStatus().getValue() << 4, ByteOrder.BIG_ENDIAN, header, 16);
            EtUtils.intToBytes(evs[i].getRawByteOrder(), ByteOrder.BIG_ENDIAN, header, 20);
            int indx = 28;
            int[] control = evs[i].getControlNoCopy();
            int j = 0;
            while (j < 6) {
                EtUtils.intToBytes(control[j], ByteOrder.BIG_ENDIAN, header, indx);
                ++j;
                indx += 4;
            }
            this.out.write(header);
            if (evs[i].getModify() != Modify.ANYTHING) continue;
            ByteBuffer buf = evs[i].getDataBuffer();
            if (buf == null) {
                throw new EtException("null data buffer");
            }
            if (!buf.hasArray()) {
                for (int j2 = 0; j2 < evs[i].getLength(); ++j2) {
                    this.out.write(buf.get(j2));
                }
                continue;
            }
            this.out.write(buf.array(), 0, evs[i].getLength());
        }
        this.out.flush();
        this.in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEvents(EtContainer container) throws IOException, EtException, EtDeadException, EtClosedException {
        if (container == null || container.method != EtContainer.MethodType.PUT) {
            throw new EtException("arg null or not setup for putEvents");
        }
        int offset = container.offset;
        int length = container.length;
        EtAttachment att = container.att;
        EtEventImpl[] evs = container.putDumpEvents;
        int selectInts = 6;
        int dataShift = 4;
        int bytes = 0;
        int numEvents = 0;
        int headerSize = 52;
        for (int i = offset; i < offset + length; ++i) {
            if (evs[i].getOwner() != att.getId()) {
                throw new EtException("may not put event(s), not owner on event " + i);
            }
            if (evs[i].getModify() == Modify.NOTHING) continue;
            ++numEvents;
            bytes += headerSize;
            if (evs[i].getModify() != Modify.ANYTHING) continue;
            bytes += evs[i].getLength();
        }
        if (this.sys.usingJniLibrary()) {
            if (offset == 0) {
                this.sys.getJni().putEvents(this.sys.getJni().getLocalEtId(), att.getId(), evs, length);
                return;
            }
            EtEventImpl[] events = container.holdEvents;
            for (int i = 0; i < length; ++i) {
                events[i] = evs[offset + i];
            }
            this.sys.getJni().putEvents(this.sys.getJni().getLocalEtId(), att.getId(), events, length);
            return;
        }
        if (numEvents == 0) {
            return;
        }
        container.adjustByteArraySize(headerSize);
        byte[] header = container.byteArray;
        EtSystem etSystem = this;
        synchronized (etSystem) {
            this.out.writeInt(23);
            this.out.writeInt(att.getId());
            this.out.writeInt(numEvents);
            this.out.writeLong(bytes);
            for (int i = offset; i < offset + length; ++i) {
                if (evs[i].getModify() == Modify.NOTHING) continue;
                EtUtils.intToBytes(evs[i].getId(), ByteOrder.BIG_ENDIAN, header, 0);
                EtUtils.longToBytes(evs[i].getLength(), ByteOrder.BIG_ENDIAN, header, 8);
                EtUtils.intToBytes(evs[i].getPriority().getValue() | evs[i].getDataStatus().getValue() << 4, ByteOrder.BIG_ENDIAN, header, 16);
                EtUtils.intToBytes(evs[i].getRawByteOrder(), ByteOrder.BIG_ENDIAN, header, 20);
                int indx = 28;
                int[] control = evs[i].getControlNoCopy();
                int j = 0;
                while (j < 6) {
                    EtUtils.intToBytes(control[j], ByteOrder.BIG_ENDIAN, header, indx);
                    ++j;
                    indx += 4;
                }
                this.out.write(header, 0, headerSize);
                if (evs[i].getModify() != Modify.ANYTHING) continue;
                ByteBuffer buf = evs[i].getDataBuffer();
                if (buf == null) {
                    throw new EtException("null data buffer");
                }
                if (!buf.hasArray()) {
                    for (int j2 = 0; j2 < evs[i].getLength(); ++j2) {
                        this.out.write(buf.get(j2));
                    }
                    continue;
                }
                this.out.write(buf.array(), 0, evs[i].getLength());
            }
            this.out.flush();
            this.in.readInt();
        }
    }

    private void dumpEventsJNI(int attId, EtEvent[] evs, int offset, int length) throws EtException, EtDeadException, EtClosedException {
        EtEventImpl[] events = new EtEventImpl[length];
        for (int i = 0; i < length; ++i) {
            events[i] = (EtEventImpl)evs[offset + i];
        }
        this.sys.getJni().dumpEvents(this.sys.getJni().getLocalEtId(), attId, events, length);
    }

    public void dumpEvents(EtAttachment att, EtEvent[] evs) throws IOException, EtException, EtDeadException, EtClosedException {
        if (evs == null) {
            throw new EtException("Invalid event array arg");
        }
        this.dumpEvents(att, evs, 0, evs.length);
    }

    public void dumpEvents(EtAttachment att, List<EtEvent> eventList) throws IOException, EtException, EtDeadException, EtClosedException {
        if (eventList == null) {
            throw new EtException("Invalid event list arg");
        }
        this.dumpEvents(att, eventList.toArray(new EtEvent[eventList.size()]));
    }

    public synchronized void dumpEvents(EtAttachment att, EtEvent[] evs, int offset, int length) throws IOException, EtException, EtDeadException, EtClosedException {
        int i;
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        if (att == null || !att.isUsable() || att.getSys() != this) {
            throw new EtException("Invalid attachment");
        }
        if (evs == null) {
            throw new EtException("Invalid event array arg");
        }
        if (offset < 0 || length < 0 || offset + length > evs.length) {
            throw new EtException("Bad offset or length argument(s)");
        }
        int numEvents = 0;
        for (i = offset; i < offset + length; ++i) {
            if (evs[i].getOwner() != att.getId()) {
                throw new EtException("may not put event(s), not owner");
            }
            if (evs[i].getModify() == Modify.NOTHING) continue;
            ++numEvents;
        }
        if (this.sys.usingJniLibrary()) {
            this.dumpEventsJNI(att.getId(), evs, offset, length);
            return;
        }
        if (numEvents == 0) {
            return;
        }
        this.out.writeInt(27);
        this.out.writeInt(att.getId());
        this.out.writeInt(numEvents);
        for (i = offset; i < offset + length; ++i) {
            if (evs[i].getModify() == Modify.NOTHING) continue;
            this.out.writeInt(evs[i].getId());
        }
        this.out.flush();
        this.in.skipBytes(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEvents(EtContainer container) throws IOException, EtException, EtDeadException, EtClosedException {
        if (container == null || container.method != EtContainer.MethodType.DUMP) {
            throw new EtException("arg null or not setup for dumpEvents");
        }
        int offset = container.offset;
        int length = container.length;
        EtAttachment att = container.att;
        EtEventImpl[] evs = container.putDumpEvents;
        int numEvents = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (evs[i].getOwner() != att.getId()) {
                throw new EtException("may not put event(s), not owner");
            }
            if (evs[i].getModify() == Modify.NOTHING) continue;
            ++numEvents;
        }
        if (this.sys.usingJniLibrary()) {
            if (offset == 0) {
                this.sys.getJni().dumpEvents(this.sys.getJni().getLocalEtId(), att.getId(), evs, length);
                return;
            }
            EtEventImpl[] events = container.holdEvents;
            for (int i = 0; i < length; ++i) {
                events[i] = evs[offset + i];
            }
            this.sys.getJni().dumpEvents(this.sys.getJni().getLocalEtId(), att.getId(), events, length);
            return;
        }
        if (numEvents == 0) {
            return;
        }
        EtSystem etSystem = this;
        synchronized (etSystem) {
            this.out.writeInt(27);
            this.out.writeInt(att.getId());
            this.out.writeInt(numEvents);
            for (int i = offset; i < offset + length; ++i) {
                if (evs[i].getModify() == Modify.NOTHING) continue;
                this.out.writeInt(evs[i].getId());
            }
            this.out.flush();
            this.in.readInt();
        }
    }

    private synchronized int getIntValue(int cmd) throws IOException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        this.out.writeInt(cmd);
        this.out.flush();
        this.in.skipBytes(4);
        return this.in.readInt();
    }

    public int getNumStations() throws IOException, EtClosedException {
        return this.getIntValue(152);
    }

    public int getStationsMax() throws IOException, EtClosedException {
        return this.getIntValue(153);
    }

    public int getNumAttachments() throws IOException, EtClosedException {
        return this.getIntValue(156);
    }

    public int getAttachmentsMax() throws IOException, EtClosedException {
        return this.getIntValue(157);
    }

    public int getNumProcesses() throws IOException, EtClosedException {
        return this.getIntValue(154);
    }

    public int getProcessesMax() throws IOException, EtClosedException {
        return this.getIntValue(155);
    }

    public int getNumTemps() throws IOException, EtClosedException {
        return this.getIntValue(150);
    }

    public int getTempsMax() throws IOException, EtClosedException {
        return this.getIntValue(151);
    }

    public int getHeartbeat() throws IOException, EtClosedException {
        return this.getIntValue(158);
    }

    public int getPid() throws IOException, EtClosedException {
        return this.getIntValue(159);
    }

    public int getGroupCount() throws IOException, EtClosedException {
        return this.getIntValue(160);
    }

    public int[] getGroups() throws IOException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        this.out.writeInt(172);
        this.out.flush();
        int groupSize = this.in.readInt();
        int[] groups = new int[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            groups[i] = this.in.readInt();
        }
        return groups;
    }

    public int getNumEvents() {
        return this.sys.getNumEvents();
    }

    public long getEventSize() {
        return this.sys.getEventSize();
    }

    public int getLanguage() {
        return this.sys.getLanguage();
    }

    public String getLocalAddress() {
        return this.sys.getLocalAddress();
    }

    public String getHost() {
        return this.sys.getHostAddress();
    }

    public int getTcpPort() {
        return this.sys.getTcpPort();
    }

    public synchronized AllData getData() throws EtException, IOException, EtClosedException {
        int i;
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        AllData data = new AllData();
        this.out.writeInt(170);
        this.out.flush();
        int error = this.in.readInt();
        if (error != 0) {
            throw new EtException("error getting ET system data");
        }
        this.in.skipBytes(4);
        data.sysData.read(this.in);
        int count = this.in.readInt();
        data.statData = new StationData[count];
        for (i = 0; i < count; ++i) {
            data.statData[i] = new StationData();
            data.statData[i].read(this.in);
        }
        count = this.in.readInt();
        data.attData = new AttachmentData[count];
        for (i = 0; i < count; ++i) {
            data.attData[i] = new AttachmentData();
            data.attData[i].read(this.in);
        }
        count = this.in.readInt();
        data.procData = new ProcessData[count];
        for (i = 0; i < count; ++i) {
            data.procData[i] = new ProcessData();
            data.procData[i].read(this.in);
        }
        return data;
    }

    public synchronized int[] getHistogram() throws IOException, EtException, EtClosedException {
        if (!this.open) {
            throw new EtClosedException("Not connected to ET system");
        }
        this.out.writeInt(171);
        this.out.flush();
        if (this.in.readInt() != 0) {
            throw new EtException("cannot get histogram");
        }
        byte[] data = new byte[4 * (this.sys.getNumEvents() + 1)];
        int[] hist = new int[this.sys.getNumEvents() + 1];
        this.in.readFully(data);
        for (int i = 0; i < this.sys.getNumEvents() + 1; ++i) {
            hist[i] = EtUtils.bytesToInt(data, i * 4);
        }
        return hist;
    }
}

