/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.util.List;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.system.AttachmentLocal;

public class EtContainer {
    MethodType method = MethodType.NEW;
    private int etEventSize;
    private int bufSize;
    int eventCount;
    private int eventArraySize;
    private EtEventImpl[] jniEvents;
    EtEventImpl[] realEvents;
    EtEventImpl[] putDumpEvents;
    EtEventImpl[] holdEvents;
    int offset;
    int length;
    private boolean hasEndEvent;
    private int lastIndex = -1;
    EtAttachment att;
    AttachmentLocal attLocal;
    byte[] byteArray = new byte[1000];
    Modify modify;
    Mode mode;
    int microSec;
    int count;
    int size;
    int group;

    public EtContainer(int eventSize) throws EtException {
        if (eventSize < 1) {
            throw new EtException("eventSize must be > 0");
        }
        this.etEventSize = eventSize;
    }

    public EtContainer(int count, int eventSize) throws EtException {
        if (count < 1 || eventSize < 1) {
            throw new EtException("args must be > 0");
        }
        this.bufSize = this.etEventSize = eventSize;
        this.eventArraySize = count;
        this.holdEvents = new EtEventImpl[this.eventArraySize];
        this.realEvents = new EtEventImpl[this.eventArraySize];
        for (int i = 0; i < this.eventArraySize; ++i) {
            this.realEvents[i] = new EtEventImpl(this.bufSize);
        }
    }

    public int getEtEventSize() {
        return this.etEventSize;
    }

    public EtAttachment getAtt() {
        return this.att;
    }

    public AttachmentLocal getAttLocal() {
        return this.attLocal;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    public int getGroup() {
        return this.group;
    }

    public int getMicroSec() {
        return this.microSec;
    }

    public EtEventImpl[] getHoldEvents() {
        return this.holdEvents;
    }

    public MethodType getMethod() {
        return this.method;
    }

    private void adjustEventArraySize(int count, int size, boolean allocate) {
        block5: {
            block6: {
                block4: {
                    if (this.realEvents != null && this.eventArraySize >= count) break block4;
                    this.bufSize = this.bufSize < size ? size : this.bufSize;
                    this.bufSize = this.bufSize < this.etEventSize ? this.etEventSize : this.bufSize;
                    this.eventArraySize = count;
                    this.holdEvents = new EtEventImpl[this.eventArraySize];
                    this.realEvents = new EtEventImpl[this.eventArraySize];
                    for (int i = 0; i < this.eventArraySize; ++i) {
                        this.realEvents[i] = new EtEventImpl(this.bufSize);
                    }
                    break block5;
                }
                if (this.bufSize >= size) break block6;
                this.bufSize = size;
                for (int i = 0; i < this.eventArraySize; ++i) {
                    this.realEvents[i] = new EtEventImpl(this.bufSize);
                }
                break block5;
            }
            if (!allocate) break block5;
            if (this.bufSize < size) {
                this.bufSize = size;
            }
            for (int i = 0; i < this.eventArraySize; ++i) {
                this.realEvents[i] = new EtEventImpl(this.bufSize);
            }
        }
    }

    public void newEvents(EtAttachment att, Mode mode, int microSec, int count, int size, int group) throws EtException {
        this.newEvents(att, mode, microSec, count, size, group, false);
    }

    public void newEvents(EtAttachment att, Mode mode, int microSec, int count, int size, int group, boolean allocate) throws EtException {
        if (mode == null) {
            throw new EtException("mode arg null");
        }
        if (att == null || !att.isUsable()) {
            throw new EtException("Invalid attachment");
        }
        if (count < 0) {
            throw new EtException("count arg negative");
        }
        if (microSec < 0 && mode == Mode.TIMED) {
            throw new EtException("microSec arg negative");
        }
        if (size < 1) {
            throw new EtException("size arg < 1");
        }
        if (group < 1) {
            throw new EtException("group arg < 1");
        }
        this.att = att;
        this.mode = mode;
        this.microSec = microSec;
        this.count = count;
        this.size = size;
        this.group = group;
        this.method = MethodType.NEW;
        this.jniEvents = null;
        this.lastIndex = -1;
        this.hasEndEvent = false;
        this.adjustEventArraySize(count, size, allocate);
        for (int i = 0; i < this.eventArraySize; ++i) {
            this.realEvents[i].init();
        }
    }

    public void newEvents(AttachmentLocal att, int modeVal, int microSec, int count, int size, int group) throws EtException {
        Mode mode = Mode.getMode(modeVal);
        if (mode == null) {
            throw new EtException("modeVal arg invalid");
        }
        if (att == null) {
            throw new EtException("Invalid attachment");
        }
        if (count < 0) {
            throw new EtException("count arg negative");
        }
        if (microSec < 0 && mode == Mode.TIMED) {
            throw new EtException("microSec arg negative");
        }
        if (size < 1) {
            throw new EtException("size arg < 1");
        }
        if (group < 1) {
            throw new EtException("group arg < 1");
        }
        this.attLocal = att;
        this.mode = mode;
        this.microSec = microSec;
        this.count = count;
        this.size = size;
        this.group = group;
        this.method = MethodType.NEW_LOCAL;
        this.jniEvents = null;
        this.lastIndex = -1;
        this.hasEndEvent = false;
    }

    public void getEvents(EtAttachment att, Mode mode, Modify modify, int microSec, int count) throws EtException {
        this.getEvents(att, mode, modify, microSec, count, false);
    }

    public void getEvents(EtAttachment att, Mode mode, Modify modify, int microSec, int count, boolean allocate) throws EtException {
        if (att == null || !att.isUsable()) {
            throw new EtException("Invalid attachment");
        }
        if (att.getStation().getId() == 0) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (count < 0) {
            throw new EtException("count arg negative");
        }
        if (mode == null) {
            throw new EtException("mode arg null");
        }
        if (mode == Mode.TIMED && microSec < 0) {
            throw new EtException("microSec arg negative");
        }
        this.att = att;
        this.mode = mode;
        this.modify = modify == null ? Modify.NOTHING : modify;
        this.microSec = microSec;
        this.count = count;
        this.method = MethodType.GET;
        this.jniEvents = null;
        this.lastIndex = -1;
        this.hasEndEvent = false;
        this.adjustEventArraySize(count, 0, allocate);
    }

    public void getEvents(AttachmentLocal att, int modeVal, int microSec, int count) throws EtException {
        Mode mode = Mode.getMode(modeVal);
        if (att == null) {
            throw new EtException("Invalid attachment");
        }
        if (att.getStation().getId() == 0L) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (count < 0) {
            throw new EtException("count arg negative");
        }
        if (mode == null) {
            throw new EtException("modeVal arg invalid");
        }
        if (mode == Mode.TIMED && microSec < 0) {
            throw new EtException("microSec arg negative");
        }
        this.attLocal = att;
        this.mode = mode;
        this.microSec = microSec;
        this.count = count;
        this.method = MethodType.GET_LOCAL;
        this.jniEvents = null;
        this.lastIndex = -1;
        this.hasEndEvent = false;
    }

    public void putEvents(EtAttachment att, int offset, int length) throws EtException {
        this.putDumpEvents = this.jniEvents != null ? this.jniEvents : this.realEvents;
        if (offset < 0 || length < 0 || offset + length > this.putDumpEvents.length) {
            throw new EtException("Bad offset or length argument(s)");
        }
        if (att == null || !att.isUsable()) {
            throw new EtException("Invalid attachment");
        }
        this.att = att;
        this.offset = offset;
        this.length = length;
        this.method = MethodType.PUT;
        if (offset > 0 && this.jniEvents != null && this.holdEvents.length < length) {
            this.holdEvents = new EtEventImpl[length];
        }
    }

    public void putEvents(AttachmentLocal att) throws EtException {
        if (att == null) {
            throw new EtException("Invalid attachment");
        }
        this.attLocal = att;
        this.method = MethodType.PUT_LOCAL;
    }

    public void dumpEvents(EtAttachment att, int offset, int length) throws EtException {
        this.putDumpEvents = this.jniEvents != null ? this.jniEvents : this.realEvents;
        if (offset < 0 || length < 0 || offset + length > this.putDumpEvents.length) {
            throw new EtException("Bad offset or length argument(s)");
        }
        if (att == null || !att.isUsable()) {
            throw new EtException("Invalid attachment");
        }
        this.att = att;
        this.offset = offset;
        this.length = length;
        this.method = MethodType.DUMP;
        if (offset > 0 && this.jniEvents != null && this.holdEvents.length < length) {
            this.holdEvents = new EtEventImpl[length];
        }
    }

    public void dumpEvents(AttachmentLocal att) throws EtException {
        if (att == null) {
            throw new EtException("Invalid attachment");
        }
        this.attLocal = att;
        this.method = MethodType.DUMP_LOCAL;
    }

    void holdNewEvents(EtEventImpl[] evs) {
        this.holdNewEvents(evs, evs.length);
    }

    void holdNewEvents(EtEventImpl[] evs, int len) {
        this.eventCount = len;
        if (evs != this.realEvents) {
            this.jniEvents = evs;
        }
    }

    public void holdLocalEvents(List<EtEventImpl> list) {
        this.eventCount = list.size();
        if (this.holdEvents == null || this.holdEvents.length != this.eventCount) {
            this.holdEvents = new EtEventImpl[this.eventCount];
        }
        for (int i = 0; i < this.eventCount; ++i) {
            this.holdEvents[i] = list.get(i);
        }
    }

    public void holdLocalEvents(EtEventImpl[] evs) {
        this.eventCount = evs.length;
        this.holdEvents = evs;
    }

    public EtEvent[] getEventArray() {
        if (this.method == MethodType.NEW || this.method == MethodType.GET) {
            if (this.jniEvents != null) {
                return this.jniEvents;
            }
            return this.realEvents;
        }
        return null;
    }

    public EtEventImpl[] getEventArrayLocal() {
        if (this.method == MethodType.NEW_LOCAL || this.method == MethodType.GET_LOCAL) {
            return this.holdEvents;
        }
        return null;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    void adjustByteArraySize(int neededBytes) {
        if (this.byteArray.length < neededBytes) {
            this.byteArray = new byte[neededBytes];
        }
    }

    private void clear() {
        if (this.realEvents != null) {
            for (EtEventImpl ev : this.realEvents) {
                ev.init();
            }
        }
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int index) {
        this.lastIndex = index;
    }

    public boolean hasEndEvent() {
        return this.hasEndEvent;
    }

    public void setHasEndEvent(boolean index) {
        this.hasEndEvent = index;
    }

    public static enum MethodType {
        NEW,
        NEW_LOCAL,
        GET,
        GET_LOCAL,
        PUT,
        PUT_LOCAL,
        DUMP,
        DUMP_LOCAL;

    }
}

