/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.data;

import java.io.DataInputStream;
import java.io.IOException;
import org.jlab.coda.et.EtUtils;

public class AttachmentData {
    private int num;
    private int proc;
    private int stat;
    private int pid;
    private int blocked;
    private int quit;
    private int eventsOwned;
    private long eventsPut;
    private long eventsGet;
    private long eventsDump;
    private long eventsMake;
    private String host;
    private String stationName;
    private String ipAddress;

    public int getId() {
        return this.num;
    }

    public int getProc() {
        return this.proc;
    }

    public int getStationId() {
        return this.stat;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean blocked() {
        return this.blocked == 1;
    }

    public boolean quitting() {
        return this.quit == 1;
    }

    public int getEventsOwned() {
        return this.eventsOwned;
    }

    public long getEventsPut() {
        return this.eventsPut;
    }

    public long getEventsGet() {
        return this.eventsGet;
    }

    public long getEventsDump() {
        return this.eventsDump;
    }

    public long getEventsMake() {
        return this.eventsMake;
    }

    public String getHost() {
        return this.host;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void read(DataInputStream dis) throws IOException {
        byte[] info = new byte[72];
        dis.readFully(info);
        this.num = EtUtils.bytesToInt(info, 0);
        this.proc = EtUtils.bytesToInt(info, 4);
        this.stat = EtUtils.bytesToInt(info, 8);
        this.pid = EtUtils.bytesToInt(info, 12);
        this.blocked = EtUtils.bytesToInt(info, 16);
        this.quit = EtUtils.bytesToInt(info, 20);
        this.eventsOwned = EtUtils.bytesToInt(info, 24);
        this.eventsPut = EtUtils.bytesToLong(info, 28);
        this.eventsGet = EtUtils.bytesToLong(info, 36);
        this.eventsDump = EtUtils.bytesToLong(info, 44);
        this.eventsMake = EtUtils.bytesToLong(info, 52);
        int length1 = EtUtils.bytesToInt(info, 60);
        int length2 = EtUtils.bytesToInt(info, 64);
        int length3 = EtUtils.bytesToInt(info, 68);
        if (length1 + length2 + length3 > 72) {
            info = new byte[length1 + length2 + length3];
        }
        dis.readFully(info, 0, length1 + length2 + length3);
        this.host = new String(info, 0, length1 - 1, "US-ASCII");
        this.stationName = new String(info, length1, length2 - 1, "US-ASCII");
        this.ipAddress = new String(info, length1 + length2, length3 - 1, "US-ASCII");
    }
}

