/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.exception.EtException;

public class EtStation {
    private int id;
    private String name;
    private EtSystem sys;
    private boolean usable;

    EtStation(String name, int id, EtSystem sys) {
        this.id = id;
        this.sys = sys;
        this.name = name;
    }

    void setUsable(boolean usable) {
        this.usable = usable;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public EtSystem getSys() {
        return this.sys;
    }

    public boolean isUsable() {
        return this.usable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSelectWords() throws IOException, EtException {
        int err;
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        int[] select = new int[6];
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(83);
            this.sys.getOutputStream().writeInt(this.id);
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
            for (int i = 0; i < select.length; ++i) {
                select[i] = this.sys.getInputStream().readInt();
            }
        }
        if (err != 0) {
            throw new EtException("cannot find station");
        }
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectWords(int[] select) throws IOException, EtException {
        int err;
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (select.length != 6) {
            throw new EtException("wrong number of elements in select array");
        }
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(82);
            this.sys.getOutputStream().writeInt(this.id);
            for (int i = 0; i < select.length; ++i) {
                this.sys.getOutputStream().writeInt(select[i]);
            }
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
        }
        if (err != 0) {
            throw new EtException("this station has been removed from ET system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValue(int command) throws IOException, EtException {
        int err;
        byte[] buf = null;
        String val = null;
        int length = 0;
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(command);
            this.sys.getOutputStream().writeInt(this.id);
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
            length = this.sys.getInputStream().readInt();
            if (err == 0) {
                buf = new byte[length];
                this.sys.getInputStream().readFully(buf, 0, length);
            }
        }
        if (err == 0) {
            try {
                val = new String(buf, 0, length - 1, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            if (length == 0) {
                return null;
            }
            throw new EtException("cannot find station");
        }
        return val;
    }

    public String getSelectLibrary() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(84);
    }

    public String getSelectFunction() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(85);
    }

    public String getSelectClass() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(86);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntValue(int cmd) throws IOException, EtException {
        int err;
        int val = 0;
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(cmd);
            this.sys.getOutputStream().writeInt(this.id);
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
            val = this.sys.getInputStream().readInt();
        }
        if (err != 0) {
            throw new EtException("this station has been removed from ET system");
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIntValue(int cmd, int val) throws IOException, EtException {
        int err;
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(cmd);
            this.sys.getOutputStream().writeInt(this.id);
            this.sys.getOutputStream().writeInt(val);
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
        }
        if (err != 0) {
            throw new EtException("this station has been removed from ET system");
        }
    }

    public int getNumAttachments() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(100);
    }

    public int getStatus() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(101);
    }

    public int getInputCount() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(102);
    }

    public int getOutputCount() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(103);
    }

    public int getBlockMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(104);
    }

    public void setBlockMode(int mode) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (mode != 1 && mode != 0) {
            throw new EtException("bad block mode value");
        }
        this.setIntValue(115, mode);
    }

    public int getUserMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(105);
    }

    public void setUserMode(int mode) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (mode < 0) {
            throw new EtException("bad user mode value");
        }
        this.setIntValue(116, mode);
    }

    public int getRestoreMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(106);
    }

    public void setRestoreMode(int mode) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new EtException("bad restore mode value");
        }
        this.setIntValue(117, mode);
    }

    public int getSelectMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(109);
    }

    public int getCue() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(108);
    }

    public void setCue(int cue) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (cue < 1) {
            throw new EtException("bad cue value");
        }
        this.setIntValue(119, cue);
    }

    public int getPrescale() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(107);
    }

    public void setPrescale(int prescale) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (prescale < 1) {
            throw new EtException("bad prescale value");
        }
        this.setIntValue(118, prescale);
    }
}

