/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.monitorGui.Monitor;
import org.jlab.coda.et.monitorGui.MonitorSingleSystem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MonitorConfiguration
extends DefaultHandler {
    private SAXParser parser;
    private StringBuffer buffer = new StringBuffer(100);
    private HashMap<String, String> dataStorage = new HashMap(100);
    private Monitor monitor;
    private boolean readWindowParametersOnly;
    private boolean finishedReadingWindowParameters;
    private String currentElement;
    private String findMethod;
    private Point windowLocation;
    private Dimension windowSize;

    public MonitorConfiguration(Monitor mon) {
        this.monitor = mon;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMonitor(Monitor mon) {
        this.monitor = mon;
    }

    public Point getWindowLocation() {
        return new Point(this.windowLocation);
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowSize);
    }

    public void loadWindowParameters(File file) throws IOException, SAXException {
        this.loadWindowParameters(file.getPath());
    }

    public void loadWindowParameters(String fileName) throws IOException, SAXException {
        File f = new File(fileName);
        this.readWindowParametersOnly = true;
        this.parser.parse(f, (DefaultHandler)this);
        this.readWindowParametersOnly = false;
        this.finishedReadingWindowParameters = false;
    }

    public void load(String fileName) throws IOException, SAXException {
        File f = new File(fileName);
        this.parser.parse(f, (DefaultHandler)this);
    }

    public void load(File file) throws IOException, SAXException {
        this.load(file.getPath());
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes attrs) {
        this.currentElement = local;
        if (local.equals("broadcasting") || local.equals("multicasting") || local.equals("broadAndMulticasting") || local.equals("direct")) {
            this.findMethod = this.currentElement;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.finishedReadingWindowParameters || ch == null || length == 0) {
            return;
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String qname) {
        if (this.finishedReadingWindowParameters) {
            return;
        }
        String elementData = this.buffer.toString().trim();
        if (elementData.length() > 0) {
            this.dataStorage.put(this.currentElement, elementData);
            this.buffer.setLength(0);
        }
        if (local.equals("graphics")) {
            StringTokenizer tok;
            if (this.readWindowParametersOnly) {
                int w = Integer.parseInt(this.dataStorage.get("width"));
                int h = Integer.parseInt(this.dataStorage.get("height"));
                int x = Integer.parseInt(this.dataStorage.get("xPosition"));
                int y = Integer.parseInt(this.dataStorage.get("yPosition"));
                this.windowLocation = new Point(x, y);
                this.windowSize = new Dimension(w, h);
                this.finishedReadingWindowParameters = true;
                this.dataStorage.clear();
                return;
            }
            if (this.dataStorage.containsKey("fileNameList")) {
                tok = new StringTokenizer(this.dataStorage.get("fileNameList"));
                while (tok.hasMoreTokens()) {
                    this.monitor.addFileName(tok.nextToken());
                }
            }
            if (this.dataStorage.containsKey("hostList")) {
                tok = new StringTokenizer(this.dataStorage.get("hostList"));
                while (tok.hasMoreTokens()) {
                    this.monitor.addHostname(tok.nextToken());
                }
            }
            this.dataStorage.clear();
        } else if (local.equals("etConnection")) {
            String etSystem = this.dataStorage.get("fileName");
            int period = Integer.parseInt(this.dataStorage.get("period"));
            int divider = Integer.parseInt(this.dataStorage.get("dividerPosition"));
            int orientation = 1;
            if (this.dataStorage.get("orientation").equals("vertical")) {
                orientation = 0;
            }
            EtSystemOpenConfig config = null;
            try {
                String host;
                if (this.dataStorage.containsKey("location")) {
                    host = this.dataStorage.get("location");
                    host = host.equals("local") ? ".local" : (host.equals("remote") ? ".remote" : ".anywhere");
                } else {
                    host = this.dataStorage.get("host");
                    this.monitor.addHostname(host);
                }
                if (this.findMethod.equals("broadcasting")) {
                    int broadcastPort = Integer.parseInt(this.dataStorage.get("broadcastPort"));
                    StringTokenizer tok = new StringTokenizer(this.dataStorage.get("broadcastAddressList"));
                    ArrayList<String> addrs = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        addrs.add(tok.nextToken());
                    }
                    config = new EtSystemOpenConfig(etSystem, broadcastPort, host, addrs);
                } else if (this.findMethod.equals("multicasting")) {
                    int ttl = Integer.parseInt(this.dataStorage.get("ttl").trim());
                    int multicastPort = Integer.parseInt(this.dataStorage.get("multicastPort"));
                    StringTokenizer tok = new StringTokenizer(this.dataStorage.get("multicastAddressList"));
                    ArrayList<String> addrs = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        addrs.add(tok.nextToken());
                    }
                    config = new EtSystemOpenConfig(etSystem, host, addrs, multicastPort, ttl);
                } else if (this.findMethod.equals("broadAndMulticasting")) {
                    int ttl = Integer.parseInt(this.dataStorage.get("ttl"));
                    int broadcastPort = Integer.parseInt(this.dataStorage.get("broadcastPort"));
                    int multicastPort = Integer.parseInt(this.dataStorage.get("multicastPort"));
                    StringTokenizer tok = new StringTokenizer(this.dataStorage.get("broadcastAddressList"));
                    ArrayList<String> bAddrs = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        bAddrs.add(tok.nextToken());
                    }
                    tok = new StringTokenizer(this.dataStorage.get("multicastAddressList"));
                    ArrayList<String> mAddrs = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        mAddrs.add(tok.nextToken());
                    }
                    config = new EtSystemOpenConfig(etSystem, host, bAddrs, mAddrs, true, 3, 0, broadcastPort, ttl, 2);
                } else if (this.findMethod.equals("direct")) {
                    int port = Integer.parseInt(this.dataStorage.get("tcpPort"));
                    config = new EtSystemOpenConfig(etSystem, host, port);
                }
            }
            catch (EtException ex) {
                ex.printStackTrace();
            }
            this.monitor.addFileName(etSystem);
            this.monitor.addEtSystem(config, period, divider, orientation, null);
            this.dataStorage.clear();
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(": line ");
        str.append(ex.getLineNumber());
        str.append(" :col ");
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public void save(File file) throws FileNotFoundException {
        String fileName = file.getPath();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "ASCII");
            StringBuilder text = new StringBuilder(1000);
            text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            text.append("<configuration>\n\n");
            text.append("  <graphics>\n    <width>");
            text.append(this.monitor.getMonitorWidth());
            text.append("</width>\n    <height>");
            text.append(this.monitor.getMonitorHeight());
            text.append("</height>\n    <xPosition>");
            text.append(this.monitor.getX());
            text.append("</xPosition>\n    <yPosition>");
            text.append(this.monitor.getY());
            text.append("</yPosition>\n");
            osw.write(text.toString());
            text.setLength(0);
            String[] names = this.monitor.getHostnames();
            if (names != null) {
                text.append("    <hostList>");
                for (String name : names) {
                    text.append("\n      ");
                    text.append(name);
                }
                text.append("\n    </hostList>\n");
            }
            if ((names = this.monitor.getFileNames()) != null) {
                text.append("    <fileNameList>");
                for (String name : names) {
                    text.append("\n      ");
                    text.append(name);
                }
                text.append("\n    </fileNameList>\n");
            }
            text.append("  </graphics>\n\n");
            osw.write(text.toString());
            text.setLength(0);
            for (Map.Entry<String, EtSystem> entry : this.monitor.connections.entrySet()) {
                String host;
                EtSystem use = entry.getValue();
                String key = entry.getKey();
                EtSystemOpenConfig config = use.getConfig();
                text.append("  <etConnection>\n    <fileName>");
                text.append(config.getEtName());
                text.append("</fileName>\n");
                int method = config.getNetworkContactMethod();
                if (method == 1) {
                    text.append("    <broadcasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <broadcastAddressList>");
                    for (String baddr : config.getBroadcastAddrs()) {
                        text.append("\n        ");
                        text.append(baddr);
                    }
                    text.append("\n      </broadcastAddressList>\n      <broadcastPort>");
                    text.append(config.getUdpPort());
                    text.append("</broadcastPort>\n    </broadcasting>\n");
                } else if (method == 0) {
                    text.append("    <multicasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <multicastAddressList>");
                    for (String maddr : config.getMulticastAddrs()) {
                        text.append("\n        ");
                        text.append(maddr);
                    }
                    text.append("\n      </multicastAddressList>\n      <multicastPort>");
                    text.append(config.getUdpPort());
                    text.append("</multicastPort>\n      <ttl>");
                    text.append(config.getTTL());
                    text.append("</ttl>\n    </multicasting>\n");
                } else if (method == 3) {
                    text.append("    <broadAndMulticasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <broadcastAddressList>");
                    for (String baddr : config.getBroadcastAddrs()) {
                        text.append("\n        ");
                        text.append(baddr);
                    }
                    text.append("\n      </broadcastAddressList>\n      <broadcastPort>");
                    text.append(config.getUdpPort());
                    text.append("</broadcastPort>\n");
                    text.append("      <multicastAddressList>");
                    for (String maddr : config.getMulticastAddrs()) {
                        text.append("\n        ");
                        text.append(maddr);
                    }
                    text.append("\n      </multicastAddressList>\n      <multicastPort>");
                    text.append(config.getUdpPort());
                    text.append("</multicastPort>\n      <ttl>");
                    text.append(config.getTTL());
                    text.append("</ttl>\n    </broadAndMulticasting>\n");
                } else {
                    text.append("    <direct>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <tcpPort>");
                    text.append(config.getTcpPort());
                    text.append("</tcpPort>\n");
                    text.append("    </direct>\n");
                }
                MonitorSingleSystem singleMonitor = this.monitor.monitors.get(key);
                text.append("    <period>");
                text.append(singleMonitor.getUpdatePeriod());
                text.append("</period>\n    <dividerPosition>");
                text.append(singleMonitor.getDividerPosition());
                text.append("</dividerPosition>\n    <orientation>");
                if (singleMonitor.getOrientation() == 1) {
                    text.append("horizontal");
                } else {
                    text.append("vertical");
                }
                text.append("</orientation>\n");
                text.append("  </etConnection>\n\n");
                osw.write(text.toString());
                text.setLength(0);
            }
            text.append("</configuration>\n");
            osw.write(text.toString());
            osw.close();
            fos.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

