/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.data;

import java.io.DataInputStream;
import java.io.IOException;
import org.jlab.coda.et.EtUtils;

public class SystemData {
    private int alive;
    private int heartbeat;
    private int temps;
    private int stations;
    private int attachments;
    private int processes;
    private int eventsOwned;
    private int mutex;
    private int statMutex;
    private int statAddMutex;
    private int endian;
    private int share;
    private int mainPid;
    private int selects;
    private int events;
    private long eventSize;
    private boolean bit64;
    private int tempsMax;
    private int stationsMax;
    private int attachmentsMax;
    private int processesMax;
    private int tcpPort;
    private int udpPort;
    private int multicastPort;
    private int interfaceCount;
    private int multicastCount;
    private String[] interfaceAddresses;
    private String[] multicastAddresses;
    private String etName;

    public boolean alive() {
        return this.alive == 1;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public int getTemps() {
        return this.temps;
    }

    public int getStations() {
        return this.stations;
    }

    public int getAttachments() {
        return this.attachments;
    }

    public int getProcesses() {
        return this.processes;
    }

    public int getEventsOwned() {
        return this.eventsOwned;
    }

    public int getMutex() {
        return this.mutex;
    }

    public int getStatMutex() {
        return this.statMutex;
    }

    public int getStatAddMutex() {
        return this.statAddMutex;
    }

    public int getEndian() {
        return this.endian;
    }

    public int getShare() {
        return this.share;
    }

    public int getMainPid() {
        return this.mainPid;
    }

    public int getSelects() {
        return this.selects;
    }

    public int getEvents() {
        return this.events;
    }

    public long getEventSize() {
        return this.eventSize;
    }

    public boolean isBit64() {
        return this.bit64;
    }

    public int getTempsMax() {
        return this.tempsMax;
    }

    public int getStationsMax() {
        return this.stationsMax;
    }

    public int getAttachmentsMax() {
        return this.attachmentsMax;
    }

    public int getProcessesMax() {
        return this.processesMax;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getInterfaces() {
        return this.interfaceCount;
    }

    public int getMulticasts() {
        return this.multicastCount;
    }

    public String[] getInterfaceAddresses() {
        return (String[])this.interfaceAddresses.clone();
    }

    public String[] getMulticastAddresses() {
        return (String[])this.multicastAddresses.clone();
    }

    public String getEtName() {
        return this.etName;
    }

    public void read(DataInputStream dis) throws IOException {
        int i;
        int off = 0;
        byte[] info = new byte[108];
        dis.readFully(info);
        this.alive = EtUtils.bytesToInt(info, off);
        this.heartbeat = EtUtils.bytesToInt(info, off += 4);
        this.temps = EtUtils.bytesToInt(info, off += 4);
        this.stations = EtUtils.bytesToInt(info, off += 4);
        this.attachments = EtUtils.bytesToInt(info, off += 4);
        this.processes = EtUtils.bytesToInt(info, off += 4);
        this.eventsOwned = EtUtils.bytesToInt(info, off += 4);
        this.mutex = EtUtils.bytesToInt(info, off += 4);
        this.statMutex = EtUtils.bytesToInt(info, off += 4);
        this.statAddMutex = EtUtils.bytesToInt(info, off += 4);
        this.endian = EtUtils.bytesToInt(info, off += 4);
        this.share = EtUtils.bytesToInt(info, off += 4);
        this.mainPid = EtUtils.bytesToInt(info, off += 4);
        this.selects = EtUtils.bytesToInt(info, off += 4);
        this.events = EtUtils.bytesToInt(info, off += 4);
        this.eventSize = EtUtils.bytesToLong(info, off += 4);
        this.bit64 = EtUtils.bytesToInt(info, off += 8) == 1;
        this.tempsMax = EtUtils.bytesToInt(info, off += 4);
        this.stationsMax = EtUtils.bytesToInt(info, off += 4);
        this.attachmentsMax = EtUtils.bytesToInt(info, off += 4);
        this.processesMax = EtUtils.bytesToInt(info, off += 4);
        this.tcpPort = EtUtils.bytesToInt(info, off += 4);
        this.udpPort = EtUtils.bytesToInt(info, off += 4);
        this.multicastPort = EtUtils.bytesToInt(info, off += 4);
        this.interfaceCount = EtUtils.bytesToInt(info, off += 4);
        this.multicastCount = EtUtils.bytesToInt(info, off += 4);
        off = 0;
        int lengthTotal = 0;
        int[] lengths = new int[this.interfaceCount + this.multicastCount + 1];
        for (i = 0; i < this.interfaceCount + this.multicastCount + 1; ++i) {
            lengths[i] = dis.readInt();
            lengthTotal += lengths[i];
        }
        if (lengthTotal > 100) {
            info = new byte[lengthTotal];
        }
        dis.readFully(info, 0, lengthTotal);
        this.interfaceAddresses = new String[this.interfaceCount];
        for (i = 0; i < this.interfaceCount; ++i) {
            this.interfaceAddresses[i] = new String(info, off, lengths[i] - 1, "US-ASCII");
            off += lengths[i];
        }
        this.multicastAddresses = new String[this.multicastCount];
        for (i = 0; i < this.multicastCount; ++i) {
            this.multicastAddresses[i] = new String(info, off, lengths[i + this.interfaceCount] - 1, "US-ASCII");
            off += lengths[i + this.interfaceCount];
        }
        this.etName = new String(info, off, lengths[this.interfaceCount + this.multicastCount] - 1, "US-ASCII");
    }
}

