/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.data;

import java.io.DataInputStream;
import java.io.IOException;

public class StationData {
    private int num;
    private int status;
    private int mutex;
    private int attachments;
    private int[] attIds = new int[110];
    private int inListMutex;
    private int inListCount;
    private long inListTry;
    private long inListIn;
    private int outListMutex;
    private int outListCount;
    private long outListOut;
    private int flowMode;
    private int userMode;
    private int restoreMode;
    private int blockMode;
    private int prescale;
    private int cue;
    private int selectMode;
    private int[] select = new int[6];
    private String selectFunction;
    private String selectLibrary;
    private String selectClass;
    private String name;

    public int getId() {
        return this.num;
    }

    public int getStatus() {
        return this.status;
    }

    public int getMutex() {
        return this.mutex;
    }

    public int getAttachments() {
        return this.attachments;
    }

    public int[] getAttachmentIds() {
        return (int[])this.attIds.clone();
    }

    public int getInListMutex() {
        return this.inListMutex;
    }

    public int getInListCount() {
        return this.inListCount;
    }

    public long getInListTry() {
        return this.inListTry;
    }

    public long getInListIn() {
        return this.inListIn;
    }

    public int getOutListMutex() {
        return this.outListMutex;
    }

    public int getOutListCount() {
        return this.outListCount;
    }

    public long getOutListOut() {
        return this.outListOut;
    }

    public int getFlowMode() {
        return this.flowMode;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public int getRestoreMode() {
        return this.restoreMode;
    }

    public int getBlockMode() {
        return this.blockMode;
    }

    public int getPrescale() {
        return this.prescale;
    }

    public int getCue() {
        return this.cue;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int[] getSelect() {
        return (int[])this.select.clone();
    }

    public String getSelectFunction() {
        return this.selectFunction;
    }

    public String getSelectLibrary() {
        return this.selectLibrary;
    }

    public String getSelectClass() {
        return this.selectClass;
    }

    public String getName() {
        return this.name;
    }

    public void read(DataInputStream dis) throws IOException {
        int i;
        this.attachments = dis.readInt();
        this.num = dis.readInt();
        this.status = dis.readInt();
        this.mutex = dis.readInt();
        for (i = 0; i < this.attachments; ++i) {
            this.attIds[i] = dis.readInt();
        }
        this.inListMutex = dis.readInt();
        this.inListCount = dis.readInt();
        this.inListTry = dis.readLong();
        this.inListIn = dis.readLong();
        this.outListMutex = dis.readInt();
        this.outListCount = dis.readInt();
        this.outListOut = dis.readLong();
        this.flowMode = dis.readInt();
        this.userMode = dis.readInt();
        this.restoreMode = dis.readInt();
        this.blockMode = dis.readInt();
        this.prescale = dis.readInt();
        this.cue = dis.readInt();
        this.selectMode = dis.readInt();
        for (i = 0; i < 6; ++i) {
            this.select[i] = dis.readInt();
        }
        int length1 = dis.readInt();
        int length2 = dis.readInt();
        int length3 = dis.readInt();
        int length4 = dis.readInt();
        int length = length1 + length2 + length3 + length4;
        byte[] buf = new byte[length];
        dis.readFully(buf, 0, length);
        int off = 0;
        if (length1 > 0) {
            this.selectFunction = new String(buf, off, length1 - 1, "US-ASCII");
            off += length1;
        }
        if (length2 > 0) {
            this.selectLibrary = new String(buf, off, length2 - 1, "US-ASCII");
            off += length2;
        }
        if (length3 > 0) {
            this.selectClass = new String(buf, off, length3 - 1, "US-ASCII");
            off += length3;
        }
        if (length4 > 0) {
            this.name = new String(buf, off, length4 - 1, "US-ASCII");
        }
    }
}

