/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.nio.ByteBuffer;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.enums.Mode;

public class Blaster {
    private static void usage() {
        System.out.println("\nUsage: java Blaster -f <ET name> -host <ET host> [-h] [-v] [-c <chunk size>]\n                     [-s <event size>] [-g <group>] [-p <ET server port>] [-i <interface address>]\n                     [-rb <buffer size>] [-sb <buffer size>] [-nd]\n                     [-d <nanosec>] [-d <nanosec>]\n\n       -host    ET system's host\n       -f       ET system's (memory-mapped file) name\n       -h       help\n       -v       verbose output\n       -c       number of events in one get/put array\n       -s       event size in bytes\n       -g       group from which to get new events (1,2,...)\n       -p       ET server port\n       -i       outgoing network interface IP address (dot-decimal)\n\n       -rb      TCP receive buffer size (bytes)\n       -sb      TCP send buffer size (bytes)\n       -nd      turn on TCP no-delay\n       -d       delay in nanoseconds between each send\n       -single  put events back one by one (chunk = 1)\n\n        This consumer works by making a direct connection to the\n        ET system's server port.\n");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        etName = null;
        host = null;
        netInterface = null;
        port = 11111;
        group = 1;
        size = 32;
        chunk = 1;
        nanosec = 0;
        recvBufSize = 0;
        sendBufSize = 0;
        noDelay = false;
        verbose = false;
        singleBack = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                netInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-d")) {
                try {
                    nanosec = Integer.parseInt(args[++i]);
                    if (nanosec >= 0) continue;
                    System.out.println("Nanoseconds of delay must be >= 0.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper delay number.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-c")) {
                try {
                    chunk = Integer.parseInt(args[++i]);
                    if (chunk >= 1 && chunk <= 1000) continue;
                    System.out.println("Chunk size may be 1 - 1000.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper chunk size.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-s")) {
                try {
                    size = Integer.parseInt(args[++i]);
                    if (size >= 1) continue;
                    System.out.println("Size needs to be positive int.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper size.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-g")) {
                try {
                    group = Integer.parseInt(args[++i]);
                    if (group >= 1 && group <= 10) continue;
                    System.out.println("Group number must be between 0 and 10.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper group number.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-rb")) {
                try {
                    recvBufSize = Integer.parseInt(args[++i]);
                    if (recvBufSize >= 1) continue;
                    System.out.println("recv buffer must be > 0.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper recv buffer size.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-sb")) {
                try {
                    sendBufSize = Integer.parseInt(args[++i]);
                    if (sendBufSize >= 1) continue;
                    System.out.println("send buffer must be > 0.");
                    Blaster.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper send buffer size.");
                    Blaster.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-nd")) {
                noDelay = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-single")) {
                singleBack = true;
                continue;
            }
            Blaster.usage();
            return;
        }
        if (host == null || etName == null) {
            Blaster.usage();
            return;
        }
        try {
            config = new EtSystemOpenConfig(etName, host, port);
            config.setConnectRemotely(true);
            if (noDelay) {
                config.setNoDelay(noDelay);
            }
            if (recvBufSize > 0) {
                config.setTcpRecvBufSize(recvBufSize);
            }
            if (sendBufSize > 0) {
                config.setTcpSendBufSize(sendBufSize);
            }
            if (netInterface != null) {
                config.setNetworkInterface(netInterface);
            }
            sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            gc = sys.stationNameToObject("GRAND_CENTRAL");
            att = sys.attach(gc);
            data = new byte[size];
            byteBuffer = ByteBuffer.wrap(data);
            eventCount = 0L;
            byteCount = 0L;
            totalT = 0L;
            totalEventCount = 0L;
            totalByteCount = 0L;
            t1 = System.currentTimeMillis();
            while (true) {
                for (EtEvent mev : mevs = sys.newEvents(att, Mode.SLEEP, true, 0, chunk, size, group)) {
                    realEvent = (EtEventImpl)mev;
                    realEvent.setDataBuffer(byteBuffer);
                    mev.setLength(size);
                }
                if (singleBack) {
                    for (i = 0; i < mevs.length; ++i) {
                        sys.putEvents(att, mevs, i, 1);
                        ++eventCount;
                        byteCount += (long)(size + 52 + 20);
                        if (nanosec <= 0) continue;
                        EtUtils.sleepNanos(nanosec);
                    }
                } else {
                    sys.putEvents(att, mevs);
                    eventCount += (long)mevs.length;
                    byteCount += (long)(mevs.length * (size + 52) + 20);
                    if (nanosec > 0) {
                        EtUtils.sleepNanos(nanosec);
                    }
                }
                if ((time = (t2 = System.currentTimeMillis()) - t1) <= 5000L) ** continue;
                eventRate = 1000.0 * (double)eventCount / (double)time;
                byteRate = 1000.0 * (double)byteCount / (double)time;
                avgEventRate = 1000.0 * (double)(totalEventCount += eventCount) / (double)(totalT += time);
                avgByteRate = 1000.0 * (double)(totalByteCount += byteCount) / (double)totalT;
                System.out.printf("evRate: %3.4g Hz,  %3.4g avg;  byteRate: %3.4g bytes/sec,  %3.4g avg\n", new Object[]{eventRate, avgEventRate, byteRate, avgByteRate});
                eventCount = 0L;
                byteCount = 0L;
                t1 = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as producer");
            ex.printStackTrace();
            return;
        }
    }
}

