/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.INameProvider;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.StructureType;

public class StructureFinder {
    public static List<BaseStructure> getMatchingStructures(BaseStructure structure, IEvioFilter filter) {
        if (structure == null) {
            System.out.println("getMatchingStructures: returning null list");
            return null;
        }
        return structure.getMatchingStructures(filter);
    }

    public static List<BaseStructure> getMatchingBanks(BaseStructure structure, final int tag, final int number) {
        IEvioFilter filter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType type, IEvioStructure struct) {
                return type == StructureType.BANK && tag == struct.getHeader().tag && number == struct.getHeader().number;
            }
        };
        return StructureFinder.getMatchingStructures(structure, filter);
    }

    public static List<BaseStructure> getMatchingStructures(BaseStructure structure, final int tag) {
        IEvioFilter filter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType type, IEvioStructure struct) {
                return tag == struct.getHeader().tag;
            }
        };
        return StructureFinder.getMatchingStructures(structure, filter);
    }

    public static List<BaseStructure> getMatchingNonBanks(BaseStructure structure, final int tag) {
        IEvioFilter filter = new IEvioFilter(){

            @Override
            public boolean accept(StructureType type, IEvioStructure struct) {
                return type != StructureType.BANK && tag == struct.getHeader().tag;
            }
        };
        return StructureFinder.getMatchingStructures(structure, filter);
    }

    public static List<BaseStructure> getMatchingStructures(BaseStructure structure, String name, INameProvider dictionary) throws EvioException {
        boolean useGlobalDictionary = false;
        if (dictionary == null) {
            if (!NameProvider.isProviderSet()) {
                throw new EvioException("Dictionary must be given as arg or defined globally in NameProvider");
            }
            useGlobalDictionary = true;
        }
        class MyEvioFilter
        implements IEvioFilter {
            String name;
            INameProvider dictionary;
            boolean useGlobalDictionary;

            MyEvioFilter(boolean useGlobalDictionary, String name, INameProvider dictionary) {
                this.name = name;
                this.dictionary = dictionary;
                this.useGlobalDictionary = useGlobalDictionary;
            }

            @Override
            public boolean accept(StructureType structureType, IEvioStructure struct) {
                String dictName = this.useGlobalDictionary ? NameProvider.getName((BaseStructure)struct) : this.dictionary.getName((BaseStructure)struct);
                return this.name.equals(dictName);
            }
        }
        MyEvioFilter filter = new MyEvioFilter(useGlobalDictionary, name, dictionary);
        return StructureFinder.getMatchingStructures(structure, filter);
    }

    public static List<BaseStructure> getMatchingParent(BaseStructure structure, String parentName, INameProvider dictionary) throws EvioException {
        boolean useGlobalDictionary = false;
        if (dictionary == null) {
            if (!NameProvider.isProviderSet()) {
                throw new EvioException("Dictionary must be given as arg or defined globally in NameProvider");
            }
            useGlobalDictionary = true;
        }
        class MyEvioFilter
        implements IEvioFilter {
            String name;
            INameProvider dictionary;
            boolean useGlobalDictionary;

            MyEvioFilter(boolean useGlobalDictionary, String name, INameProvider dictionary) {
                this.name = name;
                this.dictionary = dictionary;
                this.useGlobalDictionary = useGlobalDictionary;
            }

            @Override
            public boolean accept(StructureType structureType, IEvioStructure struct) {
                BaseStructure parent = ((BaseStructure)struct).getParent();
                if (parent == null) {
                    return false;
                }
                String dictName = this.useGlobalDictionary ? NameProvider.getName(parent) : this.dictionary.getName(parent);
                return this.name.equals(dictName);
            }
        }
        MyEvioFilter filter = new MyEvioFilter(useGlobalDictionary, parentName, dictionary);
        return StructureFinder.getMatchingStructures(structure, filter);
    }

    public static List<BaseStructure> getMatchingChild(BaseStructure structure, String childName, INameProvider dictionary) throws EvioException {
        boolean useGlobalDictionary = false;
        if (dictionary == null) {
            if (!NameProvider.isProviderSet()) {
                throw new EvioException("Dictionary must be given as arg or defined globally in NameProvider");
            }
            useGlobalDictionary = true;
        }
        class MyEvioFilter
        implements IEvioFilter {
            String name;
            INameProvider dictionary;
            boolean useGlobalDictionary;

            MyEvioFilter(boolean useGlobalDictionary, String name, INameProvider dictionary) {
                this.name = name;
                this.dictionary = dictionary;
                this.useGlobalDictionary = useGlobalDictionary;
            }

            @Override
            public boolean accept(StructureType structureType, IEvioStructure struct) {
                Vector<BaseStructure> children = ((BaseStructure)struct).getChildren();
                if (children == null || children.size() < 1) {
                    return false;
                }
                Enumeration<BaseStructure> enumeration = children.elements();
                while (enumeration.hasMoreElements()) {
                    BaseStructure bStruct = enumeration.nextElement();
                    String dictName = this.useGlobalDictionary ? NameProvider.getName(bStruct) : this.dictionary.getName(bStruct);
                    if (!this.name.equals(dictName)) continue;
                    return true;
                }
                return false;
            }
        }
        MyEvioFilter filter = new MyEvioFilter(useGlobalDictionary, childName, dictionary);
        return StructureFinder.getMatchingStructures(structure, filter);
    }
}

