/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioException;

public class EvioCompactEventWriter {
    private EventWriter writer;

    public EvioCompactEventWriter(String baseName, String directory, int runNumber, int split, int bufferSize, ByteOrder byteOrder, String xmlDictionary) throws EvioException {
        this.writer = new EventWriter(baseName, directory, null, runNumber, split, EventWriter.DEFAULT_BLOCK_SIZE, EventWriter.DEFAULT_BLOCK_COUNT, bufferSize, byteOrder, xmlDictionary, null, false, false);
    }

    public EvioCompactEventWriter(String baseName, String directory, int runNumber, int split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK) throws EvioException {
        this.writer = new EventWriter(baseName, directory, null, runNumber, split, blockSizeMax / 4, blockCountMax, bufferSize, byteOrder, xmlDictionary, null, overWriteOK, false);
    }

    public EvioCompactEventWriter(String baseName, String directory, String runType, int runNumber, int split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK) throws EvioException {
        this.writer = new EventWriter(baseName, directory, runType, runNumber, split, blockSizeMax / 4, blockCountMax, bufferSize, byteOrder, xmlDictionary, null, overWriteOK, false);
    }

    public EvioCompactEventWriter(ByteBuffer byteBuffer, int blockSizeMax, int blockCountMax, String xmlDictionary) throws EvioException {
        this.writer = new EventWriter(byteBuffer, blockSizeMax / 4, blockCountMax, xmlDictionary, null);
    }

    public int getEventsWritten() {
        return this.writer.getEventsWritten();
    }

    public void setStartingBlockNumber(int startingBlockNumber) {
        this.writer.setStartingBlockNumber(startingBlockNumber);
    }

    public void close() {
        this.writer.close();
    }

    public void writeEvent(ByteBuffer eventBuffer) throws EvioException, IOException {
        this.writer.writeEvent(eventBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() {
        ByteBuffer buf;
        if (this.writer.toFile()) {
            return null;
        }
        EventWriter eventWriter = this.writer;
        synchronized (eventWriter) {
            buf = this.writer.getBuffer().duplicate();
            if (!this.writer.isClosed() && buf.position() < buf.capacity() - 32) {
                buf.position(buf.position() + 32);
            }
        }
        buf.flip();
        return buf;
    }
}

