/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Environment {
    private static Environment environment;
    private String homeDirectory = this.getProperty("user.home");
    private String currentWorkingDirectory = this.getProperty("user.dir");
    private String userName = this.getProperty("user.name");
    private String osName = this.getProperty("os.name");
    private String tempDirectory = this.getProperty("java.io.tmpdir");
    private String classPath = this.getProperty("java.class.path");
    private String hostName;

    private Environment() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostName = addr.getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "???";
        }
    }

    public static Environment getInstance() {
        if (environment == null) {
            environment = new Environment();
        }
        return environment;
    }

    private String getProperty(String keyName) {
        try {
            return System.getProperty(keyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("Environment: \n");
        sb.append("Host Name: " + this.getHostName() + "\n");
        sb.append("User Name: " + this.getUserName() + "\n");
        sb.append("Temp Directory: " + this.getTempDirectory() + "\n");
        sb.append("OS Name: " + this.getOsName() + "\n");
        sb.append("Home Directory: " + this.getHomeDirectory() + "\n");
        sb.append("Current Working Directory: " + this.getCurrentWorkingDirectory() + "\n");
        sb.append("Class Path: " + this.getClassPath() + "\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        Environment env = Environment.getInstance();
        System.out.println(env.toString());
    }
}

