/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.TagSegmentHeader;

public final class CompositeData {
    private String format;
    private List<Integer> formatInts;
    private List<Object> items;
    private List<DataType> types;
    private List<Integer> nList;
    private TagSegmentHeader tsHeader;
    private BankHeader bHeader;
    private byte[] rawBytes;
    private ByteBuffer dataBuffer;
    private int dataBytes;
    private int dataPadding;
    private int dataOffset;
    private ByteOrder byteOrder;
    private int getIndex;

    private CompositeData() {
    }

    public CompositeData(String format, int formatTag, Data data, int dataTag, int dataNum) throws EvioException {
        boolean debug = false;
        this.format = format;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        if (debug) {
            System.out.println("Analyzing composite data:");
        }
        if (format == null || data == null) {
            throw new EvioException("format and/or data arg is null");
        }
        this.formatInts = CompositeData.compositeFormatToInt(format);
        if (this.formatInts.size() < 1) {
            throw new EvioException("bad format string data");
        }
        this.items = data.dataItems;
        this.types = data.dataTypes;
        this.nList = data.nList;
        EvioTagSegment tagSegment = new EvioTagSegment(formatTag, DataType.CHARSTAR8);
        try {
            tagSegment.appendStringData(format);
        }
        catch (EvioException e) {
            // empty catch block
        }
        this.tsHeader = (TagSegmentHeader)tagSegment.getHeader();
        EvioBank bank = new EvioBank(dataTag, DataType.COMPOSITE, dataNum);
        this.bHeader = (BankHeader)bank.getHeader();
        this.bHeader.setPadding(data.getPadding());
        this.dataPadding = data.getPadding();
        this.dataBytes = data.getDataSize();
        this.bHeader.setLength(1 + this.dataBytes / 4);
        this.dataOffset = this.bHeader.getHeaderLength() + this.tsHeader.getHeaderLength() + this.tsHeader.getLength();
        int totalByteLen = this.dataBytes + 4 * this.dataOffset;
        this.rawBytes = new byte[totalByteLen];
        ByteBuffer allDataBuffer = ByteBuffer.wrap(this.rawBytes, 0, totalByteLen);
        tagSegment.write(allDataBuffer);
        this.bHeader.write(allDataBuffer);
        CompositeData.dataToRawBytes(allDataBuffer, data, this.formatInts);
        this.dataBuffer = ByteBuffer.wrap(this.rawBytes, 4 * this.dataOffset, this.dataBytes).slice();
        this.dataBytes -= data.getPadding();
    }

    public CompositeData(byte[] rawBytes, ByteOrder byteOrder) throws EvioException {
        boolean debug = false;
        if (rawBytes == null) {
            throw new EvioException("null argument(s)");
        }
        if (debug) {
            System.out.println("CompositeData constr: incoming byte order = " + byteOrder);
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (debug) {
            System.out.println("Analyzing composite data:");
        }
        this.rawBytes = rawBytes;
        this.byteOrder = byteOrder;
        this.tsHeader = EventParser.createTagSegmentHeader(rawBytes, 0, byteOrder);
        if (debug) {
            System.out.println("    tagseg: type = " + Integer.toHexString(this.tsHeader.getDataTypeValue()) + ", tag = " + this.tsHeader.getTag() + ", len = " + this.tsHeader.getLength());
        }
        this.dataOffset = this.tsHeader.getHeaderLength();
        String[] strs = BaseStructure.unpackRawBytesToStrings(rawBytes, 4 * this.dataOffset);
        if (strs.length < 1) {
            throw new EvioException("bad format string data");
        }
        this.format = strs[0];
        if (debug) {
            System.out.println("    format: " + this.format);
        }
        this.formatInts = CompositeData.compositeFormatToInt(this.format);
        if (this.formatInts.size() < 1) {
            throw new EvioException("bad format string data");
        }
        this.dataOffset += this.tsHeader.getLength() - (this.tsHeader.getHeaderLength() - 1);
        this.bHeader = EventParser.createBankHeader(rawBytes, 4 * this.dataOffset, byteOrder);
        this.dataOffset += this.bHeader.getHeaderLength();
        this.dataPadding = this.bHeader.getPadding();
        this.dataBytes = 4 * (this.bHeader.getLength() - (this.bHeader.getHeaderLength() - 1)) - this.dataPadding;
        if (this.dataBytes < 2) {
            throw new EvioException("no composite data");
        }
        if (debug) {
            System.out.println("    bank: type = " + Integer.toHexString(this.bHeader.getDataTypeValue()) + ", tag = " + this.bHeader.getTag() + ", num = " + this.bHeader.getNumber());
            System.out.println("    bank: len (words) = " + this.bHeader.getLength() + ", data len - padding = " + this.dataBytes);
        }
        this.dataBuffer = ByteBuffer.wrap(rawBytes, 4 * this.dataOffset, this.dataBytes).slice();
        this.process();
    }

    public static CompositeData[] parse(byte[] rawBytes, ByteOrder byteOrder) throws EvioException {
        boolean debug = false;
        if (rawBytes == null) {
            throw new EvioException("null argument(s)");
        }
        if (debug) {
            System.out.println("CompositeData parse: incoming byte order = " + byteOrder);
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (debug) {
            System.out.println("Analyzing composite data:");
        }
        ArrayList<CompositeData> list = new ArrayList<CompositeData>(100);
        int rawBytesOffset = 0;
        int rawBytesLeft = rawBytes.length;
        if (debug) {
            System.out.println("    raw byte count = " + rawBytesLeft);
        }
        while (rawBytesLeft > 0) {
            int byteCount = 0;
            CompositeData cd = new CompositeData();
            cd.byteOrder = byteOrder;
            cd.tsHeader = EventParser.createTagSegmentHeader(rawBytes, rawBytesOffset, byteOrder);
            byteCount += 4 * (cd.tsHeader.getLength() + 1);
            if (debug) {
                System.out.println("    tagseg: type = " + (Object)((Object)cd.tsHeader.getDataType()) + ", tag = " + cd.tsHeader.getTag() + ", len = " + cd.tsHeader.getLength());
            }
            cd.dataOffset = cd.tsHeader.getHeaderLength();
            String[] strs = BaseStructure.unpackRawBytesToStrings(rawBytes, rawBytesOffset + 4 * cd.dataOffset);
            if (strs.length < 1) {
                throw new EvioException("bad format string data");
            }
            cd.format = strs[0];
            if (debug) {
                System.out.println("    format: " + cd.format);
            }
            cd.formatInts = CompositeData.compositeFormatToInt(cd.format);
            if (cd.formatInts.size() < 1) {
                throw new EvioException("bad format string data");
            }
            cd.dataOffset = cd.tsHeader.getLength() + 1;
            cd.bHeader = EventParser.createBankHeader(rawBytes, rawBytesOffset + 4 * cd.dataOffset, byteOrder);
            byteCount += 4 * (cd.bHeader.getLength() + 1);
            cd.dataOffset += cd.bHeader.getHeaderLength();
            cd.dataPadding = cd.bHeader.getPadding();
            cd.dataBytes = 4 * (cd.bHeader.getLength() - (cd.bHeader.getHeaderLength() - 1)) - cd.dataPadding;
            if (cd.dataBytes < 2) {
                throw new EvioException("no composite data");
            }
            if (debug) {
                System.out.println("    bank: type = " + (Object)((Object)cd.bHeader.getDataType()) + ", tag = " + cd.bHeader.getTag() + ", num = " + cd.bHeader.getNumber());
                System.out.println("    bank: len (words) = " + cd.bHeader.getLength() + ", data len - padding (bytes) = " + cd.dataBytes);
            }
            cd.rawBytes = new byte[byteCount];
            System.arraycopy(rawBytes, rawBytesOffset, cd.rawBytes, 0, byteCount);
            cd.dataBuffer = ByteBuffer.wrap(cd.rawBytes, 4 * cd.dataOffset, cd.dataBytes).slice();
            cd.process();
            list.add(cd);
            rawBytesLeft -= byteCount;
            rawBytesOffset += byteCount;
            if (!debug) continue;
            System.out.println("    raw byte count = " + rawBytesLeft + ", raw byte offset = " + rawBytesOffset);
        }
        int size = list.size();
        if (size > 0) {
            CompositeData[] cdArray = new CompositeData[size];
            return list.toArray(cdArray);
        }
        return null;
    }

    public static byte[] generateRawBytes(CompositeData[] data) throws EvioException {
        int len;
        if (data == null || data.length < 1) {
            return null;
        }
        int totalLen = 0;
        for (CompositeData cd : data) {
            len = cd.getRawBytes().length;
            if (Integer.MAX_VALUE - totalLen < len) {
                throw new EvioException("added data overflowed containing structure");
            }
            totalLen += len;
        }
        byte[] rawBytes = new byte[totalLen];
        int offset = 0;
        for (CompositeData cd : data) {
            len = cd.getRawBytes().length;
            System.arraycopy(cd.getRawBytes(), 0, rawBytes, offset, len);
            offset += len;
        }
        return rawBytes;
    }

    public Object clone() {
        CompositeData cd = new CompositeData();
        cd.getIndex = this.getIndex;
        cd.byteOrder = this.byteOrder;
        cd.dataBytes = this.dataBytes;
        cd.dataOffset = this.dataOffset;
        cd.rawBytes = (byte[])this.rawBytes.clone();
        cd.tsHeader = new TagSegmentHeader(this.tsHeader.getTag(), this.tsHeader.getDataType());
        cd.bHeader = new BankHeader(this.bHeader.getTag(), this.bHeader.getDataType(), this.bHeader.getNumber());
        cd.dataBuffer = ByteBuffer.wrap(this.rawBytes, 4 * this.dataOffset, 4 * this.bHeader.getLength()).slice();
        cd.formatInts = new ArrayList<Integer>(this.formatInts.size());
        cd.formatInts.addAll(this.formatInts);
        cd.types = new ArrayList<DataType>(this.types.size());
        cd.types.addAll(this.types);
        int listLength = this.items.size();
        cd.items = new ArrayList<Object>(listLength);
        block3: for (int i = 0; i < listLength; ++i) {
            switch (this.types.get(i)) {
                case CHARSTAR8: {
                    String[] strs = (String[])this.items.get(i);
                    cd.items.add(strs.clone());
                    continue block3;
                }
                default: {
                    cd.items.add(this.items.get(i));
                }
            }
        }
        return cd;
    }

    public static String stringsToFormat(String[] strings) {
        byte[] rawBuf = BaseStructure.stringsToRawBytes(strings);
        if (rawBuf != null) {
            return rawBuf.length + "a";
        }
        return null;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public List<DataType> getTypes() {
        return this.types;
    }

    public List<Integer> getNValues() {
        return this.nList;
    }

    public int index() {
        return this.getIndex;
    }

    public void index(int index) {
        this.getIndex = index;
    }

    public Integer getInt() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.INT32 && type != DataType.UINT32) {
            return null;
        }
        return (Integer)this.items.get(this.getIndex++);
    }

    public Integer getNValue() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.NVALUE) {
            return null;
        }
        return (Integer)this.items.get(this.getIndex++);
    }

    public Integer getHollerit() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.HOLLERIT) {
            return null;
        }
        return (Integer)this.items.get(this.getIndex++);
    }

    public Byte getByte() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.CHAR8 && type != DataType.UCHAR8) {
            return null;
        }
        return (Byte)this.items.get(this.getIndex++);
    }

    public Short getShort() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.SHORT16 && type != DataType.USHORT16) {
            return null;
        }
        return (Short)this.items.get(this.getIndex++);
    }

    public Long getLong() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.LONG64 && type != DataType.ULONG64) {
            return null;
        }
        return (Long)this.items.get(this.getIndex++);
    }

    public Float getFloat() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.FLOAT32) {
            return null;
        }
        return (Float)this.items.get(this.getIndex++);
    }

    public Double getDouble() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.DOUBLE64) {
            return null;
        }
        return (Double)this.items.get(this.getIndex++);
    }

    public String[] getStrings() {
        if (this.getIndex > this.types.size()) {
            return null;
        }
        DataType type = this.types.get(this.getIndex);
        if (type != DataType.CHARSTAR8) {
            return null;
        }
        return (String[])this.items.get(this.getIndex++);
    }

    static int max(int a, int b) {
        return a > b ? a : b;
    }

    static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static List<Integer> compositeFormatToInt(String fmt) throws EvioException {
        boolean debug = false;
        ArrayList<Integer> ifmt = new ArrayList<Integer>(2 * fmt.length());
        int nr = 0;
        int nn = 1;
        int lev = 0;
        if (debug) {
            System.out.println("\nfmt >" + fmt + "<");
        }
        for (int l = 0; l < fmt.length(); ++l) {
            String s;
            int ii;
            char ch = fmt.charAt(l);
            if (ch == ' ') continue;
            if (debug) {
                System.out.println("ch = " + ch);
            }
            if (Character.isDigit(ch)) {
                if (debug) {
                    System.out.println("the number of repeats before, nr = " + nr);
                }
                if (nr < 0) {
                    throw new EvioException("no negative repeats");
                }
                if ((nr = 10 * CompositeData.max(0, nr) + Character.digit(ch, 10)) > 15) {
                    throw new EvioException("no more than 15 repeats allowed");
                }
                if (!debug) continue;
                System.out.println("the number of repeats nr = " + nr);
                continue;
            }
            if (ch == '(') {
                if (nr < 0) {
                    throw new EvioException("no negative repeats");
                }
                ++lev;
                if (debug) {
                    System.out.println(String.format("111: nn=%d nr=%d\n", nn, nr));
                }
                if (nn == 0) {
                    ifmt.add(15);
                } else {
                    ifmt.add(16 * CompositeData.max(nn, nr));
                }
                nn = 1;
                nr = 0;
                if (!debug) continue;
                ii = ifmt.size() - 1;
                s = String.format("  [%3d] S%3d (16 * %2d + %2d), nr=%d\n", ii, ifmt.get(ii), ifmt.get(ii) / 16, ifmt.get(ii) - ifmt.get(ii) / 16 * 16, nr);
                System.out.println(s);
                continue;
            }
            if (ch == ')') {
                if (nr >= 0) {
                    throw new EvioException("cannot repeat right parenthesis");
                }
                --lev;
                ifmt.add(0);
                nr = -1;
                if (!debug) continue;
                ii = ifmt.size() - 1;
                s = String.format("  [%3d] S%3d (16 * %2d + %2d), nr=%d\n", ii, ifmt.get(ii), ifmt.get(ii) / 16, ifmt.get(ii) - ifmt.get(ii) / 16 * 16, nr);
                System.out.println(s);
                continue;
            }
            if (ch == ',') {
                if (nr >= 0) {
                    throw new EvioException("cannot repeat comma");
                }
                nr = 0;
                if (!debug) continue;
                System.out.println(String.format("komma, nr=%d", nr));
                continue;
            }
            if (ch == 'N') {
                nn = 0;
                if (!debug) continue;
                System.out.println("nn");
                continue;
            }
            int kf = ch == 'i' ? 1 : (ch == 'F' ? 2 : (ch == 'a' ? 3 : (ch == 'S' ? 4 : (ch == 's' ? 5 : (ch == 'C' ? 6 : (ch == 'c' ? 7 : (ch == 'D' ? 8 : (ch == 'L' ? 9 : (ch == 'l' ? 10 : (ch == 'I' ? 11 : (ch == 'A' ? 12 : 0)))))))))));
            if (kf != 0) {
                if (debug) {
                    System.out.println(String.format("222: nn=%d nr=%d\n", nn, nr));
                }
                if (nr < 0) {
                    throw new EvioException("no negative repeats");
                }
                ifmt.add(16 * CompositeData.max(nn, nr) + kf);
                nn = 1;
                if (debug) {
                    ii = ifmt.size() - 1;
                    s = String.format("  [%3d] S%3d (16 * %2d + %2d), nr=%d\n", ii, ifmt.get(ii), ifmt.get(ii) / 16, ifmt.get(ii) - ifmt.get(ii) / 16 * 16, nr);
                    System.out.println(s);
                }
            } else {
                throw new EvioException("illegal character");
            }
            nr = -1;
        }
        if (lev != 0) {
            throw new EvioException("mismatched number of right/left parentheses");
        }
        if (debug) {
            System.out.println();
        }
        return ifmt;
    }

    public static void swapAll(byte[] src, int srcOff, byte[] dest, int destOff, int length, ByteOrder srcOrder) throws EvioException {
        if (src == null) {
            throw new EvioException("null argument(s)");
        }
        boolean inPlace = false;
        if (dest == null) {
            dest = src;
            inPlace = true;
        }
        if (srcOff < 0 || destOff < 0 || length < 0) {
            throw new EvioException("offsets or length must be >= 0");
        }
        if (dest == src && srcOff != destOff) {
            throw new EvioException("if src = dest, offsets cannot differ");
        }
        ByteOrder destOrder = srcOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        int srcBytesLeft = 4 * length;
        ByteBuffer srcBuffer = ByteBuffer.wrap(src, srcOff, 4 * length);
        ByteBuffer destBuffer = ByteBuffer.wrap(dest, destOff, 4 * length);
        srcBuffer.order(srcOrder);
        destBuffer.order(destOrder);
        while (srcBytesLeft > 0) {
            int dataOffset = 0;
            TagSegmentHeader tsHeader = EventParser.createTagSegmentHeader(src, srcOff + dataOffset, srcOrder);
            int headerLen = tsHeader.getHeaderLength();
            int dataLength = tsHeader.getLength() - (headerLen - 1);
            if (dataLength < 1) {
                throw new EvioException("no format data");
            }
            tsHeader.write(destBuffer);
            String[] strs = BaseStructure.unpackRawBytesToStrings(src, srcOff + (dataOffset += 4 * headerLen));
            if (strs.length < 1) {
                throw new EvioException("bad format string data");
            }
            String format = strs[0];
            List<Integer> formatInts = CompositeData.compositeFormatToInt(format);
            if (formatInts.size() < 1) {
                throw new EvioException("bad format string data");
            }
            if (!inPlace) {
                System.arraycopy(src, srcOff + dataOffset, dest, destOff + dataOffset, 4 * dataLength);
            }
            BankHeader bHeader = EventParser.createBankHeader(src, srcOff + (dataOffset += 4 * dataLength), srcOrder);
            headerLen = bHeader.getHeaderLength();
            dataLength = bHeader.getLength() - (headerLen - 1);
            if (dataLength < 1) {
                throw new EvioException("no data");
            }
            dataLength = 4 * dataLength - bHeader.getPadding();
            destBuffer.position(destOff + dataOffset);
            bHeader.write(destBuffer);
            srcBuffer.position(srcOff + (dataOffset += 4 * headerLen));
            destBuffer.position(destOff + dataOffset);
            CompositeData.swapData(srcBuffer, destBuffer, dataLength, formatInts);
            srcBuffer.position(srcOff + (dataOffset += dataLength));
            destBuffer.position(srcOff + dataOffset);
            srcOff += dataOffset;
            destOff += dataOffset;
            if ((srcBytesLeft -= dataOffset) >= 0) continue;
            throw new EvioException("bad format");
        }
    }

    static void swapAll(ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos, int len, boolean inPlace) throws EvioException {
        int srcBytesLeft = 4 * len;
        while (srcBytesLeft > 0) {
            int dataOffset = 0;
            EvioNode node = new EvioNode();
            ByteDataTransformer.swapTagSegmentHeader(node, srcBuffer, destBuffer, srcPos, destPos);
            destPos += 4;
            dataOffset += 4;
            String[] strs = BaseStructure.unpackRawBytesToStrings(srcBuffer, srcPos += 4, 4 * node.dataLen);
            if (strs.length < 1) {
                throw new EvioException("bad format string data");
            }
            String format = strs[0];
            List<Integer> formatInts = CompositeData.compositeFormatToInt(format);
            if (formatInts.size() < 1) {
                throw new EvioException("bad format string data");
            }
            int byteLen = 4 * node.dataLen;
            if (!inPlace) {
                for (int i = 0; i < byteLen; ++i) {
                    destBuffer.put(destPos + i, srcBuffer.get(srcPos + i));
                }
            }
            dataOffset += byteLen;
            ByteDataTransformer.swapBankHeader(node, srcBuffer, destBuffer, srcPos += byteLen, destPos += byteLen);
            if (node.dataLen < 1) {
                throw new EvioException("no data");
            }
            dataOffset += 8;
            byteLen = 4 * node.dataLen;
            CompositeData.swapData(srcBuffer, destBuffer, srcPos += 8, destPos += 8, byteLen - node.pad, formatInts);
            srcPos += byteLen;
            destPos += byteLen;
            if ((srcBytesLeft -= (dataOffset += byteLen)) >= 0) continue;
            throw new EvioException("bad format");
        }
    }

    public static void swapData(byte[] src, int srcOff, byte[] dest, int destOff, int nBytes, List<Integer> ifmt, ByteOrder srcOrder) throws EvioException {
        if (src == null) {
            throw new EvioException("src arg cannot be null");
        }
        ByteBuffer srcBuf = ByteBuffer.wrap(src, srcOff, nBytes);
        srcBuf.order(srcOrder);
        if (src == dest) {
            if (srcOff != destOff) {
                throw new EvioException("if src = dest, offsets cannot differ");
            }
            dest = null;
        }
        ByteBuffer destBuf = dest == null ? null : ByteBuffer.wrap(dest, destOff, nBytes);
        CompositeData.swapData(srcBuf, destBuf, nBytes, ifmt);
    }

    public static void swapData(ByteBuffer srcBuf, ByteBuffer destBuf, int nBytes, List<Integer> ifmt) throws EvioException {
        CompositeData.swapData(srcBuf, destBuf, srcBuf.position(), destBuf.position(), nBytes, ifmt);
    }

    public static void swapData(ByteBuffer srcBuf, ByteBuffer destBuf, int srcPos, int destPos, int nBytes, List<Integer> ifmt) throws EvioException {
        boolean inPlace;
        boolean debug = false;
        if (ifmt == null || nBytes <= 0) {
            throw new EvioException("bad argument value(s)");
        }
        int nfmt = ifmt.size();
        if (nfmt <= 0) {
            throw new EvioException("empty format list");
        }
        if (destBuf == null) {
            destBuf = srcBuf;
        }
        boolean bl = inPlace = srcBuf == destBuf;
        if (srcPos < 0 || srcPos > srcBuf.capacity() - 8) {
            throw new EvioException("bad value for srcPos arg");
        }
        if (destPos < 0 || destPos > destBuf.capacity() - 8) {
            throw new EvioException("bad value for destPos arg");
        }
        LV[] lv = new LV[10];
        for (int i = 0; i < lv.length; ++i) {
            lv[i] = new LV();
        }
        int imt = 0;
        int ncnf = 0;
        int lev = 0;
        int iterm = 0;
        boolean fromLittleEndian = true;
        if (srcBuf.order() == ByteOrder.BIG_ENDIAN) {
            fromLittleEndian = false;
        }
        int srcEndIndex = srcPos + nBytes;
        if (srcBuf.capacity() < nBytes || destBuf.capacity() < nBytes) {
            throw new EvioException("buffer(s) is(are) too small to handle swap");
        }
        while (srcPos < srcEndIndex) {
            int i;
            int kcnf;
            if (debug) {
                System.out.println(String.format("+++ %d %d\n", srcPos, srcEndIndex));
            }
            while (true) {
                if (++imt > nfmt) {
                    imt = 0;
                    if (!debug) continue;
                    System.out.println("1\n");
                    continue;
                }
                if (ifmt.get(imt - 1) == 0) {
                    ++lv[lev - 1].irepeat;
                    if (lv[lev - 1].irepeat >= lv[lev - 1].nrepeat) {
                        iterm = lv[lev - 1].left - 1;
                        --lev;
                        if (!debug) continue;
                        System.out.println("2\n");
                        continue;
                    }
                    imt = lv[lev - 1].left;
                    if (!debug) continue;
                    System.out.println("3\n");
                    continue;
                }
                ncnf = ifmt.get(imt - 1) / 16;
                kcnf = ifmt.get(imt - 1) - 16 * ncnf;
                if (kcnf == 15) {
                    kcnf = 0;
                    i = srcBuf.getInt(srcPos);
                    if (!fromLittleEndian) {
                        ncnf = i;
                    }
                    destBuf.putInt(destPos, i);
                    if (fromLittleEndian) {
                        ncnf = Integer.reverseBytes(i);
                    }
                    srcPos += 4;
                    destPos += 4;
                    if (debug) {
                        System.out.println("ncnf from data = " + ncnf);
                    }
                }
                if (kcnf != 0) break;
                lv[lev].left = imt;
                lv[lev].nrepeat = ncnf;
                lv[lev].irepeat = 0;
                ++lev;
                if (!debug) continue;
                System.out.println("4\n");
            }
            if (lev == 0) {
                if (debug) {
                    System.out.println("51\n");
                }
            } else if (imt != nfmt - 1) {
                if (debug) {
                    System.out.println(String.format("52: %d %d\n", imt, nfmt - 1));
                }
            } else if (imt != lv[lev - 1].left + 1) {
                if (debug) {
                    System.out.println(String.format("53: %d %d\n", imt, nfmt - 1));
                }
            } else {
                ncnf = 999999999;
                if (debug) {
                    System.out.println("54\n");
                }
            }
            if (ncnf == 0) {
                i = srcBuf.getInt(srcPos);
                if (!fromLittleEndian) {
                    ncnf = i;
                }
                destBuf.putInt(destPos, i);
                if (fromLittleEndian) {
                    ncnf = Integer.reverseBytes(i);
                }
                srcPos += 4;
                destPos += 4;
                if (debug) {
                    System.out.println("ncnf from data = " + ncnf);
                }
            }
            if (kcnf == 8 || kcnf == 9 || kcnf == 10) {
                int b64EndIndex = srcPos + 8 * ncnf;
                if (b64EndIndex > srcEndIndex) {
                    b64EndIndex = srcEndIndex;
                }
                while (srcPos < b64EndIndex) {
                    destBuf.putLong(destPos, srcBuf.getLong(srcPos));
                    srcPos += 8;
                    destPos += 8;
                }
                if (!debug) continue;
                System.out.println("64bit: %d elements " + ncnf);
                continue;
            }
            if (kcnf == 1 || kcnf == 2 || kcnf == 11 || kcnf == 12) {
                int b32EndIndex = srcPos + 4 * ncnf;
                if (b32EndIndex > srcEndIndex) {
                    b32EndIndex = srcEndIndex;
                }
                while (srcPos < b32EndIndex) {
                    destBuf.putInt(destPos, srcBuf.getInt(srcPos));
                    srcPos += 4;
                    destPos += 4;
                }
                if (!debug) continue;
                System.out.println("32bit: %d elements " + ncnf);
                continue;
            }
            if (kcnf == 4 || kcnf == 5) {
                int b16EndIndex = srcPos + 2 * ncnf;
                if (b16EndIndex > srcEndIndex) {
                    b16EndIndex = srcEndIndex;
                }
                while (srcPos < b16EndIndex) {
                    destBuf.putShort(destPos, srcBuf.getShort(srcPos));
                    srcPos += 2;
                    destPos += 2;
                }
                if (!debug) continue;
                System.out.println("16bit: %d elements " + ncnf);
                continue;
            }
            if (kcnf != 6 && kcnf != 7 && kcnf != 3) continue;
            if (!inPlace) {
                for (int j = 0; j < ncnf; ++j) {
                    destBuf.put(destPos + j, srcBuf.get(srcPos + j));
                }
            }
            srcPos += ncnf;
            destPos += ncnf;
            if (!debug) continue;
            System.out.println("C: %d elements " + ncnf);
        }
    }

    public static void dataToRawBytes(ByteBuffer rawBuf, Data data, List<Integer> ifmt) throws EvioException {
        boolean debug = false;
        if (ifmt == null || data == null || rawBuf == null) {
            throw new EvioException("arg is null");
        }
        int nfmt = ifmt.size();
        if (nfmt <= 0) {
            throw new EvioException("empty format list");
        }
        class LV {
            int left;
            int nrepeat;
            int irepeat;

            LV() {
            }
        }
        LV[] lv = new LV[10];
        for (int i = 0; i < lv.length; ++i) {
            lv[i] = new LV();
        }
        int imt = 0;
        int ncnf = 0;
        int lev = 0;
        int iterm = 0;
        int itemIndex = 0;
        int itemCount = data.dataItems.size();
        itemIndex = 0;
        block15: while (itemIndex < itemCount) {
            int kcnf;
            while (true) {
                if (++imt > nfmt) {
                    imt = 0;
                    continue;
                }
                if (ifmt.get(imt - 1) == 0) {
                    ++lv[lev - 1].irepeat;
                    if (lv[lev - 1].irepeat >= lv[lev - 1].nrepeat) {
                        iterm = lv[lev - 1].left - 1;
                        --lev;
                        continue;
                    }
                    imt = lv[lev - 1].left;
                    continue;
                }
                ncnf = ifmt.get(imt - 1) / 16;
                kcnf = ifmt.get(imt - 1) - 16 * ncnf;
                if (kcnf == 15) {
                    kcnf = 0;
                    if (data.dataTypes.get(itemIndex) != DataType.INT32) {
                        throw new EvioException("Data type mismatch");
                    }
                    ncnf = (Integer)data.dataItems.get(itemIndex++);
                    if (debug) {
                        System.out.println("N 1 from list = " + ncnf);
                    }
                    rawBuf.putInt(ncnf);
                }
                if (kcnf != 0) break;
                lv[lev].left = imt;
                lv[lev].nrepeat = ncnf;
                lv[lev].irepeat = 0;
                ++lev;
            }
            if (lev != 0 && imt == nfmt - 1 && imt == lv[lev - 1].left + 1) {
                ncnf = 999999999;
            }
            if (ncnf == 0) {
                if (data.dataTypes.get(itemIndex) != DataType.INT32) {
                    throw new EvioException("Data type mismatch");
                }
                ncnf = (Integer)data.dataItems.get(itemIndex++);
                rawBuf.putInt(ncnf);
                if (debug) {
                    System.out.println("N 2 from list = " + ncnf);
                }
            }
            if (debug) {
                System.out.println("Convert data of type = " + kcnf + ", itemIndex = " + itemIndex);
            }
            switch (kcnf) {
                case 8: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.DOUBLE64) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putDouble((Double)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 9: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.LONG64) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putLong((Long)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 10: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.ULONG64) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putLong((Long)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 11: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.INT32) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putInt((Integer)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 1: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.UINT32) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putInt((Integer)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 2: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.FLOAT32) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putFloat(((Float)data.dataItems.get(itemIndex++)).floatValue());
                    }
                    continue block15;
                }
                case 12: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.HOLLERIT) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putInt((Integer)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 4: {
                    if (debug) {
                        System.out.println("Putting " + ncnf + " shorts into raw buffer");
                    }
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.SHORT16) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putShort((Short)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 5: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.USHORT16) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.putShort((Short)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 6: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.CHAR8) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.put((Byte)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 7: {
                    for (int j = 0; j < ncnf; ++j) {
                        if (data.dataTypes.get(itemIndex) != DataType.UCHAR8) {
                            throw new EvioException("Data type mismatch");
                        }
                        rawBuf.put((Byte)data.dataItems.get(itemIndex++));
                    }
                    continue block15;
                }
                case 3: {
                    if (data.dataTypes.get(itemIndex) != DataType.CHARSTAR8) {
                        throw new EvioException("Data type mismatch");
                    }
                    String[] strs = (String[])data.dataItems.get(itemIndex++);
                    byte[] rb = BaseStructure.stringsToRawBytes(strs);
                    rawBuf.put(rb);
                    if (ncnf == rb.length) break;
                    throw new EvioException("String format mismatch with string (array)");
                }
            }
        }
    }

    public void process() {
        boolean debug = false;
        int nfmt = this.formatInts.size();
        boolean swap = false;
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            swap = true;
        }
        this.items = new ArrayList<Object>(100);
        this.types = new ArrayList<DataType>(100);
        this.nList = new ArrayList<Integer>(100);
        class LV {
            int left;
            int nrepeat;
            int irepeat;

            LV() {
            }
        }
        LV[] lv = new LV[10];
        for (int i = 0; i < lv.length; ++i) {
            lv[i] = new LV();
        }
        int imt = 0;
        int ncnf = 0;
        int lev = 0;
        int iterm = 0;
        int dataIndex = 0;
        int endIndex = this.dataBytes;
        while (dataIndex < endIndex) {
            int i;
            int kcnf;
            if (debug) {
                System.out.println(String.format("+++ %d %d\n", dataIndex, endIndex));
            }
            while (true) {
                if (++imt > nfmt) {
                    imt = 0;
                    continue;
                }
                if (this.formatInts.get(imt - 1) == 0) {
                    ++lv[lev - 1].irepeat;
                    if (lv[lev - 1].irepeat >= lv[lev - 1].nrepeat) {
                        iterm = lv[lev - 1].left - 1;
                        --lev;
                        continue;
                    }
                    imt = lv[lev - 1].left;
                    continue;
                }
                ncnf = this.formatInts.get(imt - 1) / 16;
                kcnf = this.formatInts.get(imt - 1) - 16 * ncnf;
                if (kcnf == 15) {
                    kcnf = 0;
                    i = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i = Integer.reverseBytes(i);
                    }
                    ncnf = i;
                    this.nList.add(i);
                    this.items.add(i);
                    this.types.add(DataType.NVALUE);
                    dataIndex += 4;
                }
                if (kcnf != 0) break;
                lv[lev].left = imt;
                lv[lev].nrepeat = ncnf;
                lv[lev].irepeat = 0;
                ++lev;
            }
            if (lev != 0 && imt == nfmt - 1 && imt == lv[lev - 1].left + 1) {
                ncnf = 999999999;
            }
            if (ncnf == 0) {
                i = this.dataBuffer.getInt(dataIndex);
                if (swap) {
                    i = Integer.reverseBytes(i);
                }
                ncnf = i;
                this.nList.add(i);
                this.items.add(i);
                this.types.add(DataType.NVALUE);
                dataIndex += 4;
            }
            if (kcnf == 8 || kcnf == 9 || kcnf == 10) {
                int b64EndIndex = dataIndex + 8 * ncnf;
                if (b64EndIndex > endIndex) {
                    b64EndIndex = endIndex;
                }
                while (dataIndex < b64EndIndex) {
                    long lng = this.dataBuffer.getLong(dataIndex);
                    if (swap) {
                        lng = Long.reverseBytes(lng);
                    }
                    this.types.add(DataType.getDataType(kcnf));
                    if (kcnf == 8) {
                        this.items.add(Double.longBitsToDouble(lng));
                    } else {
                        this.items.add(lng);
                    }
                    dataIndex += 8;
                }
                continue;
            }
            if (kcnf == 1 || kcnf == 2 || kcnf == 11 || kcnf == 12) {
                int b32EndIndex = dataIndex + 4 * ncnf;
                if (b32EndIndex > endIndex) {
                    b32EndIndex = endIndex;
                }
                while (dataIndex < b32EndIndex) {
                    i = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i = Integer.reverseBytes(i);
                    }
                    if (kcnf == 12) {
                        this.types.add(DataType.HOLLERIT);
                        this.items.add(i);
                    } else if (kcnf == 2) {
                        this.types.add(DataType.getDataType(kcnf));
                        this.items.add(Float.valueOf(Float.intBitsToFloat(i)));
                    } else {
                        this.types.add(DataType.getDataType(kcnf));
                        this.items.add(i);
                    }
                    dataIndex += 4;
                }
                continue;
            }
            if (kcnf == 4 || kcnf == 5) {
                int b16EndIndex = dataIndex + 2 * ncnf;
                if (b16EndIndex > endIndex) {
                    b16EndIndex = endIndex;
                }
                while (dataIndex < b16EndIndex) {
                    short s = this.dataBuffer.getShort(dataIndex);
                    if (swap) {
                        s = Short.reverseBytes(s);
                    }
                    this.types.add(DataType.getDataType(kcnf));
                    this.items.add(s);
                    dataIndex += 2;
                }
                continue;
            }
            if (kcnf != 6 && kcnf != 7 && kcnf != 3) continue;
            int b8EndIndex = dataIndex + ncnf;
            if (b8EndIndex > endIndex) {
                b8EndIndex = endIndex;
                ncnf = endIndex - b8EndIndex;
            }
            this.dataBuffer.position(dataIndex);
            byte[] bytes = new byte[ncnf];
            this.dataBuffer.get(bytes);
            if (kcnf == 3) {
                String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
                this.items.add(strs);
            } else {
                for (int i2 = 0; i2 < ncnf; ++i2) {
                    this.items.add(bytes[i2]);
                }
            }
            this.dataBuffer.position(0);
            this.types.add(DataType.getDataType(kcnf));
            dataIndex += ncnf;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        this.getIndex = 0;
        StringBuilder sb = new StringBuilder(1024);
        int numItems = this.items.size();
        for (int i = 0; i < numItems; ++i) {
            if (i % 5 == 0) {
                sb.append(indent);
            }
            switch (this.types.get(i)) {
                case INT32: {
                    sb.append("I=");
                    sb.append(this.getInt());
                    break;
                }
                case UINT32: {
                    sb.append("i=");
                    sb.append(this.getInt());
                    break;
                }
                case HOLLERIT: {
                    sb.append("A=");
                    sb.append(this.getInt());
                    break;
                }
                case CHAR8: {
                    sb.append("C=");
                    sb.append(this.getByte());
                    break;
                }
                case UCHAR8: {
                    sb.append("c=");
                    sb.append(this.getByte());
                    break;
                }
                case SHORT16: {
                    sb.append("S=");
                    sb.append(this.getShort());
                    break;
                }
                case USHORT16: {
                    sb.append("s=");
                    sb.append(this.getShort());
                    break;
                }
                case LONG64: {
                    sb.append("L=");
                    sb.append(this.getLong());
                    break;
                }
                case ULONG64: {
                    sb.append("l=");
                    sb.append(this.getLong());
                    break;
                }
                case DOUBLE64: {
                    sb.append("D=");
                    sb.append(this.getDouble());
                    break;
                }
                case FLOAT32: {
                    sb.append("F=");
                    sb.append(this.getFloat());
                    break;
                }
                case CHARSTAR8: {
                    sb.append("a=");
                    String[] strs = this.getStrings();
                    for (int j = 0; j < strs.length; ++j) {
                        sb.append(strs[j]);
                        if (j >= strs.length - 1) continue;
                        sb.append(",");
                    }
                    break;
                }
            }
            if (i < numItems - 1) {
                sb.append(", ");
            }
            if ((i + 1) % 5 != 0 || i >= numItems - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public void toXML(XMLStreamWriter xmlWriter, BaseStructure bs, boolean hex) throws XMLStreamException {
        boolean debug = false;
        int nfmt = this.formatInts.size();
        boolean swap = false;
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            swap = true;
        }
        LV[] lv = new LV[10];
        for (int i = 0; i < lv.length; ++i) {
            lv[i] = new LV();
        }
        int imt = 0;
        int ncnf = 0;
        int lev = 0;
        int iterm = 0;
        int rowNumber = 2;
        int dataIndex = 0;
        int endIndex = this.dataBytes;
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeStartElement("composite");
        bs.increaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeStartElement("string");
        xmlWriter.writeAttribute("data_type", "0x3");
        xmlWriter.writeAttribute("tag", "" + this.tsHeader.tag);
        xmlWriter.writeAttribute("length", "" + this.tsHeader.length);
        xmlWriter.writeAttribute("ndata", "1");
        bs.increaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeCharacters(this.format);
        bs.decreaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeEndElement();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeStartElement("data");
        bs.increaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeStartElement("row");
        xmlWriter.writeAttribute("num", "1");
        bs.increaseXmlIndent();
        while (dataIndex < endIndex) {
            int i;
            boolean oneLine;
            int i2;
            int kcnf;
            while (true) {
                if (++imt > nfmt) {
                    imt = 0;
                    bs.decreaseXmlIndent();
                    xmlWriter.writeCharacters("\n");
                    xmlWriter.writeCharacters(bs.xmlIndent);
                    xmlWriter.writeEndElement();
                    xmlWriter.writeCharacters("\n");
                    xmlWriter.writeCharacters(bs.xmlIndent);
                    xmlWriter.writeStartElement("row");
                    xmlWriter.writeAttribute("num", "" + rowNumber++);
                    bs.increaseXmlIndent();
                    continue;
                }
                if (this.formatInts.get(imt - 1) == 0) {
                    ++lv[lev - 1].irepeat;
                    if (lv[lev - 1].irepeat >= lv[lev - 1].nrepeat) {
                        iterm = lv[lev - 1].left - 1;
                        --lev;
                        bs.decreaseXmlIndent();
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCharacters(bs.xmlIndent);
                        xmlWriter.writeEndElement();
                        continue;
                    }
                    imt = lv[lev - 1].left;
                    xmlWriter.writeCharacters("\n");
                    continue;
                }
                ncnf = this.formatInts.get(imt - 1) / 16;
                kcnf = this.formatInts.get(imt - 1) - 16 * ncnf;
                if (kcnf == 15) {
                    kcnf = 0;
                    i2 = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i2 = Integer.reverseBytes(i2);
                    }
                    ncnf = i2;
                    dataIndex += 4;
                }
                if (kcnf != 0) break;
                lv[lev].left = imt;
                lv[lev].nrepeat = ncnf;
                lv[lev].irepeat = 0;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                xmlWriter.writeStartElement("repeat");
                xmlWriter.writeAttribute("count", "" + ncnf);
                bs.increaseXmlIndent();
                ++lev;
            }
            if (lev != 0 && imt == nfmt - 1 && imt == lv[lev - 1].left + 1) {
                ncnf = 999999999;
            }
            if (ncnf == 0) {
                i2 = this.dataBuffer.getInt(dataIndex);
                if (swap) {
                    i2 = Integer.reverseBytes(i2);
                }
                ncnf = i2;
                dataIndex += 4;
            }
            if (kcnf == 8 || kcnf == 9 || kcnf == 10) {
                int count = 1;
                int itemsOnLine = 2;
                boolean oneLine2 = ncnf <= itemsOnLine;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                if (kcnf == 8) {
                    xmlWriter.writeStartElement("double");
                } else if (kcnf == 9) {
                    xmlWriter.writeStartElement("int64");
                } else if (kcnf == 10) {
                    xmlWriter.writeStartElement("uint64");
                }
                xmlWriter.writeAttribute("count", "" + ncnf);
                if (!oneLine2) {
                    bs.increaseXmlIndent();
                    xmlWriter.writeCharacters("\n");
                } else {
                    xmlWriter.writeCharacters(" ");
                }
                int b64EndIndex = dataIndex + 8 * ncnf;
                if (b64EndIndex > endIndex) {
                    b64EndIndex = endIndex;
                }
                while (dataIndex < b64EndIndex) {
                    long lng = this.dataBuffer.getLong(dataIndex);
                    if (swap) {
                        lng = Long.reverseBytes(lng);
                    }
                    if (!oneLine2 && count % itemsOnLine == 1) {
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                    if (kcnf == 8) {
                        double d = Double.longBitsToDouble(lng);
                        if (debug) {
                            System.out.println("write double " + d);
                        }
                        xmlWriter.writeCharacters(String.format("%23.16g ", d));
                    } else {
                        if (debug) {
                            System.out.println("write long " + lng);
                        }
                        if (hex) {
                            xmlWriter.writeCharacters(String.format("0x%016x ", lng));
                        } else {
                            xmlWriter.writeCharacters(String.format("%18d ", lng));
                        }
                    }
                    if (count++ % itemsOnLine == 0) {
                        xmlWriter.writeCharacters("\n");
                    }
                    dataIndex += 8;
                }
                if (!oneLine2) {
                    bs.decreaseXmlIndent();
                    if ((count - 1) % itemsOnLine != 0) {
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                }
                xmlWriter.writeEndElement();
                continue;
            }
            if (kcnf == 1 || kcnf == 2 || kcnf == 11 || kcnf == 12) {
                int count = 1;
                int itemsOnLine = 4;
                oneLine = ncnf <= itemsOnLine;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                if (kcnf == 2) {
                    xmlWriter.writeStartElement("float");
                } else if (kcnf == 1) {
                    xmlWriter.writeStartElement("uint32");
                } else if (kcnf == 11) {
                    xmlWriter.writeStartElement("int32");
                } else {
                    xmlWriter.writeStartElement("Hollerit");
                }
                xmlWriter.writeAttribute("count", "" + ncnf);
                if (!oneLine) {
                    bs.increaseXmlIndent();
                    xmlWriter.writeCharacters("\n");
                } else {
                    xmlWriter.writeCharacters(" ");
                }
                int b32EndIndex = dataIndex + 4 * ncnf;
                if (b32EndIndex > endIndex) {
                    b32EndIndex = endIndex;
                }
                while (dataIndex < b32EndIndex) {
                    i = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i = Integer.reverseBytes(i);
                    }
                    if (!oneLine && count % itemsOnLine == 1) {
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                    if (kcnf == 2) {
                        float f = Float.intBitsToFloat(i);
                        if (debug) {
                            System.out.println("write float " + f);
                        }
                        xmlWriter.writeCharacters(String.format("%14.8g ", Float.valueOf(f)));
                    } else {
                        if (debug) {
                            System.out.println("write int " + i);
                        }
                        if (hex) {
                            xmlWriter.writeCharacters(String.format("0x%08x ", i));
                        } else {
                            xmlWriter.writeCharacters(String.format("%10d ", i));
                        }
                    }
                    if (count++ % itemsOnLine == 0) {
                        xmlWriter.writeCharacters("\n");
                    }
                    dataIndex += 4;
                }
                if (!oneLine) {
                    bs.decreaseXmlIndent();
                    if ((count - 1) % itemsOnLine != 0) {
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                }
                xmlWriter.writeEndElement();
                continue;
            }
            if (kcnf == 4 || kcnf == 5) {
                int count = 1;
                int itemsOnLine = 6;
                oneLine = ncnf <= itemsOnLine;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                if (kcnf == 4) {
                    xmlWriter.writeStartElement("int16");
                } else if (kcnf == 5) {
                    xmlWriter.writeStartElement("uint16");
                }
                xmlWriter.writeAttribute("count", "" + ncnf);
                if (!oneLine) {
                    bs.increaseXmlIndent();
                    xmlWriter.writeCharacters("\n");
                } else {
                    xmlWriter.writeCharacters(" ");
                }
                int b16EndIndex = dataIndex + 2 * ncnf;
                if (b16EndIndex > endIndex) {
                    b16EndIndex = endIndex;
                }
                while (dataIndex < b16EndIndex) {
                    short s = this.dataBuffer.getShort(dataIndex);
                    if (swap) {
                        s = Short.reverseBytes(s);
                    }
                    if (debug) {
                        System.out.println("write short " + s);
                    }
                    if (!oneLine && count % itemsOnLine == 1) {
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                    if (hex) {
                        xmlWriter.writeCharacters(String.format("0x%04x ", s));
                    } else {
                        xmlWriter.writeCharacters(String.format("%6d ", s));
                    }
                    if (count++ % itemsOnLine == 0) {
                        xmlWriter.writeCharacters("\n");
                    }
                    dataIndex += 2;
                }
                if (!oneLine) {
                    bs.decreaseXmlIndent();
                    if ((count - 1) % itemsOnLine != 0) {
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                }
                xmlWriter.writeEndElement();
                continue;
            }
            if (kcnf != 6 && kcnf != 7 && kcnf != 3) continue;
            this.dataBuffer.position(dataIndex);
            byte[] bytes = new byte[ncnf];
            this.dataBuffer.get(bytes);
            if (kcnf == 3) {
                String[] strs;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                xmlWriter.writeStartElement("string");
                xmlWriter.writeAttribute("count", "" + ncnf);
                bs.increaseXmlIndent();
                xmlWriter.writeCharacters("\n");
                for (String s : strs = BaseStructure.unpackRawBytesToStrings(bytes, 0)) {
                    xmlWriter.writeCharacters(bs.xmlIndent);
                    xmlWriter.writeCharacters(s);
                    xmlWriter.writeCharacters("\n");
                }
                bs.decreaseXmlIndent();
                xmlWriter.writeCharacters(bs.xmlIndent);
                xmlWriter.writeEndElement();
            } else {
                int count = 1;
                int itemsOnLine = 8;
                oneLine = ncnf <= itemsOnLine;
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(bs.xmlIndent);
                if (kcnf == 6) {
                    xmlWriter.writeStartElement("int8");
                } else if (kcnf == 7) {
                    xmlWriter.writeStartElement("uint8");
                }
                xmlWriter.writeAttribute("count", "" + ncnf);
                if (!oneLine) {
                    bs.increaseXmlIndent();
                    xmlWriter.writeCharacters("\n");
                } else {
                    xmlWriter.writeCharacters(" ");
                }
                for (i = 0; i < ncnf; ++i) {
                    if (!oneLine && count % itemsOnLine == 1) {
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                    if (debug) {
                        System.out.println("write byte " + bytes[i]);
                    }
                    if (hex) {
                        xmlWriter.writeCharacters(String.format("0x%02x ", bytes[i]));
                    } else {
                        xmlWriter.writeCharacters(String.format("%4d ", bytes[i]));
                    }
                    if (count++ % itemsOnLine != 0) continue;
                    xmlWriter.writeCharacters("\n");
                }
                if (!oneLine) {
                    bs.decreaseXmlIndent();
                    if ((count - 1) % itemsOnLine != 0) {
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCharacters(bs.xmlIndent);
                    }
                }
                xmlWriter.writeEndElement();
            }
            this.dataBuffer.position(0);
            dataIndex += ncnf;
        }
        bs.decreaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeEndElement();
        bs.decreaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeEndElement();
        bs.decreaseXmlIndent();
        xmlWriter.writeCharacters("\n");
        xmlWriter.writeCharacters(bs.xmlIndent);
        xmlWriter.writeEndElement();
    }

    public String toString(boolean hex) {
        StringBuilder sb = new StringBuilder(1000);
        int nfmt = this.formatInts.size();
        boolean swap = false;
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            swap = true;
        }
        class LV {
            int left;
            int nrepeat;
            int irepeat;

            LV() {
            }
        }
        LV[] lv = new LV[10];
        for (int i = 0; i < lv.length; ++i) {
            lv[i] = new LV();
        }
        int imt = 0;
        int ncnf = 0;
        int lev = 0;
        int iterm = 0;
        int dataIndex = 0;
        int endIndex = this.dataBytes;
        sb.append(this.format);
        sb.append("\n");
        while (dataIndex < endIndex) {
            int i;
            int i2;
            int kcnf;
            while (true) {
                if (++imt > nfmt) {
                    imt = 0;
                    sb.append("\n");
                    continue;
                }
                if (this.formatInts.get(imt - 1) == 0) {
                    ++lv[lev - 1].irepeat;
                    if (lv[lev - 1].irepeat >= lv[lev - 1].nrepeat) {
                        iterm = lv[lev - 1].left - 1;
                        --lev;
                        continue;
                    }
                    imt = lv[lev - 1].left;
                    sb.append("\n");
                    continue;
                }
                ncnf = this.formatInts.get(imt - 1) / 16;
                kcnf = this.formatInts.get(imt - 1) - 16 * ncnf;
                if (kcnf == 15) {
                    kcnf = 0;
                    i2 = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i2 = Integer.reverseBytes(i2);
                    }
                    ncnf = i2;
                    dataIndex += 4;
                }
                if (kcnf != 0) break;
                lv[lev].left = imt;
                lv[lev].nrepeat = ncnf;
                lv[lev].irepeat = 0;
                sb.append("\n");
                ++lev;
            }
            if (lev != 0 && imt == nfmt - 1 && imt == lv[lev - 1].left + 1) {
                ncnf = 999999999;
            }
            if (ncnf == 0) {
                i2 = this.dataBuffer.getInt(dataIndex);
                if (swap) {
                    i2 = Integer.reverseBytes(i2);
                }
                ncnf = i2;
                dataIndex += 4;
            }
            if (kcnf == 8 || kcnf == 9 || kcnf == 10) {
                int count = 1;
                int itemsOnLine = 2;
                sb.append("\n");
                int b64EndIndex = dataIndex + 8 * ncnf;
                if (b64EndIndex > endIndex) {
                    b64EndIndex = endIndex;
                }
                while (dataIndex < b64EndIndex) {
                    long lng = this.dataBuffer.getLong(dataIndex);
                    if (swap) {
                        lng = Long.reverseBytes(lng);
                    }
                    if (kcnf == 8) {
                        double d = Double.longBitsToDouble(lng);
                        sb.append(String.format("%-23.16g ", d));
                    } else if (hex) {
                        sb.append(String.format("0x%016x  ", lng));
                    } else {
                        sb.append(String.format("%-18d ", lng));
                    }
                    if (count++ % itemsOnLine == 0) {
                        sb.append("\n");
                    }
                    dataIndex += 8;
                }
                if ((count - 1) % itemsOnLine == 0) continue;
                sb.append("\n");
                continue;
            }
            if (kcnf == 1 || kcnf == 2 || kcnf == 11 || kcnf == 12) {
                int count = 1;
                int itemsOnLine = 4;
                sb.append("\n");
                int b32EndIndex = dataIndex + 4 * ncnf;
                if (b32EndIndex > endIndex) {
                    b32EndIndex = endIndex;
                }
                while (dataIndex < b32EndIndex) {
                    i = this.dataBuffer.getInt(dataIndex);
                    if (swap) {
                        i = Integer.reverseBytes(i);
                    }
                    if (kcnf == 2) {
                        float f = Float.intBitsToFloat(i);
                        sb.append(String.format("%-14.8g ", Float.valueOf(f)));
                    } else if (hex) {
                        sb.append(String.format("0x%08x  ", i));
                    } else {
                        sb.append(String.format("%-10d ", i));
                    }
                    if (count++ % itemsOnLine == 0) {
                        sb.append("\n");
                    }
                    dataIndex += 4;
                }
                if ((count - 1) % itemsOnLine == 0) continue;
                sb.append("\n");
                continue;
            }
            if (kcnf == 4 || kcnf == 5) {
                int count = 1;
                int itemsOnLine = 6;
                sb.append("\n");
                int b16EndIndex = dataIndex + 2 * ncnf;
                if (b16EndIndex > endIndex) {
                    b16EndIndex = endIndex;
                }
                while (dataIndex < b16EndIndex) {
                    short s = this.dataBuffer.getShort(dataIndex);
                    if (swap) {
                        s = Short.reverseBytes(s);
                    }
                    if (hex) {
                        sb.append(String.format("0x%04x  ", s));
                    } else {
                        sb.append(String.format("%-6d ", s));
                    }
                    if (count++ % itemsOnLine == 0) {
                        sb.append("\n");
                    }
                    dataIndex += 2;
                }
                if ((count - 1) % itemsOnLine == 0) continue;
                sb.append("\n");
                continue;
            }
            if (kcnf != 6 && kcnf != 7 && kcnf != 3) continue;
            this.dataBuffer.position(dataIndex);
            byte[] bytes = new byte[ncnf];
            this.dataBuffer.get(bytes);
            if (kcnf == 3) {
                String[] strs;
                sb.append("\n");
                for (String s : strs = BaseStructure.unpackRawBytesToStrings(bytes, 0)) {
                    sb.append(s);
                    sb.append("\n");
                }
            } else {
                int count = 1;
                int itemsOnLine = 8;
                sb.append("\n");
                for (i = 0; i < ncnf; ++i) {
                    if (hex) {
                        sb.append(String.format("0x%02x  ", bytes[i]));
                    } else {
                        sb.append(String.format("%-4d ", bytes[i]));
                    }
                    if (count++ % itemsOnLine != 0) continue;
                    sb.append("\n");
                }
                if ((count - 1) % itemsOnLine != 0) {
                    sb.append("\n");
                }
            }
            this.dataBuffer.position(0);
            dataIndex += ncnf;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static class Data {
        private int dataBytes;
        private int paddingBytes;
        private int[] pads = new int[]{0, 3, 2, 1};
        private ArrayList<Object> dataItems = new ArrayList(100);
        private ArrayList<DataType> dataTypes = new ArrayList(100);
        private ArrayList<Integer> nList = new ArrayList(100);

        private void addBytesToData(int bytes) {
            this.dataBytes += bytes;
            this.paddingBytes = this.pads[this.dataBytes % 4];
        }

        public synchronized int getDataSize() {
            return this.dataBytes + this.paddingBytes;
        }

        public synchronized int getPadding() {
            return this.paddingBytes;
        }

        public synchronized void addN(int N) {
            this.nList.add(N);
            this.dataItems.add(N);
            this.dataTypes.add(DataType.INT32);
            this.addBytesToData(4);
        }

        public synchronized void addInt(int i) {
            this.dataItems.add(i);
            this.dataTypes.add(DataType.INT32);
            this.addBytesToData(4);
        }

        public synchronized void addInt(int[] i) {
            for (int ii : i) {
                this.dataItems.add(ii);
                this.dataTypes.add(DataType.INT32);
            }
            this.addBytesToData(4 * i.length);
        }

        public synchronized void addUint(int i) {
            this.dataItems.add(i);
            this.dataTypes.add(DataType.UINT32);
            this.addBytesToData(4);
        }

        public synchronized void addUint(int[] i) {
            for (int ii : i) {
                this.dataItems.add(ii);
                this.dataTypes.add(DataType.UINT32);
            }
            this.addBytesToData(4 * i.length);
        }

        public synchronized void addShort(short s) {
            this.dataItems.add(s);
            this.dataTypes.add(DataType.SHORT16);
            this.addBytesToData(2);
        }

        public synchronized void addShort(short[] s) {
            for (short ss : s) {
                this.dataItems.add(ss);
                this.dataTypes.add(DataType.SHORT16);
            }
            this.addBytesToData(2 * s.length);
        }

        public synchronized void addUshort(short s) {
            this.dataItems.add(s);
            this.dataTypes.add(DataType.USHORT16);
            this.addBytesToData(2);
        }

        public synchronized void addUshort(short[] s) {
            for (short ss : s) {
                this.dataItems.add(ss);
                this.dataTypes.add(DataType.USHORT16);
            }
            this.addBytesToData(2 * s.length);
        }

        public synchronized void addLong(long l) {
            this.dataItems.add(l);
            this.dataTypes.add(DataType.LONG64);
            this.addBytesToData(8);
        }

        public synchronized void addLong(long[] l) {
            for (long ll : l) {
                this.dataItems.add(ll);
                this.dataTypes.add(DataType.LONG64);
            }
            this.addBytesToData(8 * l.length);
        }

        public synchronized void addUlong(long l) {
            this.dataItems.add(l);
            this.dataTypes.add(DataType.ULONG64);
            this.addBytesToData(8);
        }

        public synchronized void addUlong(long[] l) {
            for (long ll : l) {
                this.dataItems.add(ll);
                this.dataTypes.add(DataType.ULONG64);
            }
            this.addBytesToData(8 * l.length);
        }

        public synchronized void addChar(byte b) {
            this.dataItems.add(b);
            this.dataTypes.add(DataType.CHAR8);
            this.addBytesToData(1);
        }

        public synchronized void addChar(byte[] b) {
            for (byte bb : b) {
                this.dataItems.add(bb);
                this.dataTypes.add(DataType.CHAR8);
            }
            this.addBytesToData(b.length);
        }

        public synchronized void addUchar(byte b) {
            this.dataItems.add(b);
            this.dataTypes.add(DataType.UCHAR8);
            this.addBytesToData(1);
        }

        public synchronized void addUchar(byte[] b) {
            for (byte bb : b) {
                this.dataItems.add(bb);
                this.dataTypes.add(DataType.UCHAR8);
            }
            this.addBytesToData(b.length);
        }

        public synchronized void addFloat(float f) {
            this.dataItems.add(Float.valueOf(f));
            this.dataTypes.add(DataType.FLOAT32);
            this.addBytesToData(4);
        }

        public synchronized void addFloat(float[] f) {
            for (float ff : f) {
                this.dataItems.add(Float.valueOf(ff));
                this.dataTypes.add(DataType.FLOAT32);
            }
            this.addBytesToData(4 * f.length);
        }

        public synchronized void addDouble(double d) {
            this.dataItems.add(d);
            this.dataTypes.add(DataType.DOUBLE64);
            this.addBytesToData(8);
        }

        public synchronized void addDouble(double[] d) {
            for (double dd : d) {
                this.dataItems.add(dd);
                this.dataTypes.add(DataType.DOUBLE64);
            }
            this.addBytesToData(8 * d.length);
        }

        public synchronized void addString(String s) {
            String[] ss = new String[]{s};
            this.dataItems.add(ss);
            this.dataTypes.add(DataType.CHARSTAR8);
            this.addBytesToData(BaseStructure.stringsToRawSize(ss));
        }

        public synchronized void addString(String[] s) {
            this.dataItems.add(s);
            this.dataTypes.add(DataType.CHARSTAR8);
            this.addBytesToData(BaseStructure.stringsToRawSize(s));
        }
    }

    static class LV {
        int left;
        int nrepeat;
        int irepeat;

        LV() {
        }
    }
}

