/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioWriter;

public class BlockHeaderV2
implements IEvioWriter,
IBlockHeader {
    public static final int MAX_BLOCK_SIZE = 32768;
    private int size;
    private int number;
    private int headerLength;
    private int start;
    private int end;
    private int version;
    private int reserved1;
    private int magicNumber;
    private long bufferStartingPosition = -1L;

    @Override
    public int getSize() {
        return this.size;
    }

    public BlockHeaderV2() {
        this.size = 0;
        this.number = 0;
        this.headerLength = 0;
        this.start = 0;
        this.end = 0;
        this.version = 0;
        this.reserved1 = 0;
        this.magicNumber = 0;
    }

    public BlockHeaderV2(int size, int number) {
        this.size = size;
        this.number = number;
        this.headerLength = 8;
        this.start = 8;
        this.end = size;
        this.version = 2;
        this.reserved1 = 0;
        this.magicNumber = -1059454720;
    }

    public BlockHeaderV2(BlockHeaderV2 blkHeader) {
        if (blkHeader == null) {
            return;
        }
        this.size = blkHeader.size;
        this.number = blkHeader.number;
        this.headerLength = blkHeader.headerLength;
        this.version = blkHeader.version;
        this.end = blkHeader.end;
        this.start = blkHeader.start;
        this.reserved1 = blkHeader.reserved1;
        this.magicNumber = blkHeader.magicNumber;
        this.bufferStartingPosition = blkHeader.bufferStartingPosition;
    }

    public Object clone() {
        return new BlockHeaderV2(this);
    }

    @Override
    public boolean hasDictionary() {
        return false;
    }

    @Override
    public boolean isLastBlock() {
        return false;
    }

    public void setSize(int size) throws EvioException {
        if (size < 8 || size > 32768) {
            throw new EvioException(String.format("Bad value for size in block (physical record) header: %d", size));
        }
        if (size % 256 != 0) {
            throw new EvioException(String.format("Bad value for size in block (physical record) header: %d (must be multiple of 256 ints)", size));
        }
        this.size = size;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) throws EvioException {
        if (start < 0 || start > 32768) {
            throw new EvioException(String.format("Bad value for start in block (physical record) header: %d", start));
        }
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) throws EvioException {
        if (end < 8 || end > 32768) {
            throw new EvioException(String.format("Bad value for end in block (physical record) header: %d", end));
        }
        this.end = end;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int headerLength) throws EvioException {
        if (headerLength != 8) {
            String message = "Bad Block (Physical Record) Header Length: " + headerLength;
            throw new EvioException(message);
        }
        this.headerLength = headerLength;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int reserved1) {
        this.reserved1 = reserved1;
    }

    @Override
    public int getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(int magicNumber) throws EvioException {
        if (magicNumber != -1059454720) {
            throw new EvioException(String.format("Value for magicNumber %8x does not match MAGIC_NUMBER 0xc0da0100.", magicNumber));
        }
        this.magicNumber = magicNumber;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(String.format("block size:    %d\n", this.size));
        sb.append(String.format("number:        %d\n", this.number));
        sb.append(String.format("headerLen:     %d\n", this.headerLength));
        sb.append(String.format("start:         %d\n", this.start));
        sb.append(String.format("end:           %d\n", this.end));
        sb.append(String.format("version:       %d\n", this.version));
        sb.append(String.format("reserved1:     %d\n", this.reserved1));
        sb.append(String.format("magicNumber:   %8x\n", this.magicNumber));
        sb.append(String.format(" *buffer start:  %d\n", this.getBufferStartingPosition()));
        sb.append(String.format(" *next   start:  %d\n", this.nextBufferStartingPosition()));
        return sb.toString();
    }

    @Override
    public long getBufferEndingPosition() {
        return this.bufferStartingPosition + (long)(4 * this.end);
    }

    @Override
    public long getBufferStartingPosition() {
        return this.bufferStartingPosition;
    }

    @Override
    public void setBufferStartingPosition(long bufferStartingPosition) {
        this.bufferStartingPosition = bufferStartingPosition;
    }

    @Override
    public long nextBufferStartingPosition() {
        return this.bufferStartingPosition + (long)(4 * this.size);
    }

    @Override
    public long firstEventStartingPosition() {
        if (this.start == 0) {
            return 0L;
        }
        return this.bufferStartingPosition + (long)(4 * this.start);
    }

    @Override
    public int bytesRemaining(long position) throws EvioException {
        if (position < this.bufferStartingPosition) {
            throw new EvioException("Provided position is less than buffer starting position.");
        }
        long nextBufferStart = this.nextBufferStartingPosition();
        if (position > nextBufferStart) {
            throw new EvioException("Provided position beyond buffer end position.");
        }
        return (int)(nextBufferStart - position);
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.size);
        byteBuffer.putInt(this.number);
        byteBuffer.putInt(this.headerLength);
        byteBuffer.putInt(this.start);
        byteBuffer.putInt(this.end);
        byteBuffer.putInt(this.version);
        byteBuffer.putInt(this.reserved1);
        byteBuffer.putInt(this.magicNumber);
        return 32;
    }
}

