/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.StructureType;
import org.jlab.coda.jevio.TagSegmentHeader;

public class EvioTagSegment
extends BaseStructure {
    public static final String ELEMENT_NAME = "tagsegment";

    public EvioTagSegment() {
        this(new TagSegmentHeader());
    }

    public EvioTagSegment(TagSegmentHeader tagSegmentHeader) {
        super(tagSegmentHeader);
    }

    public EvioTagSegment(int tag, DataType dataType) {
        this(new TagSegmentHeader(tag, dataType));
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.TAGSEGMENT;
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter) {
        try {
            this.commonXMLStart(xmlWriter);
            if (this.header.dataType.isStructure()) {
                xmlWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xmlWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType.getValue()));
            xmlWriter.writeAttribute("tag", "" + this.header.tag);
            xmlWriter.writeAttribute("length", "" + this.header.length);
            xmlWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xmlWriter);
            this.decreaseXmlIndent();
            this.commonXMLClose(xmlWriter);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

