/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioCompactStructureHandler;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioSegment;

public class CompactTest {
    static EvioEvent createSimpleSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[21];
        Arrays.fill(intData, 1);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, tag);
            event = builder.getEvent();
            EvioBank bankInts = new EvioBank(tag + 1, DataType.INT32, tag + 1);
            bankInts.appendIntData(intData);
            builder.addChild(event, bankInts);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[1];
        Arrays.fill(intData, 1);
        byte[] byteData = new byte[4];
        Arrays.fill(byteData, (byte)2);
        short[] shortData = new short[2];
        Arrays.fill(shortData, (short)3);
        double[] doubleData = new double[1];
        Arrays.fill(doubleData, 4.0);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.SEGMENT, tag);
            event = builder.getEvent();
            EvioSegment segShorts = new EvioSegment(8, DataType.SHORT16);
            segShorts.appendShortData(shortData);
            builder.addChild(event, segShorts);
            EvioSegment segDoubles = new EvioSegment(9, DataType.DOUBLE64);
            segDoubles.appendDoubleData(doubleData);
            builder.addChild(event, segDoubles);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static ByteBuffer createSingleSegment(int tag) {
        EvioSegment seg = new EvioSegment(tag, DataType.INT32);
        int[] intData = new int[10];
        Arrays.fill(intData, 456);
        try {
            seg.appendIntData(intData);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(48);
        seg.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createSingleBank(int tag, int num) {
        EvioEvent bank = CompactTest.createSimpleSingleEvent(tag);
        int byteSize = bank.getTotalBytes();
        ByteBuffer bb = ByteBuffer.allocate(byteSize);
        bank.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createBuffer(int eventCount) {
        String xmlDict = null;
        ByteBuffer myBuf = ByteBuffer.allocate(1000 * eventCount);
        try {
            EventWriter writer = new EventWriter(myBuf, 10000, 100, xmlDict, null);
            EvioEvent ev = CompactTest.createSimpleSingleEvent(1);
            for (int i = 0; i < eventCount; ++i) {
                writer.writeEvent(ev);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        myBuf.flip();
        return myBuf;
    }

    public static void main(String[] args) {
        boolean count = true;
        boolean evCount = false;
        int loops = 1;
        int adds = 1;
        ByteBuffer bankBuf = CompactTest.createSingleBank(66, 99);
        ByteBuffer addBuf = CompactTest.createSingleBank(77, 88);
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < loops; ++i) {
            try {
                EvioCompactStructureHandler handler = new EvioCompactStructureHandler(bankBuf, DataType.BANK);
                List<EvioNode> nodes = handler.getNodes();
                System.out.println("Original struct has " + bankBuf.remaining() + " bytes");
                System.out.println("Original struct has " + nodes.size() + " nodes");
                ByteBuffer newBuf = null;
                for (int j = 0; j < adds; ++j) {
                    System.out.println("Insert buffer of " + addBuf.remaining() + " bytes");
                    newBuf = handler.addStructure(addBuf);
                    nodes = handler.getNodes();
                }
                System.out.println("New struct has " + nodes.size() + " nodes");
                System.out.println("bank buf pos = " + addBuf.position() + ", limit = " + addBuf.limit());
                System.out.println("new buf pos = " + newBuf.position() + ", limit = " + newBuf.limit());
                EvioCompactStructureHandler handler2 = new EvioCompactStructureHandler(newBuf, DataType.BANK);
                System.out.println("Reconstructed struct has " + newBuf.remaining() + " bytes");
                nodes = handler2.getNodes();
                System.out.println("Reconstructed struct has " + nodes.size() + " nodes");
                continue;
            }
            catch (EvioException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        double rate = 1000.0 * ((double)loops * (double)evCount) / (double)time;
        System.out.println("rate = " + String.format("%.3g", rate) + " Hz");
        System.out.println("time = " + time + " milliseconds");
    }
}

