/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.StringTokenizer;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;

public class EvioDictionaryEntry
implements Comparable<EvioDictionaryEntry> {
    private int tag;
    private int[] numbers;
    private String description;

    public EvioDictionaryEntry(String tag, String num, String description) {
        this.description = description;
        this.tag = Integer.parseInt(tag);
        if (num != null) {
            String[] tokens = this.tokens(num, ".");
            this.numbers = new int[tokens.length];
            int j = 0;
            for (int i = tokens.length - 1; i >= 0; --i) {
                this.numbers[j] = Integer.parseInt(tokens[i]);
                ++j;
            }
        }
    }

    public boolean match(BaseStructure structure) {
        if (structure instanceof EvioEvent) {
            if (this.numbers == null || this.numbers.length != 1) {
                return false;
            }
            BaseStructureHeader header = structure.header;
            return this.tag == header.tag && this.numbers[0] == header.number;
        }
        if (structure instanceof EvioBank) {
            if (structure.header.tag != this.tag) {
                return false;
            }
            if (this.numbers == null) {
                return false;
            }
            for (int i = 0; i < this.numbers.length; ++i) {
                BaseStructureHeader header = structure.header;
                if (this.numbers[i] != header.number) {
                    return false;
                }
                if ((structure = structure.getParent()) == null) {
                    return i >= this.numbers.length - 1;
                }
                if (structure instanceof EvioSegment) {
                    return false;
                }
                if (!(structure instanceof EvioTagSegment)) continue;
                return false;
            }
            return true;
        }
        BaseStructureHeader header = structure.header;
        return this.tag == header.tag;
    }

    @Override
    public int compareTo(EvioDictionaryEntry entry) {
        if (entry.numbers == null) {
            return -1;
        }
        if (this.numbers == null) {
            return 1;
        }
        if (this.numbers.length > entry.numbers.length) {
            return -1;
        }
        if (this.numbers.length < entry.numbers.length) {
            return 1;
        }
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] < entry.numbers[i]) {
                return -1;
            }
            if (this.numbers[i] <= entry.numbers[i]) continue;
            return 1;
        }
        return 0;
    }

    private String[] tokens(String str, String token) {
        StringTokenizer t = new StringTokenizer(str, token);
        int num = t.countTokens();
        String[] tokens = new String[num];
        for (int i = 0; i < num; ++i) {
            tokens[i] = t.nextToken();
        }
        return tokens;
    }

    public String getDescription() {
        return this.description;
    }

    public int getTag() {
        return this.tag;
    }

    public StringBuilder toXML() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("<xmldumpDictEntry name=\"");
        sb.append(this.description);
        sb.append("\"  tag=\"");
        sb.append(this.tag);
        sb.append("\"");
        String ns = null;
        if (this.numbers != null) {
            for (int i = this.numbers.length - 1; i >= 0; --i) {
                if (ns == null) {
                    ns = "";
                }
                ns = ns + this.numbers[i];
                if (i == 0) continue;
                ns = ns + ".";
            }
        }
        if (ns != null) {
            sb.append("  num=\"");
            sb.append(ns);
            sb.append("\"");
        }
        sb.append("/>\n");
        return sb;
    }

    public String toString() {
        String ns = null;
        if (this.numbers != null) {
            for (int i = this.numbers.length - 1; i >= 0; --i) {
                if (ns == null) {
                    ns = "";
                }
                ns = ns + this.numbers[i];
                if (i == 0) continue;
                ns = ns + ".";
            }
        }
        if (ns == null) {
            return String.format("tag: %-4d description: %s", this.tag, this.description);
        }
        return String.format("tag: %-4d num: %-10s description: %s", this.tag, ns, this.description);
    }
}

