/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.HashMap;

public enum DataType {
    UNKNOWN32(0),
    UINT32(1),
    FLOAT32(2),
    CHARSTAR8(3),
    SHORT16(4),
    USHORT16(5),
    CHAR8(6),
    UCHAR8(7),
    DOUBLE64(8),
    LONG64(9),
    ULONG64(10),
    INT32(11),
    TAGSEGMENT(12),
    ALSOSEGMENT(13),
    ALSOBANK(14),
    COMPOSITE(15),
    BANK(16),
    SEGMENT(32),
    HOLLERIT(65),
    NVALUE(66);

    private int value;
    private static HashMap<Integer, String> names;
    private static HashMap<Integer, DataType> dataTypes;

    public static DataType getDataType(int val) {
        return dataTypes.get(val);
    }

    public static String getName(int val) {
        String n = names.get(val);
        if (n != null) {
            return n;
        }
        return "UNKNOWN";
    }

    public String toString() {
        if (this == ALSOBANK) {
            return "BANK";
        }
        if (this == ALSOSEGMENT) {
            return "SEGMENT";
        }
        return super.toString();
    }

    private DataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isStructure() {
        switch (this) {
            case BANK: 
            case SEGMENT: 
            case TAGSEGMENT: 
            case ALSOBANK: 
            case ALSOSEGMENT: {
                return true;
            }
        }
        return false;
    }

    static {
        names = new HashMap(32);
        dataTypes = new HashMap(32);
        for (DataType item : DataType.values()) {
            dataTypes.put(item.value, item);
            names.put(item.value, item.name());
        }
    }
}

