/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class EvioCompactReader {
    private static final int MAGIC_OFFSET = 28;
    private static final int VERSION_OFFSET = 20;
    private static final int BLOCK_SIZE_OFFSET = 0;
    private static final int BLOCK_NUMBER = 4;
    private static final int BLOCK_HEADER_SIZE_OFFSET = 8;
    private static final int BLOCK_EVENT_COUNT = 12;
    private static final int BLOCK_RESERVED_1 = 16;
    private static final int VERSION_MASK = 255;
    public final ArrayList<EvioNode> eventNodes = new ArrayList(200000);
    private final HashMap<Integer, BlockNode> blockNodes = new HashMap(1000);
    private int eventCount = -1;
    private int evioVersion;
    private ByteOrder byteOrder;
    private ByteOrder fileByteOrder;
    private int blockCount = -1;
    private int firstBlockHeaderWords;
    private BlockHeaderV4 blockHeader = new BlockHeaderV4();
    private boolean isFile;
    private boolean hasDictionary;
    private String dictionaryXML;
    private EvioXMLDictionary dictionary;
    private ByteBuffer byteBuffer;
    private int initialPosition;
    private int validDataWords;
    private boolean closed;
    private MappedByteBuffer mappedByteBuffer;
    private String path;
    private long fileSize;

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    public EvioCompactReader(String path) throws EvioException, IOException {
        this(new File(path));
    }

    public EvioCompactReader(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("File arg is null");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = file.getAbsolutePath();
        FileChannel fileChannel = fileInputStream.getChannel();
        this.fileSize = fileChannel.size();
        if (this.fileSize > Integer.MAX_VALUE) {
            throw new EvioException("file too large (must be < 2.1475GB)");
        }
        this.mapFile(fileChannel);
        fileChannel.close();
        this.initialPosition = 0;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
        this.isFile = true;
    }

    public EvioCompactReader(ByteBuffer byteBuffer) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
    }

    public synchronized void setBuffer(ByteBuffer buf) throws EvioException {
        if (buf == null) {
            throw new EvioException("arg is null");
        }
        this.close();
        this.blockNodes.clear();
        this.eventNodes.clear();
        this.blockCount = -1;
        this.eventCount = -1;
        this.dictionaryXML = null;
        this.initialPosition = buf.position();
        this.byteBuffer = buf;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
        this.closed = false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public int getEvioVersion() {
        return this.evioVersion;
    }

    public String getPath() {
        return this.path;
    }

    public ByteOrder getFileByteOrder() {
        return this.fileByteOrder;
    }

    public synchronized String getDictionaryXML() throws EvioException {
        if (this.dictionaryXML != null) {
            return this.dictionaryXML;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.hasDictionary) {
            try {
                this.readDictionary();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dictionaryXML;
    }

    public synchronized EvioXMLDictionary getDictionary() throws EvioException {
        if (this.dictionary != null) {
            return this.dictionary;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.hasDictionary) {
            try {
                if (this.dictionaryXML == null) {
                    this.readDictionary();
                }
                this.dictionary = new EvioXMLDictionary(this.dictionaryXML);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dictionary;
    }

    public boolean hasDictionary() {
        return this.hasDictionary;
    }

    private void mapFile(FileChannel inputChannel) throws IOException {
        long sz = inputChannel.size();
        this.mappedByteBuffer = inputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        this.byteBuffer = this.mappedByteBuffer;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public EvioNode getEvent(int eventNumber) {
        try {
            return this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private void generateEventPositionTable() throws EvioException {
        boolean curLastBlock = false;
        boolean firstBlock = true;
        boolean hasDictionary = false;
        int position = this.initialPosition;
        this.blockCount = 0;
        this.eventCount = 0;
        this.validDataWords = 0;
        try {
            while (!curLastBlock) {
                BlockNode blockNode = new BlockNode();
                this.blockNodes.put(this.blockCount, blockNode);
                blockNode.pos = position;
                blockNode.len = this.byteBuffer.getInt(position);
                int ver = this.byteBuffer.getInt(position + 20);
                int blockHdrSize = this.byteBuffer.getInt(position + 8);
                blockNode.count = this.byteBuffer.getInt(position + 12);
                ++this.blockCount;
                blockNode.place = blockNode.place;
                this.validDataWords += blockNode.len;
                curLastBlock = BlockHeaderV4.isLastBlock(ver);
                if (firstBlock) {
                    hasDictionary = BlockHeaderV4.hasDictionary(ver);
                }
                position += 4 * blockHdrSize;
                if (firstBlock && hasDictionary) {
                    firstBlock = false;
                    int byteLen = 4 * (this.byteBuffer.getInt(position) + 1);
                    position += byteLen;
                }
                for (int i = 0; i < blockNode.count; ++i) {
                    EvioNode node = this.extractNode(this.byteBuffer, blockNode, null, DataType.BANK, position, this.eventCount + i, true);
                    this.eventNodes.add(node);
                    int len = 8 + 4 * node.dataLen;
                    position += len;
                }
                this.eventCount += blockNode.count;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("File/buffer bad format", e);
        }
    }

    private ReadStatus readFirstHeader() {
        int pos = this.initialPosition;
        if (this.byteBuffer.limit() - pos < 32) {
            this.byteBuffer.clear();
            return ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.byteBuffer.order();
            int magicNumber = this.byteBuffer.getInt(pos + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteBuffer.order(this.byteOrder);
                magicNumber = this.byteBuffer.getInt(pos + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR reread magic # (" + magicNumber + ") & still not right");
                    return ReadStatus.EVIO_EXCEPTION;
                }
            }
            this.fileByteOrder = this.byteOrder;
            int bitInfo = this.byteBuffer.getInt(pos + 20);
            this.evioVersion = bitInfo & 0xFF;
            if (this.evioVersion < 4) {
                System.out.println("Unsupported evio version (" + this.evioVersion + ") for EvioCompactReader class");
                return ReadStatus.EVIO_EXCEPTION;
            }
            this.hasDictionary = BlockHeaderV4.bitInfoHasDictionary(bitInfo);
            this.firstBlockHeaderWords = this.byteBuffer.getInt(pos + 8);
            this.blockHeader.setSize(this.byteBuffer.getInt(pos + 0));
            this.blockHeader.setNumber(this.byteBuffer.getInt(pos + 4));
            this.blockHeader.setHeaderLength(this.firstBlockHeaderWords);
            this.blockHeader.setEventCount(this.byteBuffer.getInt(pos + 12));
            this.blockHeader.setReserved1(this.byteBuffer.getInt(pos + 16));
            this.blockHeader.parseToBitInfo(bitInfo);
            this.blockHeader.setVersion(this.evioVersion);
            this.blockHeader.setReserved2(0);
            this.blockHeader.setMagicNumber(magicNumber);
        }
        catch (EvioException a) {
            this.byteBuffer.clear();
            return ReadStatus.EVIO_EXCEPTION;
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.byteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        return ReadStatus.SUCCESS;
    }

    public BlockHeaderV4 getFirstBlockHeader() {
        return this.blockHeader;
    }

    private void readDictionary() throws EvioException {
        int originalPos = this.byteBuffer.position();
        int pos = this.initialPosition + 4 * this.firstBlockHeaderWords;
        int length = this.byteBuffer.getInt(pos);
        if (length < 1) {
            throw new EvioException("Bad value for dictionary length");
        }
        this.byteBuffer.getInt(pos += 4);
        pos += 4;
        int eventDataSizeBytes = 4 * (length - 1);
        byte[] bytes = new byte[eventDataSizeBytes];
        try {
            this.byteBuffer.position(pos);
            this.byteBuffer.get(bytes, 0, eventDataSizeBytes);
        }
        catch (Exception e) {
            throw new EvioException("Problems reading buffer");
        }
        String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
        if (strs == null) {
            throw new EvioException("Data in bad format");
        }
        this.dictionaryXML = strs[0];
        this.byteBuffer.position(originalPos);
    }

    private EvioNode extractNode(ByteBuffer buffer, BlockNode blockNode, EvioNode eventNode, DataType type, int position, int place, boolean isEvent) throws EvioException {
        EvioNode node = new EvioNode();
        node.pos = position;
        node.place = place;
        node.blockNode = blockNode;
        node.eventNode = eventNode;
        node.isEvent = isEvent;
        node.type = type.getValue();
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                node.len = buffer.getInt(position);
                node.dataPos = position + 8;
                node.dataLen = node.len - 1;
                position += 4;
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    node.tag = buffer.getShort(position) & 0xFFFF;
                    position += 2;
                    int dt = buffer.get(position++) & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    if (dt == 64) {
                        node.dataType = DataType.TAGSEGMENT.getValue();
                        node.pad = 0;
                    }
                    node.num = buffer.get(position) & 0xFF;
                    break;
                }
                node.num = buffer.get(position++) & 0xFF;
                int dt = buffer.get(position++) & 0xFF;
                node.dataType = dt & 0x3F;
                node.pad = dt >>> 6;
                if (dt == 64) {
                    node.dataType = DataType.TAGSEGMENT.getValue();
                    node.pad = 0;
                }
                node.tag = buffer.getShort(position) & 0xFFFF;
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                node.dataPos = position + 4;
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    node.tag = buffer.get(position++) & 0xFF;
                    int dt = buffer.get(position++) & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    if (dt == 64) {
                        node.dataType = DataType.TAGSEGMENT.getValue();
                        node.pad = 0;
                    }
                    node.len = buffer.getShort(position) & 0xFFFF;
                } else {
                    node.len = buffer.getShort(position) & 0xFFFF;
                    position += 2;
                    int dt = buffer.get(position++) & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    if (dt == 64) {
                        node.dataType = DataType.TAGSEGMENT.getValue();
                        node.pad = 0;
                    }
                    node.tag = buffer.get(position) & 0xFF;
                }
                node.dataLen = node.len;
                break;
            }
            case TAGSEGMENT: {
                node.dataPos = position + 4;
                if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                    int temp = buffer.getShort(position) & 0xFFFF;
                    node.tag = temp >>> 4;
                    node.dataType = temp & 0xF;
                    node.len = buffer.getShort(position += 2) & 0xFFFF;
                } else {
                    node.len = buffer.getShort(position) & 0xFFFF;
                    int temp = buffer.getShort(position += 2) & 0xFFFF;
                    node.tag = temp >>> 4;
                    node.dataType = temp & 0xF;
                }
                node.dataLen = node.len;
                break;
            }
            default: {
                throw new EvioException("File/buffer bad format");
            }
        }
        return node;
    }

    private static void scanStructure(ByteBuffer buffer, EvioNode eventNode, BlockNode blockNode, DataType type, int length, int position, List<EvioNode> list) {
        if (!type.isStructure()) {
            return;
        }
        int dataBytes = 4 * length;
        int endingPos = position + dataBytes;
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                while (position < endingPos) {
                    int num;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    int len = buffer.getInt(position);
                    int dataLen = len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        num = buffer.get(position++) & 0xFF;
                    } else {
                        num = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.BANK.getValue();
                    kidNode.pos = position - 8;
                    kidNode.dataLen = dataLen;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = num;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactReader.scanStructure(buffer, eventNode, blockNode, dType, dataLen, position, list);
                    }
                    position += 4 * dataLen;
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.get(position++) & 0xFF;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.SEGMENT.getValue();
                    kidNode.pos = position - 4;
                    kidNode.dataLen = len;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactReader.scanStructure(buffer, eventNode, blockNode, dType, len, position, list);
                    }
                    position += 4 * len;
                }
                break;
            }
            case TAGSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int dataType;
                    int tag;
                    int temp;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        temp = buffer.getShort(position) & 0xFFFF;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                        len = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        temp = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.TAGSEGMENT.getValue();
                    kidNode.pos = position - 4;
                    kidNode.dataLen = len;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = 0;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactReader.scanStructure(buffer, eventNode, blockNode, dType, len, position, list);
                    }
                    position += 4 * len;
                }
                break;
            }
        }
    }

    private LinkedList<EvioNode> scanStructure(int eventNumber) {
        EvioNode node = this.eventNodes.get(eventNumber - 1);
        LinkedList<EvioNode> list = new LinkedList<EvioNode>();
        list.add(node);
        EvioCompactReader.scanStructure(this.byteBuffer, node, node.blockNode, node.getDataTypeObj(), node.dataLen, node.dataPos, list);
        return list;
    }

    public synchronized List<EvioNode> searchEvent(int eventNumber, int tag, int num) throws EvioException {
        if (tag < 0 || num < 0 || eventNumber < 1 || eventNumber > this.eventCount) {
            throw new EvioException("bad arg value(s)");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        LinkedList<EvioNode> returnList = new LinkedList<EvioNode>();
        LinkedList<EvioNode> list = this.scanStructure(eventNumber);
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    public synchronized List<EvioNode> searchEvent(int eventNumber, String dictName, EvioXMLDictionary dictionary) throws EvioException {
        int num;
        int tag;
        if (dictName == null) {
            throw new EvioException("null dictionary entry name");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (dictionary == null && this.hasDictionary) {
            dictionary = this.getDictionary();
        }
        if (dictionary != null) {
            tag = dictionary.getTag(dictName);
            num = dictionary.getNum(dictName);
            if (tag == -1 || num == -1) {
                throw new EvioException("no dictionary entry for " + dictName);
            }
        } else {
            throw new EvioException("no dictionary available");
        }
        return this.searchEvent(eventNumber, tag, num);
    }

    public synchronized ByteBuffer addStructure(int eventNumber, ByteBuffer addBuffer) throws EvioException {
        EvioNode eventNode;
        if (addBuffer == null || addBuffer.remaining() < 8) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            eventNode = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist");
        }
        int endPos = eventNode.dataPos + 4 * eventNode.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = DataType.getDataType(eventNode.dataType);
        ByteBuffer newBuffer = ByteBuffer.allocate(4 * this.validDataWords + appendDataLen);
        newBuffer.order(this.byteOrder);
        this.byteBuffer.position(this.initialPosition).limit(endPos);
        newBuffer.put(this.byteBuffer);
        int newDataPos = newBuffer.position();
        newBuffer.put(addBuffer);
        this.byteBuffer.position(endPos).limit(4 * this.validDataWords + this.initialPosition);
        newBuffer.put(this.byteBuffer);
        newBuffer.flip();
        this.byteBuffer.position(this.initialPosition);
        addBuffer.position(origAddBufPos);
        for (int i = 0; i < this.eventCount; ++i) {
            EvioNode eNode = this.eventNodes.get(i);
            eNode.pos -= this.initialPosition;
            eNode.dataPos -= this.initialPosition;
            if (i <= eventNode.place) continue;
            eNode.pos += appendDataLen;
            eNode.dataPos += appendDataLen;
        }
        for (int i = 0; i < this.blockCount; ++i) {
            BlockNode bNode = this.blockNodes.get(i);
            bNode.pos -= this.initialPosition;
            if (i <= eventNode.blockNode.place) continue;
            bNode.pos += appendDataLen;
        }
        this.byteBuffer = newBuffer;
        this.initialPosition = newBuffer.position();
        if (this.isFile) {
            this.isFile = false;
            this.mappedByteBuffer = null;
        }
        int blockLenPos = eventNode.blockNode.pos;
        int eventLenPos = eventNode.pos;
        eventNode.blockNode.len += appendDataWordLen;
        newBuffer.putInt(blockLenPos, eventNode.blockNode.len);
        eventNode.len += appendDataWordLen;
        eventNode.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                newBuffer.putInt(eventLenPos, eventNode.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                    newBuffer.putShort(eventLenPos + 2, (short)eventNode.len);
                    break;
                }
                newBuffer.putShort(eventLenPos, (short)eventNode.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        return newBuffer;
    }

    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.getData(node, false);
    }

    public synchronized ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.position(node.dataPos).limit(node.dataPos + 4 * node.dataLen - node.pad);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * node.dataLen);
            newBuf.put(this.byteBuffer);
            newBuf.order(this.byteOrder);
            newBuf.flip();
            this.byteBuffer.position(pos).limit(lim);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice();
        buf.order(this.byteOrder);
        this.byteBuffer.position(pos).limit(lim);
        return buf;
    }

    public ByteBuffer getEventBuffer(int eventNumber) throws EvioException {
        return this.getEventBuffer(eventNumber, false);
    }

    public synchronized ByteBuffer getEventBuffer(int eventNumber, boolean copy) throws EvioException {
        EvioNode node;
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            node = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.position(node.pos).limit(node.dataPos + 4 * node.dataLen);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(node.dataPos + 4 * node.dataLen - node.pos);
            newBuf.put(this.byteBuffer);
            newBuf.order(this.byteOrder);
            newBuf.flip();
            this.byteBuffer.position(pos).limit(lim);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice();
        buf.order(this.byteOrder);
        this.byteBuffer.position(pos).limit(lim);
        return buf;
    }

    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.position(node.pos).limit(node.dataPos + 4 * node.dataLen);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(node.dataPos + 4 * node.dataLen - node.pos);
            newBuf.put(this.byteBuffer);
            newBuf.order(this.byteOrder);
            newBuf.flip();
            this.byteBuffer.position(pos).limit(lim);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice();
        buf.order(this.byteOrder);
        this.byteBuffer.position(pos).limit(lim);
        return buf;
    }

    public synchronized void close() {
        this.byteBuffer.position(this.initialPosition);
        this.closed = true;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void toFile(String fileName) throws EvioException, IOException {
        if (fileName == null) {
            throw new EvioException("null fileName arg");
        }
        File f = new File(fileName);
        this.toFile(f);
    }

    public synchronized void toFile(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("null file arg");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        channel.write(this.byteBuffer);
        channel.close();
        this.byteBuffer.position(pos);
    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

