/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;

public class BigFileWrite {
    public static void main(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/jevio-4.3/testdata/bigFileV4.ev";
        File file = new File(fileName);
        int[] intData = new int[3750];
        int count = 0;
        long t1 = 0L;
        long t2 = 0L;
        long totalT = 0L;
        long totalCount = 0L;
        try {
            EventWriter eventWriter = new EventWriter(file);
            EventBuilder eventBuilder = new EventBuilder(1, DataType.INT32, 1);
            EvioEvent ev = eventBuilder.getEvent();
            t1 = System.currentTimeMillis();
            int j = 0;
            while (j < 400000) {
                intData[0] = j++;
                ev.setIntData(intData);
                eventWriter.writeEvent(ev);
                ++count;
            }
            eventWriter.close();
            t2 = System.currentTimeMillis();
            long time = t2 - t1;
            double rate = 1000.0 * (double)count / (double)time;
            double avgRate = 1000.0 * (double)(totalCount += (long)count) / (double)(totalT += time);
            System.out.println("rate = " + String.format("%.3g", rate) + " Hz,  avg = " + String.format("%.3g", avgRate));
            System.out.println("time = " + time + " milliseconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

