/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioProgressListener;
import org.jlab.coda.jevio.INameProvider;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;
import org.jlab.coda.jevio.graphics.EventTreePanel;

public class EventTreeMenu {
    JButton nextButton;
    JButton prevButton;
    private JMenuItem xmlExportItem;
    private JMenuItem openEventFile;
    private JTextField eventNumberInput;
    private EventTreePanel eventTreePanel;
    private int eventIndex;
    private String dataFilePath;
    private String dictionaryFilePath;
    private String xmlFilePath;
    private FileNameExtensionFilter evioFileFilter;
    private EvioReader evioFileReader;
    private boolean isUserDictionary;
    private INameProvider userDictionary;
    private INameProvider fileDictionary;
    private INameProvider currentDictionary;
    private EventListenerList evioListenerList;

    public EventTreeMenu(EventTreePanel eventTreePanel) {
        this.eventTreePanel = eventTreePanel;
    }

    public EventTreePanel getEventTreePanel() {
        return this.eventTreePanel;
    }

    void addEventControlPanel() {
        this.nextButton = new JButton("next >");
        ActionListener al_next = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.evioFileReader != null) {
                    try {
                        EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(++EventTreeMenu.this.eventIndex);
                        if (event != null) {
                            EventTreeMenu.this.eventTreePanel.setEvent(event);
                        }
                        if (EventTreeMenu.this.eventIndex > 1) {
                            EventTreeMenu.this.prevButton.setEnabled(true);
                        }
                    }
                    catch (IOException e1) {
                        EventTreeMenu.this.eventIndex--;
                        e1.printStackTrace();
                    }
                    catch (EvioException e1) {
                        EventTreeMenu.this.eventIndex--;
                        e1.printStackTrace();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.nextButton.addActionListener(al_next);
        this.prevButton = new JButton("< prev");
        this.prevButton.setEnabled(false);
        ActionListener al_prev = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.evioFileReader != null) {
                    try {
                        if (EventTreeMenu.this.eventIndex > 1) {
                            EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(--EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                            }
                            if (EventTreeMenu.this.eventIndex < 2) {
                                EventTreeMenu.this.prevButton.setEnabled(false);
                            }
                        }
                    }
                    catch (IOException e1) {
                        EventTreeMenu.this.eventIndex++;
                        e1.printStackTrace();
                    }
                    catch (EvioException e1) {
                        EventTreeMenu.this.eventIndex++;
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.prevButton.addActionListener(al_prev);
        ActionListener al_eventNumIn = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String num = EventTreeMenu.this.eventNumberInput.getText();
                    if (num != null) {
                        int eventNum = Integer.parseInt(num);
                        if (eventNum > 0 && eventNum <= EventTreeMenu.this.evioFileReader.getEventCount()) {
                            EventTreeMenu.this.eventIndex = eventNum;
                            EvioEvent event = EventTreeMenu.this.evioFileReader.gotoEventNumber(EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                            }
                        } else {
                            EventTreeMenu.this.eventNumberInput.setText("");
                        }
                    }
                }
                catch (NumberFormatException e1) {
                    EventTreeMenu.this.eventNumberInput.setText("");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        JLabel label = new JLabel("Go to event # ");
        this.eventNumberInput = new JTextField();
        this.eventNumberInput.addActionListener(al_eventNumIn);
        JPanel cPanel = this.eventTreePanel.getEventInfoPanel().controlPanel;
        cPanel.setBorder(new EmptyBorder(5, 8, 5, 8));
        cPanel.setLayout(new GridLayout(2, 2, 5, 5));
        cPanel.add(this.prevButton);
        cPanel.add(this.nextButton);
        cPanel.add(label);
        cPanel.add(this.eventNumberInput);
    }

    public JMenu createViewMenu() {
        JMenu menu = new JMenu(" View ");
        ActionListener al_hex = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                String txt = item.getText();
                if (txt.equals("Hexidecimal")) {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(true);
                    item.setText("Decimal");
                } else {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(false);
                    item.setText("Hexidecimal");
                }
                EventTreeMenu.this.eventTreePanel.refreshDisplay();
            }
        };
        JMenuItem hexItem = new JMenuItem("Hexidecimal");
        hexItem.addActionListener(al_hex);
        hexItem.setEnabled(true);
        menu.add(hexItem);
        ActionListener al_switchDict = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.switchDictionary()) {
                    EventTreeMenu.this.eventTreePanel.refreshDisplay();
                }
            }
        };
        JMenuItem switchDictItem = new JMenuItem("Switch dictionary");
        switchDictItem.addActionListener(al_switchDict);
        switchDictItem.setEnabled(true);
        menu.add(switchDictItem);
        return menu;
    }

    public JMenu createFileMenu() {
        JMenu menu = new JMenu(" File ");
        ActionListener al_oef = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenEventFile();
            }
        };
        this.openEventFile = new JMenuItem("Open Event File...");
        this.openEventFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openEventFile.addActionListener(al_oef);
        menu.add(this.openEventFile);
        ActionListener al_odf = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenDictionary();
            }
        };
        JMenuItem df_item = new JMenuItem("Open Dictionary...");
        df_item.addActionListener(al_odf);
        menu.add(df_item);
        menu.addSeparator();
        ActionListener al_xml = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.exportToXML();
            }
        };
        this.xmlExportItem = new JMenuItem("Export File to XML...");
        this.xmlExportItem.addActionListener(al_xml);
        this.xmlExportItem.setEnabled(false);
        menu.add(this.xmlExportItem);
        menu.addSeparator();
        ActionListener al_exit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        JMenuItem exit_item = new JMenuItem("Quit");
        exit_item.addActionListener(al_exit);
        menu.add(exit_item);
        return menu;
    }

    private void doOpenEventFile() {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile();
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
        this.nextButton.doClick();
    }

    public void manualOpenEventFile(File file) {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile(file);
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
    }

    private void doOpenDictionary() {
        this.openDictionary();
    }

    public boolean switchDictionary() {
        if (this.isUserDictionary) {
            if (this.fileDictionary != null) {
                this.currentDictionary = this.fileDictionary;
                NameProvider.setProvider(this.currentDictionary);
                this.eventTreePanel.refreshDescription();
                this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
                this.isUserDictionary = false;
                return true;
            }
        } else if (this.userDictionary != null) {
            this.currentDictionary = this.userDictionary;
            NameProvider.setProvider(this.currentDictionary);
            this.eventTreePanel.refreshDescription();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.isUserDictionary = true;
            return true;
        }
        return false;
    }

    public void exportToXML() {
        this.eventTreePanel.getProgressBar().setValue(0);
        JFileChooser chooser = new JFileChooser(this.xmlFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML Evio Files", "xml");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.eventTreePanel);
        if (returnVal == 0) {
            int answer;
            File selectedFile = chooser.getSelectedFile();
            this.xmlFilePath = selectedFile.getAbsolutePath();
            if (selectedFile.exists() && (answer = JOptionPane.showConfirmDialog(null, selectedFile.getPath() + "  already exists. Do you want to overwrite it?", "Overwite Existing File?", 0)) != 0) {
                return;
            }
            final IEvioProgressListener progressListener = new IEvioProgressListener(){

                @Override
                public void completed(int num, int total) {
                    int percentDone = (int)(100.0 * (double)num / (double)total);
                    EventTreeMenu.this.eventTreePanel.getProgressBar().setValue(percentDone);
                    EventTreeMenu.this.eventTreePanel.getProgressBar().repaint();
                }
            };
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventTreeMenu.this.evioFileReader.toXMLFile(EventTreeMenu.this.xmlFilePath, progressListener);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    EventTreeMenu.this.eventTreePanel.getProgressBar().setValue(0);
                    JOptionPane.showMessageDialog(EventTreeMenu.this.eventTreePanel, "XML Writing has completed.", "Done", 1);
                }
            };
            new Thread(runner).start();
        }
    }

    public void addEventFileExtension(String extension) {
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio", extension);
        } else {
            String[] exts = this.evioFileFilter.getExtensions();
            String[] newExts = Arrays.copyOf(exts, exts.length + 1);
            newExts[exts.length] = extension;
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", newExts);
        }
    }

    public void setEventFileExtensions(String[] extensions) {
        this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", extensions);
    }

    public EvioReader openEventFile() {
        this.eventTreePanel.getEventInfoPanel().setEventNumber(0);
        JFileChooser chooser = new JFileChooser(this.dataFilePath);
        chooser.setSelectedFile(null);
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio");
        }
        chooser.setFileFilter(this.evioFileFilter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            this.eventTreePanel.getHeaderPanel().setHeader(null);
            File selectedFile = chooser.getSelectedFile();
            this.dataFilePath = selectedFile.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setSource(this.dataFilePath);
            try {
                if (this.evioFileReader != null) {
                    this.evioFileReader.close();
                    this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(0);
                }
                this.evioFileReader = new EvioReader(selectedFile);
                this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(this.evioFileReader.getEventCount());
                if (this.evioFileReader.hasDictionaryXML()) {
                    this.currentDictionary = this.fileDictionary = NameProviderFactory.createNameProvider(this.evioFileReader.getDictionaryXML());
                    NameProvider.setProvider(this.currentDictionary);
                    this.isUserDictionary = false;
                    this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
                }
                this.eventIndex = 0;
            }
            catch (EvioException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
            catch (IOException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader openEventFile(File file) {
        this.eventTreePanel.getEventInfoPanel().setEventNumber(0);
        this.eventTreePanel.getHeaderPanel().setHeader(null);
        this.dataFilePath = file.getAbsolutePath();
        this.eventTreePanel.getEventInfoPanel().setSource(this.dataFilePath);
        try {
            if (this.evioFileReader != null) {
                this.evioFileReader.close();
                this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(0);
            }
            this.evioFileReader = new EvioReader(file);
            this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(this.evioFileReader.getEventCount());
            if (this.evioFileReader.hasDictionaryXML()) {
                this.currentDictionary = this.fileDictionary = NameProviderFactory.createNameProvider(this.evioFileReader.getDictionaryXML());
                NameProvider.setProvider(this.currentDictionary);
                this.isUserDictionary = false;
                this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
            }
            this.eventIndex = 0;
        }
        catch (EvioException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader getEvioFileReader() {
        return this.evioFileReader;
    }

    public void setDefaultDataDir(String defaultDataDir) {
        this.dataFilePath = defaultDataDir;
    }

    public boolean openDictionary() {
        JFileChooser chooser = new JFileChooser(this.dictionaryFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Dictionary Files", "xml", "dict", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            File selectedFile = chooser.getSelectedFile();
            this.currentDictionary = this.userDictionary = NameProviderFactory.createNameProvider(selectedFile);
            NameProvider.setProvider(this.currentDictionary);
            this.isUserDictionary = true;
            this.dictionaryFilePath = selectedFile.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.eventTreePanel.refreshDescription();
            return true;
        }
        return false;
    }

    public void openDictionaryFile(File file) {
        if (file != null) {
            this.currentDictionary = this.userDictionary = NameProviderFactory.createNameProvider(file);
            NameProvider.setProvider(this.currentDictionary);
            this.isUserDictionary = true;
            this.dictionaryFilePath = file.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.eventTreePanel.refreshDescription();
        }
    }

    public void addEvioListener(IEvioListener listener) {
        if (listener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, listener);
    }

    private void connectEvioListeners() {
        if (this.evioListenerList == null) {
            return;
        }
        EventParser parser = this.getEvioFileReader().getParser();
        EventListener[] listeners = this.evioListenerList.getListeners(IEvioListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            parser.addEvioListener((IEvioListener)listeners[i]);
        }
    }
}

