/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EvioException;

public class MappedMemoryHandler {
    private int blockCount;
    private int eventCount;
    private int regionCount;
    private ArrayList<int[]> eventPositions = new ArrayList(2000000);
    private ArrayList<ByteBuffer> regions = new ArrayList(100);

    int getEventCount() {
        return this.eventCount;
    }

    int getBlockCount() {
        return this.blockCount;
    }

    int getMapCount() {
        return this.regionCount;
    }

    ByteBuffer getFirstMap() {
        return this.regions.get(0);
    }

    ByteBuffer getByteBuffer(int eventNumber) {
        int[] evData = this.eventPositions.get(eventNumber);
        ByteBuffer buf = this.regions.get(evData[0]);
        buf.position(evData[1]);
        return buf;
    }

    MappedMemoryHandler(FileChannel channel, ByteOrder byteOrder) throws EvioException, IOException {
        long fileSize = channel.size();
        long offset = 0L;
        long remainingSize = fileSize;
        this.regionCount = 0;
        while (remainingSize > 0L) {
            long sz = Math.min(remainingSize, Integer.MAX_VALUE);
            MappedByteBuffer memoryMapBuf = channel.map(FileChannel.MapMode.READ_ONLY, offset, sz);
            memoryMapBuf.order(byteOrder);
            long bytesUsed = this.generateEventPositions(memoryMapBuf, this.regionCount);
            this.regions.add(memoryMapBuf);
            offset += bytesUsed;
            remainingSize -= bytesUsed;
            ++this.regionCount;
        }
    }

    MappedMemoryHandler(ByteBuffer evioBuf) throws EvioException {
        this.regionCount = 1;
        this.generateEventPositions(evioBuf, 0);
        this.regions.add(evioBuf);
    }

    private long generateEventPositions(ByteBuffer byteBuffer, int regionNumber) throws EvioException {
        boolean curLastBlock = false;
        boolean firstBlock = true;
        boolean hasDictionary = false;
        int position = 0;
        int bytesLeft = byteBuffer.limit();
        while (!curLastBlock && bytesLeft > 0) {
            int byteLen;
            int byteInfo = byteBuffer.getInt(position + 20);
            int blockSize = byteBuffer.getInt(position + 0);
            int blockHdrSize = byteBuffer.getInt(position + 8);
            int blockEventCount = byteBuffer.getInt(position + 12);
            int magicNum = byteBuffer.getInt(position + 28);
            if (magicNum != -1059454720) {
                throw new EvioException("File/buffer bad format");
            }
            if (4 * blockSize > bytesLeft) {
                if (position < 32) {
                    throw new EvioException("File/buffer bad format");
                }
                return position;
            }
            ++this.blockCount;
            this.eventCount += blockEventCount;
            curLastBlock = BlockHeaderV4.isLastBlock(byteInfo);
            if (regionNumber == 0 && firstBlock) {
                hasDictionary = BlockHeaderV4.hasDictionary(byteInfo);
            }
            position += 4 * blockHdrSize;
            bytesLeft -= 4 * blockHdrSize;
            if (regionNumber == 0 && firstBlock && hasDictionary) {
                firstBlock = false;
                byteLen = 4 * (byteBuffer.getInt(position) + 1);
                position += byteLen;
                bytesLeft -= byteLen;
            }
            for (int i = 0; i < blockEventCount; ++i) {
                if (bytesLeft < 8) {
                    throw new EvioException("File/buffer bad format");
                }
                this.eventPositions.add(new int[]{regionNumber, position});
                byteLen = 4 * (byteBuffer.getInt(position) + 1);
                position += byteLen;
                bytesLeft -= byteLen;
            }
        }
        if (position < 32) {
            throw new EvioException("File/buffer bad format");
        }
        return position;
    }
}

