/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.gui.Filter;

public class cMsgHandler {
    private JPanel panel;
    private cMsg cmsg;
    private String udl;
    private String subject;
    private String type;
    private cMsgSubscriptionHandle handle;
    private myCallback callback = new myCallback();
    private int eventNum = 1;
    private int currentIndex = -1;
    private int listLimit = 100;
    private final int maxListSize = 1000;
    private ArrayList<EvioEvent> eventList = new ArrayList(1000);
    private Filter eventFilter = Filter.EVERY;

    public Filter getEventFilter() {
        return this.eventFilter;
    }

    public void setEventFilter(Filter eventFilter) {
        this.eventFilter = eventFilter;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getType() {
        return this.type;
    }

    public void disconnect() {
        if (this.cmsg == null || !this.cmsg.isConnected()) {
            return;
        }
        try {
            this.cmsg.disconnect();
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.handle = null;
        this.subject = null;
        this.type = null;
    }

    public void connect(String udl) throws cMsgException {
        String descr;
        String name;
        if (this.cmsg == null) {
            name = "evioViewer_" + System.currentTimeMillis();
            descr = "evio event viewer";
            this.cmsg = new cMsg(udl, name, descr);
            this.udl = udl;
        }
        if (this.cmsg.isConnected()) {
            if (udl.equals(this.udl)) {
                return;
            }
            this.cmsg.disconnect();
        }
        if (!udl.equals(this.udl)) {
            name = "evioViewer_" + System.currentTimeMillis();
            descr = "evio event viewer";
            this.cmsg = new cMsg(udl, name, descr);
            this.udl = udl;
        }
        this.cmsg.connect();
        this.cmsg.start();
        this.subject = null;
        this.type = null;
    }

    public boolean subscribe(String subject, String type) throws cMsgException {
        if (this.cmsg == null || !this.cmsg.isConnected() || subject == null || type == null || subject.length() < 1 || type.length() < 1) {
            this.handle = null;
            return false;
        }
        if (subject.equals(this.subject) && type.equals(this.type)) {
            return true;
        }
        if (this.handle != null) {
            try {
                this.cmsg.unsubscribe(this.handle);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.handle = this.cmsg.subscribe(subject, type, (cMsgCallbackInterface)this.callback, null);
        this.subject = subject;
        this.type = type;
        return true;
    }

    private int extractEvents(cMsgMessage msg) {
        try {
            EvioEvent ev;
            cMsgPayloadItem payloadItem;
            ByteBuffer buf = ByteBuffer.wrap(msg.getByteArray());
            EvioReader reader = new EvioReader(buf);
            String dictionary = reader.getDictionaryXML();
            if (dictionary == null && (payloadItem = msg.getPayloadItem("dictionary")) != null) {
                try {
                    dictionary = payloadItem.getString();
                }
                catch (cMsgException e) {
                    // empty catch block
                }
            }
            while ((ev = reader.parseNextEvent()) != null) {
                ev.setDictionaryXML(dictionary);
                this.addEvent(ev);
                if (this.eventList.size() < this.listLimit) continue;
                break;
            }
        }
        catch (IOException e) {
        }
        catch (EvioException evioException) {
            // empty catch block
        }
        return this.eventNum;
    }

    private synchronized void resetEventNumber() {
        this.eventNum = 1;
    }

    public synchronized void addEvent(EvioEvent event) {
        if (event == null || this.eventList.size() >= this.listLimit) {
            return;
        }
        if (!Filter.allow(event)) {
            System.out.println("CMSG FILTER REJECTS event -> " + event);
            return;
        }
        event.setEventNumber(this.eventNum++);
        this.eventList.add(event);
    }

    public synchronized EvioEvent getEvent(int index) {
        if (index < 1 || index > this.listLimit || index > this.eventList.size()) {
            return null;
        }
        this.currentIndex = index - 1;
        return this.eventList.get(this.currentIndex);
    }

    public synchronized EvioEvent getNextEvent() {
        int nextIndex = this.currentIndex + 1;
        if (nextIndex >= this.listLimit || nextIndex >= this.eventList.size()) {
            return null;
        }
        return this.eventList.get(++this.currentIndex);
    }

    public synchronized boolean hasNextEvent() {
        int nextIndex = this.currentIndex + 1;
        return nextIndex < this.listLimit && nextIndex < this.eventList.size();
    }

    public synchronized EvioEvent getPrevEvent() {
        int prevIndex = this.currentIndex - 1;
        if (prevIndex < 0) {
            return null;
        }
        return this.eventList.get(--this.currentIndex);
    }

    public synchronized int getListSize() {
        return this.eventList.size();
    }

    public synchronized int getCurrentEventIndex() {
        return this.currentIndex;
    }

    public synchronized void resetCurrentEventIndex() {
        this.currentIndex = -1;
    }

    public void setEventNum(int eventNum) {
        this.eventNum = eventNum;
    }

    public synchronized void clearList() {
        this.eventList.clear();
        this.currentIndex = -1;
        this.resetEventNumber();
    }

    public synchronized void clearList(int numberToDelete) {
        int listSize = this.eventList.size();
        if (numberToDelete < listSize) {
            for (int i = listSize; i > listSize - numberToDelete; --i) {
                this.eventList.remove(i - 1);
            }
            if (this.currentIndex >= this.eventList.size()) {
                this.currentIndex = -1;
            }
            return;
        }
        this.clearList();
    }

    public synchronized int getListLimit() {
        return this.listLimit;
    }

    public synchronized void setListLimit(int limit) {
        if (limit < 1 || limit == this.listLimit) {
            return;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        if (limit < this.listLimit && limit < this.eventList.size()) {
            this.clearList(this.eventList.size() - limit);
        }
        this.listLimit = limit;
    }

    public JPanel createCmsgPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        final Color darkGreen = new Color(0, 160, 0);
        final Color darkRed = new Color(160, 0, 0);
        final JTextField UDL = new JTextField("cMsg://localhost/cMsg/myNameSpace");
        final JTextField Subject = new JTextField("evio");
        final JTextField Type2 = new JTextField("*");
        final JButton connectButton = new JButton("Connect");
        UDL.setEditable(true);
        UDL.setMargin(new Insets(2, 5, 2, 5));
        ActionListener al_sub = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    cMsgHandler.this.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("evio");
                }
            }
        };
        Subject.addActionListener(al_sub);
        MouseAdapter ml_sub = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    cMsgHandler.this.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("evio");
                }
            }
        };
        Subject.addMouseListener(ml_sub);
        Subject.setEditable(true);
        Subject.setMargin(new Insets(2, 5, 2, 5));
        ActionListener al_typ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    cMsgHandler.this.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("*");
                }
            }
        };
        Type2.addActionListener(al_typ);
        MouseAdapter ml_typ = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    cMsgHandler.this.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("*");
                }
            }
        };
        Type2.addMouseListener(ml_typ);
        Type2.setEditable(true);
        Type2.setMargin(new Insets(2, 5, 2, 5));
        final JLabel status = new JLabel("  Press button to connect to cMsg server  ");
        status.setVerticalTextPosition(0);
        status.setBorder(new LineBorder(Color.black));
        JPanel p1 = new JPanel();
        ActionListener al_con = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                if (button.getText().equals("Connect")) {
                    try {
                        cMsgHandler.this.connect(UDL.getText());
                        cMsgHandler.this.subscribe(Subject.getText(), Type2.getText());
                    }
                    catch (cMsgException e1) {
                        status.setForeground(Color.red);
                        status.setText(" Failed to connect to cMsg server");
                        return;
                    }
                    UDL.setEnabled(false);
                    status.setForeground(darkGreen);
                    status.setText(" Connected to cMsg server");
                    connectButton.setText("Disconnect");
                } else {
                    cMsgHandler.this.disconnect();
                    UDL.setEnabled(true);
                    status.setForeground(darkRed);
                    status.setText(" Disconnected from cMsg server");
                    connectButton.setText("Connect");
                }
            }
        };
        connectButton.setAlignmentX(0.5f);
        connectButton.addActionListener(al_con);
        connectButton.setEnabled(true);
        p1.setBorder(new EmptyBorder(2, 5, 2, 5));
        p1.setLayout(new GridLayout(0, 1));
        p1.add(connectButton);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(4, 0));
        JLabel label1 = new JLabel("UDL ");
        label1.setHorizontalAlignment(4);
        p3.add(label1);
        JLabel label2 = new JLabel("Subject ");
        label2.setHorizontalAlignment(4);
        p3.add(label2);
        JLabel label3 = new JLabel("Type ");
        label3.setHorizontalAlignment(4);
        p3.add(label3);
        JLabel label4 = new JLabel("Status ");
        label4.setHorizontalAlignment(4);
        p3.add(label4);
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(4, 0));
        p4.add(UDL);
        p4.add(Subject);
        p4.add(Type2);
        p4.add(status);
        Dimension d = p3.getPreferredSize();
        d.height = p4.getPreferredSize().height;
        p3.setMaximumSize(d);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(Box.createRigidArea(new Dimension(5, 0)));
        p2.add(p3);
        p2.add(p4);
        p2.add(Box.createRigidArea(new Dimension(3, 0)));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(Box.createRigidArea(new Dimension(0, 3)));
        this.panel.add(p2);
        this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.panel.add(p1);
        this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        return this.panel;
    }

    private class myCallback
    extends cMsgCallbackAdapter {
        private myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            if (cMsgHandler.this.eventList.size() >= cMsgHandler.this.listLimit) {
                return;
            }
            byte[] data = msg.getByteArray();
            if (data == null) {
                return;
            }
            cMsgHandler.this.extractEvents(msg);
        }
    }
}

