/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class EvioCompactStructureHandler {
    private EvioNode node;
    private LinkedList<EvioNode> scannedStructures;
    private LinkedList<EvioNode> scannedChildStructures;
    private ByteBuffer byteBuffer;
    private ByteOrder byteOrder;
    private int initialPosition;

    public EvioCompactStructureHandler(ByteBuffer byteBuffer, DataType type) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        if (type == null || !type.isStructure()) {
            throw new EvioException("type arg is null or is not an evio structure");
        }
        if (byteBuffer.remaining() < 1) {
            throw new EvioException("Buffer has too little data");
        }
        if ((type == DataType.BANK || type == DataType.ALSOBANK) && byteBuffer.remaining() < 2) {
            throw new EvioException("Buffer has too little data");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        this.byteOrder = byteBuffer.order();
        this.node = this.extractNode(byteBuffer, null, null, type, this.initialPosition, 0, false);
        if (this.node.len + 1 < byteBuffer.remaining() / 4) {
            throw new EvioException("Buffer has too little data");
        }
    }

    public synchronized void setBuffer(ByteBuffer buf, DataType type) throws EvioException {
        if (buf == null) {
            throw new EvioException("Buffer arg is null");
        }
        if (type == null || !type.isStructure()) {
            throw new EvioException("type arg is null or is not an evio structure");
        }
        if (this.byteBuffer.remaining() < 1) {
            throw new EvioException("Buffer has too little data");
        }
        if ((type == DataType.BANK || type == DataType.ALSOBANK) && this.byteBuffer.remaining() < 2) {
            throw new EvioException("Buffer has too little data");
        }
        this.close();
        this.scannedStructures.clear();
        this.initialPosition = buf.position();
        this.byteBuffer = buf;
        this.byteOrder = this.byteBuffer.order();
        this.node = this.extractNode(this.byteBuffer, null, null, type, this.initialPosition, 0, false);
        if (this.node.len + 1 < this.byteBuffer.remaining() / 4) {
            throw new EvioException("Buffer has too little data");
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public EvioNode getStructure() {
        return this.node;
    }

    private EvioNode extractNode(ByteBuffer buffer, BlockNode blockNode, EvioNode eventNode, DataType type, int position, int place, boolean isEvent) throws EvioException {
        EvioNode node = new EvioNode();
        node.pos = position;
        node.place = place;
        node.blockNode = blockNode;
        node.eventNode = eventNode;
        node.isEvent = isEvent;
        node.type = type.getValue();
        try {
            switch (type) {
                case BANK: 
                case ALSOBANK: {
                    node.len = buffer.getInt(position);
                    node.dataPos = position + 8;
                    node.dataLen = node.len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        node.tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.num = buffer.get(position) & 0xFF;
                        break;
                    }
                    node.num = buffer.get(position++) & 0xFF;
                    int dt = buffer.get(position++) & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    if (dt == 64) {
                        node.dataType = DataType.TAGSEGMENT.getValue();
                        node.pad = 0;
                    }
                    node.tag = buffer.getShort(position) & 0xFFFF;
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: {
                    node.dataPos = position + 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        node.tag = buffer.get(position++) & 0xFF;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.len = buffer.getShort(position) & 0xFFFF;
                    } else {
                        node.len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.tag = buffer.get(position) & 0xFF;
                    }
                    node.dataLen = node.len;
                    break;
                }
                case TAGSEGMENT: {
                    node.dataPos = position + 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        int temp = buffer.getShort(position) & 0xFFFF;
                        node.tag = temp >>> 4;
                        node.dataType = temp & 0xF;
                        node.len = buffer.getShort(position += 2) & 0xFFFF;
                    } else {
                        node.len = buffer.getShort(position) & 0xFFFF;
                        int temp = buffer.getShort(position += 2) & 0xFFFF;
                        node.tag = temp >>> 4;
                        node.dataType = temp & 0xF;
                    }
                    node.dataLen = node.len;
                    break;
                }
                default: {
                    throw new EvioException("File/buffer bad format");
                }
            }
        }
        catch (BufferUnderflowException a) {
            throw new EvioException("File/buffer bad format");
        }
        return node;
    }

    private static void scanStructure(ByteBuffer buffer, EvioNode node, EvioNode eventNode, BlockNode blockNode, DataType type, int length, int position, List<EvioNode> list) {
        if (node != null && node.scanned) {
            return;
        }
        if (!type.isStructure()) {
            return;
        }
        int dataBytes = 4 * length;
        int endingPos = position + dataBytes;
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                while (position < endingPos) {
                    int num;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    int len = buffer.getInt(position);
                    int dataLen = len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        num = buffer.get(position++) & 0xFF;
                    } else {
                        num = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.BANK.getValue();
                    kidNode.pos = position - 8;
                    kidNode.dataLen = dataLen;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = num;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactStructureHandler.scanStructure(buffer, null, eventNode, blockNode, dType, dataLen, position, list);
                    }
                    position += 4 * dataLen;
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.get(position++) & 0xFF;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.SEGMENT.getValue();
                    kidNode.pos = position - 4;
                    kidNode.dataLen = len;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactStructureHandler.scanStructure(buffer, null, eventNode, blockNode, dType, len, position, list);
                    }
                    position += 4 * len;
                }
                break;
            }
            case TAGSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int dataType;
                    int tag;
                    int temp;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        temp = buffer.getShort(position) & 0xFFFF;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                        len = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        temp = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                    }
                    DataType dType = DataType.getDataType(dataType);
                    EvioNode kidNode = new EvioNode();
                    kidNode.len = len;
                    kidNode.type = DataType.TAGSEGMENT.getValue();
                    kidNode.pos = position - 4;
                    kidNode.dataLen = len;
                    kidNode.dataType = dataType;
                    kidNode.dataPos = position;
                    kidNode.eventNode = eventNode;
                    kidNode.blockNode = blockNode;
                    kidNode.pad = 0;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    list.add(kidNode);
                    if (dType.isStructure()) {
                        EvioCompactStructureHandler.scanStructure(buffer, null, eventNode, blockNode, dType, len, position, list);
                    }
                    position += 4 * len;
                }
                break;
            }
        }
        if (node != null && node.isEvent) {
            node.scanned = true;
        }
    }

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    private LinkedList<EvioNode> scanStructure() {
        if (this.scannedStructures == null) {
            this.scannedStructures = new LinkedList();
            this.scannedChildStructures = new LinkedList();
            EvioCompactStructureHandler.scanStructure(this.byteBuffer, this.node, this.node, this.node.blockNode, this.node.getDataTypeObj(), this.node.dataLen, this.node.dataPos, this.scannedChildStructures);
            this.scannedStructures.addAll(this.scannedChildStructures);
            this.scannedStructures.add(this.node);
        }
        return this.scannedStructures;
    }

    public List<EvioNode> searchStructure(int tag, int num) throws EvioException {
        if (tag < 0 || num < 0) {
            throw new EvioException("bad arg value(s)");
        }
        LinkedList<EvioNode> returnList = new LinkedList<EvioNode>();
        LinkedList<EvioNode> list = this.scanStructure();
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    public List<EvioNode> searchStructure(String dictName, EvioXMLDictionary dictionary) throws EvioException {
        if (dictName == null || dictionary == null) {
            throw new EvioException("null dictionary and/or entry name");
        }
        int tag = dictionary.getTag(dictName);
        int num = dictionary.getNum(dictName);
        if (tag == -1 || num == -1) {
            throw new EvioException("no dictionary entry for " + dictName);
        }
        return this.searchStructure(tag, num);
    }

    public ByteBuffer addStructure(ByteBuffer addBuffer) throws EvioException {
        if (addBuffer == null || addBuffer.remaining() < 4) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        int endPos = this.node.dataPos + 4 * this.node.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = this.node.getDataTypeObj();
        ByteBuffer newBuffer = ByteBuffer.allocate(endPos - this.initialPosition + appendDataLen);
        newBuffer.order(this.byteOrder);
        this.byteBuffer.position(this.initialPosition).limit(endPos);
        newBuffer.put(this.byteBuffer);
        int newDataPos = newBuffer.position();
        newBuffer.put(addBuffer);
        newBuffer.flip();
        this.byteBuffer.position(this.initialPosition);
        addBuffer.position(origAddBufPos);
        boolean didEventNode = false;
        if (this.initialPosition != 0) {
            if (this.scannedStructures != null) {
                for (EvioNode evNode : this.scannedStructures) {
                    evNode.pos -= this.initialPosition;
                    evNode.dataPos -= this.initialPosition;
                    if (evNode != this.node) continue;
                    didEventNode = true;
                }
            }
            if (!didEventNode) {
                this.node.pos -= this.initialPosition;
                this.node.dataPos -= this.initialPosition;
            }
        }
        this.byteBuffer = newBuffer;
        this.initialPosition = newBuffer.position();
        int eventLenPos = this.node.pos;
        this.node.len += appendDataWordLen;
        this.node.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                newBuffer.putInt(eventLenPos, this.node.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    newBuffer.putShort(eventLenPos + 2, (short)this.node.len);
                    break;
                }
                newBuffer.putShort(eventLenPos, (short)this.node.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        if (this.node.scanned) {
            EvioNode newNode = this.extractNode(newBuffer, this.node.blockNode, this.node, eventDataType, newDataPos, 0, false);
            this.scannedStructures.add(newNode);
            EvioCompactStructureHandler.scanStructure(newBuffer, null, newNode.eventNode, newNode.blockNode, newNode.getDataTypeObj(), newNode.dataLen, newNode.dataPos, this.scannedStructures);
        }
        return newBuffer;
    }

    public ByteBuffer getData(EvioNode node) {
        return this.getData(node, false);
    }

    public synchronized ByteBuffer getData(EvioNode node, boolean copy) {
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.position(node.dataPos).limit(node.dataPos + 4 * node.dataLen);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * node.dataLen);
            newBuf.put(this.byteBuffer);
            newBuf.order(this.byteOrder);
            newBuf.flip();
            this.byteBuffer.position(pos).limit(lim);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice();
        buf.order(this.byteOrder);
        this.byteBuffer.position(pos).limit(lim);
        return buf;
    }

    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.position(node.pos).limit(node.dataPos + 4 * node.dataLen);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(node.dataPos + 4 * node.dataLen - node.pos);
            newBuf.put(this.byteBuffer);
            newBuf.order(this.byteOrder);
            newBuf.flip();
            this.byteBuffer.position(pos).limit(lim);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice();
        buf.order(this.byteOrder);
        this.byteBuffer.position(pos).limit(lim);
        return buf;
    }

    public synchronized List<EvioNode> getNodes() {
        return Collections.unmodifiableList(this.scanStructure());
    }

    public synchronized List<EvioNode> getChildNodes() {
        this.scanStructure();
        return Collections.unmodifiableList(this.scannedChildStructures);
    }

    public void close() {
        this.byteBuffer.position(this.initialPosition);
    }
}

