/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;
import org.jlab.coda.jevio.gui.DictionarySource;
import org.jlab.coda.jevio.gui.EtHandler;
import org.jlab.coda.jevio.gui.EventInfoPanel;
import org.jlab.coda.jevio.gui.EventSource;
import org.jlab.coda.jevio.gui.EventTreePanel;
import org.jlab.coda.jevio.gui.Filter;
import org.jlab.coda.jevio.gui.cMsgHandler;

public class EventTreeMenu {
    JButton nextButton;
    JButton prevButton;
    private JMenuItem xmlExportItem;
    private JMenuItem openEventFile;
    private JMenu eventSourceConfig;
    private JMenu filterMenu;
    private JSpinner currentEvent;
    private int currentEventNum;
    private int currentEventMax;
    private int currentEventMin;
    private EventTreePanel eventTreePanel;
    private EventSource eventSource = EventSource.FILE;
    private int eventIndex;
    private Color bg1Color = null;
    private Color bg2Color = null;
    private String dataFilePath;
    private String dictionaryFilePath = "";
    private String xmlFilePath;
    private FileNameExtensionFilter evioFileFilter;
    private EvioReader evioFileReader;
    private JRadioButtonMenuItem fileItem = new JRadioButtonMenuItem("EvioFile");
    private JRadioButtonMenuItem xmlItem = new JRadioButtonMenuItem("Xml");
    private JRadioButtonMenuItem cmsgItem = new JRadioButtonMenuItem("cMsg");
    private JRadioButtonMenuItem etItem = new JRadioButtonMenuItem("Et");
    private JRadioButtonMenuItem noItem = new JRadioButtonMenuItem("None");
    private DictionarySource dictionarySource = DictionarySource.NONE;
    private HashMap<String, EvioXMLDictionary> dictionaryMap = new HashMap(32);
    private JPanel cmsgPanel;
    private cMsgHandler cmsgHandler;
    private JPanel etPanel;
    private EtHandler etHandler;
    private UpdateThread listSizeUpdateThread;
    private JSpinner triggerType;
    private JSpinner qLimit;
    private JButton clearQ;
    private boolean isListSizeOne;
    private final Color darkGreen = new Color(0, 140, 0);
    private final Color darkRed = new Color(160, 0, 0);
    private JLabel qSize;
    EventInfoPanel eventInfoPanel;
    private EventListenerList evioListenerList;

    public EventTreeMenu(EventTreePanel eventTreePanel, EventInfoPanel eventInfoPanel) {
        this.eventTreePanel = eventTreePanel;
        this.eventInfoPanel = eventInfoPanel;
    }

    public EventTreePanel getEventTreePanel() {
        return this.eventTreePanel;
    }

    public JMenu getEventSourceConfig() {
        return this.eventSourceConfig;
    }

    public cMsgHandler getCmsgHandler() {
        return this.cmsgHandler;
    }

    public void setCmsgHandler(cMsgHandler cmsgHandler) {
        this.cmsgHandler = cmsgHandler;
    }

    private void setNumberOfEventsColor(Color color) {
        this.qSize.setForeground(color);
    }

    private void displayCmsgEvent(EvioEvent event) {
        if (event != null) {
            this.eventTreePanel.setEvent(event);
            String xml = event.getDictionaryXML();
            if (xml != null) {
                EvioXMLDictionary dict = this.dictionaryMap.get(xml);
                if (dict == null) {
                    dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(xml);
                    this.dictionaryMap.put(xml, dict);
                }
                DictionarySource.CMSG.setDictionary(dict);
                this.cmsgItem.setEnabled(true);
            } else {
                DictionarySource.CMSG.setDictionary(null);
                this.validateDictionarySource();
                this.cmsgItem.setSelected(false);
                this.cmsgItem.setEnabled(false);
            }
            this.currentEvent.setValue(event.getEventNumber());
        }
    }

    private void displayEtEvent(EvioEvent event) {
        if (event != null) {
            this.eventTreePanel.setEvent(event);
            String xml = event.getDictionaryXML();
            if (xml != null) {
                EvioXMLDictionary dict = this.dictionaryMap.get(xml);
                if (dict == null) {
                    dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(xml);
                    this.dictionaryMap.put(xml, dict);
                }
                DictionarySource.ET.setDictionary(dict);
                this.etItem.setEnabled(true);
            } else {
                DictionarySource.ET.setDictionary(null);
                this.validateDictionarySource();
                this.etItem.setSelected(false);
                this.etItem.setEnabled(false);
            }
            this.currentEvent.setValue(event.getEventNumber());
        }
    }

    private void setCmsgButtons() {
        if (this.isListSizeOne) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(true);
        } else {
            if (this.cmsgHandler.getCurrentEventIndex() > 0) {
                this.prevButton.setEnabled(true);
            } else {
                this.prevButton.setEnabled(false);
            }
            if (this.cmsgHandler.getCurrentEventIndex() >= this.cmsgHandler.getListSize() - 1) {
                this.nextButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(true);
            }
        }
    }

    private void setEtButtons() {
        if (this.isListSizeOne) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(true);
        } else {
            if (this.etHandler.getCurrentEventIndex() > 0) {
                this.prevButton.setEnabled(true);
            } else {
                this.prevButton.setEnabled(false);
            }
            if (this.etHandler.getCurrentEventIndex() >= this.etHandler.getListSize() - 1) {
                this.nextButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(true);
            }
        }
    }

    private void setEventSource(EventSource source) {
        if (source == this.eventSource) {
            return;
        }
        this.eventSource = source;
        this.eventTreePanel.setEvent(null);
        this.setDictionarySource(this.eventSource.getDictionarySource());
        switch (source) {
            case CMSG: {
                this.filterMenu.setEnabled(true);
                this.eventSourceConfig.setEnabled(true);
                this.eventSourceConfig.removeAll();
                this.eventSourceConfig.add(this.cmsgPanel);
                this.eventSourceConfig.setText("cMsg config");
                this.openEventFile.setEnabled(false);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.qLimit.getModel().setValue(this.cmsgHandler.getListLimit());
                int evIndex = this.cmsgHandler.getCurrentEventIndex() + 1;
                EvioEvent ev = this.cmsgHandler.getEvent(evIndex);
                if (ev != null) {
                    this.eventTreePanel.setEvent(ev);
                }
                this.eventInfoPanel.setSource("cMsg messages");
                int listSize = this.cmsgHandler.getListSize();
                if (listSize >= this.cmsgHandler.getListLimit()) {
                    this.setNumberOfEventsColor(this.darkRed);
                    this.qSize.setText("Full  " + listSize);
                } else {
                    this.setNumberOfEventsColor(this.darkGreen);
                    this.qSize.setText("" + listSize);
                }
                SpinnerNumberModel model = (SpinnerNumberModel)this.currentEvent.getModel();
                if (listSize > 0) {
                    this.currentEvent.setEnabled(true);
                    if (evIndex > 0) {
                        model.setMinimum(Integer.valueOf(1));
                    } else {
                        model.setMinimum(Integer.valueOf(0));
                    }
                } else {
                    this.currentEvent.setEnabled(false);
                    model.setMinimum(Integer.valueOf(0));
                }
                model.setMaximum(Integer.valueOf(listSize));
                model.setValue(evIndex);
                this.setCmsgButtons();
                this.qLimit.setEnabled(true);
                this.clearQ.setEnabled(true);
                if (this.listSizeUpdateThread != null) break;
                this.listSizeUpdateThread = new UpdateThread();
                this.listSizeUpdateThread.start();
                break;
            }
            case ET: {
                this.filterMenu.setEnabled(true);
                this.eventSourceConfig.setEnabled(true);
                this.eventSourceConfig.removeAll();
                this.eventSourceConfig.add(this.etPanel);
                this.eventSourceConfig.setText("ET config");
                this.openEventFile.setEnabled(false);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.qLimit.getModel().setValue(this.etHandler.getListLimit());
                int evIndex = this.etHandler.getCurrentEventIndex() + 1;
                EvioEvent ev = this.etHandler.getEvent(evIndex);
                if (ev != null) {
                    this.eventTreePanel.setEvent(ev);
                }
                this.eventInfoPanel.setSource("ET buffers");
                int listSize = this.etHandler.getListSize();
                if (listSize >= this.etHandler.getListLimit()) {
                    this.setNumberOfEventsColor(this.darkRed);
                    this.qSize.setText("Full  " + listSize);
                } else {
                    this.setNumberOfEventsColor(this.darkGreen);
                    this.qSize.setText("" + listSize);
                }
                SpinnerNumberModel model = (SpinnerNumberModel)this.currentEvent.getModel();
                if (listSize > 0) {
                    this.currentEvent.setEnabled(true);
                    if (evIndex > 0) {
                        model.setMinimum(Integer.valueOf(1));
                    } else {
                        model.setMinimum(Integer.valueOf(0));
                    }
                } else {
                    this.currentEvent.setEnabled(false);
                    model.setMinimum(Integer.valueOf(0));
                }
                model.setMaximum(Integer.valueOf(listSize));
                model.setValue(evIndex);
                this.setEtButtons();
                this.qLimit.setEnabled(true);
                this.clearQ.setEnabled(true);
                if (this.listSizeUpdateThread != null) break;
                this.listSizeUpdateThread = new UpdateThread();
                this.listSizeUpdateThread.start();
                break;
            }
            case FILE: {
                this.filterMenu.setEnabled(false);
                if (this.listSizeUpdateThread != null) {
                    this.listSizeUpdateThread.interrupt();
                    this.listSizeUpdateThread = null;
                }
                this.eventSourceConfig.setText(" ");
                this.eventSourceConfig.setEnabled(false);
                this.openEventFile.setEnabled(true);
                String fileName = "";
                int eventCount = 0;
                if (this.evioFileReader == null) {
                    this.prevButton.setEnabled(false);
                    this.nextButton.setEnabled(false);
                } else {
                    if (this.eventIndex > 1) {
                        this.prevButton.setEnabled(true);
                    } else {
                        this.prevButton.setEnabled(false);
                    }
                    try {
                        if (this.eventIndex >= this.evioFileReader.getEventCount()) {
                            this.nextButton.setEnabled(false);
                        } else {
                            this.nextButton.setEnabled(true);
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                    this.xmlExportItem.setEnabled(true);
                    fileName = this.dataFilePath;
                    try {
                        eventCount = this.evioFileReader.getEventCount();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                    try {
                        EvioEvent event = this.evioFileReader.parseEvent(this.eventIndex);
                        if (event != null) {
                            this.eventTreePanel.setEvent(event);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                }
                this.eventInfoPanel.setSource(fileName);
                SpinnerNumberModel model = (SpinnerNumberModel)this.currentEvent.getModel();
                model.setValue(this.eventIndex);
                model.setMaximum(Integer.valueOf(eventCount));
                if (eventCount > 0) {
                    this.currentEvent.setEnabled(true);
                    if (this.eventIndex > 0) {
                        model.setMinimum(Integer.valueOf(1));
                    }
                } else {
                    this.currentEvent.setEnabled(false);
                    model.setMinimum(Integer.valueOf(0));
                }
                this.qSize.setText("" + eventCount);
                this.qLimit.setValue(eventCount);
                this.setNumberOfEventsColor(Color.black);
                this.qLimit.setEnabled(false);
                this.clearQ.setEnabled(false);
                break;
            }
        }
    }

    private void setDictionarySource(DictionarySource dictSource) {
        if (dictSource == null) {
            return;
        }
        String dictText = "";
        String description = "";
        EvioXMLDictionary dictionary = dictSource.getDictionary();
        if (dictionary == null) {
            dictSource = DictionarySource.NONE;
        } else {
            dictText = dictionary.toXML();
        }
        this.dictionarySource = dictSource;
        this.eventSource.setDictionarySource(dictSource);
        switch (dictSource) {
            case EVIOFILE: {
                this.fileItem.setEnabled(true);
                this.fileItem.setSelected(true);
                description = "from evio file";
                break;
            }
            case XML: {
                this.xmlItem.setEnabled(true);
                this.xmlItem.setSelected(true);
                description = this.dictionaryFilePath;
                break;
            }
            case CMSG: {
                this.cmsgItem.setEnabled(true);
                this.cmsgItem.setSelected(true);
                description = "from cMsg message";
                break;
            }
            case ET: {
                this.etItem.setEnabled(true);
                this.etItem.setSelected(true);
                description = "from ET event";
                break;
            }
            case NONE: {
                this.noItem.setSelected(true);
                description = "none";
                break;
            }
        }
        NameProvider.setProvider(dictionary);
        this.eventInfoPanel.setDictionary(description);
        this.eventTreePanel.setDictionaryText(dictText);
        this.eventTreePanel.refreshDescription();
        this.eventTreePanel.repaintTreeAfterNewDictionary();
    }

    private void validateDictionarySource() {
        if (this.dictionarySource == null) {
            return;
        }
        if (this.dictionarySource != DictionarySource.ET && this.dictionarySource != DictionarySource.CMSG) {
            return;
        }
        EvioXMLDictionary dictionary = this.dictionarySource.getDictionary();
        if (dictionary != null) {
            return;
        }
        this.dictionarySource = DictionarySource.NONE;
        this.noItem.setSelected(true);
        NameProvider.setProvider(dictionary);
        this.eventInfoPanel.setDictionary("none");
        this.eventTreePanel.setDictionaryText("");
        this.eventTreePanel.refreshDescription();
        this.eventTreePanel.repaintTreeAfterNewDictionary();
    }

    JPanel addEventControlPanel() {
        this.nextButton = new JButton("next >");
        this.nextButton.setEnabled(false);
        ActionListener al_next = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        if (EventTreeMenu.this.evioFileReader == null) break;
                        try {
                            if (EventTreeMenu.this.eventIndex >= EventTreeMenu.this.evioFileReader.getEventCount()) break;
                            EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(++EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                                SpinnerNumberModel model = (SpinnerNumberModel)EventTreeMenu.this.currentEvent.getModel();
                                model.setValue(event.getEventNumber());
                                model.setMinimum(Integer.valueOf(1));
                            }
                            if (EventTreeMenu.this.eventIndex > 1) {
                                EventTreeMenu.this.prevButton.setEnabled(true);
                            }
                            if (EventTreeMenu.this.eventIndex < EventTreeMenu.this.evioFileReader.getEventCount()) break;
                            EventTreeMenu.this.nextButton.setEnabled(false);
                        }
                        catch (IOException e1) {
                            EventTreeMenu.this.eventIndex--;
                            e1.printStackTrace();
                        }
                        catch (EvioException e1) {
                            EventTreeMenu.this.eventIndex--;
                            e1.printStackTrace();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    case CMSG: {
                        if (EventTreeMenu.this.cmsgHandler == null) break;
                        if (EventTreeMenu.this.isListSizeOne) {
                            EventTreeMenu.this.cmsgHandler.clearList();
                            EventTreeMenu.this.eventTreePanel.setEvent(null);
                            EventTreeMenu.this.currentEvent.setValue(0);
                            break;
                        }
                        EventTreeMenu.this.displayCmsgEvent(EventTreeMenu.this.cmsgHandler.getNextEvent());
                        EventTreeMenu.this.setCmsgButtons();
                        break;
                    }
                    case ET: {
                        if (EventTreeMenu.this.etHandler == null) break;
                        if (EventTreeMenu.this.isListSizeOne) {
                            EventTreeMenu.this.etHandler.stopFillingEventList();
                            EventTreeMenu.this.etHandler.clearList();
                            EventTreeMenu.this.eventTreePanel.setEvent(null);
                            EventTreeMenu.this.etHandler.startFillingEventList();
                            EventTreeMenu.this.currentEvent.setValue(0);
                            break;
                        }
                        if (!EventTreeMenu.this.etHandler.hasNextEvent()) break;
                        EventTreeMenu.this.displayEtEvent(EventTreeMenu.this.etHandler.getNextEvent());
                        EventTreeMenu.this.setEtButtons();
                        break;
                    }
                }
            }
        };
        this.nextButton.addActionListener(al_next);
        this.prevButton = new JButton("< prev");
        this.prevButton.setEnabled(false);
        ActionListener al_prev = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        if (EventTreeMenu.this.evioFileReader == null) break;
                        try {
                            if (EventTreeMenu.this.eventIndex < 2) break;
                            EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(--EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                                EventTreeMenu.this.currentEvent.setValue(event.getEventNumber());
                            }
                            if (EventTreeMenu.this.eventIndex < 2) {
                                EventTreeMenu.this.prevButton.setEnabled(false);
                            }
                            if (EventTreeMenu.this.eventIndex >= EventTreeMenu.this.evioFileReader.getEventCount()) break;
                            EventTreeMenu.this.nextButton.setEnabled(true);
                        }
                        catch (IOException e1) {
                            EventTreeMenu.this.eventIndex++;
                            e1.printStackTrace();
                        }
                        catch (EvioException e1) {
                            EventTreeMenu.this.eventIndex++;
                            e1.printStackTrace();
                        }
                        break;
                    }
                    case CMSG: {
                        if (EventTreeMenu.this.cmsgHandler == null || EventTreeMenu.this.cmsgHandler.getCurrentEventIndex() < 1) break;
                        EventTreeMenu.this.displayCmsgEvent(EventTreeMenu.this.cmsgHandler.getPrevEvent());
                        EventTreeMenu.this.setCmsgButtons();
                        break;
                    }
                    case ET: {
                        if (EventTreeMenu.this.etHandler == null || EventTreeMenu.this.etHandler.getCurrentEventIndex() < 1) break;
                        EventTreeMenu.this.displayEtEvent(EventTreeMenu.this.etHandler.getPrevEvent());
                        EventTreeMenu.this.setEtButtons();
                        break;
                    }
                }
            }
        };
        this.prevButton.addActionListener(al_prev);
        ChangeListener currentEventListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)e.getSource()).getModel();
                    int eventNum = model.getNumber().intValue();
                    int max = (Integer)model.getMaximum();
                    int min = (Integer)model.getMinimum();
                    if (EventTreeMenu.this.currentEventMax != max) {
                        EventTreeMenu.this.currentEventMax = max;
                        return;
                    }
                    if (EventTreeMenu.this.currentEventMin != min) {
                        EventTreeMenu.this.currentEventMin = min;
                        return;
                    }
                    if (EventTreeMenu.this.currentEventNum != eventNum) {
                        EventTreeMenu.this.currentEventNum = eventNum;
                    }
                    switch (EventTreeMenu.this.eventSource) {
                        case FILE: {
                            if (eventNum <= 0 || eventNum > EventTreeMenu.this.evioFileReader.getEventCount()) break;
                            EventTreeMenu.this.eventIndex = eventNum;
                            EvioEvent event = EventTreeMenu.this.evioFileReader.gotoEventNumber(EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                                EventTreeMenu.this.currentEvent.setValue(event.getEventNumber());
                            }
                            if (EventTreeMenu.this.eventIndex > 1) {
                                EventTreeMenu.this.prevButton.setEnabled(true);
                            } else {
                                EventTreeMenu.this.prevButton.setEnabled(false);
                            }
                            if (EventTreeMenu.this.eventIndex >= EventTreeMenu.this.evioFileReader.getEventCount()) {
                                EventTreeMenu.this.nextButton.setEnabled(false);
                                break;
                            }
                            EventTreeMenu.this.nextButton.setEnabled(true);
                            break;
                        }
                        case CMSG: {
                            if (EventTreeMenu.this.cmsgHandler == null) break;
                            if (eventNum < 1) {
                                EventTreeMenu.this.eventTreePanel.setEvent(null);
                                EventTreeMenu.this.currentEvent.setValue(0);
                                return;
                            }
                            if (eventNum <= 0 || eventNum > EventTreeMenu.this.cmsgHandler.getListSize()) break;
                            EventTreeMenu.this.displayCmsgEvent(EventTreeMenu.this.cmsgHandler.getEvent(eventNum));
                            EventTreeMenu.this.setCmsgButtons();
                            break;
                        }
                        case ET: {
                            if (EventTreeMenu.this.etHandler == null) break;
                            if (eventNum < 1) {
                                EventTreeMenu.this.eventTreePanel.setEvent(null);
                                EventTreeMenu.this.currentEvent.setValue(0);
                                return;
                            }
                            if (eventNum <= 0 || eventNum > EventTreeMenu.this.etHandler.getListSize()) break;
                            EventTreeMenu.this.displayEtEvent(EventTreeMenu.this.etHandler.getEvent(eventNum));
                            EventTreeMenu.this.setEtButtons();
                            break;
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        JLabel evLabel = new JLabel("Event #");
        evLabel.setOpaque(true);
        evLabel.setBackground(this.bg1Color);
        evLabel.setForeground(Color.blue);
        evLabel.setHorizontalAlignment(0);
        this.currentEvent = new JSpinner(new SpinnerNumberModel(0, 0, 0, 1));
        this.currentEvent.addChangeListener(currentEventListener);
        this.currentEvent.setEnabled(false);
        this.currentEvent.setMaximumSize(new Dimension(10, 20));
        this.clearQ = new JButton("clear");
        this.clearQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkGreen);
                switch (EventTreeMenu.this.eventSource) {
                    case CMSG: {
                        EventTreeMenu.this.cmsgHandler.clearList();
                        EventTreeMenu.this.prevButton.setEnabled(false);
                        EventTreeMenu.this.nextButton.setEnabled(false);
                        EventTreeMenu.this.eventTreePanel.setEvent(null);
                        SpinnerNumberModel model = (SpinnerNumberModel)EventTreeMenu.this.currentEvent.getModel();
                        model.setMinimum(Integer.valueOf(0));
                        model.setValue(0);
                        EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkGreen);
                        EventTreeMenu.this.qSize.setText("0");
                        break;
                    }
                    case ET: {
                        EventTreeMenu.this.etHandler.stopFillingEventList();
                        EventTreeMenu.this.etHandler.clearList();
                        EventTreeMenu.this.prevButton.setEnabled(false);
                        EventTreeMenu.this.nextButton.setEnabled(false);
                        EventTreeMenu.this.eventTreePanel.setEvent(null);
                        SpinnerNumberModel model = (SpinnerNumberModel)EventTreeMenu.this.currentEvent.getModel();
                        model.setMinimum(Integer.valueOf(0));
                        model.setValue(0);
                        EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkGreen);
                        EventTreeMenu.this.qSize.setText("0");
                        EventTreeMenu.this.etHandler.startFillingEventList();
                    }
                }
            }
        });
        this.clearQ.setEnabled(false);
        this.clearQ.setAlignmentX(0.5f);
        JLabel qLabel = new JLabel(" Limit ");
        qLabel.setOpaque(true);
        qLabel.setBackground(this.bg2Color);
        qLabel.setHorizontalAlignment(0);
        this.qLimit = new JSpinner(new SpinnerNumberModel(100, 1, 1000, 1));
        this.qLimit.setEnabled(false);
        this.qLimit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)e.getSource()).getModel();
                int limit = model.getNumber().intValue();
                switch (EventTreeMenu.this.eventSource) {
                    case CMSG: {
                        int num2delete = EventTreeMenu.this.cmsgHandler.getListSize() - limit;
                        if (num2delete > 0) {
                            EventTreeMenu.this.cmsgHandler.setEventNum(limit + 1);
                        }
                        int evIndex = EventTreeMenu.this.cmsgHandler.getCurrentEventIndex();
                        EventTreeMenu.this.cmsgHandler.setListLimit(limit);
                        if (evIndex > limit - 1) {
                            EventTreeMenu.this.cmsgHandler.resetCurrentEventIndex();
                            EventTreeMenu.this.eventTreePanel.setEvent(null);
                            EventTreeMenu.this.prevButton.setEnabled(false);
                            EventTreeMenu.this.nextButton.setEnabled(true);
                        } else if (evIndex == limit - 1) {
                            EventTreeMenu.this.nextButton.setEnabled(false);
                        }
                        if (limit < 2) {
                            EventTreeMenu.this.isListSizeOne = true;
                            if (evIndex < 0) {
                                EventTreeMenu.this.cmsgHandler.clearList();
                            }
                            EventTreeMenu.this.prevButton.setEnabled(false);
                            EventTreeMenu.this.nextButton.setEnabled(true);
                            break;
                        }
                        EventTreeMenu.this.isListSizeOne = false;
                        break;
                    }
                    case ET: {
                        int num2delete = EventTreeMenu.this.etHandler.getListSize() - limit;
                        if (num2delete > 0) {
                            EventTreeMenu.this.etHandler.setEventNum(limit + 1);
                        }
                        int evIndex = EventTreeMenu.this.etHandler.getCurrentEventIndex();
                        EventTreeMenu.this.etHandler.setListLimit(limit);
                        if (evIndex > limit - 1) {
                            EventTreeMenu.this.etHandler.resetCurrentEventIndex();
                            EventTreeMenu.this.eventTreePanel.setEvent(null);
                            EventTreeMenu.this.prevButton.setEnabled(false);
                            EventTreeMenu.this.nextButton.setEnabled(true);
                        } else if (evIndex == limit - 1) {
                            EventTreeMenu.this.nextButton.setEnabled(false);
                        }
                        if (limit < 2) {
                            EventTreeMenu.this.isListSizeOne = true;
                            if (evIndex < 0) {
                                EventTreeMenu.this.etHandler.clearList();
                            }
                            EventTreeMenu.this.prevButton.setEnabled(false);
                            EventTreeMenu.this.nextButton.setEnabled(true);
                            break;
                        }
                        EventTreeMenu.this.isListSizeOne = false;
                    }
                }
            }
        });
        JPanel qPanel = new JPanel(new BorderLayout());
        qPanel.add((Component)qLabel, "West");
        qPanel.add((Component)this.qLimit, "Center");
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        Border lowerEtched = BorderFactory.createEtchedBorder(1);
        Border empty = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder compound1 = BorderFactory.createCompoundBorder(blackLine, empty);
        CompoundBorder compound2 = BorderFactory.createCompoundBorder(lowerEtched, empty);
        JLabel qsLabel = new JLabel(" Size   ");
        qsLabel.setOpaque(true);
        qsLabel.setBackground(this.bg2Color);
        qsLabel.setHorizontalAlignment(0);
        this.qSize = new JLabel("0");
        this.qSize.setOpaque(true);
        this.qSize.setBackground(Color.white);
        this.qSize.setHorizontalAlignment(4);
        this.qSize.setBorder(compound1);
        JPanel qsPanel = new JPanel(new BorderLayout());
        qsPanel.add((Component)qsLabel, "West");
        qsPanel.add((Component)this.qSize, "Center");
        JPanel p1 = new JPanel(new GridLayout(2, 1, 0, 5));
        p1.setBackground(this.bg2Color);
        p1.add(qPanel);
        p1.add(qsPanel);
        JPanel pq = new JPanel(new GridLayout(2, 1, 0, 5));
        pq.setBackground(this.bg2Color);
        JLabel evqLabel = new JLabel("Event Q");
        evqLabel.setOpaque(true);
        evqLabel.setBackground(this.bg2Color);
        evqLabel.setHorizontalAlignment(0);
        evqLabel.setForeground(Color.blue);
        pq.add(evqLabel);
        pq.add(this.clearQ);
        JPanel p2 = new JPanel();
        BoxLayout bl = new BoxLayout(p2, 0);
        p2.setLayout(bl);
        p2.setBackground(this.bg2Color);
        p2.setBorder(compound2);
        p2.add(pq);
        p2.add(Box.createHorizontalStrut(10));
        p2.add(p1);
        JPanel p3 = new JPanel();
        p3.setBackground(this.bg1Color);
        p3.setBorder(compound2);
        p3.setLayout(new GridLayout(2, 3, 5, 5));
        p3.add(evLabel);
        p3.add(this.currentEvent);
        p3.add(this.prevButton);
        p3.add(this.nextButton);
        JPanel p4 = new JPanel(new BorderLayout());
        p4.add((Component)p3, "Center");
        p4.add((Component)p2, "East");
        return p4;
    }

    public JMenu createEventMenu() {
        final JMenu menu = new JMenu(" Event ");
        menu.getPopupMenu().setLayout(new BoxLayout(menu.getPopupMenu(), 1));
        JLabel jl = new JLabel("Event Sources");
        jl.setHorizontalTextPosition(0);
        jl.setBorder(new EmptyBorder(3, 10, 3, 10));
        jl.setAlignmentX(0.5f);
        menu.add(jl);
        JRadioButtonMenuItem fileItem = new JRadioButtonMenuItem("File");
        JRadioButtonMenuItem cmsgItem = new JRadioButtonMenuItem("cMsg");
        JRadioButtonMenuItem etItem = new JRadioButtonMenuItem("ET");
        EmptyBorder eBorder = new EmptyBorder(3, 20, 3, 0);
        fileItem.setBorder(eBorder);
        cmsgItem.setBorder(eBorder);
        etItem.setBorder(eBorder);
        ActionListener cmsgListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.cmsgPanel == null) {
                    EventTreeMenu.this.cmsgHandler = new cMsgHandler();
                    EventTreeMenu.this.cmsgPanel = EventTreeMenu.this.cmsgHandler.createCmsgPanel();
                }
                EventTreeMenu.this.setEventSource(EventSource.CMSG);
                menu.doClick();
            }
        };
        cmsgItem.addActionListener(cmsgListener);
        ActionListener etListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.etPanel == null) {
                    EventTreeMenu.this.etHandler = new EtHandler();
                    EventTreeMenu.this.etPanel = EventTreeMenu.this.etHandler.createEtPanel();
                }
                EventTreeMenu.this.setEventSource(EventSource.ET);
                menu.doClick();
            }
        };
        etItem.addActionListener(etListener);
        ActionListener fileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setEventSource(EventSource.FILE);
                menu.doClick();
            }
        };
        fileItem.addActionListener(fileListener);
        ButtonGroup group = new ButtonGroup();
        group.add(fileItem);
        group.add(cmsgItem);
        group.add(etItem);
        group.setSelected(fileItem.getModel(), true);
        fileItem.setAlignmentX(0.5f);
        cmsgItem.setAlignmentX(0.5f);
        etItem.setAlignmentX(0.5f);
        menu.add(fileItem);
        menu.add(cmsgItem);
        menu.add(etItem);
        menu.addSeparator();
        this.eventSourceConfig = new JMenu("");
        this.eventSourceConfig.setText(" ");
        this.eventSourceConfig.setEnabled(false);
        menu.add(this.eventSourceConfig);
        return menu;
    }

    public JMenu createViewMenu() {
        JMenu menu = new JMenu(" View ");
        ActionListener al_hex = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                String txt = item.getText();
                if (txt.equals("Hexidecimal")) {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(true);
                    item.setText("Decimal");
                } else {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(false);
                    item.setText("Hexidecimal");
                }
                EventTreeMenu.this.eventTreePanel.refreshDisplay();
            }
        };
        JMenuItem hexItem = new JMenuItem("Hexidecimal");
        hexItem.addActionListener(al_hex);
        hexItem.setEnabled(true);
        menu.add(hexItem);
        ActionListener al_dict = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                String txt = item.getText();
                if (txt.equals("View Data")) {
                    EventTreeMenu.this.eventTreePanel.switchDataAndDictionary();
                    item.setText("View Dictionary");
                } else {
                    EventTreeMenu.this.eventTreePanel.switchDataAndDictionary();
                    item.setText("View Data");
                }
                EventTreeMenu.this.eventTreePanel.refreshDisplay();
            }
        };
        JMenuItem dictItem = new JMenuItem("View Dictionary");
        dictItem.addActionListener(al_dict);
        dictItem.setEnabled(true);
        menu.add(dictItem);
        ActionListener al_orient = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int orient = EventTreeMenu.this.eventTreePanel.getOrientation();
                if (orient == 1) {
                    EventTreeMenu.this.eventTreePanel.setOrientation(0);
                } else {
                    EventTreeMenu.this.eventTreePanel.setOrientation(1);
                }
            }
        };
        JMenuItem orientItem = new JMenuItem("Change Orientation");
        orientItem.addActionListener(al_orient);
        orientItem.setEnabled(true);
        menu.add(orientItem);
        menu.addSeparator();
        ActionListener al_addCol = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.eventTreePanel.addTableColumn();
            }
        };
        JMenuItem addColItem = new JMenuItem("Add Column");
        addColItem.addActionListener(al_addCol);
        addColItem.setEnabled(true);
        menu.add(addColItem);
        ActionListener al_subCol = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.eventTreePanel.removeTableColumn();
            }
        };
        JMenuItem subColItem = new JMenuItem("Remove Column");
        subColItem.addActionListener(al_subCol);
        subColItem.setEnabled(true);
        menu.add(subColItem);
        return menu;
    }

    public JMenu createDictionaryMenu() {
        final JMenu menu = new JMenu(" Dict ");
        JLabel jl = new JLabel("Sources");
        jl.setBorder(new EmptyBorder(3, 20, 3, 0));
        jl.setHorizontalTextPosition(0);
        menu.add(jl);
        EmptyBorder eBorder = new EmptyBorder(3, 30, 3, 0);
        this.fileItem.setBorder(eBorder);
        this.xmlItem.setBorder(eBorder);
        this.cmsgItem.setBorder(eBorder);
        this.etItem.setBorder(eBorder);
        this.noItem.setBorder(eBorder);
        ActionListener embListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setDictionarySource(DictionarySource.EVIOFILE);
                menu.doClick();
            }
        };
        this.fileItem.addActionListener(embListener);
        this.fileItem.setEnabled(false);
        ActionListener xmlListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setDictionarySource(DictionarySource.XML);
                menu.doClick();
            }
        };
        this.xmlItem.addActionListener(xmlListener);
        this.xmlItem.setEnabled(false);
        ActionListener cmsgListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setDictionarySource(DictionarySource.CMSG);
                menu.doClick();
            }
        };
        this.cmsgItem.addActionListener(cmsgListener);
        this.cmsgItem.setEnabled(false);
        ActionListener etListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setDictionarySource(DictionarySource.ET);
                menu.doClick();
            }
        };
        this.etItem.addActionListener(etListener);
        this.etItem.setEnabled(false);
        ActionListener noListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setDictionarySource(DictionarySource.NONE);
                menu.doClick();
            }
        };
        this.noItem.addActionListener(noListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fileItem);
        group.add(this.xmlItem);
        group.add(this.cmsgItem);
        group.add(this.etItem);
        group.add(this.noItem);
        group.setSelected(this.noItem.getModel(), true);
        menu.add(this.fileItem);
        menu.add(this.xmlItem);
        menu.add(this.cmsgItem);
        menu.add(this.etItem);
        menu.add(this.noItem);
        return menu;
    }

    public JMenu createFilterMenu() {
        this.filterMenu = new JMenu(" Filter ");
        this.filterMenu.getPopupMenu().setLayout(new BoxLayout(this.filterMenu.getPopupMenu(), 1));
        JLabel jl = new JLabel("Allow");
        jl.setHorizontalTextPosition(0);
        jl.setBorder(new EmptyBorder(3, 3, 3, 3));
        jl.setAlignmentX(1.0f);
        this.filterMenu.add(jl);
        final JRadioButtonMenuItem everyItem = new JRadioButtonMenuItem("Everything", true);
        final JRadioButtonMenuItem controlItem = new JRadioButtonMenuItem("Control");
        final JRadioButtonMenuItem physicsItem = new JRadioButtonMenuItem("Physics");
        final JRadioButtonMenuItem partialItem = new JRadioButtonMenuItem("Partial Physics");
        EmptyBorder eBorder = new EmptyBorder(3, 20, 3, 0);
        everyItem.setBorder(eBorder);
        controlItem.setBorder(eBorder);
        physicsItem.setBorder(eBorder);
        partialItem.setBorder(eBorder);
        ActionListener everyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!everyItem.isSelected()) {
                    everyItem.setSelected(true);
                    EventTreeMenu.this.filterMenu.doClick();
                    return;
                }
                EventTreeMenu.this.triggerType.setEnabled(false);
                controlItem.setSelected(false);
                partialItem.setSelected(false);
                physicsItem.setSelected(false);
                Filter.PHYSICS.setActive(false);
                Filter.PARTIAL.setActive(false);
                Filter.CONTROL.setActive(false);
                Filter.EVERY.setActive(true);
                EventTreeMenu.this.filterMenu.doClick();
            }
        };
        everyItem.addActionListener(everyListener);
        ActionListener physicsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                everyItem.setSelected(false);
                Filter.EVERY.setActive(false);
                if (physicsItem.isSelected() || partialItem.isSelected()) {
                    EventTreeMenu.this.triggerType.setEnabled(true);
                } else {
                    EventTreeMenu.this.triggerType.setEnabled(false);
                }
                if (!physicsItem.isSelected()) {
                    Filter.PHYSICS.setActive(false);
                } else {
                    Filter.PHYSICS.setActive(true);
                }
                if (!(physicsItem.isSelected() || partialItem.isSelected() || controlItem.isSelected())) {
                    everyItem.doClick();
                    return;
                }
                EventTreeMenu.this.filterMenu.doClick();
            }
        };
        physicsItem.addActionListener(physicsListener);
        ActionListener partialListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                everyItem.setSelected(false);
                Filter.EVERY.setActive(false);
                if (physicsItem.isSelected() || partialItem.isSelected()) {
                    EventTreeMenu.this.triggerType.setEnabled(true);
                } else {
                    EventTreeMenu.this.triggerType.setEnabled(false);
                }
                if (!partialItem.isSelected()) {
                    Filter.PARTIAL.setActive(false);
                } else {
                    Filter.PARTIAL.setActive(true);
                }
                if (!(physicsItem.isSelected() || partialItem.isSelected() || controlItem.isSelected())) {
                    everyItem.doClick();
                }
                EventTreeMenu.this.filterMenu.doClick();
            }
        };
        partialItem.addActionListener(partialListener);
        ActionListener controlListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                everyItem.setSelected(false);
                Filter.EVERY.setActive(false);
                if (!(physicsItem.isSelected() || partialItem.isSelected() || controlItem.isSelected())) {
                    everyItem.doClick();
                }
                if (!controlItem.isSelected()) {
                    Filter.CONTROL.setActive(false);
                } else {
                    Filter.CONTROL.setActive(true);
                }
                EventTreeMenu.this.filterMenu.doClick();
            }
        };
        controlItem.addActionListener(controlListener);
        everyItem.setAlignmentX(0.5f);
        physicsItem.setAlignmentX(0.5f);
        partialItem.setAlignmentX(0.5f);
        controlItem.setAlignmentX(0.5f);
        this.filterMenu.add(everyItem);
        this.filterMenu.add(controlItem);
        this.filterMenu.add(partialItem);
        this.filterMenu.add(physicsItem);
        this.filterMenu.addSeparator();
        JLabel qLabel = new JLabel("Trigger Type");
        qLabel.setHorizontalTextPosition(0);
        this.triggerType = new JSpinner(new SpinnerNumberModel(-1, -1, 255, 1));
        this.triggerType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)e.getSource()).getModel();
                int type = model.getNumber().intValue();
                Filter.PHYSICS.setTriggerType(type);
            }
        });
        this.triggerType.setEnabled(false);
        JPanel qPanel = new JPanel();
        qPanel.add(qLabel);
        qPanel.add(this.triggerType);
        qPanel.setAlignmentX(0.5f);
        this.filterMenu.add(qPanel);
        this.filterMenu.setEnabled(false);
        return this.filterMenu;
    }

    public JMenu createFileMenu() {
        JMenu menu = new JMenu(" File ");
        ActionListener al_oef = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenEventFile();
            }
        };
        this.openEventFile = new JMenuItem("Open Event File...");
        this.openEventFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openEventFile.addActionListener(al_oef);
        menu.add(this.openEventFile);
        ActionListener al_odf = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenDictionary();
            }
        };
        JMenuItem df_item = new JMenuItem("Open Dictionary...");
        df_item.addActionListener(al_odf);
        menu.add(df_item);
        menu.addSeparator();
        ActionListener al_xml = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.exportToXML();
            }
        };
        this.xmlExportItem = new JMenuItem("Export File to XML...");
        this.xmlExportItem.addActionListener(al_xml);
        this.xmlExportItem.setEnabled(false);
        menu.add(this.xmlExportItem);
        menu.addSeparator();
        ActionListener al_exit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        JMenuItem exit_item = new JMenuItem("Quit");
        exit_item.addActionListener(al_exit);
        menu.add(exit_item);
        return menu;
    }

    private void doOpenEventFile() {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile();
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
        this.nextButton.doClick();
    }

    public void manualOpenEventFile(File file) {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile(file);
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
    }

    private void doOpenDictionary() {
        this.openDictionary();
    }

    public void exportToXML() {
        JFileChooser chooser = new JFileChooser(this.xmlFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML Evio Files", "xml");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.eventTreePanel);
        if (returnVal == 0) {
            int answer;
            File selectedFile = chooser.getSelectedFile();
            this.xmlFilePath = selectedFile.getAbsolutePath();
            if (selectedFile.exists() && (answer = JOptionPane.showConfirmDialog(null, selectedFile.getPath() + "  already exists. Do you want to overwrite it?", "Overwite Existing File?", 0)) != 0) {
                return;
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventTreeMenu.this.evioFileReader.toXMLFile(EventTreeMenu.this.xmlFilePath, null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(EventTreeMenu.this.eventTreePanel, "XML Writing has completed.", "Done", 1);
                }
            };
            new Thread(runner).start();
        }
    }

    public void addEventFileExtension(String extension) {
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio", extension);
        } else {
            String[] exts = this.evioFileFilter.getExtensions();
            String[] newExts = Arrays.copyOf(exts, exts.length + 1);
            newExts[exts.length] = extension;
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", newExts);
        }
    }

    public void setEventFileExtensions(String[] extensions) {
        this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", extensions);
    }

    public EvioReader openEventFile() {
        if (this.dataFilePath == null || this.dataFilePath.length() < 1) {
            this.dataFilePath = System.getProperty("filePath");
            if (this.dataFilePath == null) {
                this.dataFilePath = System.getProperty("user.dir");
            }
        }
        JFileChooser chooser = new JFileChooser(this.dataFilePath);
        chooser.setSelectedFile(null);
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio");
        }
        chooser.setFileFilter(this.evioFileFilter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            this.eventTreePanel.getHeaderPanel().setHeader(null);
            File selectedFile = chooser.getSelectedFile();
            this.dataFilePath = selectedFile.getAbsolutePath();
            this.eventInfoPanel.setSource(this.dataFilePath);
            try {
                if (this.evioFileReader != null) {
                    this.evioFileReader.close();
                    this.qLimit.setValue(0);
                }
                this.evioFileReader = new EvioReader(selectedFile);
                int evCount = this.evioFileReader.getEventCount();
                this.qLimit.setValue(evCount);
                this.qSize.setText("" + evCount);
                this.currentEvent.setEnabled(true);
                SpinnerNumberModel model = (SpinnerNumberModel)this.currentEvent.getModel();
                model.setMaximum(Integer.valueOf(evCount));
                model.setMinimum(Integer.valueOf(0));
                model.setValue(0);
                String xml = this.evioFileReader.getDictionaryXML();
                if (xml != null) {
                    EvioXMLDictionary dict = this.dictionaryMap.get(xml);
                    if (dict == null) {
                        dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(xml);
                        this.dictionaryMap.put(xml, dict);
                    }
                    DictionarySource.EVIOFILE.setDictionary(dict);
                    this.fileItem.setEnabled(true);
                    this.setDictionarySource(DictionarySource.EVIOFILE);
                }
                this.eventIndex = 0;
            }
            catch (EvioException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
            catch (IOException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader openEventFile(File file) {
        this.currentEvent.setValue(0);
        this.eventTreePanel.getHeaderPanel().setHeader(null);
        this.dataFilePath = file.getAbsolutePath();
        this.eventInfoPanel.setSource(this.dataFilePath);
        try {
            if (this.evioFileReader != null) {
                this.evioFileReader.close();
                this.qLimit.setValue(0);
            }
            this.evioFileReader = new EvioReader(file);
            int evCount = this.evioFileReader.getEventCount();
            this.qLimit.setValue(evCount);
            this.qSize.setText("" + evCount);
            this.currentEvent.setEnabled(true);
            SpinnerNumberModel model = (SpinnerNumberModel)this.currentEvent.getModel();
            model.setMaximum(Integer.valueOf(evCount));
            model.setMinimum(Integer.valueOf(0));
            model.setValue(0);
            String xml = this.evioFileReader.getDictionaryXML();
            if (xml != null) {
                EvioXMLDictionary dict = this.dictionaryMap.get(xml);
                if (dict == null) {
                    dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(xml);
                    this.dictionaryMap.put(xml, dict);
                }
                DictionarySource.EVIOFILE.setDictionary(dict);
                this.fileItem.setEnabled(true);
                this.setDictionarySource(DictionarySource.EVIOFILE);
            }
            this.eventIndex = 0;
        }
        catch (EvioException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader getEvioFileReader() {
        return this.evioFileReader;
    }

    public void setDefaultDataDir(String defaultDataDir) {
        this.dataFilePath = defaultDataDir;
    }

    public boolean openDictionary() {
        if (this.dictionaryFilePath == null || this.dictionaryFilePath.length() < 1) {
            this.dictionaryFilePath = System.getProperty("dictionaryPath");
            if (this.dictionaryFilePath == null) {
                this.dictionaryFilePath = System.getProperty("user.dir");
            }
        }
        JFileChooser chooser = new JFileChooser(this.dictionaryFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Dictionary Files", "xml", "dict", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            File selectedFile = chooser.getSelectedFile();
            EvioXMLDictionary dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(selectedFile);
            DictionarySource.XML.setDictionary(dict);
            this.xmlItem.setEnabled(true);
            this.setDictionarySource(DictionarySource.XML);
            this.dictionaryFilePath = selectedFile.getAbsolutePath();
            return true;
        }
        return false;
    }

    public void openDictionaryFile(File file) {
        if (file != null) {
            EvioXMLDictionary dict = (EvioXMLDictionary)NameProviderFactory.createNameProvider(file);
            DictionarySource.XML.setDictionary(dict);
            this.xmlItem.setEnabled(true);
            this.setDictionarySource(DictionarySource.XML);
            this.dictionaryFilePath = file.getAbsolutePath();
        }
    }

    public void addEvioListener(IEvioListener listener) {
        if (listener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, listener);
    }

    private void connectEvioListeners() {
        if (this.evioListenerList == null) {
            return;
        }
        EventParser parser = this.getEvioFileReader().getParser();
        EventListener[] listeners = this.evioListenerList.getListeners(IEvioListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            parser.addEvioListener((IEvioListener)listeners[i]);
        }
    }

    private class UpdateThread
    extends Thread {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                switch (EventTreeMenu.this.eventSource) {
                    case CMSG: {
                        if (EventTreeMenu.this.cmsgHandler == null) break;
                        int listSize = EventTreeMenu.this.cmsgHandler.getListSize();
                        SpinnerNumberModel model = (SpinnerNumberModel)EventTreeMenu.this.currentEvent.getModel();
                        model.setMaximum(Integer.valueOf(listSize));
                        if (listSize > 0) {
                            EventTreeMenu.this.currentEvent.setEnabled(true);
                            if ((Integer)model.getValue() > 0) {
                                model.setMinimum(Integer.valueOf(1));
                            }
                        }
                        if (EventTreeMenu.this.cmsgHandler.getCurrentEventIndex() < listSize - 1) {
                            EventTreeMenu.this.nextButton.setEnabled(true);
                        }
                        if (listSize >= EventTreeMenu.this.cmsgHandler.getListLimit()) {
                            EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkRed);
                            EventTreeMenu.this.qSize.setText("Full  " + listSize);
                        } else {
                            EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkGreen);
                            EventTreeMenu.this.qSize.setText("" + listSize);
                        }
                        if (!EventTreeMenu.this.isListSizeOne || listSize <= 0) break;
                        EventTreeMenu.this.displayCmsgEvent(EventTreeMenu.this.cmsgHandler.getNextEvent());
                        break;
                    }
                    case ET: {
                        if (EventTreeMenu.this.etHandler == null) break;
                        int listSize = EventTreeMenu.this.etHandler.getListSize();
                        SpinnerNumberModel model = (SpinnerNumberModel)EventTreeMenu.this.currentEvent.getModel();
                        model.setMaximum(Integer.valueOf(listSize));
                        if (listSize > 0) {
                            EventTreeMenu.this.currentEvent.setEnabled(true);
                            if ((Integer)model.getValue() > 0) {
                                model.setMinimum(Integer.valueOf(1));
                            }
                        }
                        if (EventTreeMenu.this.etHandler.getCurrentEventIndex() < listSize - 1) {
                            EventTreeMenu.this.nextButton.setEnabled(true);
                        }
                        if (listSize >= EventTreeMenu.this.etHandler.getListLimit()) {
                            EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkRed);
                            EventTreeMenu.this.qSize.setText("Full  " + listSize);
                        } else {
                            EventTreeMenu.this.setNumberOfEventsColor(EventTreeMenu.this.darkGreen);
                            EventTreeMenu.this.qSize.setText("" + listSize);
                        }
                        if (!EventTreeMenu.this.isListSizeOne || listSize <= 0) break;
                        EventTreeMenu.this.displayEtEvent(EventTreeMenu.this.etHandler.getNextEvent());
                        break;
                    }
                }
            }
        };

        private UpdateThread() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                SwingUtilities.invokeLater(this.r);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

