/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.BlockHeaderV2;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioProgressListener;

public class EvioReader {
    private static final int MAGIC_OFFSET = 28;
    private static final int VERSION_OFFSET = 20;
    private static final int BLOCK_SIZE_OFFSET = 0;
    private static final int VERSION_MASK = 255;
    private static final String ROOT_ELEMENT = "evio-data";
    private final ArrayList<Long> eventPositions = new ArrayList(200000);
    private int eventNumber = 0;
    private int eventCount = -1;
    private int evioVersion;
    private ByteOrder byteOrder;
    private int firstBlockSize;
    private int blockCount = -1;
    private BlockHeaderV2 blockHeader2 = new BlockHeaderV2();
    private BlockHeaderV4 blockHeader4 = new BlockHeaderV4();
    private IBlockHeader blockHeader;
    private int blockNumberExpected = 1;
    private boolean checkBlockNumberSequence;
    private boolean lastBlock;
    private String dictionaryXML;
    private ByteBuffer byteBuffer;
    private EventParser parser;
    private int initialPosition;
    private MappedByteBuffer mappedByteBuffer;
    private ByteBuffer blockBuffer;
    private String path;
    private File file;
    private long fileSize;
    private FileChannel fileChannel;
    private DataInputStream dataStream;
    private boolean swap;
    private boolean sequentialRead;
    private int sequentialCounter = 1;

    private ReaderState getState() {
        ReaderState currentState = new ReaderState();
        currentState.lastBlock = this.lastBlock;
        currentState.eventNumber = this.eventNumber;
        currentState.blockNumberExpected = this.blockNumberExpected;
        if (this.sequentialRead) {
            try {
                currentState.filePosition = this.fileChannel.position();
            }
            catch (IOException iOException) {}
        } else {
            currentState.byteBufferPosition = this.byteBuffer.position();
        }
        if (this.evioVersion > 3) {
            currentState.blockHeader4 = (BlockHeaderV4)this.blockHeader4.clone();
        } else {
            currentState.blockHeader2 = (BlockHeaderV2)this.blockHeader2.clone();
        }
        return currentState;
    }

    private void restoreState(ReaderState state) {
        this.lastBlock = state.lastBlock;
        this.eventNumber = state.eventNumber;
        if (this.sequentialRead) {
            try {
                this.fileChannel.position(state.filePosition);
            }
            catch (IOException iOException) {}
        } else {
            this.byteBuffer.position(state.byteBufferPosition);
        }
        this.blockNumberExpected = state.blockNumberExpected;
        if (this.evioVersion > 3) {
            this.blockHeader4 = state.blockHeader4;
            this.blockHeader = this.blockHeader4;
        } else {
            this.blockHeader2 = state.blockHeader2;
            this.blockHeader = this.blockHeader2;
        }
    }

    private void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    public EvioReader(String path) throws EvioException, IOException {
        this(new File(path));
    }

    public EvioReader(String path, boolean checkBlkNumSeq) throws EvioException, IOException {
        this(new File(path), checkBlkNumSeq);
    }

    public EvioReader(File file) throws EvioException, IOException {
        this(file, false);
    }

    public EvioReader(File file, boolean checkBlkNumSeq) throws EvioException, IOException {
        this(file, false, false);
    }

    public EvioReader(String path, boolean checkBlkNumSeq, boolean sequential) throws EvioException, IOException {
        this(new File(path), checkBlkNumSeq, sequential);
    }

    public EvioReader(File file, boolean checkBlkNumSeq, boolean sequential) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("File arg is null");
        }
        this.file = file;
        this.checkBlockNumberSequence = checkBlkNumSeq;
        this.initialPosition = 0;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = file.getAbsolutePath();
        this.fileChannel = fileInputStream.getChannel();
        this.fileSize = this.fileChannel.size();
        this.sequentialRead = sequential;
        if (this.fileSize > Integer.MAX_VALUE) {
            this.sequentialRead = true;
        }
        if (this.sequentialRead) {
            this.dataStream = new DataInputStream(fileInputStream);
        } else {
            this.mapFile(this.fileChannel);
            this.fileChannel.close();
        }
        if (this.getFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
        if (this.evioVersion > 3) {
            this.generateEventPositionTable();
        }
        this.parser = new EventParser();
    }

    public EvioReader(ByteBuffer byteBuffer) throws EvioException, IOException {
        this(byteBuffer, false);
    }

    public EvioReader(ByteBuffer byteBuffer, boolean checkBlkNumSeq) throws EvioException, IOException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.checkBlockNumberSequence = checkBlkNumSeq;
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        if (this.getFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
        if (this.evioVersion > 3) {
            this.generateEventPositionTable();
        }
        this.parser = new EventParser();
    }

    public synchronized void setBuffer(ByteBuffer buf) throws EvioException, IOException {
        if (buf == null) {
            throw new EvioException("arg is null");
        }
        this.close();
        this.lastBlock = false;
        this.eventNumber = 0;
        this.blockCount = -1;
        this.eventCount = -1;
        this.blockNumberExpected = 1;
        this.sequentialCounter = 1;
        this.dictionaryXML = null;
        this.initialPosition = buf.position();
        this.byteBuffer = buf;
        if (this.getFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
        if (this.evioVersion > 3) {
            this.generateEventPositionTable();
        }
    }

    public boolean checkBlockNumberSequence() {
        return this.checkBlockNumberSequence;
    }

    public int getEvioVersion() {
        return this.evioVersion;
    }

    public String getPath() {
        return this.path;
    }

    public EventParser getParser() {
        return this.parser;
    }

    public void setParser(EventParser parser) {
        if (parser != null) {
            this.parser = parser;
        }
    }

    public String getDictionaryXML() {
        return this.dictionaryXML;
    }

    public boolean hasDictionaryXML() {
        return this.dictionaryXML != null;
    }

    public int getNumEventsRemaining() throws IOException, EvioException {
        return this.getEventCount() - this.eventNumber;
    }

    private synchronized void mapFile(FileChannel inputChannel) throws IOException {
        long sz = inputChannel.size();
        this.mappedByteBuffer = inputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        this.byteBuffer = this.mappedByteBuffer;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public long fileSize() {
        return this.fileSize;
    }

    private void generateEventPositionTable() throws IOException, EvioException {
        long bytesLeft;
        long position;
        if (this.evioVersion < 4) {
            throw new EvioException("Unsupported version (" + this.evioVersion + ")");
        }
        long firstPosition = 0L;
        boolean curLastBlock = false;
        boolean firstBlock = true;
        boolean hasDictionary = false;
        this.eventPositions.clear();
        if (this.sequentialRead) {
            firstPosition = this.fileChannel.position();
            if (firstPosition != 0L) {
                this.fileChannel.position(0L);
            }
            position = 0L;
            bytesLeft = this.fileSize;
        } else {
            position = this.initialPosition;
            bytesLeft = (long)this.byteBuffer.limit() - position;
        }
        this.blockCount = 0;
        this.eventCount = 0;
        while (!curLastBlock) {
            int byteLen;
            int len;
            int blockEventCount;
            int blockHdrSize;
            int i;
            if (this.sequentialRead) {
                this.fileChannel.position(position + 20L);
                i = this.dataStream.readInt();
                this.fileChannel.position(position + 8L);
                blockHdrSize = this.dataStream.readInt();
                this.fileChannel.position(position + 12L);
                blockEventCount = this.dataStream.readInt();
                if (this.swap) {
                    i = Integer.reverseBytes(i);
                    blockHdrSize = Integer.reverseBytes(blockHdrSize);
                    blockEventCount = Integer.reverseBytes(blockEventCount);
                }
            } else {
                i = this.byteBuffer.getInt((int)position + 20);
                blockHdrSize = this.byteBuffer.getInt((int)position + 8);
                blockEventCount = this.byteBuffer.getInt((int)position + 12);
            }
            ++this.blockCount;
            this.eventCount += blockEventCount;
            curLastBlock = BlockHeaderV4.isLastBlock(i);
            if (firstBlock) {
                hasDictionary = BlockHeaderV4.hasDictionary(i);
            }
            position += (long)(4 * blockHdrSize);
            bytesLeft -= (long)(4 * blockHdrSize);
            if (this.sequentialRead) {
                this.fileChannel.position(position);
            }
            if (firstBlock && hasDictionary) {
                firstBlock = false;
                if (this.sequentialRead) {
                    len = this.dataStream.readInt();
                    if (this.swap) {
                        len = Integer.reverseBytes(len);
                    }
                    byteLen = 4 * (len + 1);
                } else {
                    byteLen = 4 * (this.byteBuffer.getInt((int)position) + 1);
                }
                position += (long)byteLen;
                bytesLeft -= (long)byteLen;
                if (this.sequentialRead) {
                    this.fileChannel.position(position);
                }
            }
            for (i = 0; i < blockEventCount; ++i) {
                if (bytesLeft < 8L) {
                    throw new EvioException("File/buffer bad format");
                }
                this.eventPositions.add(position);
                if (this.sequentialRead) {
                    len = this.dataStream.readInt();
                    if (this.swap) {
                        len = Integer.reverseBytes(len);
                    }
                    byteLen = 4 * (len + 1);
                } else {
                    byteLen = 4 * (this.byteBuffer.getInt((int)position) + 1);
                }
                position += (long)byteLen;
                bytesLeft -= (long)byteLen;
                if (!this.sequentialRead) continue;
                this.fileChannel.position(position);
            }
        }
        if (this.sequentialRead) {
            this.fileChannel.position(firstPosition);
        }
    }

    protected synchronized ReadStatus getFirstHeader() throws IOException {
        if (this.sequentialRead) {
            this.fileChannel.position(this.initialPosition);
            if (this.fileSize - this.fileChannel.position() < 32L) {
                return ReadStatus.END_OF_FILE;
            }
        } else {
            this.byteBuffer.position(this.initialPosition);
            if (this.byteBuffer.remaining() < 32) {
                this.byteBuffer.clear();
                return ReadStatus.END_OF_FILE;
            }
        }
        try {
            if (this.sequentialRead) {
                byte[] header = new byte[32];
                this.dataStream.readFully(header);
                this.byteBuffer = ByteBuffer.wrap(header);
                this.byteOrder = ByteOrder.BIG_ENDIAN;
            } else {
                this.byteOrder = this.byteBuffer.order();
            }
            int magicNumber = this.byteBuffer.getInt(28);
            if (magicNumber != -1059454720) {
                this.swap = true;
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteBuffer.order(this.byteOrder);
                magicNumber = this.byteBuffer.getInt(28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR reread magic # (" + magicNumber + ") & still not right");
                    return ReadStatus.EVIO_EXCEPTION;
                }
            }
            this.evioVersion = this.byteBuffer.getInt(20) & 0xFF;
            if (this.evioVersion < 1) {
                return ReadStatus.EVIO_EXCEPTION;
            }
            if (this.sequentialRead) {
                int blkSize = this.byteBuffer.getInt(0);
                if (this.blockBuffer != null && this.blockBuffer.capacity() >= 4 * blkSize) {
                    this.blockBuffer.clear();
                    this.blockBuffer.limit(4 * blkSize);
                } else {
                    this.blockBuffer = ByteBuffer.allocate(4 * blkSize + 10000);
                    this.blockBuffer.limit(4 * blkSize);
                    this.blockBuffer.order(this.byteOrder);
                }
                this.blockBuffer.put(this.byteBuffer);
                this.fileChannel.read(this.blockBuffer);
                this.blockBuffer.flip();
                this.byteBuffer = this.blockBuffer;
            }
            try {
                if (this.evioVersion >= 4) {
                    this.blockHeader4.setBufferStartingPosition(this.byteBuffer.position());
                    this.blockHeader4.setSize(this.byteBuffer.getInt());
                    this.blockHeader4.setNumber(this.byteBuffer.getInt());
                    this.blockHeader4.setHeaderLength(this.byteBuffer.getInt());
                    this.blockHeader4.setEventCount(this.byteBuffer.getInt());
                    this.blockHeader4.setReserved1(this.byteBuffer.getInt());
                    this.blockHeader4.parseToBitInfo(this.byteBuffer.getInt());
                    this.blockHeader4.setVersion(this.evioVersion);
                    this.lastBlock = this.blockHeader4.getBitInfo(1);
                    this.blockHeader4.setReserved2(this.byteBuffer.getInt());
                    this.blockHeader4.setMagicNumber(this.byteBuffer.getInt());
                    this.blockHeader = this.blockHeader4;
                    int headerLenDiff = this.blockHeader4.getHeaderLength() - 8;
                    if (headerLenDiff < 0) {
                        return ReadStatus.EVIO_EXCEPTION;
                    }
                    if (headerLenDiff > 0) {
                        for (int i = 0; i < headerLenDiff; ++i) {
                            this.byteBuffer.getInt();
                        }
                    }
                    if (this.blockHeader4.hasDictionary()) {
                        this.readDictionary();
                    }
                } else {
                    this.blockHeader2.setBufferStartingPosition(this.byteBuffer.position());
                    this.blockHeader2.setSize(this.byteBuffer.getInt());
                    this.blockHeader2.setNumber(this.byteBuffer.getInt());
                    this.blockHeader2.setHeaderLength(this.byteBuffer.getInt());
                    this.blockHeader2.setStart(this.byteBuffer.getInt());
                    this.blockHeader2.setEnd(this.byteBuffer.getInt());
                    this.byteBuffer.getInt();
                    this.blockHeader2.setVersion(this.evioVersion);
                    this.blockHeader2.setReserved1(this.byteBuffer.getInt());
                    this.blockHeader2.setMagicNumber(this.byteBuffer.getInt());
                    this.blockHeader = this.blockHeader2;
                }
                this.firstBlockSize = 4 * this.blockHeader.getSize();
                if (this.checkBlockNumberSequence) {
                    if (this.blockHeader.getNumber() != this.blockNumberExpected) {
                        System.out.println("block # out of sequence, got " + this.blockHeader.getNumber() + " expecting " + this.blockNumberExpected);
                        return ReadStatus.EVIO_EXCEPTION;
                    }
                    ++this.blockNumberExpected;
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                return ReadStatus.EVIO_EXCEPTION;
            }
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.byteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        if (!this.sequentialRead) {
            this.byteBuffer.position(this.initialPosition);
        }
        return ReadStatus.SUCCESS;
    }

    protected synchronized ReadStatus nextBlockHeader() throws IOException {
        if (this.lastBlock) {
            return ReadStatus.END_OF_FILE;
        }
        if (this.sequentialRead) {
            if (this.fileSize - this.fileChannel.position() < 32L) {
                return ReadStatus.END_OF_FILE;
            }
        } else if (this.byteBuffer.remaining() < 32) {
            this.byteBuffer.clear();
            return ReadStatus.END_OF_FILE;
        }
        try {
            if (this.sequentialRead) {
                int blkSize = this.dataStream.readInt();
                if (this.swap) {
                    blkSize = Integer.reverseBytes(blkSize);
                }
                if (this.blockBuffer != null && this.blockBuffer.capacity() >= 4 * blkSize) {
                    this.blockBuffer.clear();
                    this.blockBuffer.limit(4 * blkSize);
                } else {
                    this.blockBuffer = ByteBuffer.allocate(4 * blkSize + 10000);
                    this.blockBuffer.limit(4 * blkSize);
                    this.blockBuffer.order(this.byteOrder);
                }
                this.blockBuffer.putInt(blkSize);
                this.fileChannel.read(this.blockBuffer);
                this.blockBuffer.flip();
                this.byteBuffer = this.blockBuffer;
                this.blockHeader.setBufferStartingPosition(this.blockBuffer.position());
            } else {
                this.blockHeader.setBufferStartingPosition(this.byteBuffer.position());
            }
            if (this.evioVersion >= 4) {
                this.blockHeader4.setSize(this.byteBuffer.getInt());
                this.blockHeader4.setNumber(this.byteBuffer.getInt());
                this.blockHeader4.setHeaderLength(this.byteBuffer.getInt());
                this.blockHeader4.setEventCount(this.byteBuffer.getInt());
                this.blockHeader4.setReserved1(this.byteBuffer.getInt());
                this.blockHeader4.parseToBitInfo(this.byteBuffer.getInt());
                this.blockHeader4.setVersion(this.evioVersion);
                this.lastBlock = this.blockHeader4.getBitInfo(1);
                this.blockHeader4.setReserved2(this.byteBuffer.getInt());
                this.blockHeader4.setMagicNumber(this.byteBuffer.getInt());
                this.blockHeader = this.blockHeader4;
                int headerLenDiff = this.blockHeader4.getHeaderLength() - 8;
                if (headerLenDiff < 0) {
                    return ReadStatus.EVIO_EXCEPTION;
                }
                if (headerLenDiff > 0) {
                    for (int i = 0; i < headerLenDiff; ++i) {
                        this.byteBuffer.getInt();
                    }
                }
            } else if (this.evioVersion < 4) {
                this.blockHeader2.setSize(this.byteBuffer.getInt());
                this.blockHeader2.setNumber(this.byteBuffer.getInt());
                this.blockHeader2.setHeaderLength(this.byteBuffer.getInt());
                this.blockHeader2.setStart(this.byteBuffer.getInt());
                this.blockHeader2.setEnd(this.byteBuffer.getInt());
                this.byteBuffer.getInt();
                this.blockHeader2.setVersion(this.evioVersion);
                this.blockHeader2.setReserved1(this.byteBuffer.getInt());
                this.blockHeader2.setMagicNumber(this.byteBuffer.getInt());
                this.blockHeader = this.blockHeader2;
            } else {
                return ReadStatus.EVIO_EXCEPTION;
            }
            if (this.checkBlockNumberSequence) {
                if (this.blockHeader.getNumber() != this.blockNumberExpected) {
                    System.out.println("block # out of sequence, got " + this.blockHeader.getNumber() + " expecting " + this.blockNumberExpected);
                    return ReadStatus.EVIO_EXCEPTION;
                }
                ++this.blockNumberExpected;
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
            return ReadStatus.EVIO_EXCEPTION;
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.byteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        return ReadStatus.SUCCESS;
    }

    private synchronized void readDictionary() throws IOException, EvioException {
        if (this.evioVersion < 4) {
            throw new EvioException("Unsupported version (" + this.evioVersion + ")");
        }
        int bytesRemaining = this.blockBytesRemaining();
        if (bytesRemaining < 12) {
            throw new EvioException("Not enough data in first block");
        }
        int length = this.byteBuffer.getInt();
        if (length < 1) {
            throw new EvioException("Bad value for dictionary length (too big for java?)");
        }
        bytesRemaining -= 4;
        if (this.dictionaryXML != null) {
            this.byteBuffer.position(this.byteBuffer.position() + 4 + 4 * (length - 1));
            return;
        }
        this.byteBuffer.getInt();
        int eventDataSizeBytes = 4 * (length - 1);
        if ((bytesRemaining -= 4) < eventDataSizeBytes) {
            throw new EvioException("Not enough data in first block");
        }
        byte[] bytes = new byte[eventDataSizeBytes];
        try {
            this.byteBuffer.get(bytes, 0, eventDataSizeBytes);
        }
        catch (Exception e) {
            throw new EvioException("Problems reading buffer");
        }
        String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
        if (strs == null) {
            throw new EvioException("Data in bad format");
        }
        this.dictionaryXML = strs[0];
    }

    public synchronized EvioEvent getEvent(int index) throws IOException, EvioException {
        int length;
        long position;
        long origPosition;
        if (index < 1) {
            throw new EvioException("index arg starts at 1");
        }
        if (index > this.eventPositions.size()) {
            return null;
        }
        if (this.evioVersion < 4) {
            return this.gotoEventNumber(index);
        }
        --index;
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        int eventDataSizeBytes = 0;
        if (this.sequentialRead) {
            origPosition = this.fileChannel.position();
            position = this.eventPositions.get(index);
            this.fileChannel.position(position);
            length = this.dataStream.readInt();
            if (this.swap) {
                length = Integer.reverseBytes(length);
            }
        } else {
            origPosition = this.byteBuffer.position();
            position = this.eventPositions.get(index);
            this.byteBuffer.position((int)position);
            length = this.byteBuffer.getInt();
        }
        if (length < 1) {
            throw new EvioException("Bad file/buffer format");
        }
        header.setLength(length);
        try {
            int dt;
            if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                if (this.sequentialRead) {
                    short s = this.dataStream.readShort();
                    if (this.swap) {
                        s = Short.reverseBytes(s);
                    }
                    header.setTag(ByteDataTransformer.shortBitsToInt(s));
                    dt = ByteDataTransformer.byteBitsToInt(this.dataStream.readByte());
                } else {
                    header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
                    dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
                }
                int type = dt & 0x3F;
                int padding = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    padding = 0;
                }
                header.setDataType(type);
                header.setPadding(padding);
                event.setXmlNames();
                if (this.sequentialRead) {
                    header.setNumber(ByteDataTransformer.byteBitsToInt(this.dataStream.readByte()));
                } else {
                    header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
                }
            } else {
                if (this.sequentialRead) {
                    header.setNumber(ByteDataTransformer.byteBitsToInt(this.dataStream.readByte()));
                    dt = ByteDataTransformer.byteBitsToInt(this.dataStream.readByte());
                } else {
                    header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
                    dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
                }
                int type = dt & 0x3F;
                int padding = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    padding = 0;
                }
                header.setDataType(type);
                header.setPadding(padding);
                event.setXmlNames();
                if (this.sequentialRead) {
                    short s = this.dataStream.readShort();
                    if (this.swap) {
                        s = Short.reverseBytes(s);
                    }
                    header.setTag(ByteDataTransformer.shortBitsToInt(s));
                } else {
                    header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
                }
            }
            eventDataSizeBytes = 4 * (length - 1);
            byte[] bytes = new byte[eventDataSizeBytes];
            if (this.sequentialRead) {
                this.dataStream.readFully(bytes, 0, eventDataSizeBytes);
            } else {
                this.byteBuffer.get(bytes, 0, eventDataSizeBytes);
            }
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            event.setEventNumber(index + 1);
        }
        catch (OutOfMemoryError e) {
            throw new EvioException("Out Of Memory: (event size = " + eventDataSizeBytes + ")", e);
        }
        catch (Exception e) {
            throw new EvioException("Error", e);
        }
        finally {
            if (this.sequentialRead) {
                this.fileChannel.position(origPosition);
            } else {
                this.byteBuffer.position((int)origPosition);
            }
        }
        return event;
    }

    public synchronized EvioEvent parseEvent(int index) throws IOException, EvioException {
        EvioEvent event = this.getEvent(index);
        if (event != null) {
            this.parseEvent(event);
        }
        return event;
    }

    public synchronized EvioEvent nextEvent() throws IOException, EvioException {
        int padding;
        int type;
        int dt;
        boolean atTop = false;
        if (this.sequentialRead) {
            if (this.fileChannel.position() == 0L) {
                atTop = true;
            }
        } else {
            return this.getEvent(this.sequentialCounter++);
        }
        boolean isFirstEvent = false;
        if (atTop) {
            ReadStatus status = this.nextBlockHeader();
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            isFirstEvent = true;
        }
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        long currentPosition = this.byteBuffer.position();
        int bytesRemaining = this.blockBytesRemaining();
        if (bytesRemaining < 0) {
            throw new EvioException("Number of block bytes remaining is negative.");
        }
        if (bytesRemaining == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.SUCCESS) {
                return this.nextEvent();
            }
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        if (this.blockHeader.getBufferEndingPosition() == currentPosition) {
            return null;
        }
        int length = this.byteBuffer.getInt();
        if (length < 1) {
            return null;
        }
        header.setLength(length);
        if (this.evioVersion < 4 && (bytesRemaining -= 4) == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            bytesRemaining = this.blockBytesRemaining();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
            dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
        } else {
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
            dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
        }
        bytesRemaining -= 4;
        int eventDataSizeBytes = 4 * (length - 1);
        try {
            byte[] bytes = new byte[eventDataSizeBytes];
            int bytesToGo = eventDataSizeBytes;
            int offset = 0;
            if (this.evioVersion < 4) {
                while (bytesToGo > bytesRemaining) {
                    this.byteBuffer.get(bytes, offset, bytesRemaining);
                    ReadStatus status = this.nextBlockHeader();
                    if (status == ReadStatus.END_OF_FILE) {
                        return null;
                    }
                    if (status != ReadStatus.SUCCESS) {
                        throw new EvioException("Failed reading block header after crossing boundary in nextEvent.");
                    }
                    bytesToGo -= bytesRemaining;
                    offset += bytesRemaining;
                    bytesRemaining = this.blockBytesRemaining();
                }
            }
            this.byteBuffer.get(bytes, offset, bytesToGo);
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            if (isFirstEvent && this.blockHeader.hasDictionary()) {
                if (this.dictionaryXML == null) {
                    this.dictionaryXML = event.getStringData()[0];
                }
                return this.nextEvent();
            }
            event.setEventNumber(++this.eventNumber);
            return event;
        }
        catch (OutOfMemoryError ome) {
            System.err.println("Out Of Memory\neventDataSizeBytes = " + eventDataSizeBytes + "\n" + "bytes Remaining = " + bytesRemaining + "\n" + "event Count: " + this.eventCount);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized EvioEvent nextEventOrig() throws IOException, EvioException {
        int padding;
        int type;
        int dt;
        int bytesRemaining;
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        long currentPosition = this.byteBuffer.position();
        boolean atTop = false;
        boolean isFirstEvent = false;
        if (this.sequentialRead) {
            if (this.fileChannel.position() == 0L) {
                atTop = true;
            }
        } else if (this.byteBuffer.position() == 0) {
            atTop = true;
        }
        if (atTop) {
            ReadStatus status = this.nextBlockHeader();
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            isFirstEvent = true;
        }
        if ((bytesRemaining = this.blockBytesRemaining()) < 0) {
            throw new EvioException("Number of block bytes remaining is negative.");
        }
        if (bytesRemaining == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.SUCCESS) {
                return this.nextEvent();
            }
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        if (this.blockHeader.getBufferEndingPosition() == currentPosition) {
            return null;
        }
        int length = this.byteBuffer.getInt();
        if (length < 1) {
            return null;
        }
        header.setLength(length);
        if (this.evioVersion < 4 && (bytesRemaining -= 4) == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            bytesRemaining = this.blockBytesRemaining();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
            dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
        } else {
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.byteBuffer.get()));
            dt = ByteDataTransformer.byteBitsToInt(this.byteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setTag(ByteDataTransformer.shortBitsToInt(this.byteBuffer.getShort()));
        }
        bytesRemaining -= 4;
        int eventDataSizeBytes = 4 * (length - 1);
        try {
            byte[] bytes = new byte[eventDataSizeBytes];
            int bytesToGo = eventDataSizeBytes;
            int offset = 0;
            if (this.evioVersion < 4) {
                while (bytesToGo > bytesRemaining) {
                    this.byteBuffer.get(bytes, offset, bytesRemaining);
                    ReadStatus status = this.nextBlockHeader();
                    if (status == ReadStatus.END_OF_FILE) {
                        return null;
                    }
                    if (status != ReadStatus.SUCCESS) {
                        throw new EvioException("Failed reading block header after crossing boundary in nextEvent.");
                    }
                    bytesToGo -= bytesRemaining;
                    offset += bytesRemaining;
                    bytesRemaining = this.blockBytesRemaining();
                }
            }
            this.byteBuffer.get(bytes, offset, bytesToGo);
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            if (isFirstEvent && this.blockHeader.hasDictionary()) {
                if (this.dictionaryXML == null) {
                    this.dictionaryXML = event.getStringData()[0];
                }
                return this.nextEvent();
            }
            event.setEventNumber(++this.eventNumber);
            return event;
        }
        catch (OutOfMemoryError ome) {
            System.err.println("Out Of Memory\neventDataSizeBytes = " + eventDataSizeBytes + "\n" + "bytes Remaining = " + bytesRemaining + "\n" + "event Count: " + this.eventCount);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized EvioEvent parseNextEvent() throws IOException, EvioException {
        EvioEvent event = this.nextEvent();
        if (event != null) {
            this.parseEvent(event);
        }
        return event;
    }

    public synchronized void parseEvent(EvioEvent evioEvent) throws EvioException {
        this.parser.parseEvent(evioEvent);
    }

    private int blockBytesRemaining() {
        try {
            return this.blockHeader.bytesRemaining(this.byteBuffer.position());
        }
        catch (EvioException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void rewind() throws IOException {
        if (this.sequentialRead) {
            this.fileChannel.position(this.initialPosition);
        } else {
            this.byteBuffer.position(this.initialPosition);
        }
        this.lastBlock = false;
        this.eventNumber = 0;
        this.blockNumberExpected = 1;
        this.sequentialCounter = 1;
        if (this.getFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
    }

    public long position() throws IOException {
        if (this.sequentialRead) {
            return this.fileChannel.position();
        }
        return this.byteBuffer.position();
    }

    public void position(long position) throws IOException {
        if (this.sequentialRead) {
            this.fileChannel.position(position);
        } else {
            this.byteBuffer.position((int)position);
        }
    }

    public void close() throws IOException {
        if (this.sequentialRead) {
            this.fileChannel.close();
            this.dataStream.close();
        } else {
            this.byteBuffer.position(this.initialPosition);
        }
    }

    public IBlockHeader getCurrentBlockHeader() {
        return this.blockHeader;
    }

    public EvioEvent gotoEventNumber(int evNumber) throws IOException {
        if (evNumber < 1) {
            return null;
        }
        if (this.evioVersion > 3) {
            try {
                return this.parseEvent(evNumber);
            }
            catch (EvioException e) {
                return null;
            }
        }
        this.rewind();
        int currentCount = 0;
        try {
            for (int i = currentCount + 1; i < evNumber; ++i) {
                EvioEvent event = this.nextEvent();
                if (event != null) continue;
                throw new EvioException("Asked to go to event: " + evNumber + ", which is beyond the end of file");
            }
            return this.parseNextEvent();
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
    }

    public WriteStatus toXMLFile(String path) throws IOException {
        return this.toXMLFile(path, null);
    }

    public WriteStatus toXMLFile(String path, IEvioProgressListener progressListener) throws IOException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return WriteStatus.CANNOT_OPEN_FILE;
        }
        try {
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
            xmlWriter.writeStartDocument();
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeComment("Event source file: " + path);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement(ROOT_ELEMENT);
            xmlWriter.writeAttribute("numevents", "" + this.getEventCount());
            xmlWriter.writeCharacters("\n");
            ReaderState state = this.getState();
            this.rewind();
            try {
                EvioEvent event;
                while ((event = this.parseNextEvent()) != null) {
                    event.toXML(xmlWriter);
                    if (progressListener == null) continue;
                    progressListener.completed(event.getEventNumber(), this.getEventCount());
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                return WriteStatus.UNKNOWN_ERROR;
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.restoreState(state);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (FactoryConfigurationError e) {
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (EvioException e) {
            return WriteStatus.EVIO_EXCEPTION;
        }
        return WriteStatus.SUCCESS;
    }

    public int getEventCount() throws IOException, EvioException {
        if (this.evioVersion > 3) {
            return this.eventCount;
        }
        if (this.eventCount < 0) {
            ReaderState state = this.getState();
            this.rewind();
            this.eventCount = 0;
            while (this.nextEvent() != null) {
                ++this.eventCount;
            }
            this.restoreState(state);
        }
        return this.eventCount;
    }

    public int getBlockCount() {
        if (this.evioVersion > 3) {
            return this.blockCount;
        }
        if (this.blockCount < 0) {
            this.blockCount = (int)(this.fileSize / (long)this.firstBlockSize);
        }
        return this.blockCount;
    }

    public static boolean compareEventFiles(File evFile1, File evFile2) {
        long size2;
        if (evFile1 == null || evFile2 == null) {
            System.out.println("In compareEventFiles, one or both files are null.");
            return false;
        }
        if (!evFile1.exists() || !evFile2.exists()) {
            System.out.println("In compareEventFiles, one or both files do not exist.");
            return false;
        }
        if (evFile1.isDirectory() || evFile2.isDirectory()) {
            System.out.println("In compareEventFiles, one or both files is a directory.");
            return false;
        }
        if (!evFile1.canRead() || !evFile2.canRead()) {
            System.out.println("In compareEventFiles, one or both files cannot be read.");
            return false;
        }
        String name1 = evFile1.getName();
        String name2 = evFile2.getName();
        long size1 = evFile1.length();
        if (size1 != (size2 = evFile2.length())) {
            System.out.println(name1 + " and " + name2 + " have the different lengths.");
            System.out.println(name1 + ": " + size1);
            System.out.println(name2 + ": " + size2);
            return false;
        }
        System.out.println(name1 + " and " + name2 + " have the same length: " + size1);
        try {
            EvioReader evioFile1 = new EvioReader(evFile1);
            EvioReader evioFile2 = new EvioReader(evFile2);
            int evCount1 = evioFile1.getEventCount();
            int evCount2 = evioFile2.getEventCount();
            if (evCount1 != evCount2) {
                System.out.println(name1 + " and " + name2 + " have the different #events.");
                System.out.println(name1 + ": " + evCount1);
                System.out.println(name2 + ": " + evCount2);
                return false;
            }
            System.out.println(name1 + " and " + name2 + " have the same #events: " + evCount1);
        }
        catch (EvioException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        System.out.print("Byte by byte comparison...");
        System.out.flush();
        int onetenth = (int)(1L + size1 / 10L);
        try {
            FileInputStream fis1 = new FileInputStream(evFile1);
            FileInputStream fis2 = new FileInputStream(evFile1);
            int i = 0;
            while ((long)i < size1) {
                try {
                    int byte1 = fis1.read();
                    int byte2 = fis2.read();
                    if (byte1 != byte2) {
                        System.out.println(name1 + " and " + name2 + " different at byte offset: " + i);
                        return false;
                    }
                    if (i % onetenth == 0) {
                        System.out.print(".");
                        System.out.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                ++i;
            }
            System.out.println("");
            try {
                fis1.close();
                fis2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("files " + name1 + " and " + evFile2.getPath() + " are identical.");
        return true;
    }

    private class ReaderState {
        private boolean lastBlock;
        private int eventNumber;
        private long filePosition;
        private int byteBufferPosition;
        private int blockNumberExpected;
        private BlockHeaderV2 blockHeader2;
        private BlockHeaderV4 blockHeader4;

        private ReaderState() {
        }
    }

    public static enum WriteStatus {
        SUCCESS,
        CANNOT_OPEN_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

