/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;

public class cMsgEventProducer {
    private String subject = "evio";
    private String type = "anything";
    private String name = "producer";
    private String description = "java event producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay;
    private int count = 50000;
    private boolean debug;
    private int controlTypeIndex = -1;

    cMsgEventProducer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgEventProducer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgEventProducer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-c <count>]         set # of messages to send before printing output\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgEventProducer producer = new cMsgEventProducer(args);
            producer.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    private ByteBuffer getEvioBuffer(int tag, boolean addDictionary) {
        ByteBuffer myBuf = ByteBuffer.allocate(10000);
        myBuf.order(ByteOrder.LITTLE_ENDIAN);
        String dictionary = "<xmlDict>\n  <dictEntry name=\"bank\"           tag=\"1\"   num=\"1\"/>\n  <dictEntry name=\"bank of short banks\" tag=\"2\"   num=\"2\"/>\n  <dictEntry name=\"shorts pad0\"    tag=\"3\"   num=\"3\"/>\n  <dictEntry name=\"shorts pad2\"    tag=\"4\"   num=\"4\"/>\n  <dictEntry name=\"bank of char banks\"  tag=\"5\"   num=\"5\"/>\n  <dictEntry name=\"chars pad0\"     tag=\"6\"   num=\"6\"/>\n  <dictEntry name=\"chars pad3\"     tag=\"7\"   num=\"7\"/>\n  <dictEntry name=\"chars pad2\"     tag=\"8\"   num=\"8\"/>\n  <dictEntry name=\"chars pad1\"     tag=\"9\"   num=\"9\"/>\n</xmlDict>";
        byte[] byteData1 = new byte[]{1, 2, 3, 4};
        byte[] byteData2 = new byte[]{1, 2, 3, 4, 5};
        byte[] byteData3 = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] byteData4 = new byte[]{1, 2, 3, 4, 5, 6, 7};
        short[] shortData1 = new short[]{11, 22};
        short[] shortData2 = new short[]{11, 22, 33};
        try {
            EventWriter eventWriterNew = null;
            eventWriterNew = addDictionary ? new EventWriter(myBuf, 100, 3, dictionary, null) : new EventWriter(myBuf, 100, 3, null, null);
            EventBuilder eventBuilder2 = new EventBuilder(tag, DataType.BANK, 1);
            EvioEvent eventShort = eventBuilder2.getEvent();
            EvioBank bankBanks = new EvioBank(2, DataType.BANK, 2);
            EvioBank shortBank1 = new EvioBank(3, DataType.SHORT16, 3);
            shortBank1.appendShortData(shortData1);
            eventBuilder2.addChild(bankBanks, shortBank1);
            EvioBank shortBank2 = new EvioBank(4, DataType.SHORT16, 4);
            shortBank2.appendShortData(shortData2);
            eventBuilder2.addChild(bankBanks, shortBank2);
            eventBuilder2.addChild(eventShort, bankBanks);
            eventWriterNew.writeEvent(eventShort);
            EventBuilder eventBuilder = new EventBuilder(5, DataType.BANK, 5);
            EvioEvent event = eventBuilder.getEvent();
            EvioBank charBank1 = new EvioBank(6, DataType.CHAR8, 6);
            charBank1.appendByteData(byteData1);
            eventBuilder.addChild(event, charBank1);
            EvioBank charBank2 = new EvioBank(7, DataType.CHAR8, 7);
            charBank2.appendByteData(byteData2);
            eventBuilder.addChild(event, charBank2);
            EvioBank charBank3 = new EvioBank(8, DataType.CHAR8, 8);
            charBank3.appendByteData(byteData3);
            eventBuilder.addChild(event, charBank3);
            EvioBank charBank4 = new EvioBank(9, DataType.CHAR8, 9);
            charBank4.appendByteData(byteData4);
            eventBuilder.addChild(event, charBank4);
            eventWriterNew.writeEvent(event);
            eventWriterNew.close();
            myBuf.flip();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
        return myBuf;
    }

    private ByteBuffer getPhysicsBuffer(int physicsTag, boolean addDictionary) {
        ByteBuffer myBuf = ByteBuffer.allocate(500);
        myBuf.order(ByteOrder.LITTLE_ENDIAN);
        String dictionary = "<xmlDict>\n  <dictEntry name=\"Physics Event\"  tag=\"0xFF50\" />\n  <dictEntry name=\"Trigger Bank\"   tag=\"0xFF23\" />\n</xmlDict>";
        try {
            EventWriter writer = null;
            writer = addDictionary ? new EventWriter(myBuf, 100, 3, dictionary, null) : new EventWriter(myBuf, 100, 3, null, null);
            int numEvents = 2;
            int numRocs = 2;
            int ebId = 3;
            int roc1Id = 1;
            int roc2Id = 2;
            int detId = 4;
            long firstEvNum = 1L;
            EventBuilder builder = new EventBuilder(physicsTag, DataType.BANK, numEvents);
            EvioEvent ev = builder.getEvent();
            EvioBank triggerBank = new EvioBank(65315, DataType.SEGMENT, numRocs);
            EvioSegment firstSeg = new EvioSegment(ebId, DataType.ULONG64);
            long[] fsData = new long[]{firstEvNum, 2L, 3L, 0x400000005L};
            firstSeg.appendLongData(fsData);
            EvioSegment secondSeg = new EvioSegment(ebId, DataType.USHORT16);
            short[] etData = new short[]{1, 2};
            secondSeg.appendShortData(etData);
            EvioSegment roc1Seg = new EvioSegment(roc1Id, DataType.UINT32);
            int[] iData = new int[]{2, 0, 3, 0};
            roc1Seg.appendIntData(iData);
            EvioSegment roc2Seg = new EvioSegment(roc2Id, DataType.UINT32);
            roc2Seg.appendIntData(iData);
            builder.addChild(triggerBank, firstSeg);
            builder.addChild(triggerBank, secondSeg);
            builder.addChild(triggerBank, roc1Seg);
            builder.addChild(triggerBank, roc2Seg);
            builder.addChild(ev, triggerBank);
            EvioBank dBank1 = new EvioBank(0 | 0xFFF & roc1Id, DataType.BANK, numEvents);
            EvioBank dbBank1 = new EvioBank(0 | 0xFFF & detId, DataType.UINT32, numEvents);
            int[] dbData = new int[]{(int)firstEvNum, 1, 2, 3};
            dbBank1.appendIntData(dbData);
            EvioBank dBank2 = new EvioBank(0 | 0xFFF & roc2Id, DataType.BANK, numEvents);
            builder.addChild(dBank1, dbBank1);
            builder.addChild(dBank2, dbBank1);
            builder.addChild(ev, dBank1);
            builder.addChild(ev, dBank2);
            writer.writeEvent(ev);
            writer.close();
            myBuf.flip();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
        return myBuf;
    }

    private ByteBuffer getControlBuffer() {
        ByteBuffer myBuf = ByteBuffer.allocate(100);
        myBuf.order(ByteOrder.LITTLE_ENDIAN);
        try {
            EventWriter writer = new EventWriter(myBuf, 100, 3, null, null);
            int[] controlTypes = new int[]{65488, 65489, 65490, 65491, 65492};
            this.controlTypeIndex = (this.controlTypeIndex + 1) % controlTypes.length;
            EventBuilder builder = new EventBuilder(controlTypes[this.controlTypeIndex], DataType.UINT32, 204);
            EvioEvent ev = builder.getEvent();
            int[] iData = new int[]{2, 1, 2};
            ev.appendIntData(iData);
            writer.writeEvent(ev);
            writer.close();
            myBuf.flip();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
        return myBuf;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type + "\n    UDL     = " + this.UDL);
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        try {
            coda.connect();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            return;
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        double freq = 0.0;
        double freqAvg = 0.0;
        long totalT = 0L;
        long totalC = 0L;
        long ignore = 0L;
        int tag = 0;
        while (true) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                ByteBuffer myBuf = (tag = (tag + 1) % 255) % 3 == 0 ? (tag % 2 == 0 ? this.getPhysicsBuffer(65360, true) : this.getPhysicsBuffer(65360, false)) : (tag % 3 == 1 ? (tag % 2 == 0 ? this.getPhysicsBuffer(2, true) : this.getPhysicsBuffer(2, false)) : this.getControlBuffer());
                msg.setByteArray(myBuf.array(), 0, myBuf.limit());
                System.out.println("SEND MSG");
                coda.send(msg);
                coda.flush(0);
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long t2 = System.currentTimeMillis();
            if (ignore == 0L) {
                long deltaT = t2 - t1;
                freq = (double)this.count / (double)deltaT * 1000.0;
                freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += deltaT) * 1000.0;
                if (!this.debug) continue;
                System.out.println(cMsgEventProducer.doubleToString(freq, 1) + " Hz, Avg = " + cMsgEventProducer.doubleToString(freqAvg, 1) + " Hz");
                continue;
            }
            --ignore;
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("Received msg: ");
            System.out.println(msg.toString(true, false, true));
        }
    }
}

